/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.maven.internal.handler;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.xwiki.extension.repository.maven.internal.handler.MavenArtifactHandler;
import org.xwiki.extension.repository.maven.internal.handler.MavenArtifactHandlerManager;

public class MavenArtifactHandlers {
    private Map<String, MavenArtifactHandler> handlersByType = new HashMap<String, MavenArtifactHandler>();
    private Map<String, MavenArtifactHandler> handlersByPackaging = new HashMap<String, MavenArtifactHandler>();

    public MavenArtifactHandlers() {
    }

    public MavenArtifactHandlers(MavenArtifactHandlerManager handlers) {
        handlers.getHandlers().forEach(this::add);
    }

    public void add(Map<String, ArtifactHandler> handlers) {
        for (Map.Entry<String, ArtifactHandler> entry : handlers.entrySet()) {
            MavenArtifactHandler handler = new MavenArtifactHandler(entry.getKey(), entry.getValue());
            this.add(handler);
        }
    }

    public void add(MavenArtifactHandler handler) {
        this.handlersByType.put(handler.getType(), handler);
        this.handlersByPackaging.put(handler.getPackaging(), handler);
    }

    public MavenArtifactHandler getByType(String type) {
        return this.handlersByType.get(type);
    }

    public MavenArtifactHandler getByPackaging(String packaging) {
        return this.handlersByPackaging.get(packaging);
    }

    public Collection<MavenArtifactHandler> getHandlers() {
        return this.handlersByType.values();
    }
}

