/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.maven.internal.converter;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.maven.model.Model;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.extension.Extension;
import org.xwiki.extension.maven.ArtifactModel;
import org.xwiki.extension.maven.internal.MavenExtension;
import org.xwiki.extension.maven.internal.MavenUtils;
import org.xwiki.extension.maven.internal.converter.AbstractModelConverter;
import org.xwiki.extension.repository.maven.internal.converter.ExtensionTypeConverter;
import org.xwiki.properties.converter.ConversionException;
import org.xwiki.properties.converter.Converter;

@Component
@Singleton
public class ArtifactModelConverter
extends AbstractModelConverter<ArtifactModel> {
    public static final ParameterizedType ROLE = new DefaultParameterizedType(null, Converter.class, new Type[]{ArtifactModel.class});
    @Inject
    private ExtensionTypeConverter converter;

    public <G> G convert(Type targetType, Object sourceValue) {
        if (targetType == Extension.class) {
            try {
                return (G)this.convertToExtension((ArtifactModel)sourceValue);
            }
            catch (ComponentLookupException e) {
                throw new ConversionException("Failed to convert the ArtifactModel", (Throwable)e);
            }
        }
        throw new ConversionException(String.format("Unsupported target type [%s]", targetType));
    }

    private MavenExtension convertToExtension(ArtifactModel artifactModel) throws ComponentLookupException {
        String groupId = MavenUtils.resolveGroupId((Model)artifactModel.getModel());
        String artifactId = artifactModel.getModel().getArtifactId();
        String classifier = artifactModel.getClassifier();
        String type = artifactModel.getType() != null ? this.converter.mavenTypeToExtensionType(artifactModel.getType()) : this.converter.mavenPackagingToExtensionType(artifactModel.getModel().getPackaging());
        String version = MavenUtils.resolveVersion((Model)artifactModel.getModel());
        return this.convertToExtension(artifactModel.getModel(), groupId, artifactId, classifier, type, version);
    }
}

