/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.password.internal.kdf.factory;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.crypto.password.KeyDerivationFunction;
import org.xwiki.crypto.password.KeyDerivationFunctionFactory;
import org.xwiki.crypto.password.internal.kdf.factory.AbstractBcKDFFactory;
import org.xwiki.crypto.password.params.KeyDerivationFunctionParameters;

@Component
@Singleton
public class DefaultKeyDerivationFunctionFactory
extends AbstractBcKDFFactory {
    @Inject
    private ComponentManager manager;

    @Override
    public KeyDerivationFunction getInstance(KeyDerivationFunctionParameters params) {
        return this.getFactory(params.getAlgorithmName()).getInstance(params);
    }

    @Override
    public KeyDerivationFunction getInstance(byte[] encoded) {
        KeyDerivationFunc func = KeyDerivationFunc.getInstance((Object)ASN1Sequence.getInstance((Object)encoded));
        KeyDerivationFunctionFactory factory = this.getFactory(func.getAlgorithm().getId());
        KeyDerivationFunction kdf = this.getBcInstance(factory, func);
        if (kdf == null) {
            kdf = factory.getInstance(encoded);
        }
        return kdf;
    }

    @Override
    public KeyDerivationFunction getInstance(ASN1Encodable parameters) {
        KeyDerivationFunc func = KeyDerivationFunc.getInstance((Object)parameters);
        return this.getBcInstance(this.getFactory(func.getAlgorithm().getId()), func);
    }

    private KeyDerivationFunction getBcInstance(KeyDerivationFunctionFactory factory, KeyDerivationFunc func) {
        if (factory instanceof AbstractBcKDFFactory) {
            return ((AbstractBcKDFFactory)factory).getInstance((ASN1Encodable)func);
        }
        return null;
    }

    private KeyDerivationFunctionFactory getFactory(String hint) {
        try {
            return (KeyDerivationFunctionFactory)this.manager.getInstance(KeyDerivationFunctionFactory.class, hint);
        }
        catch (ComponentLookupException e) {
            throw new UnsupportedOperationException("Key derivation function algorithm not found.", e);
        }
    }
}

