/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.internal.symmetric.generator;

import java.security.SecureRandom;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.bouncycastle.crypto.CipherKeyGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.KeyGenerator;
import org.xwiki.crypto.params.generator.symmetric.GenericKeyGenerationParameters;

@Component
@Singleton
public class DefaultKeyGenerator
implements KeyGenerator {
    @Inject
    private Provider<SecureRandom> random;

    @Override
    public byte[] generate() {
        throw new UnsupportedOperationException("Knowing the key strength is required to generate a key.");
    }

    @Override
    public byte[] generate(org.xwiki.crypto.params.generator.KeyGenerationParameters parameters) {
        if (!(parameters instanceof GenericKeyGenerationParameters)) {
            throw new IllegalArgumentException("Invalid parameters for generic key generator: " + parameters.getClass().getName());
        }
        GenericKeyGenerationParameters params = (GenericKeyGenerationParameters)parameters;
        CipherKeyGenerator generator = this.getKeyGenerator();
        generator.init(new KeyGenerationParameters((SecureRandom)this.random.get(), params.getStrength() * 8));
        return generator.generateKey();
    }

    protected CipherKeyGenerator getKeyGenerator() {
        return new CipherKeyGenerator();
    }
}

