/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.uparser;

import io.sf.carte.uparser.TokenControl;
import io.sf.carte.uparser.TokenHandler2;

public class CommentRemovalHandler
implements TokenHandler2 {
    private final StringBuilder buffer;

    public CommentRemovalHandler(int bufSize) {
        this.buffer = new StringBuilder(bufSize);
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    @Override
    public void tokenStart(TokenControl control) {
    }

    @Override
    public void word(int index, CharSequence word) {
        this.buffer.append(word);
    }

    @Override
    public void separator(int index, int codePoint) {
        this.buffer.appendCodePoint(codePoint);
    }

    @Override
    public void quoted(int index, CharSequence quoted, int quoteCp) {
        char[] quote = Character.toChars(quoteCp);
        this.buffer.append(quote);
        this.buffer.append(quoted);
        this.buffer.append(quote);
    }

    @Override
    public void quotedWithControl(int index, CharSequence quoted, int quoteCp) {
        this.quoted(index, quoted, quoteCp);
    }

    @Override
    public void quotedNewlineChar(int index, int codePoint) {
        this.buffer.appendCodePoint(codePoint);
    }

    @Override
    public void leftParenthesis(int index) {
        this.buffer.append('(');
    }

    @Override
    public void leftSquareBracket(int index) {
        this.buffer.append('[');
    }

    @Override
    public void leftCurlyBracket(int index) {
        this.buffer.append('{');
    }

    @Override
    public void rightParenthesis(int index) {
        this.buffer.append(')');
    }

    @Override
    public void rightSquareBracket(int index) {
        this.buffer.append(']');
    }

    @Override
    public void rightCurlyBracket(int index) {
        this.buffer.append('}');
    }

    @Override
    public void character(int index, int codePoint) {
        this.buffer.appendCodePoint(codePoint);
    }

    @Override
    public void escaped(int index, int codePoint) {
        this.buffer.append('\\').appendCodePoint(codePoint);
    }

    @Override
    public void control(int index, int codePoint) {
        this.buffer.appendCodePoint(codePoint);
    }

    @Override
    public void commented(int index, int commentType, String comment) {
    }

    @Override
    public void endOfStream(int len) {
    }

    @Override
    public void error(int index, byte errCode, CharSequence context) {
    }
}

