/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.xml;

import org.apache.tika.metadata.Metadata;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class AttributeDependantMetadataHandler
extends DefaultHandler {
    private final Metadata metadata;
    private final String nameHoldingAttribute;
    private final String namePrefix;
    private final StringBuilder buffer = new StringBuilder();
    private String name;

    public AttributeDependantMetadataHandler(Metadata metadata, String nameHoldingAttribute, String namePrefix) {
        this.metadata = metadata;
        this.nameHoldingAttribute = nameHoldingAttribute;
        this.namePrefix = namePrefix;
    }

    public void addMetadata(String value) {
        if (this.name == null || this.name.isEmpty()) {
            return;
        }
        if (value.length() > 0) {
            String previous = this.metadata.get(this.name);
            if (previous != null && previous.length() > 0) {
                value = previous + ", " + value;
            }
            this.metadata.set(this.name, value);
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) {
        this.addMetadata(this.buffer.toString());
        this.buffer.setLength(0);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) {
        String rawName = attributes.getValue(this.nameHoldingAttribute);
        if (rawName != null) {
            this.name = this.namePrefix == null ? rawName : this.namePrefix + rawName;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.buffer.append(ch, start, length);
    }
}

