/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.circuitbreaker;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.util.circuitbreaker.CircuitBreaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircuitBreakerRegistry
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<SolrRequest.SolrRequestType, List<CircuitBreaker>> circuitBreakerMap = new HashMap<SolrRequest.SolrRequestType, List<CircuitBreaker>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(CircuitBreaker circuitBreaker) {
        Map<SolrRequest.SolrRequestType, List<CircuitBreaker>> map = this.circuitBreakerMap;
        synchronized (map) {
            circuitBreaker.getRequestTypes().forEach(r -> {
                List list = this.circuitBreakerMap.computeIfAbsent((SolrRequest.SolrRequestType)r, k -> new ArrayList());
                list.add(circuitBreaker);
                if (log.isInfoEnabled()) {
                    log.info("Registered circuit breaker {} for request type(s) {}", (Object)circuitBreaker.getClass().getSimpleName(), r);
                }
            });
        }
    }

    @VisibleForTesting
    public void deregisterAll() throws IOException {
        this.close();
    }

    public List<CircuitBreaker> checkTripped(SolrRequest.SolrRequestType requestType) {
        ArrayList<CircuitBreaker> triggeredCircuitBreakers = null;
        for (CircuitBreaker circuitBreaker : this.circuitBreakerMap.getOrDefault(requestType, Collections.emptyList())) {
            if (!circuitBreaker.isTripped()) continue;
            if (triggeredCircuitBreakers == null) {
                triggeredCircuitBreakers = new ArrayList<CircuitBreaker>();
            }
            triggeredCircuitBreakers.add(circuitBreaker);
        }
        return triggeredCircuitBreakers;
    }

    public static String toErrorMessage(List<CircuitBreaker> circuitBreakerList) {
        StringBuilder sb = new StringBuilder();
        for (CircuitBreaker circuitBreaker : circuitBreakerList) {
            sb.append(circuitBreaker.getErrorMessage());
            sb.append("\n");
        }
        return sb.toString();
    }

    public boolean isEnabled(SolrRequest.SolrRequestType requestType) {
        return this.circuitBreakerMap.containsKey(requestType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Map<SolrRequest.SolrRequestType, List<CircuitBreaker>> map = this.circuitBreakerMap;
        synchronized (map) {
            AtomicInteger closeFailedCounter = new AtomicInteger(0);
            this.circuitBreakerMap.values().forEach(list -> list.forEach(it -> {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Closed circuit breaker {} for request type(s) {}", (Object)it.getClass().getSimpleName(), it.getRequestTypes());
                    }
                    it.close();
                }
                catch (IOException e) {
                    if (log.isErrorEnabled()) {
                        log.error(String.format(Locale.ROOT, "Failed to close circuit breaker %s", it.getClass().getSimpleName()), (Throwable)e);
                    }
                    closeFailedCounter.incrementAndGet();
                }
            }));
            this.circuitBreakerMap.clear();
            if (closeFailedCounter.get() > 0) {
                throw new IOException("Failed to close " + closeFailedCounter.get() + " circuit breakers");
            }
        }
    }
}

