/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import java.security.cert.X509Certificate;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.solr.security.AuthenticationPlugin;

public class CertAuthPlugin
extends AuthenticationPlugin {
    @Override
    public void init(Map<String, Object> pluginConfig) {
    }

    @Override
    public boolean doAuthenticate(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (certs == null || certs.length == 0) {
            this.numMissingCredentials.inc();
            response.setHeader("WWW-Authenticate", "Certificate");
            response.sendError(401, "require certificate");
            return false;
        }
        HttpServletRequest wrapped = this.wrapWithPrincipal(request, certs[0].getSubjectX500Principal());
        this.numAuthenticated.inc();
        filterChain.doFilter((ServletRequest)wrapped, (ServletResponse)response);
        return true;
    }
}

