/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.Set;
import org.apache.solr.cloud.ConfigSetCmds;
import org.apache.solr.cloud.OverseerMessageHandler;
import org.apache.solr.cloud.OverseerSolrResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.ConfigSetParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CoreContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverseerConfigSetMessageHandler
implements OverseerMessageHandler {
    public static final String CONFIGSETS_ACTION_PREFIX = "configsets:";
    private ZkStateReader zkStateReader;
    private CoreContainer coreContainer;
    private final Set<String> configSetWriteWip;
    private final Set<String> configSetReadWip;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public OverseerConfigSetMessageHandler(ZkStateReader zkStateReader, CoreContainer coreContainer) {
        this.zkStateReader = zkStateReader;
        this.coreContainer = coreContainer;
        this.configSetWriteWip = new HashSet<String>();
        this.configSetReadWip = new HashSet<String>();
    }

    @Override
    public OverseerSolrResponse processMessage(ZkNodeProps message, String operation) {
        NamedList results = new NamedList();
        try {
            if (!operation.startsWith(CONFIGSETS_ACTION_PREFIX)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Operation does not contain proper prefix: " + operation + " expected: configsets:");
            }
            operation = operation.substring(CONFIGSETS_ACTION_PREFIX.length());
            log.info("OverseerConfigSetMessageHandler.processMessage : {}, {}", (Object)operation, (Object)message);
            ConfigSetParams.ConfigSetAction action = ConfigSetParams.ConfigSetAction.get((String)operation);
            if (action == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown operation:" + operation);
            }
            switch (action) {
                case CREATE: {
                    ConfigSetCmds.createConfigSet(message, this.coreContainer);
                    break;
                }
                case DELETE: {
                    ConfigSetCmds.deleteConfigSet(message, this.coreContainer);
                    break;
                }
                default: {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown operation:" + operation);
                }
            }
        }
        catch (Exception e) {
            String configSetName = message.getStr("name");
            if (configSetName == null) {
                log.error("Operation {} failed", (Object)operation, (Object)e);
            } else {
                log.error("ConfigSet: {} operation: {} failed", new Object[]{configSetName, operation, e});
            }
            results.add("Operation " + operation + " caused exception:", (Object)e);
            SimpleOrderedMap nl = new SimpleOrderedMap();
            nl.add("msg", (Object)e.getMessage());
            nl.add("rspCode", (Object)(e instanceof SolrException ? ((SolrException)((Object)e)).code() : -1));
            results.add("exception", (Object)nl);
        }
        return new OverseerSolrResponse((NamedList<Object>)results);
    }

    @Override
    public String getName() {
        return "Overseer ConfigSet Message Handler";
    }

    @Override
    public String getTimerName(String operation) {
        return "configset_" + operation;
    }

    @Override
    public OverseerMessageHandler.Lock lockTask(ZkNodeProps message, long ignored) {
        String configSetName = this.getTaskKey(message);
        if (this.canExecute(configSetName, message)) {
            this.markExclusiveTask(configSetName, message);
            return () -> this.unmarkExclusiveTask(configSetName, message);
        }
        return null;
    }

    @Override
    public String getTaskKey(ZkNodeProps message) {
        return message.getStr("name");
    }

    private void markExclusiveTask(String configSetName, ZkNodeProps message) {
        String baseConfigSet = this.getBaseConfigSetIfCreate(message);
        this.markExclusive(configSetName, baseConfigSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markExclusive(String configSetName, String baseConfigSetName) {
        Set<String> set = this.configSetWriteWip;
        synchronized (set) {
            this.configSetWriteWip.add(configSetName);
            if (baseConfigSetName != null) {
                this.configSetReadWip.add(baseConfigSetName);
            }
        }
    }

    private void unmarkExclusiveTask(String configSetName, ZkNodeProps message) {
        String baseConfigSet = this.getBaseConfigSetIfCreate(message);
        this.unmarkExclusiveConfigSet(configSetName, baseConfigSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unmarkExclusiveConfigSet(String configSetName, String baseConfigSetName) {
        Set<String> set = this.configSetWriteWip;
        synchronized (set) {
            this.configSetWriteWip.remove(configSetName);
            if (baseConfigSetName != null) {
                this.configSetReadWip.remove(baseConfigSetName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canExecute(String configSetName, ZkNodeProps message) {
        String baseConfigSetName = this.getBaseConfigSetIfCreate(message);
        Set<String> set = this.configSetWriteWip;
        synchronized (set) {
            if (this.configSetWriteWip.contains(configSetName) || this.configSetReadWip.contains(configSetName)) {
                return false;
            }
            if (baseConfigSetName != null && this.configSetWriteWip.contains(baseConfigSetName)) {
                return false;
            }
        }
        return true;
    }

    private String getBaseConfigSetIfCreate(ZkNodeProps message) {
        String operation = message.getStr("operation").substring(CONFIGSETS_ACTION_PREFIX.length());
        ConfigSetParams.ConfigSetAction action = ConfigSetParams.ConfigSetAction.get((String)operation);
        return ConfigSetCmds.getBaseConfigSetName(action, message.getStr("baseConfigSet"));
    }
}

