/*
 * Decompiled with CFR 0.152.
 */
package org.securityfilter.authenticator;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.securityfilter.authenticator.Authenticator;
import org.securityfilter.authenticator.persistent.PersistentLoginManagerInterface;
import org.securityfilter.config.SecurityConfig;
import org.securityfilter.filter.SecurityFilter;
import org.securityfilter.filter.SecurityRequestWrapper;
import org.securityfilter.filter.URLPattern;
import org.securityfilter.filter.URLPatternFactory;
import org.securityfilter.filter.URLPatternMatcher;
import org.securityfilter.realm.SecurityRealmInterface;

public class FormAuthenticator
implements Authenticator {
    public static final String LOGIN_SUBMIT_PATTERN_KEY = "loginSubmitPattern";
    public static final String DEFAULT_LOGIN_SUBMIT_PATTERN = "/j_security_check";
    protected String loginSubmitPattern;
    protected static final String FORM_USERNAME = "j_username";
    protected static final String FORM_PASSWORD = "j_password";
    protected static final String FORM_REMEMBERME = "j_rememberme";
    protected String loginPage;
    protected URLPattern loginPagePattern;
    protected String errorPage;
    protected URLPattern errorPagePattern;
    protected String defaultPage;
    protected PersistentLoginManagerInterface persistentLoginManager;
    protected URLPattern logoutPagePattern;
    protected SecurityRealmInterface realm;

    public void init(FilterConfig filterConfig, SecurityConfig securityConfig) throws Exception {
        this.realm = securityConfig.getRealm();
        this.loginSubmitPattern = filterConfig.getInitParameter(LOGIN_SUBMIT_PATTERN_KEY);
        if (this.loginSubmitPattern == null) {
            this.loginSubmitPattern = DEFAULT_LOGIN_SUBMIT_PATTERN;
        }
        this.defaultPage = securityConfig.getDefaultPage();
        URLPatternFactory patternFactory = new URLPatternFactory();
        this.loginPage = securityConfig.getLoginPage();
        this.loginPagePattern = patternFactory.createURLPattern(this.stripQueryString(this.loginPage), null, null, 0);
        this.errorPage = securityConfig.getErrorPage();
        this.errorPagePattern = patternFactory.createURLPattern(this.stripQueryString(this.errorPage), null, null, 0);
        String logoutPage = securityConfig.getLogoutPage();
        if (logoutPage != null) {
            this.logoutPagePattern = patternFactory.createURLPattern(this.stripQueryString(logoutPage), null, null, 0);
        }
        this.persistentLoginManager = securityConfig.getPersistentLoginManager();
    }

    public String getAuthMethod() {
        return "FORM";
    }

    public boolean processLogin(SecurityRequestWrapper request, HttpServletResponse response) throws Exception {
        Principal principal;
        String password;
        String username;
        if (request.getRemoteUser() == null && this.persistentLoginManager != null && this.persistentLoginManager.rememberingLogin((HttpServletRequest)request)) {
            username = this.persistentLoginManager.getRememberedUsername((HttpServletRequest)request, response);
            principal = this.realm.authenticate(username, password = this.persistentLoginManager.getRememberedPassword((HttpServletRequest)request, response));
            if (principal != null) {
                request.setUserPrincipal(principal);
            } else {
                this.persistentLoginManager.forgetLogin((HttpServletRequest)request, response);
            }
        }
        if (request.getMatchableURL().endsWith(this.loginSubmitPattern)) {
            username = request.getParameter(FORM_USERNAME);
            principal = this.realm.authenticate(username, password = request.getParameter(FORM_PASSWORD));
            if (principal != null) {
                if (request.getUserPrincipal() != null && !username.equals(request.getRemoteUser())) {
                    request.getSession().invalidate();
                }
                if (this.persistentLoginManager != null) {
                    String rememberme = request.getParameter(FORM_REMEMBERME);
                    if (rememberme != null) {
                        this.persistentLoginManager.rememberLogin((HttpServletRequest)request, response, username, password);
                    } else {
                        this.persistentLoginManager.forgetLogin((HttpServletRequest)request, response);
                    }
                }
                request.setUserPrincipal(principal);
                String continueToURL = this.getContinueToURL((HttpServletRequest)request);
                response.sendRedirect(response.encodeRedirectURL(continueToURL));
            } else {
                response.setStatus(401);
                request.getRequestDispatcher(this.errorPage).forward((ServletRequest)request, (ServletResponse)response);
            }
            return true;
        }
        return false;
    }

    public void showLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        SecurityFilter.saveRequestInformation(request);
        response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + this.loginPage));
    }

    public boolean processLogout(SecurityRequestWrapper request, HttpServletResponse response, URLPatternMatcher patternMatcher) throws Exception {
        String requestURL = request.getMatchableURL();
        if (this.matchesLogoutPattern(requestURL, patternMatcher)) {
            if (this.persistentLoginManager != null && this.persistentLoginManager.rememberingLogin((HttpServletRequest)request)) {
                this.persistentLoginManager.forgetLogin((HttpServletRequest)request, response);
            }
            return true;
        }
        return false;
    }

    public boolean bypassSecurityForThisRequest(SecurityRequestWrapper request, URLPatternMatcher patternMatcher) throws Exception {
        String requestURL = request.getMatchableURL();
        return patternMatcher.match(requestURL, this.loginPagePattern) || patternMatcher.match(requestURL, this.errorPagePattern) || this.matchesLogoutPattern(requestURL, patternMatcher);
    }

    private boolean matchesLogoutPattern(String requestURL, URLPatternMatcher patternMatcher) throws Exception {
        if (this.logoutPagePattern != null) {
            return patternMatcher.match(requestURL, this.logoutPagePattern);
        }
        return false;
    }

    private String getContinueToURL(HttpServletRequest request) {
        String savedURL = SecurityFilter.getContinueToURL(request);
        if (savedURL != null) {
            return savedURL;
        }
        return request.getContextPath() + this.defaultPage;
    }

    private String stripQueryString(String uri) {
        int queryStart;
        if (uri != null && (queryStart = uri.indexOf(63)) != -1) {
            uri = uri.substring(0, queryStart);
        }
        return uri;
    }
}

