/*
 * Decompiled with CFR 0.152.
 */
package org.securityfilter.authenticator;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.securityfilter.authenticator.Authenticator;
import org.securityfilter.config.SecurityConfig;
import org.securityfilter.filter.SecurityFilter;
import org.securityfilter.filter.SecurityRequestWrapper;
import org.securityfilter.filter.URLPatternMatcher;
import org.securityfilter.realm.SecurityRealmInterface;

public class BasicAuthenticator
implements Authenticator {
    public static final String LOGIN_ATTEMPTS = (class$org$securityfilter$authenticator$BasicAuthenticator == null ? (class$org$securityfilter$authenticator$BasicAuthenticator = BasicAuthenticator.class$("org.securityfilter.authenticator.BasicAuthenticator")) : class$org$securityfilter$authenticator$BasicAuthenticator).getName() + ".LOGIN_ATTEMPTS";
    public static final String LOGIN_FAILED_MESSAGE = "Sorry you are having problems logging in, please try again";
    public static final int MAX_ATTEMPTS = 3;
    protected SecurityRealmInterface realm;
    protected String realmName;
    static /* synthetic */ Class class$org$securityfilter$authenticator$BasicAuthenticator;

    public void init(FilterConfig filterConfig, SecurityConfig securityConfig) throws Exception {
        this.realm = securityConfig.getRealm();
        this.realmName = securityConfig.getRealmName();
    }

    public String getAuthMethod() {
        return "BASIC";
    }

    public boolean processLogin(SecurityRequestWrapper request, HttpServletResponse response) throws Exception {
        if (request.getUserPrincipal() == null) {
            String authorizationHeader = request.getHeader("Authorization");
            HttpSession session = request.getSession();
            if (authorizationHeader != null) {
                String password;
                String decoded = this.decodeBasicAuthorizationString(authorizationHeader);
                String username = this.parseUsername(decoded);
                Principal principal = this.realm.authenticate(username, password = this.parsePassword(decoded));
                if (principal != null) {
                    request.getSession().removeAttribute(LOGIN_ATTEMPTS);
                    request.setUserPrincipal(principal);
                } else if (session.getAttribute(LOGIN_ATTEMPTS) != null) {
                    this.showLogin(request.getCurrentRequest(), response);
                    return true;
                }
            }
        }
        return false;
    }

    public void showLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        int loginAttempts;
        SecurityFilter.saveRequestInformation(request);
        if (request.getSession().getAttribute(LOGIN_ATTEMPTS) != null) {
            loginAttempts = (Integer)request.getSession().getAttribute(LOGIN_ATTEMPTS);
            ++loginAttempts;
        } else {
            loginAttempts = 1;
        }
        request.getSession().setAttribute(LOGIN_ATTEMPTS, (Object)new Integer(loginAttempts));
        if (loginAttempts <= 3) {
            response.setHeader("WWW-Authenticate", "BASIC realm=\"" + this.realmName + "\"");
            response.setStatus(401);
        } else {
            request.getSession().removeAttribute(LOGIN_ATTEMPTS);
            response.sendError(401, LOGIN_FAILED_MESSAGE);
        }
    }

    public boolean bypassSecurityForThisRequest(SecurityRequestWrapper request, URLPatternMatcher patternMatcher) {
        return false;
    }

    public boolean processLogout(SecurityRequestWrapper request, HttpServletResponse response, URLPatternMatcher patternMatcher) {
        return false;
    }

    private String parseUsername(String decoded) {
        if (decoded == null) {
            return null;
        }
        int colon = decoded.indexOf(58);
        if (colon < 0) {
            return null;
        }
        return decoded.substring(0, colon).trim();
    }

    private String parsePassword(String decoded) {
        if (decoded == null) {
            return null;
        }
        int colon = decoded.indexOf(58);
        if (colon < 0) {
            return null;
        }
        return decoded.substring(colon + 1).trim();
    }

    private String decodeBasicAuthorizationString(String authorization) {
        if (authorization == null || !authorization.toLowerCase().startsWith("basic ")) {
            return null;
        }
        authorization = authorization.substring(6).trim();
        return new String(Base64.decodeBase64((byte[])authorization.getBytes()));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

