/*
 * Decompiled with CFR 0.152.
 */
package org.suigeneris.jrcs.rcs.impl;

import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.suigeneris.jrcs.diff.PatchFailedException;
import org.suigeneris.jrcs.diff.Revision;
import org.suigeneris.jrcs.diff.delta.AddDelta;
import org.suigeneris.jrcs.diff.delta.Chunk;
import org.suigeneris.jrcs.diff.delta.DeleteDelta;
import org.suigeneris.jrcs.diff.delta.Delta;
import org.suigeneris.jrcs.rcs.Archive;
import org.suigeneris.jrcs.rcs.InvalidFileFormatException;
import org.suigeneris.jrcs.rcs.InvalidVersionNumberException;
import org.suigeneris.jrcs.rcs.Version;
import org.suigeneris.jrcs.rcs.impl.BranchNode;
import org.suigeneris.jrcs.rcs.impl.Line;
import org.suigeneris.jrcs.rcs.impl.NodeNotFoundException;
import org.suigeneris.jrcs.rcs.impl.Path;
import org.suigeneris.jrcs.rcs.impl.Phrases;
import org.suigeneris.jrcs.rcs.impl.TrunkNode;
import org.suigeneris.jrcs.util.ToString;

public abstract class Node
extends ToString
implements Comparable {
    public final Version version;
    protected Date date = new Date();
    protected String author = System.getProperty("user.name");
    protected String state = "Exp";
    protected String log = "";
    protected String locker = "";
    protected String text;
    protected Node rcsnext;
    protected Node parent;
    protected Node child;
    protected TreeMap branches = null;
    protected Phrases phrases = null;
    protected static final Format dateFormatter = new MessageFormat("\t{0,number,##00}.{1,number,00}.{2,number,00}.{3,number,00}.{4,number,00}.{5,number,00}");
    protected static final DateFormat dateFormat = new SimpleDateFormat("yy.MM.dd.HH.mm.ss");
    protected static final DateFormat dateFormat2K = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss");

    protected Node(Node other) {
        this(other.version, null);
        this.date = other.date;
        this.author = other.author;
        this.state = other.state;
        this.log = other.log;
        this.locker = other.locker;
    }

    protected Node(Version vernum, Node rcsnext) {
        if (vernum == null) {
            throw new IllegalArgumentException(vernum.toString());
        }
        this.version = (Version)vernum.clone();
        this.setRCSNext(rcsnext);
    }

    public static Node newNode(Version vernum, Node rcsnext) throws InvalidVersionNumberException {
        if (vernum.isTrunk()) {
            return new TrunkNode(vernum, (TrunkNode)rcsnext);
        }
        return new BranchNode(vernum, (BranchNode)rcsnext);
    }

    static Node newNode(Version vernum) throws InvalidVersionNumberException {
        return Node.newNode(vernum, null);
    }

    public int compareTo(Object other) {
        if (other == this) {
            return 0;
        }
        if (!(other instanceof Node)) {
            return -1;
        }
        return this.version.compareTo(((Node)other).version);
    }

    public boolean isGhost() {
        return this.version.isGhost() || this.text == null;
    }

    public BranchNode getBranch(int no) {
        if (this.branches == null) {
            return null;
        }
        if (no == 0) {
            Integer branchNo = (Integer)this.branches.lastKey();
            return branchNo == null ? null : this.branches.get(branchNo);
        }
        return (BranchNode)this.branches.get(new Integer(no));
    }

    public Node root() {
        Node result = this;
        while (result.parent != null) {
            result = result.parent;
        }
        return result;
    }

    public void setLocker(String user) {
        this.locker = user.intern();
    }

    public void setAuthor(String user) {
        this.author = user.intern();
    }

    public void setDate(int[] value) {
        this.date = new GregorianCalendar(value[0] + (value[0] <= 99 ? 1900 : 0), value[1] - 1, value[2], value[3], value[4], value[5]).getTime();
    }

    public void setState(String value) {
        this.state = value;
    }

    public void setRCSNext(Node node) {
        this.rcsnext = node;
    }

    public void setLog(String value) {
        this.log = value.endsWith(Archive.RCS_NEWLINE) ? value.substring(0, value.length() - 1) : value;
    }

    public void setText(String value) {
        this.text = value;
    }

    public void setText(Object[] value) {
        this.setText(Node.arrayToString((Object[])value, (String)Archive.RCS_NEWLINE));
    }

    public void addBranch(BranchNode node) throws InvalidVersionNumberException {
        if (node.version.isLessThan(this.version) || node.version.size() != this.version.size() + 2) {
            throw new InvalidVersionNumberException("version must be grater");
        }
        int branchno = node.version.at(this.version.size());
        if (this.branches == null) {
            this.branches = new TreeMap();
        }
        this.branches.put(new Integer(branchno), node);
        node.parent = this;
    }

    public void removeBranch(Node node) {
        if (this.version.size() >= node.version.size()) {
            return;
        }
        int branchno = node.version.at(this.version.size());
        this.branches.remove(new Integer(branchno));
        BranchNode child = (BranchNode)node.getChild();
        if (child != null) {
            this.parent.addBranch(child);
        }
    }

    public Version nextVersion() {
        return this.version.next();
    }

    public Version newBranchVersion() {
        Version result = new Version(this.version);
        if (this.branches == null || this.branches.size() <= 0) {
            result.__addBranch(1);
        } else {
            result.__addBranch((int)((Integer)this.branches.lastKey()));
        }
        result.__addBranch(1);
        return result;
    }

    public Node getRCSNext() {
        return this.rcsnext;
    }

    public Path pathTo(Version vernum) throws NodeNotFoundException {
        return this.pathTo(vernum, false);
    }

    public Path pathTo(Version vernum, boolean soft) throws NodeNotFoundException {
        Path path = new Path();
        Node target = this;
        do {
            path.add(target);
        } while ((target = target.nextInPathTo(vernum, soft)) != null);
        return path;
    }

    public abstract Node nextInPathTo(Version var1, boolean var2) throws NodeNotFoundException;

    public abstract Node deltaRevision();

    public void patch(List original) throws InvalidFileFormatException, PatchFailedException {
        this.patch(original, false);
    }

    public void patch(List original, boolean annotate) throws InvalidFileFormatException, PatchFailedException {
        String cmd;
        Revision revision = new Revision();
        Object[] lines = this.getText();
        for (int it = 0; it < lines.length && (cmd = lines[it].toString()).length() != 0; ++it) {
            int count;
            int n;
            char action;
            StringTokenizer t = new StringTokenizer(cmd, "ad ", true);
            try {
                action = t.nextToken().charAt(0);
                n = Integer.parseInt(t.nextToken());
                t.nextToken();
                count = Integer.parseInt(t.nextToken());
            }
            catch (Exception e) {
                throw new InvalidFileFormatException(this.version + ":line:" + ":" + e.getClass().getName(), e);
            }
            if (action == 'd') {
                revision.addDelta((Delta)new DeleteDelta(new Chunk(n - 1, count)));
                continue;
            }
            if (action == 'a') {
                revision.addDelta((Delta)new AddDelta(n, new Chunk(this.getTextLines(it + 1, it + 1 + count), 0, count, n - 1)));
                it += count;
                continue;
            }
            throw new InvalidFileFormatException(this.version.toString());
        }
        revision.applyTo(original);
    }

    public void toString(StringBuffer s) {
        this.toString(s, Archive.RCS_NEWLINE);
    }

    public void toString(StringBuffer s, String EOL) {
        String EOI = ";" + EOL;
        String NLT = EOL + "\t";
        s.append(EOL);
        s.append(this.version.toString() + EOL);
        s.append("date");
        if (this.date != null) {
            DateFormat formatter = dateFormat;
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(this.date);
            if (cal.get(1) > 1999) {
                formatter = dateFormat2K;
            }
            s.append("\t" + formatter.format(this.date));
        }
        s.append(";\tauthor");
        if (this.author != null) {
            s.append(" " + this.author);
        }
        s.append(";\tstate");
        if (this.state != null) {
            s.append(" ");
            s.append(this.state);
        }
        s.append(EOI);
        s.append("branches");
        if (this.branches != null) {
            Iterator i = this.branches.values().iterator();
            while (i.hasNext()) {
                Node n = (Node)i.next();
                if (n == null) continue;
                s.append(NLT + n.version);
            }
        }
        s.append(EOI);
        s.append("next\t");
        if (this.rcsnext != null) {
            s.append(this.rcsnext.version.toString());
        }
        s.append(EOI);
    }

    public String toText() {
        StringBuffer s = new StringBuffer();
        this.toText(s, Archive.RCS_NEWLINE);
        return s.toString();
    }

    public void toText(StringBuffer s, String EOL) {
        s.append(EOL + EOL);
        s.append(this.version.toString() + EOL);
        s.append("log" + EOL);
        if (this.log.length() == 0) {
            s.append(Archive.quoteString(""));
        } else {
            s.append(Archive.quoteString(this.log + EOL));
        }
        s.append(EOL);
        if (this.phrases != null) {
            s.append(this.phrases.toString());
        }
        s.append("text" + EOL);
        s.append(Archive.quoteString(this.text));
        s.append(EOL);
        if (this.branches != null) {
            Iterator i = this.branches.values().iterator();
            while (i.hasNext()) {
                Node n = (Node)i.next();
                if (n == null) continue;
                n.toText(s, EOL);
            }
        }
    }

    public List getTextLines() {
        return this.getTextLines(new LinkedList());
    }

    public List getTextLines(int from, int to) {
        return this.getTextLines(new LinkedList(), from, to);
    }

    public List getTextLines(List lines) {
        return this.getTextLines(lines, 0, this.getText().length);
    }

    public List getTextLines(List lines, int from, int to) {
        Object[] t = this.getText();
        for (int i = from; i < to; ++i) {
            lines.add(new Line(this.deltaRevision(), t[i]));
        }
        return lines;
    }

    public final Date getDate() {
        return this.date;
    }

    public final String getAuthor() {
        return this.author;
    }

    public final String getState() {
        return this.state;
    }

    public final String getLog() {
        return this.log;
    }

    public final String getLocker() {
        return this.locker;
    }

    public final Object[] getText() {
        return ToString.stringToArray((String)this.text, (String)Archive.RCS_NEWLINE);
    }

    public final Object[] mergedText() {
        return new Object[]{this.text};
    }

    public final Node getChild() {
        return this.child;
    }

    public final TreeMap getBranches() {
        return this.branches;
    }

    public final Node getParent() {
        return this.parent;
    }

    public final Version getVersion() {
        return this.version;
    }

    public Phrases getPhrases() {
        return this.phrases;
    }
}

