/*
 * Decompiled with CFR 0.152.
 */
package com.github.ooxi.jdatauri;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;

public class DataUri {
    private static final String CHARSET_OPTION_NAME = "charset";
    private static final String FILENAME_OPTION_NAME = "filename";
    private static final String CONTENT_DISPOSITION_OPTION_NAME = "content-disposition";
    private final String mime;
    private final Charset charset;
    private final String filename;
    private final String contentDisposition;
    private final byte[] data;
    private static final Pattern PLUS = Pattern.compile("+", 16);

    public DataUri(String mime, Charset charset, byte[] data) {
        this(mime, charset, null, null, data);
    }

    public DataUri(String mime, Charset charset, String filename, String contentDisposition, byte[] data) {
        this.mime = mime;
        this.charset = charset;
        this.filename = filename;
        this.contentDisposition = contentDisposition;
        this.data = data;
        if (null == mime) {
            throw new NullPointerException("`mime' must not be null");
        }
        if (null == data) {
            throw new NullPointerException("`data' must not be null");
        }
    }

    public String getMime() {
        return this.mime;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public byte[] getData() {
        return this.data;
    }

    public int hashCode() {
        int hash = 3;
        hash = 23 * hash + (this.mime != null ? this.mime.hashCode() : 0);
        hash = 23 * hash + (this.charset != null ? this.charset.hashCode() : 0);
        hash = 23 * hash + (this.filename != null ? this.filename.hashCode() : 0);
        hash = 23 * hash + (this.contentDisposition != null ? this.contentDisposition.hashCode() : 0);
        hash = 23 * hash + Arrays.hashCode(this.data);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataUri other = (DataUri)obj;
        if (this.mime == null ? other.mime != null : !this.mime.equals(other.mime)) {
            return false;
        }
        if (!(this.charset == other.charset || this.charset != null && this.charset.equals(other.charset))) {
            return false;
        }
        if (this.filename == null ? other.filename != null : !this.filename.equals(other.filename)) {
            return false;
        }
        if (this.contentDisposition == null ? other.contentDisposition != null : !this.contentDisposition.equals(other.contentDisposition)) {
            return false;
        }
        return Arrays.equals(this.data, other.data);
    }

    public static DataUri parse(String uri, Charset charset) {
        if (!uri.toLowerCase().startsWith("data:")) {
            throw new IllegalArgumentException("URI must start with a case-insensitive `data:'");
        }
        if (-1 == uri.indexOf(44)) {
            throw new IllegalArgumentException("URI must contain a `,'");
        }
        List<String> supportedContentEncodings = Arrays.asList("base64");
        String mimeType = "text/plain";
        String contentEncoding = "";
        boolean contentEncodingAlreadySet = false;
        final HashMap<String, String> supportedValues = new HashMap<String, String>(){
            {
                this.put(DataUri.CHARSET_OPTION_NAME, "");
                this.put(DataUri.FILENAME_OPTION_NAME, "");
                this.put(DataUri.CONTENT_DISPOSITION_OPTION_NAME, "");
            }
        };
        HashMap<String, Boolean> supportedValueSetBits = new HashMap<String, Boolean>(){
            {
                for (String key : supportedValues.keySet()) {
                    this.put(key, false);
                }
            }
        };
        int comma = uri.indexOf(44);
        String temp = uri.substring("data:".length(), comma);
        String[] headers = temp.split(";");
        for (int header = 0; header < headers.length; ++header) {
            boolean valueSet;
            String nameCaseInsensitive;
            String name;
            String s = headers[header];
            s = s.toLowerCase();
            int eq = s.indexOf(61);
            String value = "";
            if (-1 == eq) {
                name = DataUri.percentDecode(s, charset);
                name = name.trim();
            } else {
                name = s.substring(0, eq);
                name = DataUri.percentDecode(name, charset);
                name = name.trim();
                value = s.substring(eq + 1);
                value = DataUri.percentDecode(value, charset);
                value = value.trim();
            }
            if (0 == header && -1 == eq && !name.isEmpty()) {
                mimeType = name;
                continue;
            }
            if (-1 == eq) {
                nameCaseInsensitive = name.toLowerCase();
                if (!supportedContentEncodings.contains(nameCaseInsensitive) || contentEncodingAlreadySet) continue;
                contentEncoding = name;
                contentEncodingAlreadySet = true;
                continue;
            }
            nameCaseInsensitive = name.toLowerCase();
            if (value.isEmpty() || !supportedValues.containsKey(nameCaseInsensitive) || (valueSet = ((Boolean)supportedValueSetBits.get(nameCaseInsensitive)).booleanValue())) continue;
            supportedValues.put(nameCaseInsensitive, value);
            supportedValueSetBits.put(nameCaseInsensitive, true);
        }
        String data = uri.substring(comma + 1);
        data = DataUri.percentDecode(data, charset);
        String finalMimeType = mimeType;
        Charset finalCharset = ((String)supportedValues.get(CHARSET_OPTION_NAME)).isEmpty() ? null : Charset.forName((String)supportedValues.get(CHARSET_OPTION_NAME));
        String finalFilename = ((String)supportedValues.get(FILENAME_OPTION_NAME)).isEmpty() ? null : (String)supportedValues.get(FILENAME_OPTION_NAME);
        String finalContentDisposition = ((String)supportedValues.get(CONTENT_DISPOSITION_OPTION_NAME)).isEmpty() ? null : (String)supportedValues.get(CONTENT_DISPOSITION_OPTION_NAME);
        byte[] finalData = "base64".equalsIgnoreCase(contentEncoding) ? Base64.decodeBase64((String)data) : data.getBytes(charset);
        DataUri dataURIObject = new DataUri(finalMimeType, finalCharset, finalFilename, finalContentDisposition, finalData);
        return dataURIObject;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("data:").append(this.getMime()).append(";");
        if (this.charset != null) {
            s.append("charset=").append(this.charset.name()).append(";");
        }
        if (this.contentDisposition != null) {
            s.append("content-disposition=").append(this.contentDisposition).append(";");
        }
        if (this.filename != null) {
            s.append("filename=").append(this.filename).append(";");
        }
        s.append("base64,").append(Base64.encodeBase64String((byte[])this.getData()));
        return s.toString();
    }

    private static String percentDecode(String s, Charset cs) {
        try {
            s = PLUS.matcher(s).replaceAll("%2B");
            return URLDecoder.decode(s, cs.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Charset `" + cs.name() + "' not supported", e);
        }
    }
}

