/*
 * Decompiled with CFR 0.152.
 */
package org.incava.diff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.incava.diff.LCSTable;
import org.incava.diff.Thresholds;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LCS<ObjectType> {
    private final List<ObjectType> from;
    private final List<ObjectType> to;
    private final Comparator<ObjectType> comparator;

    public LCS(ObjectType[] from, ObjectType[] to, Comparator<ObjectType> comp) {
        this(Arrays.asList(from), Arrays.asList(to), comp);
    }

    public LCS(ObjectType[] from, ObjectType[] to) {
        this(from, to, null);
    }

    public LCS(List<ObjectType> from, List<ObjectType> to) {
        this(from, to, null);
    }

    public LCS(List<ObjectType> from, List<ObjectType> to, Comparator<ObjectType> comp) {
        this.from = from;
        this.to = to;
        this.comparator = comp;
    }

    public List<Integer> getMatches() {
        int fromStart = 0;
        int fromEnd = this.from.size() - 1;
        int toStart = 0;
        int toEnd = this.to.size() - 1;
        TreeMap<Integer, Integer> matches = new TreeMap<Integer, Integer>();
        while (fromStart <= fromEnd && toStart <= toEnd && this.equals(this.comparator, this.from.get(fromStart), this.to.get(toStart))) {
            matches.put(fromStart++, toStart++);
        }
        while (fromStart <= fromEnd && toStart <= toEnd && this.equals(this.comparator, this.from.get(fromEnd), this.to.get(toEnd))) {
            matches.put(fromEnd--, toEnd--);
        }
        this.addMatches(matches, fromStart, fromEnd, toStart, toEnd);
        return LCS.toList(matches);
    }

    public void addMatches(TreeMap<Integer, Integer> matches, int fromStart, int fromEnd, int toStart, int toEnd) {
        Map<ObjectType, List<Integer>> toMatches = this.getToMatches(toStart, toEnd);
        LCSTable links = new LCSTable();
        Thresholds thresh = new Thresholds();
        for (int idx = fromStart; idx <= fromEnd; ++idx) {
            ObjectType fromElement = this.from.get(idx);
            List<Integer> positions = toMatches.get(fromElement);
            if (positions == null) continue;
            Integer k = 0;
            ListIterator<Integer> pit = positions.listIterator(positions.size());
            while (pit.hasPrevious()) {
                Integer j = pit.previous();
                k = thresh.insert(j, k);
                if (k == null) continue;
                links.update(idx, j, k);
            }
        }
        if (!thresh.isEmpty()) {
            Integer ti = (Integer)thresh.lastKey();
            Map<Integer, Integer> chain = links.getChain(ti);
            matches.putAll(chain);
        }
    }

    public Map<ObjectType, List<Integer>> createMatchesMap() {
        if (this.comparator == null) {
            if (this.from.size() > 0 && this.from.get(0) instanceof Comparable) {
                return new TreeMap();
            }
            return new HashMap();
        }
        return new TreeMap(this.comparator);
    }

    public Map<ObjectType, List<Integer>> getToMatches(int toStart, int toEnd) {
        Map<ObjectType, List<Integer>> toMatches = this.createMatchesMap();
        for (int toIdx = toStart; toIdx <= toEnd; ++toIdx) {
            ObjectType key = this.to.get(toIdx);
            List<Integer> positions = toMatches.get(key);
            if (positions == null) {
                positions = new ArrayList<Integer>();
                toMatches.put(key, positions);
            }
            positions.add(toIdx);
        }
        return toMatches;
    }

    protected boolean equals(Comparator<ObjectType> comparator, ObjectType x, ObjectType y) {
        return comparator == null ? x.equals(y) : comparator.compare(x, y) == 0;
    }

    protected static List<Integer> toList(TreeMap<Integer, Integer> map) {
        int size = map.isEmpty() ? 0 : 1 + map.lastKey();
        ArrayList<Integer> list = new ArrayList<Integer>(Collections.nCopies(size, null));
        for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
            list.set(entry.getKey(), entry.getValue());
        }
        return list;
    }
}

