/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.CSSOMObjectImpl;
import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.format.CSSFormat;
import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.parser.Locatable;
import com.steadystate.css.parser.SACMediaListImpl;
import com.steadystate.css.parser.media.MediaQuery;
import com.steadystate.css.userdata.UserDataConstants;
import com.steadystate.css.util.LangUtils;
import com.steadystate.css.util.ThrowCssExceptionErrorHandler;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Locator;
import org.w3c.css.sac.SACMediaList;
import org.w3c.dom.DOMException;
import org.w3c.dom.stylesheets.MediaList;

public class MediaListImpl
extends CSSOMObjectImpl
implements MediaList {
    private static final long serialVersionUID = 6662784733573034870L;
    private List<MediaQuery> mediaQueries_ = new ArrayList<MediaQuery>(10);

    public MediaListImpl(SACMediaList mediaList) {
        this();
        Locator locator;
        this.setMediaList(mediaList);
        if (mediaList instanceof Locatable && (locator = ((Locatable)mediaList).getLocator()) != null) {
            this.setUserData(UserDataConstants.KEY_LOCATOR, locator);
        }
    }

    public MediaListImpl() {
    }

    @Override
    public String getMediaText() {
        return this.getMediaText(null);
    }

    public String getMediaText(CSSFormat format) {
        StringBuilder sb = new StringBuilder("");
        boolean isNotFirst = false;
        for (MediaQuery mediaQuery : this.mediaQueries_) {
            if (isNotFirst) {
                sb.append(", ");
            } else {
                isNotFirst = true;
            }
            sb.append(mediaQuery.getCssText(format));
        }
        return sb.toString();
    }

    @Override
    public void setMediaText(String mediaText) throws DOMException {
        InputSource source = new InputSource((Reader)new StringReader(mediaText));
        try {
            CSSOMParser parser = new CSSOMParser();
            parser.setErrorHandler(ThrowCssExceptionErrorHandler.INSTANCE);
            SACMediaList sml = parser.parseMedia(source);
            this.setMediaList(sml);
        }
        catch (CSSParseException e) {
            throw new DOMException(12, e.getLocalizedMessage());
        }
        catch (IOException e) {
            throw new DOMException(8, e.getLocalizedMessage());
        }
    }

    @Override
    public int getLength() {
        return this.mediaQueries_.size();
    }

    @Override
    public String item(int index) {
        MediaQuery mq = this.mediaQuery(index);
        if (null == mq) {
            return null;
        }
        return mq.getMedia();
    }

    public MediaQuery mediaQuery(int index) {
        if (index < 0 || index >= this.mediaQueries_.size()) {
            return null;
        }
        return this.mediaQueries_.get(index);
    }

    @Override
    public void deleteMedium(String oldMedium) throws DOMException {
        for (MediaQuery mediaQuery : this.mediaQueries_) {
            String str = mediaQuery.getMedia();
            if (!str.equalsIgnoreCase(oldMedium)) continue;
            this.mediaQueries_.remove(mediaQuery);
            return;
        }
        throw new DOMExceptionImpl(8, 18);
    }

    @Override
    public void appendMedium(String newMedium) throws DOMException {
        this.mediaQueries_.add(new MediaQuery(newMedium));
    }

    public String toString() {
        return this.getMediaText(null);
    }

    public void setMedia(List<String> media) {
        this.mediaQueries_.clear();
        for (String medium : media) {
            this.mediaQueries_.add(new MediaQuery(medium));
        }
    }

    private void setMediaList(SACMediaList mediaList) {
        if (mediaList instanceof SACMediaListImpl) {
            SACMediaListImpl impl = (SACMediaListImpl)mediaList;
            for (int i = 0; i < mediaList.getLength(); ++i) {
                this.mediaQueries_.add(impl.mediaQuery(i));
            }
            return;
        }
        for (int i = 0; i < mediaList.getLength(); ++i) {
            this.mediaQueries_.add(new MediaQuery(mediaList.item(i)));
        }
    }

    private boolean equalsMedia(MediaList ml) {
        if (ml == null || this.getLength() != ml.getLength()) {
            return false;
        }
        for (int i = 0; i < this.getLength(); ++i) {
            String m2;
            String m1 = this.item(i);
            if (LangUtils.equals(m1, m2 = ml.item(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MediaList)) {
            return false;
        }
        MediaList ml = (MediaList)obj;
        return super.equals(obj) && this.equalsMedia(ml);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = LangUtils.hashCode(hash, this.mediaQueries_);
        return hash;
    }
}

