/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom4j;

import io.sf.carte.doc.agent.DeviceFactory;
import io.sf.carte.doc.dom4j.HrefAttribute;
import io.sf.carte.doc.dom4j.LinkElement;
import io.sf.carte.doc.dom4j.StyleDefinerElement;
import io.sf.carte.doc.dom4j.StyleElement;
import io.sf.carte.doc.dom4j.XHTMLDocumentFactory;
import io.sf.carte.doc.dom4j.XHTMLElement;
import io.sf.carte.doc.style.css.CSSCanvas;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSMediaException;
import io.sf.carte.doc.style.css.CSSPropertyDefinition;
import io.sf.carte.doc.style.css.CSSStyleSheet;
import io.sf.carte.doc.style.css.DocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.ErrorHandler;
import io.sf.carte.doc.style.css.LinkStyle;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.SheetErrorHandler;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.nsac.CSSBudgetException;
import io.sf.carte.doc.style.css.nsac.InputSource;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.BaseDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.om.DefaultErrorHandler;
import io.sf.carte.doc.style.css.om.StyleSheetList;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMDocumentType;
import org.dom4j.dom.DOMElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMStringList;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.stylesheets.StyleSheet;

public class XHTMLDocument
extends DOMDocument
implements CSSDocument {
    public static final String XHTML_NAMESPACE_URI = "http://www.w3.org/1999/xhtml";
    private static final long serialVersionUID = 7L;
    private String documentURI = null;
    private URL baseURL = null;
    private DocumentCSSStyleSheet mergedStyleSheet = null;
    private int styleCacheSerial = Integer.MIN_VALUE;
    private Set<CSSPropertyDefinition> registeredPropertySet = null;
    Set<StyleDefinerElement> linkedStyle = new LinkedHashSet<StyleDefinerElement>(4);
    Set<StyleDefinerElement> embeddedStyle = new LinkedHashSet<StyleDefinerElement>(3);
    private final MyOMStyleSheetList sheets = new MyOMStyleSheetList(7);
    private String metaDefaultStyleSet = "";
    private String metaReferrerPolicy = "";
    private String lastStyleSheetSet = null;
    private String targetMedium = null;
    private final Map<String, CSSCanvas> canvases = new HashMap<String, CSSCanvas>(3);
    private final ErrorHandler errorHandler = this.createErrorHandler();

    protected XHTMLDocument() {
    }

    protected XHTMLDocument(String name) {
        super(name);
    }

    protected XHTMLDocument(DOMElement rootElement) {
        super(rootElement);
    }

    protected XHTMLDocument(DOMDocumentType docType) {
        super(docType);
    }

    protected XHTMLDocument(DOMElement rootElement, DOMDocumentType docType) {
        super(rootElement, docType);
    }

    protected XHTMLDocument(String name, DOMElement rootElement, DOMDocumentType docType) {
        super(name, rootElement, docType);
    }

    protected String elementID(org.dom4j.Element element) {
        return element.attributeValue("id");
    }

    public String getCompatMode() {
        DocumentType doctype = this.getDoctype();
        if (doctype != null) {
            return "CSS1Compat";
        }
        return "BackCompat";
    }

    public CSSDocument.ComplianceMode getComplianceMode() {
        DocumentType doctype = this.getDoctype();
        if (doctype != null) {
            return CSSDocument.ComplianceMode.STRICT;
        }
        return CSSDocument.ComplianceMode.QUIRKS;
    }

    public XHTMLDocument getOwnerDocument() {
        return null;
    }

    public XHTMLElement getDocumentElement() {
        return (XHTMLElement)((Object)super.getDocumentElement());
    }

    public XHTMLElement getElementById(String elementId) {
        return (XHTMLElement)((Object)super.getElementById(elementId));
    }

    public XHTMLElement createElement(String name) throws DOMException {
        return (XHTMLElement)((Object)super.createElement(name));
    }

    public XHTMLElement createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        return (XHTMLElement)((Object)super.createElementNS(namespaceURI, qualifiedName));
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return null;
    }

    public String getInputEncoding() {
        return null;
    }

    @Deprecated
    public Object getFeature(String feature, String version) {
        return null;
    }

    @Deprecated
    public boolean getStrictErrorChecking() {
        return false;
    }

    @Deprecated
    public void setStrictErrorChecking(boolean strictErrorChecking) {
    }

    @Deprecated
    public void normalizeDocument() {
    }

    @Deprecated
    public String getXmlEncoding() {
        return null;
    }

    @Deprecated
    public boolean getXmlStandalone() {
        return false;
    }

    @Deprecated
    public String getXmlVersion() {
        return null;
    }

    public void registerProperty(CSSPropertyDefinition definition) {
        if (this.registeredPropertySet == null) {
            this.registeredPropertySet = new HashSet<CSSPropertyDefinition>();
        }
        this.registeredPropertySet.add(definition);
        this.mergedStyleSheet = null;
    }

    public StyleSheetList getStyleSheets() {
        if (this.sheets.needsUpdate()) {
            this.sheets.update();
        }
        return this.sheets;
    }

    private void updateStyleLists() {
        this.sheets.clear();
        Iterator<StyleDefinerElement> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            this.addLinkedSheet(links.next().getSheet());
        }
        Iterator<StyleDefinerElement> embd = this.embeddedStyle.iterator();
        while (embd.hasNext()) {
            this.addLinkedSheet(embd.next().getSheet());
        }
        this.sheets.setNeedsUpdate(false);
        if (this.lastStyleSheetSet != null) {
            this.setSelectedStyleSheetSet(this.lastStyleSheetSet);
        } else if (this.metaDefaultStyleSet.length() > 0) {
            this.setSelectedStyleSheetSet(this.metaDefaultStyleSet);
            this.lastStyleSheetSet = null;
        } else {
            this.setSelectedStyleSheetSet(this.sheets.getPreferredStyleSheetSet());
            this.lastStyleSheetSet = null;
        }
        if (this.getCanvas() != null) {
            this.getCanvas().reloadStyleState();
        }
    }

    private void addLinkedSheet(AbstractCSSStyleSheet linkedSheet) {
        if (linkedSheet != null) {
            this.sheets.add(linkedSheet);
        }
    }

    public DocumentCSSStyleSheet getStyleSheet() {
        if (this.mergedStyleSheet == null) {
            this.mergeStyleSheets();
        }
        return this.mergedStyleSheet;
    }

    private void mergeStyleSheets() {
        this.getStyleSheets();
        BaseDocumentCSSStyleSheet defSheet = this.getDocumentFactory().getDefaultStyleSheet(this.getComplianceMode());
        this.mergedStyleSheet = this.targetMedium == null ? defSheet.clone() : defSheet.clone(this.targetMedium);
        ((BaseDocumentCSSStyleSheet)this.mergedStyleSheet).setOwnerDocument((CSSDocument)this);
        Iterator<AbstractCSSStyleSheet> it = this.sheets.iterator();
        while (it.hasNext()) {
            this.mergedStyleSheet.addStyleSheet(it.next());
        }
        if (this.registeredPropertySet != null) {
            for (CSSPropertyDefinition def : this.registeredPropertySet) {
                this.mergedStyleSheet.registerProperty(def);
            }
        }
    }

    public boolean addStyleSheet(InputSource cssSrc) throws DOMException, IOException {
        String media = cssSrc.getMedia();
        if (media != null && !"all".equalsIgnoreCase(media)) {
            MediaQueryList mediaList;
            try {
                mediaList = this.getDocumentFactory().getStyleSheetFactory().createMediaQueryList(media, null);
            }
            catch (CSSBudgetException e) {
                DOMException ex = new DOMException(9, e.getMessage());
                ex.initCause(e);
                throw ex;
            }
            if (mediaList.isNotAllMedia()) {
                return false;
            }
            AbstractCSSStyleSheet sheet = this.getDocumentFactory().getStyleSheetFactory().createStyleSheet(cssSrc.getTitle(), mediaList);
            ((BaseDocumentCSSStyleSheet)sheet).setOwnerDocument((CSSDocument)this);
            boolean result = sheet.parseStyleSheet(cssSrc.getCharacterStream());
            if (result) {
                result = !mediaList.hasErrors();
            }
            this.getStyleSheet().addStyleSheet(sheet);
            return result;
        }
        return this.getStyleSheet().parseStyleSheet(cssSrc.getCharacterStream());
    }

    public DOMStringList getStyleSheetSets() {
        if (this.sheets.needsUpdate()) {
            this.sheets.update();
        }
        return this.sheets.getStyleSheetSets();
    }

    public String getSelectedStyleSheetSet() {
        if (this.sheets.needsUpdate()) {
            this.sheets.update();
        }
        String selectedSetName = "";
        Iterator<StyleDefinerElement> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            String title;
            AbstractCSSStyleSheet sheet = links.next().getSheet();
            if (sheet == null || (title = sheet.getTitle()) == null || title.length() == 0 || sheet.getDisabled()) continue;
            if (selectedSetName.length() > 0) {
                if (selectedSetName.equalsIgnoreCase(title)) continue;
                return null;
            }
            selectedSetName = title;
        }
        Iterator<StyleDefinerElement> style = this.embeddedStyle.iterator();
        while (links.hasNext()) {
            String title;
            AbstractCSSStyleSheet sheet = style.next().getSheet();
            if (sheet == null || (title = sheet.getTitle()) == null || title.length() <= 0 || sheet.getDisabled()) continue;
            if (selectedSetName.length() > 0) {
                if (selectedSetName.equalsIgnoreCase(title)) continue;
                return null;
            }
            selectedSetName = title;
        }
        return selectedSetName;
    }

    public void setSelectedStyleSheetSet(String name) {
        if (name == null || name.length() > 0 && !this.getStyleSheetSets().contains(name)) {
            return;
        }
        this.selectSheetSet(name, this.linkedStyle);
        this.selectSheetSet(name, this.embeddedStyle);
    }

    private void selectSheetSet(String name, Set<StyleDefinerElement> styleDefinerSet) {
        Iterator<StyleDefinerElement> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            String title;
            AbstractCSSStyleSheet sheet = links.next().getSheet();
            if (sheet == null || (title = sheet.getTitle()) == null || title.length() <= 0) continue;
            if (title.equals(name)) {
                sheet.setDisabled(false);
                this.lastStyleSheetSet = name;
                continue;
            }
            sheet.setDisabled(true);
        }
    }

    public String getLastStyleSheetSet() {
        return this.lastStyleSheetSet;
    }

    public void enableStyleSheetsForSet(String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        XHTMLDocument.enableStyleSheetSet(name, this.linkedStyle);
        XHTMLDocument.enableStyleSheetSet(name, this.embeddedStyle);
    }

    private static void enableStyleSheetSet(String name, Set<StyleDefinerElement> styleDefinerSet) {
        Iterator<StyleDefinerElement> links = styleDefinerSet.iterator();
        while (links.hasNext()) {
            String title;
            AbstractCSSStyleSheet sheet = links.next().getSheet();
            if (sheet == null || (title = sheet.getTitle()) == null || title.length() <= 0 || !title.equals(name)) continue;
            sheet.setDisabled(false);
        }
    }

    void onLinkStyleAdd(LinkStyle<?> element) {
        if (element instanceof LinkElement) {
            this.linkedStyle.add((LinkElement)element);
        } else if (element instanceof StyleElement) {
            this.embeddedStyle.add((StyleElement)element);
        }
        this.onStyleModify();
    }

    void onLinkStyleRemove(LinkStyle<?> element) {
        boolean removed = element instanceof LinkElement ? this.linkedStyle.remove(element) : (element instanceof StyleElement ? this.embeddedStyle.remove(element) : false);
        if (removed) {
            CSSStyleSheet sheet = element.getSheet();
            if (sheet != null) {
                String title = sheet.getTitle();
                if (title != null) {
                    this.sheets.remove(title);
                } else {
                    this.sheets.remove((StyleSheet)sheet);
                }
            }
            this.onStyleModify();
        }
    }

    void onStyleModify() {
        if (this.mergedStyleSheet != null) {
            this.mergedStyleSheet = null;
            ++this.styleCacheSerial;
        }
        this.sheets.setNeedsUpdate(true);
    }

    int getStyleCacheSerial() {
        return this.styleCacheSerial;
    }

    public StyleDatabase getStyleDatabase() {
        DeviceFactory df;
        StyleDatabase sdb = null;
        if (this.targetMedium != null && (df = this.getDocumentFactory().getStyleSheetFactory().getDeviceFactory()) != null) {
            sdb = df.getStyleDatabase(this.targetMedium);
        }
        return sdb;
    }

    public String getTargetMedium() {
        return this.targetMedium;
    }

    public void setTargetMedium(String medium) throws CSSMediaException {
        if ("all".equalsIgnoreCase(medium)) {
            this.targetMedium = null;
        } else {
            if (medium != null) {
                medium = medium.intern();
            }
            this.targetMedium = medium;
        }
        this.onStyleModify();
    }

    public CSSCanvas getCanvas() {
        CSSCanvas canvas;
        if (this.targetMedium == null) {
            return null;
        }
        if (this.canvases.containsKey(this.targetMedium)) {
            return this.canvases.get(this.targetMedium);
        }
        DeviceFactory df = this.getDocumentFactory().getStyleSheetFactory().getDeviceFactory();
        if (df != null) {
            canvas = df.createCanvas(this.targetMedium, (CSSDocument)this);
            this.canvases.put(this.targetMedium, canvas);
        } else {
            canvas = null;
        }
        return canvas;
    }

    public void rebuildCascade() {
        this.onStyleModify();
    }

    protected XHTMLDocumentFactory getDocumentFactory() {
        return (XHTMLDocumentFactory)super.getDocumentFactory();
    }

    protected ErrorHandler createErrorHandler() {
        return new MyDefaultErrorHandler();
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public boolean hasStyleIssues() {
        return this.sheets.hasErrorsOrWarnings() || this.getErrorHandler().hasErrors() || this.getErrorHandler().hasWarnings();
    }

    public void onMetaAdded(String name, String attribute) {
        if ("default-style".equalsIgnoreCase(name)) {
            this.metaDefaultStyleSet = attribute;
            this.onStyleModify();
        }
    }

    public void onMetaRemoved(String name, String attribute) {
        if ("default-style".equalsIgnoreCase(name)) {
            this.metaDefaultStyleSet = "";
            this.onStyleModify();
        }
    }

    public URL getBaseURL() {
        if (this.baseURL == null) {
            XHTMLElement elm = this.getDocumentElement();
            if (elm != null) {
                String href;
                DOMElement base;
                String attr = elm.getAttribute("xml:base");
                if (attr.length() != 0 && this.setBaseURL((Element)((Object)elm), attr)) {
                    return this.baseURL;
                }
                org.dom4j.Element head = elm.element("head");
                if (head != null && (base = (DOMElement)head.element("base")) != null && (href = base.attributeValue("href")) != null && href.length() != 0 && this.setBaseURL((Element)base, href)) {
                    return this.baseURL;
                }
            }
            if (this.documentURI != null) {
                try {
                    URI uri = new URI(this.documentURI);
                    this.baseURL = uri.toURL();
                }
                catch (MalformedURLException | URISyntaxException exception) {
                    // empty catch block
                }
            }
        }
        return this.baseURL;
    }

    public String getBaseURI() {
        URL url = this.getBaseURL();
        if (url == null) {
            return null;
        }
        return url.toExternalForm();
    }

    public void setBaseURL(URL baseURL) {
        this.baseURL = baseURL;
        HrefAttribute.onBaseModify(this);
    }

    boolean setBaseURL(Element element, String base) {
        String docUri = this.getDocumentURI();
        if (docUri != null) {
            URL url;
            URI uriBase;
            URI dUri;
            try {
                dUri = new URI(docUri);
            }
            catch (URISyntaxException e) {
                return this.setBaseForNullDocumentURI(base, element);
            }
            try {
                uriBase = new URI(base);
                uriBase = dUri.resolve(uriBase);
                url = uriBase.toURL();
            }
            catch (MalformedURLException e) {
                this.getErrorHandler().ioError(base, (IOException)e);
                return false;
            }
            catch (Exception e) {
                this.getErrorHandler().nodeError((Node)element, "Cannot convert URI to absolute: " + base, (Throwable)e);
                return false;
            }
            String docscheme = dUri.getScheme();
            String bscheme = uriBase.getScheme();
            if (!(docscheme.equals(bscheme) || bscheme.equals("https") || bscheme.equals("http") || docscheme.equals("file") || docscheme.equals("jar"))) {
                this.getErrorHandler().policyError((Node)element, "Remote document wants to set a non-http base URL: " + uriBase.toASCIIString());
                return false;
            }
            this.baseURL = url;
            return true;
        }
        return this.setBaseForNullDocumentURI(base, element);
    }

    private boolean setBaseForNullDocumentURI(String base, Element baseElement) {
        try {
            URI uriBase = new URI(base);
            String scheme = uriBase.getScheme();
            if (scheme.equals("https") || scheme.equals("http")) {
                this.baseURL = uriBase.toURL();
                return true;
            }
            this.getErrorHandler().policyError((Node)baseElement, "Untrusted document wants to set a non-http base URL: " + base);
        }
        catch (Exception e) {
            this.getErrorHandler().nodeError((Node)baseElement, "Cannot convert URI to absolute: " + base, (Throwable)e);
        }
        return false;
    }

    public boolean isSafeOrigin(URL linkedURL) {
        URL base = this.getBaseURL();
        String docHost = base.getHost();
        int docPort = base.getPort();
        if (docPort == -1) {
            docPort = base.getDefaultPort();
        }
        String linkedHost = linkedURL.getHost();
        int linkedPort = linkedURL.getPort();
        if (linkedPort == -1) {
            linkedPort = linkedURL.getDefaultPort();
        }
        return (docHost.equalsIgnoreCase(linkedHost) || ParseHelper.endsWithIgnoreCase((CharSequence)linkedHost, (CharSequence)('.' + docHost))) && docPort == linkedPort;
    }

    public boolean isAuthorizedOrigin(URL url) {
        String scheme = url.getProtocol();
        if (this.documentURI != null) {
            URL base = this.getBaseURL();
            String baseScheme = base.getProtocol();
            if (!(scheme.equalsIgnoreCase("https") || scheme.equalsIgnoreCase("http") || baseScheme.equals("file") || baseScheme.equals("jar"))) {
                return false;
            }
        } else if (!scheme.equalsIgnoreCase("https") && !scheme.equalsIgnoreCase("http")) {
            return false;
        }
        return true;
    }

    public String getReferrerPolicy() {
        NodeList nl = this.getElementsByTagName("meta");
        for (int i = nl.getLength() - 1; i >= 0; --i) {
            String policy;
            Element el = (Element)nl.item(i);
            if (!"referrer".equalsIgnoreCase(el.getAttribute("name")) || (policy = el.getAttribute("content")).length() == 0) continue;
            this.metaReferrerPolicy = policy;
            break;
        }
        return this.metaReferrerPolicy;
    }

    protected void setReferrerPolicyHeader(String policy) {
        if (this.metaReferrerPolicy.length() == 0) {
            this.metaReferrerPolicy = policy;
        }
    }

    public void setDocumentURI(String documentURI) {
        this.documentURI = documentURI;
        this.setBaseURL(null);
    }

    public String getDocumentURI() {
        return this.documentURI;
    }

    public URLConnection openConnection(URL url) throws IOException {
        return url.openConnection();
    }

    public InputStream openStream(String uri) throws IOException {
        return this.openConnection(this.getURL(uri)).getInputStream();
    }

    public boolean isVisitedURI(String href) {
        return false;
    }

    class MyOMStyleSheetList
    extends StyleSheetList {
        private static final long serialVersionUID = 1L;

        protected MyOMStyleSheetList(int initialCapacity) {
            super(initialCapacity);
        }

        protected boolean hasErrorsOrWarnings() {
            boolean hasRuleErrors = false;
            Iterator<AbstractCSSStyleSheet> it = this.iterator();
            while (it.hasNext()) {
                AbstractCSSStyleSheet sheet = it.next();
                SheetErrorHandler eh = sheet.getErrorHandler();
                if (!sheet.hasRuleErrorsOrWarnings() && !eh.hasSacErrors() && !eh.hasSacWarnings() && !eh.hasOMErrors() && !eh.hasOMWarnings()) continue;
                hasRuleErrors = true;
                break;
            }
            return hasRuleErrors;
        }

        protected Iterator<AbstractCSSStyleSheet> iterator() {
            return super.iterator();
        }

        protected void clear() {
            super.clear();
        }

        protected boolean needsUpdate() {
            return super.needsUpdate();
        }

        protected void setNeedsUpdate(boolean needsUpdate) {
            super.setNeedsUpdate(needsUpdate);
        }

        protected void update() {
            super.update();
            XHTMLDocument.this.updateStyleLists();
        }
    }

    class MyDefaultErrorHandler
    extends DefaultErrorHandler {
        private static final long serialVersionUID = 1L;

        MyDefaultErrorHandler() {
        }

        protected AbstractCSSStyleSheetFactory getStyleSheetFactory() {
            return XHTMLDocument.this.getDocumentFactory().getStyleSheetFactory();
        }
    }
}

