/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom4j;

import io.sf.carte.doc.dom4j.DOM4JCSSStyleSheet;
import io.sf.carte.doc.dom4j.StyleDefinerElement;
import io.sf.carte.doc.style.css.CSSStyleSheet;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.nsac.CSSBudgetException;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.MediaFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.dom4j.QName;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

class StyleElement
extends StyleDefinerElement {
    private static final long serialVersionUID = 2L;

    StyleElement(String name) {
        super(name);
    }

    StyleElement(QName qname) {
        super(qname);
    }

    StyleElement(QName qname, int attributeCount) {
        super(qname, attributeCount);
    }

    public void normalize() {
        if (!this.containsCSS()) {
            super.normalize();
        } else {
            AbstractCSSStyleSheet sheet = this.getSheet();
            if (sheet == null) {
                super.normalize();
            } else {
                super.setText(sheet.toString());
            }
        }
    }

    private boolean containsCSS() {
        AbstractCSSStyleSheet sheet;
        String type;
        return this.linkedSheet != null && ("text/css".equalsIgnoreCase(type = this.attributeValue("type")) || (type == null || type.length() == 0) && (sheet = this.getSheet()) != null && sheet.getCssRules().getLength() != 0);
    }

    @Override
    public AbstractCSSStyleSheet getSheet() {
        if (this.needsUpdate) {
            MediaQueryList mediaList;
            String type = this.attributeValue("type");
            if (type != null && !"text/css".equalsIgnoreCase(type) && type.length() != 0) {
                return null;
            }
            String media = this.attributeValue("media");
            if (media == null || media.trim().length() == 0) {
                mediaList = MediaFactory.createAllMedia();
            } else {
                try {
                    mediaList = this.getDocumentFactory().getStyleSheetFactory().createImmutableMediaQueryList(media, (Node)((Object)this));
                }
                catch (CSSBudgetException e) {
                    this.getErrorHandler().linkedStyleError((Node)((Object)this), e.getMessage());
                    return null;
                }
                if (mediaList.isNotAllMedia() && mediaList.hasErrors()) {
                    return null;
                }
            }
            String title = this.attributeValue("title");
            if (title != null && (title = title.trim()).length() == 0) {
                title = null;
            }
            if (this.linkedSheet == null) {
                this.linkedSheet = this.getDocumentFactory().createLinkedStyleSheet((Node)((Object)this), title, mediaList);
            } else {
                DOM4JCSSStyleSheet mysheet = (DOM4JCSSStyleSheet)this.linkedSheet;
                mysheet.setMedia(mediaList);
                mysheet.setTitle(title);
                this.linkedSheet.getCssRules().clear();
            }
            String styleText = this.getText();
            if (styleText.length() != 0) {
                this.linkedSheet.setHref(this.getBaseURI());
                StringReader re = new StringReader(styleText);
                try {
                    this.linkedSheet.parseStyleSheet((Reader)re);
                }
                catch (DOMException e) {
                    this.getErrorHandler().linkedSheetError((Exception)e, (CSSStyleSheet)this.linkedSheet);
                }
                catch (IOException e) {
                    this.getErrorHandler().linkedSheetError((Exception)e, (CSSStyleSheet)this.linkedSheet);
                }
            }
            this.needsUpdate = false;
        }
        return this.linkedSheet;
    }

    @Override
    void resetLinkedSheet() {
        super.resetLinkedSheet();
        if (this.linkedSheet != null) {
            this.getSheet();
        }
    }
}

