/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class UnicodeWildcardValue
extends TypedValue {
    private static final long serialVersionUID = 1L;
    private String wildcard = null;

    public UnicodeWildcardValue() {
        super(CSSValue.Type.UNICODE_WILDCARD);
    }

    protected UnicodeWildcardValue(UnicodeWildcardValue copied) {
        super(copied);
        this.wildcard = copied.wildcard;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        throw new DOMException(7, "This property is read-only.");
    }

    @Override
    public String getStringValue() {
        return this.wildcard;
    }

    @Override
    public void setStringValue(CSSValue.Type stringType, String stringValue) throws DOMException {
        this.checkModifiableProperty();
        if (stringType != CSSValue.Type.UNICODE_WILDCARD) {
            throw new DOMException(13, "Only setting wildcards is supported.");
        }
        if (stringValue == null) {
            throw new DOMException(5, "Null value.");
        }
        stringValue = stringValue.trim();
        this.checkWildcard(stringValue);
        this.wildcard = stringValue;
    }

    private void checkWildcard(String wildcard) {
        int len = wildcard.length();
        if (len == 0 || len > 6) {
            this.invalidWildcardError(wildcard);
        }
        for (int i = 0; i < len; ++i) {
            char c = wildcard.charAt(i);
            if (c == '?' || UnicodeWildcardValue.isHexChar(c)) continue;
            this.invalidWildcardError(wildcard);
        }
    }

    static boolean isHexChar(char codePoint) {
        return codePoint >= '0' && codePoint <= '9' || codePoint >= 'A' && codePoint <= 'F' || codePoint >= 'a' && codePoint <= 'f';
    }

    private void invalidWildcardError(String wildcard2) {
        throw new DOMException(12, "Not a valid wildcard: " + this.wildcard);
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write((CharSequence)"U+");
        wri.write((CharSequence)this.wildcard);
    }

    @Override
    public String getCssText() {
        return "U+" + this.wildcard;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.wildcard == null ? 0 : this.wildcard.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnicodeWildcardValue other = (UnicodeWildcardValue)obj;
        if (this.wildcard == null) {
            return other.wildcard == null;
        }
        return this.wildcard.equals(other.wildcard);
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public UnicodeWildcardValue clone() {
        return new UnicodeWildcardValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            UnicodeWildcardValue.this.wildcard = lunit.getStringValue();
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }
    }
}

