/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSPrimitiveValue;
import io.sf.carte.doc.style.css.CSSPrimitiveValueItem;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.CSSLexicalProcessingException;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueItem;
import java.util.Iterator;
import java.util.LinkedList;
import org.w3c.dom.DOMException;

public abstract class PrimitiveValue
extends StyleValue
implements CSSPrimitiveValue {
    private static final long serialVersionUID = 1L;
    private final CSSValue.Type primitiveType;
    private boolean subproperty = false;

    protected PrimitiveValue(CSSValue.Type unitType) {
        this.primitiveType = unitType;
    }

    protected PrimitiveValue(PrimitiveValue copied) {
        this.subproperty = copied.subproperty;
        this.primitiveType = copied.primitiveType;
    }

    @Override
    public CSSValue.Type getPrimitiveType() {
        return this.primitiveType;
    }

    @Override
    public boolean isPrimitiveValue() {
        return true;
    }

    @Override
    public void setExpectInteger() throws DOMException {
        throw new DOMException(17, "Expected an integer, found type " + (Object)((Object)this.getPrimitiveType()));
    }

    public void setSubproperty(boolean subp) {
        this.subproperty = subp;
    }

    @Override
    public boolean isSubproperty() {
        return this.subproperty;
    }

    void checkModifiableProperty() throws DOMException {
        if (this.isSubproperty() || this.isReadOnly()) {
            throw new DOMException(7, "This property was either set as a shorthand or as part of a more complex property. Must modify at a higher level (possibly at the style-declaration).");
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.primitiveType.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof PrimitiveValue)) {
            return false;
        }
        PrimitiveValue other = (PrimitiveValue)obj;
        return this.primitiveType == other.primitiveType;
    }

    LexicalSetter newLexicalSetter() {
        return null;
    }

    @Override
    public abstract PrimitiveValue clone();

    class LexicalSetter
    implements ValueItem,
    CSSPrimitiveValueItem {
        LexicalUnit nextLexicalUnit = null;
        private LinkedList<String> syntaxWarnings = null;

        LexicalSetter() {
        }

        void setLexicalUnit(LexicalUnit lunit) throws DOMException {
        }

        @Override
        public LexicalUnit getNextLexicalUnit() {
            return this.nextLexicalUnit;
        }

        @Override
        public PrimitiveValue getCSSValue() {
            return PrimitiveValue.this;
        }

        void reportSyntaxWarning(String message) {
            if (this.syntaxWarnings == null) {
                this.syntaxWarnings = new LinkedList();
            }
            this.syntaxWarnings.add(message);
        }

        @Override
        public boolean hasWarnings() {
            return this.syntaxWarnings != null;
        }

        @Override
        public void handleSyntaxWarnings(StyleDeclarationErrorHandler handler) {
            if (this.syntaxWarnings != null) {
                Iterator it = this.syntaxWarnings.iterator();
                while (it.hasNext()) {
                    handler.syntaxWarning((String)it.next());
                }
            }
        }

        boolean checkProxyValue(LexicalUnit lunit) {
            LexicalUnit.LexicalType type = lunit.getLexicalUnitType();
            if (type == LexicalUnit.LexicalType.VAR || type == LexicalUnit.LexicalType.ATTR) {
                throw new CSSLexicalProcessingException("Cannot handle this PROXY in this value.");
            }
            return false;
        }

        public String toString() {
            return PrimitiveValue.this.getCssText();
        }
    }
}

