/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSGradientValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.CSSLexicalProcessingException;
import io.sf.carte.doc.style.css.property.FunctionValue;
import io.sf.carte.doc.style.css.property.LexicalValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueList;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class GradientValue
extends FunctionValue
implements CSSGradientValue {
    private static final long serialVersionUID = 1L;
    private CSSGradientValue.GradientType gradientType = CSSGradientValue.GradientType.OTHER_GRADIENT;

    GradientValue() {
        super(CSSValue.Type.GRADIENT);
    }

    GradientValue(GradientValue copied) {
        super(copied);
        this.gradientType = copied.gradientType;
    }

    @Override
    public CSSGradientValue.GradientType getGradientType() {
        return this.gradientType;
    }

    @Override
    public CSSValueSyntax.Match matches(CSSValueSyntax syntax) {
        if (syntax != null) {
            if (syntax.getCategory() == CSSValueSyntax.Category.universal) {
                return CSSValueSyntax.Match.TRUE;
            }
            do {
                CSSValueSyntax.Match result;
                if ((result = this.matchesComponent(syntax)) == CSSValueSyntax.Match.FALSE) continue;
                return result;
            } while ((syntax = syntax.getNext()) != null);
        }
        return CSSValueSyntax.Match.FALSE;
    }

    @Override
    CSSValueSyntax.Match matchesComponent(CSSValueSyntax syntax) {
        switch (syntax.getCategory()) {
            case image: 
            case universal: {
                return CSSValueSyntax.Match.TRUE;
            }
        }
        return CSSValueSyntax.Match.FALSE;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.gradientType == null ? 0 : this.gradientType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GradientValue other = (GradientValue)obj;
        return this.gradientType == other.gradientType;
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public GradientValue clone() {
        return new GradientValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(GradientValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) throws DOMException {
            String funcname = lunit.getFunctionName();
            GradientValue.this.setFunctionName(funcname);
            funcname = funcname.toLowerCase(Locale.ROOT);
            LexicalUnit lu = lunit.getParameters();
            if (lu == null) {
                throw this.createDOMSyntaxException("Gradient without arguments");
            }
            if (funcname.endsWith("linear-gradient")) {
                if (funcname.equals("linear-gradient")) {
                    GradientValue.this.gradientType = CSSGradientValue.GradientType.LINEAR_GRADIENT;
                } else if (funcname.equals("repeating-linear-gradient")) {
                    GradientValue.this.gradientType = CSSGradientValue.GradientType.REPEATING_LINEAR_GRADIENT;
                } else {
                    GradientValue.this.gradientType = CSSGradientValue.GradientType.OTHER_GRADIENT;
                }
                this.setLinearGradient(lu, new ValueFactory());
            } else if (funcname.endsWith("radial-gradient")) {
                if (funcname.equals("radial-gradient")) {
                    GradientValue.this.gradientType = CSSGradientValue.GradientType.RADIAL_GRADIENT;
                } else if (funcname.equals("repeating-radial-gradient")) {
                    GradientValue.this.gradientType = CSSGradientValue.GradientType.REPEATING_RADIAL_GRADIENT;
                } else {
                    GradientValue.this.gradientType = CSSGradientValue.GradientType.OTHER_GRADIENT;
                }
                this.setRadialGradient(lu, new ValueFactory());
            } else if (funcname.endsWith("conic-gradient")) {
                if (funcname.equals("conic-gradient")) {
                    GradientValue.this.gradientType = CSSGradientValue.GradientType.CONIC_GRADIENT;
                } else if (funcname.equals("repeating-conic-gradient")) {
                    GradientValue.this.gradientType = CSSGradientValue.GradientType.REPEATING_CONIC_GRADIENT;
                } else {
                    GradientValue.this.gradientType = CSSGradientValue.GradientType.OTHER_GRADIENT;
                }
                this.setConicGradient(lu, new ValueFactory());
            } else {
                throw this.createDOMSyntaxException("Unknown gradient type");
            }
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }

        private DOMException createDOMSyntaxException(String message) {
            return new DOMException(12, message);
        }

        private void setLinearGradient(LexicalUnit lu, ValueFactory factory) {
            int colorStopCount = 0;
            LexicalUnit colorStopLU = this.isLinearColorStop(lu) ? lu : this.setAngleArguments(lu, factory);
            if (colorStopLU == null) {
                throw this.createDOMSyntaxException("Expected angle, side or color stop, found: " + lu.toString());
            }
            do {
                colorStopLU = this.processLinearColorStop(colorStopLU, factory);
                ++colorStopCount;
                if (colorStopLU == null) continue;
                if (colorStopLU.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    colorStopLU = colorStopLU.getNextLexicalUnit();
                    continue;
                }
                throw this.createDOMSyntaxException("Expected color stops, found: " + lu.toString());
            } while (colorStopLU != null);
            if (colorStopCount < 2) {
                this.reportSyntaxWarning("Expected at least 2 color stops, found only one.");
            }
        }

        private LexicalUnit setAngleArguments(LexicalUnit lu, ValueFactory factory) {
            LexicalUnit finalLU = null;
            if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT) {
                String ident = lu.getStringValue().toLowerCase(Locale.ROOT);
                ValueList list = ValueList.createWSValueList();
                if ("to".equals(ident)) {
                    list.add(factory.createCSSPrimitiveValue(lu, true));
                    lu = lu.getNextLexicalUnit();
                } else {
                    if (!this.isSideValue(ident)) {
                        return null;
                    }
                    this.reportSyntaxWarning("Missing 'to' in side/corner specification in gradient: " + lu.toString());
                }
                if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT) {
                    ident = lu.getStringValue().toLowerCase(Locale.ROOT);
                    if (this.isSideValue(ident)) {
                        list.add(factory.createCSSPrimitiveValue(lu, true));
                        finalLU = lu = lu.getNextLexicalUnit();
                        if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && this.isSideValue(ident = lu.getStringValue().toLowerCase(Locale.ROOT))) {
                            list.add(factory.createCSSPrimitiveValue(lu, true));
                            finalLU = lu.getNextLexicalUnit();
                        }
                        GradientValue.this.getArguments().add(list);
                    }
                } else {
                    this.checkProxyValue(lu);
                }
            } else if (this.canBeAngleOrPercentage(lu)) {
                GradientValue.this.getArguments().add(factory.createCSSPrimitiveValue(lu, true));
                finalLU = lu.getNextLexicalUnit();
            } else {
                this.checkProxyValue(lu);
            }
            if (finalLU != null) {
                finalLU = finalLU.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA ? finalLU.getNextLexicalUnit() : null;
            }
            return finalLU;
        }

        private boolean isSideValue(String ident) {
            return "left".equals(ident) || "right".equals(ident) || "top".equals(ident) || "bottom".equals(ident);
        }

        private boolean isLinearColorStop(LexicalUnit lu) {
            LexicalUnit lu2 = lu.getNextLexicalUnit();
            if (this.isColorUnit(lu)) {
                return true;
            }
            return lu2 != null && this.isColorUnit(lu2) && ValueFactory.isLengthPercentageSACUnit(lu);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private LexicalUnit processLinearColorStop(LexicalUnit lu, ValueFactory factory) {
            PrimitiveValue hint;
            LexicalUnit finalLU = null;
            LexicalUnit lu2 = lu.getNextLexicalUnit();
            if (this.isColorUnit(lu)) {
                PrimitiveValue color;
                try {
                    color = factory.createCSSPrimitiveValue(lu, true);
                }
                catch (CSSLexicalProcessingException e) {
                    PrimitiveValue.LexicalSetter item = new LexicalValue().newLexicalSetter();
                    item.setLexicalUnit(lu.shallowClone());
                    color = item.getCSSValue();
                }
                if (lu2 != null && ValueFactory.isLengthPercentageSACUnit(lu2)) {
                    ValueList list = ValueList.createWSValueList();
                    list.add(color);
                    list.add(factory.createCSSPrimitiveValue(lu2, true));
                    GradientValue.this.getArguments().add(list);
                    lu2 = lu2.getNextLexicalUnit();
                    if (lu2 == null) return lu2;
                    if (!ValueFactory.isLengthPercentageSACUnit(lu2)) return lu2;
                    list.add(factory.createCSSPrimitiveValue(lu2, true));
                    lu2 = lu2.getNextLexicalUnit();
                    return lu2;
                } else {
                    GradientValue.this.getArguments().add(color);
                }
                return lu2;
            }
            if (!ValueFactory.isLengthPercentageSACUnit(lu)) throw this.createDOMSyntaxException("Bad color stop");
            if (lu2 != null && this.isColorUnit(lu2)) {
                PrimitiveValue color;
                ValueList list = ValueList.createWSValueList();
                try {
                    color = factory.createCSSPrimitiveValue(lu2, true);
                }
                catch (CSSLexicalProcessingException e) {
                    PrimitiveValue.LexicalSetter item = new LexicalValue().newLexicalSetter();
                    item.setLexicalUnit(lu2.shallowClone());
                    color = item.getCSSValue();
                }
                list.add(color);
                list.add(factory.createCSSPrimitiveValue(lu, true));
                GradientValue.this.getArguments().add(list);
                return lu2.getNextLexicalUnit();
            }
            if (lu2 != null) {
                if (lu2.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) throw this.createDOMSyntaxException("Bad color stop");
            }
            try {
                hint = factory.createCSSPrimitiveValue(lu, true);
            }
            catch (CSSLexicalProcessingException e) {
                PrimitiveValue.LexicalSetter item = new LexicalValue().newLexicalSetter();
                item.setLexicalUnit(lu.shallowClone());
                hint = item.getCSSValue();
            }
            GradientValue.this.getArguments().add(hint);
            return lu2;
        }

        private boolean isColorUnit(LexicalUnit lunit) {
            return ValueFactory.isColorSACUnit(lunit);
        }

        private void setRadialGradient(LexicalUnit lu, ValueFactory factory) {
            LexicalUnit colorStopLU;
            int colorStopCount = 0;
            if (!this.isLinearColorStop(lu) && (lu = this.processNonColorStop(lu, factory)) != null && !this.isLinearColorStop(lu)) {
                lu = this.processNonColorStop(lu, factory);
            }
            if ((colorStopLU = lu) == null) {
                throw this.createDOMSyntaxException("Missing color stop");
            }
            do {
                colorStopLU = this.processLinearColorStop(colorStopLU, factory);
                ++colorStopCount;
                if (colorStopLU == null) continue;
                if (colorStopLU.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    colorStopLU = colorStopLU.getNextLexicalUnit();
                    continue;
                }
                throw this.createDOMSyntaxException("Expected color stops, found: " + lu.toString());
            } while (colorStopLU != null);
            if (colorStopCount < 2) {
                this.reportSyntaxWarning("Expected at least 2 color stops, found only one.");
            }
        }

        private LexicalUnit processNonColorStop(LexicalUnit lu, ValueFactory factory) {
            ValueList list = ValueList.createWSValueList();
            do {
                if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    if (list.isEmpty()) {
                        throw this.createDOMSyntaxException("Found empty argument: " + lu.toString());
                    }
                    lu = lu.getNextLexicalUnit();
                    break;
                }
                list.add(factory.createCSSPrimitiveValue(lu, true));
            } while ((lu = lu.getNextLexicalUnit()) != null);
            if (list.getLength() != 1) {
                GradientValue.this.getArguments().add(list);
            } else {
                GradientValue.this.getArguments().add(list.item(0));
            }
            return lu;
        }

        private void setConicGradient(LexicalUnit lu, ValueFactory factory) {
            LexicalUnit colorStopLU;
            int colorStopCount = 0;
            if (!this.isAngularColorStop(lu)) {
                ValueList list = ValueList.createWSValueList();
                do {
                    if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        if (list.isEmpty()) {
                            throw this.createDOMSyntaxException("Found empty argument: " + lu.toString());
                        }
                        lu = lu.getNextLexicalUnit();
                        break;
                    }
                    list.add(factory.createCSSPrimitiveValue(lu, true));
                } while ((lu = lu.getNextLexicalUnit()) != null);
                if (list.getLength() != 1) {
                    GradientValue.this.getArguments().add(list);
                } else {
                    GradientValue.this.getArguments().add(list.item(0));
                }
            }
            if ((colorStopLU = lu) == null) {
                throw this.createDOMSyntaxException("Missing angle, position or color stop in gradient");
            }
            do {
                colorStopLU = this.processAngularColorStop(colorStopLU, factory);
                ++colorStopCount;
                if (colorStopLU == null) continue;
                if (colorStopLU.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    colorStopLU = colorStopLU.getNextLexicalUnit();
                    continue;
                }
                throw this.createDOMSyntaxException("Expected color stops, found: " + lu.toString());
            } while (colorStopLU != null);
            if (colorStopCount < 2) {
                this.reportSyntaxWarning("Expected at least 2 color stops, found only one.");
            }
        }

        private boolean isAngularColorStop(LexicalUnit lu) {
            LexicalUnit lu2 = lu.getNextLexicalUnit();
            if (this.isColorUnit(lu)) {
                return true;
            }
            return lu2 != null && this.isColorUnit(lu2) && this.canBeAngleOrPercentage(lu);
        }

        private boolean canBeAngleOrPercentage(LexicalUnit lunit) throws CSSLexicalProcessingException {
            return ValueFactory.isAngleOrPercentageSACUnit(lunit);
        }

        private LexicalUnit processAngularColorStop(LexicalUnit lu, ValueFactory factory) {
            LexicalUnit finalLU = null;
            LexicalUnit lu2 = lu.getNextLexicalUnit();
            if (this.isColorUnit(lu)) {
                PrimitiveValue color;
                try {
                    color = factory.createCSSPrimitiveValue(lu, true);
                }
                catch (CSSLexicalProcessingException e) {
                    PrimitiveValue.LexicalSetter item = new LexicalValue().newLexicalSetter();
                    item.setLexicalUnit(lu.shallowClone());
                    color = item.getCSSValue();
                }
                if (lu2 != null && this.canBeAngleOrPercentage(lu2)) {
                    ValueList list = ValueList.createWSValueList();
                    list.add(color);
                    list.add(factory.createCSSPrimitiveValue(lu2, true));
                    GradientValue.this.getArguments().add(list);
                    lu2 = lu2.getNextLexicalUnit();
                    if (lu2 != null && this.canBeAngleOrPercentage(lu2)) {
                        list.add(factory.createCSSPrimitiveValue(lu2, true));
                        lu2 = lu2.getNextLexicalUnit();
                    }
                } else {
                    GradientValue.this.getArguments().add(color);
                }
                finalLU = lu2;
            } else if (lu2 != null && this.isColorUnit(lu2) && this.canBeAngleOrPercentage(lu)) {
                PrimitiveValue color;
                ValueList list = ValueList.createWSValueList();
                try {
                    color = factory.createCSSPrimitiveValue(lu2, true);
                }
                catch (CSSLexicalProcessingException e) {
                    PrimitiveValue.LexicalSetter item = new LexicalValue().newLexicalSetter();
                    item.setLexicalUnit(lu2.shallowClone());
                    color = item.getCSSValue();
                }
                list.add(color);
                list.add(factory.createCSSPrimitiveValue(lu, true));
                GradientValue.this.getArguments().add(list);
                finalLU = lu2.getNextLexicalUnit();
            } else if (this.canBeAngleOrPercentage(lu)) {
                GradientValue.this.getArguments().add(factory.createCSSPrimitiveValue(lu, true));
                finalLU = lu2;
            } else {
                throw this.createDOMSyntaxException("Bad angular color stop");
            }
            return finalLU;
        }
    }
}

