/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.AlgebraicExpression;
import io.sf.carte.doc.style.css.CSSExpression;
import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.CSSFunctionValue;
import io.sf.carte.doc.style.css.CSSMathFunctionValue;
import io.sf.carte.doc.style.css.CSSNumberValue;
import io.sf.carte.doc.style.css.CSSOperandExpression;
import io.sf.carte.doc.style.css.CSSPrimitiveValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueList;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.Unit;
import java.util.Iterator;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class Evaluator {
    private static final FunctionEvaluator[] funcEvaluators = Evaluator.loadFunctionEvaluators();
    private final short preferredUnit;

    public Evaluator() {
        this(6);
    }

    private static FunctionEvaluator[] loadFunctionEvaluators() {
        FunctionEvaluator[] evals = new FunctionEvaluator[CSSMathFunctionValue.MathFunction.OTHER.ordinal()];
        evals[CSSMathFunctionValue.MathFunction.ABS.ordinal()] = new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator eval, CSSMathFunctionValue function, Unit resultUnit) {
                return eval.functionAbs(function.getArguments(), resultUnit);
            }
        };
        evals[CSSMathFunctionValue.MathFunction.CLAMP.ordinal()] = new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator eval, CSSMathFunctionValue function, Unit resultUnit) {
                return eval.functionClamp(function.getArguments(), resultUnit);
            }
        };
        evals[CSSMathFunctionValue.MathFunction.MAX.ordinal()] = new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator eval, CSSMathFunctionValue function, Unit resultUnit) {
                return eval.functionMax(function.getArguments(), resultUnit);
            }
        };
        evals[CSSMathFunctionValue.MathFunction.MIN.ordinal()] = new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator eval, CSSMathFunctionValue function, Unit resultUnit) {
                return eval.functionMin(function.getArguments(), resultUnit);
            }
        };
        evals[CSSMathFunctionValue.MathFunction.ROUND.ordinal()] = new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator eval, CSSMathFunctionValue function, Unit resultUnit) {
                return eval.functionRound(function.getArguments(), resultUnit);
            }
        };
        evals[CSSMathFunctionValue.MathFunction.MOD.ordinal()] = new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator eval, CSSMathFunctionValue function, Unit resultUnit) {
                return eval.functionMod(function.getArguments(), resultUnit);
            }
        };
        evals[CSSMathFunctionValue.MathFunction.REM.ordinal()] = new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator eval, CSSMathFunctionValue function, Unit resultUnit) {
                return eval.functionRem(function.getArguments(), resultUnit);
            }
        };
        evals[CSSMathFunctionValue.MathFunction.HYPOT.ordinal()] = new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator eval, CSSMathFunctionValue function, Unit resultUnit) {
                return eval.functionHypot(function.getArguments(), resultUnit);
            }
        };
        evals[CSSMathFunctionValue.MathFunction.HYPOT2.ordinal()] = new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator eval, CSSMathFunctionValue function, Unit resultUnit) {
                return eval.functionHypot2(function.getArguments(), resultUnit);
            }
        };
        evals[CSSMathFunctionValue.MathFunction.LOG.ordinal()] = new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator eval, CSSMathFunctionValue function, Unit resultUnit) {
                return eval.functionLog(function.getArguments(), resultUnit);
            }
        };
        evals[CSSMathFunctionValue.MathFunction.EXP.ordinal()] = new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator eval, CSSMathFunctionValue function, Unit resultUnit) {
                return eval.functionExp(function.getArguments(), resultUnit);
            }
        };
        evals[CSSMathFunctionValue.MathFunction.SQRT.ordinal()] = new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator eval, CSSMathFunctionValue function, Unit resultUnit) {
                return eval.functionSqrt(function.getArguments(), resultUnit);
            }
        };
        evals[CSSMathFunctionValue.MathFunction.POW.ordinal()] = new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator eval, CSSMathFunctionValue function, Unit resultUnit) {
                return eval.functionPow(function.getArguments(), resultUnit);
            }
        };
        evals[CSSMathFunctionValue.MathFunction.SIGN.ordinal()] = new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator eval, CSSMathFunctionValue function, Unit resultUnit) {
                return eval.functionSign(function.getArguments(), resultUnit);
            }
        };
        evals[CSSMathFunctionValue.MathFunction.SIN.ordinal()] = new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator eval, CSSMathFunctionValue function, Unit resultUnit) {
                return eval.functionSin(function.getArguments(), resultUnit);
            }
        };
        evals[CSSMathFunctionValue.MathFunction.COS.ordinal()] = new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator eval, CSSMathFunctionValue function, Unit resultUnit) {
                return eval.functionCos(function.getArguments(), resultUnit);
            }
        };
        evals[CSSMathFunctionValue.MathFunction.TAN.ordinal()] = new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator eval, CSSMathFunctionValue function, Unit resultUnit) {
                return eval.functionTan(function.getArguments(), resultUnit);
            }
        };
        evals[CSSMathFunctionValue.MathFunction.ASIN.ordinal()] = new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator eval, CSSMathFunctionValue function, Unit resultUnit) {
                return eval.functionASin(function.getArguments(), resultUnit);
            }
        };
        evals[CSSMathFunctionValue.MathFunction.ACOS.ordinal()] = new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator eval, CSSMathFunctionValue function, Unit resultUnit) {
                return eval.functionACos(function.getArguments(), resultUnit);
            }
        };
        evals[CSSMathFunctionValue.MathFunction.ATAN.ordinal()] = new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator eval, CSSMathFunctionValue function, Unit resultUnit) {
                return eval.functionATan(function.getArguments(), resultUnit);
            }
        };
        evals[CSSMathFunctionValue.MathFunction.ATAN2.ordinal()] = new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator eval, CSSMathFunctionValue function, Unit resultUnit) {
                return eval.functionATan2(function.getArguments(), resultUnit);
            }
        };
        return evals;
    }

    public Evaluator(short preferredUnit) {
        this.preferredUnit = preferredUnit;
    }

    public CSSNumberValue evaluateFunction(CSSMathFunctionValue function) throws DOMException {
        Unit resultUnit = new Unit();
        CSSNumberValue result = this.evaluateFunction(function, resultUnit);
        int exp = resultUnit.getExponent();
        if (exp > 1 || exp < 0) {
            throw new DOMException(17, "Resulting unit is not valid CSS unit.");
        }
        float fv = result.getFloatValue(result.getUnitType());
        if (Float.isNaN(fv)) {
            throw new DOMException(15, "Result is not a number (NaN).");
        }
        if (function.isExpectingInteger()) {
            result.roundToInteger();
        }
        return result;
    }

    CSSNumberValue evaluateFunction(CSSMathFunctionValue function, Unit resultUnit) throws DOMException {
        return funcEvaluators[function.getFunctionIndex()].evaluateFunction(this, function, resultUnit);
    }

    private CSSNumberValue functionMax(CSSValueList<? extends CSSValue> arguments, Unit resultUnit) throws DOMException {
        short firstUnit;
        if (arguments.isEmpty()) {
            throw new DOMException(12, "max() functions take at least one argument");
        }
        Iterator it = arguments.iterator();
        CSSValue arg = (CSSValue)it.next();
        CSSTypedValue typed = this.enforceTyped(arg);
        typed = this.evaluate(typed, resultUnit);
        boolean calculated = typed.isCalculatedNumber();
        float max = this.floatValue(typed, resultUnit);
        int exp = resultUnit.getExponent();
        short maxUnit = firstUnit = resultUnit.getUnitType();
        float maxInSpecifiedUnit = max;
        while (it.hasNext()) {
            arg = (CSSValue)it.next();
            typed = this.enforceTyped(arg);
            typed = this.evaluate(typed, resultUnit);
            float partial = this.floatValue(typed, resultUnit);
            if (exp != resultUnit.getExponent()) {
                throw new DOMException(15, "max() arguments have incompatible dimensions.");
            }
            float partialInFirstUnit = NumberValue.floatValueConversion(partial, resultUnit.getUnitType(), firstUnit);
            if (!(max < partialInFirstUnit)) continue;
            max = partialInFirstUnit;
            maxInSpecifiedUnit = partial;
            maxUnit = resultUnit.getUnitType();
            calculated = typed.isCalculatedNumber();
        }
        return this.createNumberValue(maxUnit, maxInSpecifiedUnit, calculated);
    }

    private CSSTypedValue enforceTyped(CSSValue arg) throws DOMException {
        if (arg.getCssValueType() != CSSValue.CssType.TYPED) {
            throw new DOMException(12, "Unexpected value: " + arg.getCssText());
        }
        CSSTypedValue typed = (CSSTypedValue)arg;
        if (typed.getPrimitiveType() == CSSValue.Type.IDENT) {
            String s = typed.getStringValue();
            if ("pi".equalsIgnoreCase(s)) {
                typed = NumberValue.createCSSNumberValue((short)0, (float)Math.PI);
            } else if ("e".equalsIgnoreCase(s)) {
                typed = NumberValue.createCSSNumberValue((short)0, (float)Math.E);
            } else {
                throw new DOMException(12, "Unexpected value: " + arg.getCssText());
            }
        }
        return typed;
    }

    private CSSNumberValue functionMin(CSSValueList<? extends CSSValue> arguments, Unit resultUnit) throws DOMException {
        short firstUnit;
        if (arguments.isEmpty()) {
            throw new DOMException(12, "min() functions take at least one argument");
        }
        Iterator it = arguments.iterator();
        CSSValue arg = (CSSValue)it.next();
        CSSTypedValue typed = this.enforceTyped(arg);
        typed = this.evaluate(typed, resultUnit);
        boolean calculated = typed.isCalculatedNumber();
        float min = this.floatValue(typed, resultUnit);
        int exp = resultUnit.getExponent();
        short minUnit = firstUnit = resultUnit.getUnitType();
        float minInSpecifiedUnit = min;
        while (it.hasNext()) {
            arg = (CSSValue)it.next();
            typed = this.enforceTyped(arg);
            typed = this.evaluate(typed, resultUnit);
            float partial = this.floatValue(typed, resultUnit);
            if (exp != resultUnit.getExponent()) {
                throw new DOMException(15, "min() arguments have incompatible dimensions.");
            }
            float partialInFirstUnit = NumberValue.floatValueConversion(partial, resultUnit.getUnitType(), firstUnit);
            if (!(min > partialInFirstUnit)) continue;
            min = partialInFirstUnit;
            minInSpecifiedUnit = partial;
            minUnit = resultUnit.getUnitType();
            calculated = typed.isCalculatedNumber();
        }
        return this.createNumberValue(minUnit, minInSpecifiedUnit, calculated);
    }

    private CSSNumberValue functionClamp(CSSValueList<? extends CSSValue> arguments, Unit resultUnit) throws DOMException {
        if (arguments.getLength() != 3) {
            throw new DOMException(12, "Clamp functions take three arguments");
        }
        CSSTypedValue arg = this.typedArgument(arguments, 1);
        arg = this.evaluate(arg, resultUnit);
        boolean calculated = arg.isCalculatedNumber();
        float result = this.floatValue(arg, resultUnit);
        short centralUnit = resultUnit.getUnitType();
        int exp = resultUnit.getExponent();
        CSSTypedValue arg0 = this.typedArgument(arguments, 0);
        arg0 = this.evaluate(arg0, resultUnit);
        float min = this.floatValue(arg0, resultUnit);
        if (exp != resultUnit.getExponent()) {
            throw new DOMException(15, "clamp() arguments have incompatible dimensions.");
        }
        min = NumberValue.floatValueConversion(min, resultUnit.getUnitType(), centralUnit);
        CSSTypedValue arg2 = this.typedArgument(arguments, 2);
        arg2 = this.evaluate(arg2, resultUnit);
        float max = this.floatValue(arg2, resultUnit);
        if (exp != resultUnit.getExponent()) {
            throw new DOMException(15, "clamp() arguments have incompatible dimensions.");
        }
        if (result > (max = NumberValue.floatValueConversion(max, resultUnit.getUnitType(), centralUnit))) {
            result = max;
            calculated = arg2.isCalculatedNumber();
        }
        if (result < min) {
            result = min;
            calculated = arg0.isCalculatedNumber();
        }
        return this.createNumberValue(centralUnit, result, calculated);
    }

    private CSSNumberValue functionRound(CSSValueList<? extends CSSValue> arguments, Unit resultUnit) throws DOMException {
        float b;
        CSSTypedValue argA;
        String strategy;
        int len = arguments.getLength();
        if (len > 3 || len < 1) {
            throw new DOMException(12, "round() functions take up to three arguments");
        }
        CSSTypedValue argB = null;
        CSSValue arg0 = arguments.item(0);
        if (arg0.getPrimitiveType() == CSSValue.Type.IDENT) {
            strategy = ((CSSTypedValue)arg0).getStringValue().toLowerCase(Locale.ROOT);
            if (len == 1) {
                throw new DOMException(12, "Missing operand in round() function");
            }
            argA = this.typedArgument(arguments, 1);
            if (len == 3) {
                argB = this.typedArgument(arguments, 2);
            }
        } else {
            argA = this.typedArgument(arguments, 0);
            if (len == 2) {
                argB = this.typedArgument(arguments, 1);
            }
            strategy = "nearest";
        }
        argA = this.evaluate(argA, resultUnit);
        float a = this.floatValue(argA, resultUnit);
        short unit = resultUnit.getUnitType();
        if (argB != null) {
            int aexp = resultUnit.getExponent();
            argB = this.evaluate(argB, resultUnit);
            b = this.floatValue(argB, resultUnit);
            if (aexp != resultUnit.getExponent()) {
                throw new DOMException(15, "round() arguments have incompatible dimensions.");
            }
            a = NumberValue.floatValueConversion(a, unit, resultUnit.getUnitType());
            unit = resultUnit.getUnitType();
        } else {
            b = 1.0f;
        }
        float result = Evaluator.round(strategy, a, b);
        return this.createNumberValue(unit, result, true);
    }

    private static float round(String strategy, double a, double b) {
        double result;
        switch (strategy) {
            default: {
                result = (double)Math.round(a / b) * b;
                break;
            }
            case "up": {
                result = Math.ceil(a / b) * b;
                break;
            }
            case "down": {
                result = Math.floor(a / b) * b;
                break;
            }
            case "to-zero": {
                result = (double)((long)(a / b)) * b;
            }
        }
        return (float)result;
    }

    private CSSNumberValue functionMod(CSSValueList<? extends CSSValue> arguments, Unit resultUnit) throws DOMException {
        if (arguments.getLength() != 2) {
            throw new DOMException(12, "mod() functions take two arguments");
        }
        CSSTypedValue arg = this.typedArgument(arguments, 0);
        CSSTypedValue arg2 = this.typedArgument(arguments, 1);
        resultUnit.setUnitType(arg.getUnitType());
        Unit unit2 = new Unit();
        float f1 = this.evalValue(arg, resultUnit);
        float f2 = this.evalValue(arg2, unit2);
        if (unit2.getExponent() != resultUnit.getExponent()) {
            throw new DOMException(12, "mod() arguments have different units");
        }
        short unit = unit2.getUnitType();
        f1 = NumberValue.floatValueConversion(f1, resultUnit.getUnitType(), unit);
        resultUnit.setUnitType(unit);
        float result = (float)((double)f1 - Math.floor(f1 / f2) * (double)f2);
        return this.createNumberValue(unit, result, true);
    }

    private CSSNumberValue functionRem(CSSValueList<? extends CSSValue> arguments, Unit resultUnit) throws DOMException {
        if (arguments.getLength() != 2) {
            throw new DOMException(12, "rem() functions take two arguments");
        }
        CSSTypedValue arg = this.typedArgument(arguments, 0);
        CSSTypedValue arg2 = this.typedArgument(arguments, 1);
        resultUnit.setUnitType(arg.getUnitType());
        Unit unit2 = new Unit();
        float f1 = this.evalValue(arg, resultUnit);
        float f2 = this.evalValue(arg2, unit2);
        if (unit2.getExponent() != resultUnit.getExponent()) {
            throw new DOMException(12, "rem() arguments have different units");
        }
        short unit = unit2.getUnitType();
        f1 = NumberValue.floatValueConversion(f1, resultUnit.getUnitType(), unit);
        resultUnit.setUnitType(unit);
        float result = f1 - (float)((int)(f1 / f2)) * f2;
        return this.createNumberValue(unit, result, true);
    }

    private CSSNumberValue functionSin(CSSValueList<? extends CSSValue> arguments, Unit resultUnit) throws DOMException {
        if (arguments.getLength() != 1) {
            throw new DOMException(12, "sin() functions take one argument");
        }
        CSSTypedValue arg = this.typedArgument(arguments, 0);
        float fval = this.evalValue(arg, resultUnit);
        if (resultUnit.getUnitType() != 0) {
            int exp = resultUnit.getExponent();
            if (exp > 1 || exp < 0) {
                throw new DOMException(17, "Argument unit is not angle nor plain number.");
            }
            fval = NumberValue.floatValueConversion(fval, resultUnit.getUnitType(), (short)81);
        }
        float result = (float)Math.sin(fval);
        resultUnit.setUnitType((short)0);
        resultUnit.setExponent(0);
        return this.createNumberValue((short)0, result, true);
    }

    private CSSNumberValue functionCos(CSSValueList<? extends CSSValue> arguments, Unit resultUnit) throws DOMException {
        if (arguments.getLength() != 1) {
            throw new DOMException(12, "cos() functions take one argument");
        }
        CSSTypedValue arg = this.typedArgument(arguments, 0);
        float fval = this.evalValue(arg, resultUnit);
        if (resultUnit.getUnitType() != 0) {
            int exp = resultUnit.getExponent();
            if (exp > 1 || exp < 0) {
                throw new DOMException(17, "Argument unit is not angle nor plain number.");
            }
            fval = NumberValue.floatValueConversion(fval, resultUnit.getUnitType(), (short)81);
        }
        float result = (float)Math.cos(fval);
        resultUnit.setUnitType((short)0);
        resultUnit.setExponent(0);
        return this.createNumberValue((short)0, result, true);
    }

    private CSSNumberValue functionTan(CSSValueList<? extends CSSValue> arguments, Unit resultUnit) throws DOMException {
        if (arguments.getLength() != 1) {
            throw new DOMException(12, "tan() functions take one argument");
        }
        CSSTypedValue arg = this.typedArgument(arguments, 0);
        float fval = this.evalValue(arg, resultUnit);
        if (resultUnit.getUnitType() != 0) {
            int exp = resultUnit.getExponent();
            if (exp > 1 || exp < 0) {
                throw new DOMException(17, "Argument unit is not angle nor plain number.");
            }
            fval = NumberValue.floatValueConversion(fval, resultUnit.getUnitType(), (short)81);
        }
        float result = (float)Math.tan(fval);
        resultUnit.setUnitType((short)0);
        resultUnit.setExponent(0);
        return this.createNumberValue((short)0, result, true);
    }

    private CSSNumberValue functionASin(CSSValueList<? extends CSSValue> arguments, Unit resultUnit) throws DOMException {
        if (arguments.getLength() != 1) {
            throw new DOMException(12, "asin() functions take one argument");
        }
        CSSTypedValue arg = this.typedArgument(arguments, 0);
        float result = (float)Math.asin(this.evalValue(arg, resultUnit));
        if (resultUnit.getExponent() != 0) {
            throw new DOMException(12, "asin() argument must be dimensionless");
        }
        resultUnit.setUnitType((short)81);
        resultUnit.setExponent(1);
        return this.createNumberValue((short)81, result, true);
    }

    private CSSNumberValue functionACos(CSSValueList<? extends CSSValue> arguments, Unit resultUnit) throws DOMException {
        if (arguments.getLength() != 1) {
            throw new DOMException(12, "acos() functions take one argument");
        }
        CSSTypedValue arg = this.typedArgument(arguments, 0);
        float result = (float)Math.acos(this.evalValue(arg, resultUnit));
        if (resultUnit.getExponent() != 0) {
            throw new DOMException(12, "acos() argument must be dimensionless");
        }
        resultUnit.setUnitType((short)81);
        resultUnit.setExponent(1);
        return this.createNumberValue((short)81, result, true);
    }

    private CSSNumberValue functionATan(CSSValueList<? extends CSSValue> arguments, Unit resultUnit) throws DOMException {
        if (arguments.getLength() != 1) {
            throw new DOMException(12, "atan() functions take one argument");
        }
        CSSTypedValue arg = this.typedArgument(arguments, 0);
        float f1 = this.evalValue(arg, resultUnit);
        if (resultUnit.getExponent() != 0) {
            throw new DOMException(12, "atan() argument must be dimensionless");
        }
        float result = (float)Math.atan(f1);
        resultUnit.setUnitType((short)81);
        resultUnit.setExponent(1);
        return this.createNumberValue((short)81, result, true);
    }

    private CSSNumberValue functionATan2(CSSValueList<? extends CSSValue> arguments, Unit resultUnit) throws DOMException {
        if (arguments.getLength() != 2) {
            throw new DOMException(12, "atan2() functions take two arguments");
        }
        CSSTypedValue arg = this.typedArgument(arguments, 0);
        CSSTypedValue arg2 = this.typedArgument(arguments, 1);
        float f1 = this.evalValue(arg, resultUnit);
        if (resultUnit.getUnitType() != 0) {
            throw new DOMException(12, "atan2() arguments must be dimensionless");
        }
        float f2 = this.evalValue(arg2, resultUnit);
        if (resultUnit.getExponent() != 0) {
            throw new DOMException(12, "atan2() arguments must be dimensionless");
        }
        float result = (float)Math.atan2(f1, f2);
        resultUnit.setUnitType((short)81);
        resultUnit.setExponent(1);
        return this.createNumberValue((short)81, result, true);
    }

    private CSSNumberValue functionExp(CSSValueList<? extends CSSValue> arguments, Unit resultUnit) throws DOMException {
        if (arguments.getLength() != 1) {
            throw new DOMException(12, "exp() functions take one argument");
        }
        CSSTypedValue arg = this.typedArgument(arguments, 0);
        float f1 = this.evalValue(arg, resultUnit);
        if (resultUnit.getUnitType() != 0) {
            throw new DOMException(12, "exp() argument must be dimensionless");
        }
        float result = (float)Math.exp(f1);
        return this.createNumberValue((short)0, result, true);
    }

    private CSSNumberValue functionLog(CSSValueList<? extends CSSValue> arguments, Unit resultUnit) throws DOMException {
        float result;
        int len = arguments.getLength();
        if (len > 2 || len < 1) {
            throw new DOMException(12, "log() functions take one or two arguments");
        }
        CSSTypedValue arg = this.typedArgument(arguments, 0);
        float argument = this.evalValue(arg, resultUnit);
        if (resultUnit.getUnitType() != 0) {
            throw new DOMException(12, "log() argument must be dimensionless");
        }
        if (len == 2) {
            CSSTypedValue arg2 = this.typedArgument(arguments, 1);
            Unit expUnit = new Unit();
            float base = this.evalValue(arg2, expUnit);
            if (expUnit.getUnitType() != 0) {
                throw new DOMException(12, "log() base cannot have a dimension");
            }
            result = (float)(Math.log(argument) / Math.log(base));
        } else {
            result = (float)Math.log(argument);
        }
        resultUnit.setUnitType((short)0);
        return this.createNumberValue((short)0, result, true);
    }

    private CSSNumberValue functionPow(CSSValueList<? extends CSSValue> arguments, Unit resultUnit) throws DOMException {
        int exp;
        if (arguments.getLength() != 2) {
            throw new DOMException(12, "pow() functions take two arguments");
        }
        CSSTypedValue arg = this.typedArgument(arguments, 0);
        CSSTypedValue arg2 = this.typedArgument(arguments, 1);
        resultUnit.setUnitType(arg.getUnitType());
        float base = this.evalValue(arg, resultUnit);
        Unit expUnit = new Unit();
        float exponent = this.evalValue(arg2, expUnit);
        if (expUnit.getExponent() != 0) {
            throw new DOMException(12, "pow() exponent cannot have a dimension");
        }
        float result = (float)Math.pow(base, exponent);
        float resultExp = (float)resultUnit.getExponent() * exponent;
        if (Math.abs(resultExp - (float)(exp = Math.round(resultExp))) > 0.06f) {
            throw new DOMException(12, "Result with fractional dimension not supported in pow().");
        }
        resultUnit.setExponent(exp);
        return this.createNumberValue(resultUnit.getUnitType(), result, true);
    }

    private CSSNumberValue functionSqrt(CSSValueList<? extends CSSValue> arguments, Unit resultUnit) throws DOMException {
        if (arguments.getLength() != 1) {
            throw new DOMException(12, "sqrt() functions take one argument");
        }
        CSSTypedValue arg = this.typedArgument(arguments, 0);
        float result = (float)Math.sqrt(this.evalValue(arg, resultUnit));
        int exp = resultUnit.getExponent();
        if (exp % 2 != 0) {
            throw new DOMException(15, "invalid CSS unit in sqrt() function");
        }
        resultUnit.setExponent(exp / 2);
        return this.createNumberValue(resultUnit.getUnitType(), result, true);
    }

    private CSSNumberValue functionHypot(CSSValueList<? extends CSSValue> arguments, Unit resultUnit) throws DOMException {
        int len = arguments.getLength();
        if (len == 2) {
            return this.functionHypot2(arguments, resultUnit);
        }
        if (len == 0) {
            throw new DOMException(12, "hypot() functions need at least one argument.");
        }
        CSSTypedValue arg = this.typedArgument(arguments, 0);
        float partial = this.evalValue(arg, resultUnit);
        double result = partial * partial;
        short firstUnit = resultUnit.getUnitType();
        for (int i = 1; i < len; ++i) {
            arg = this.typedArgument(arguments, i);
            partial = this.evalValue(arg, resultUnit);
            if (firstUnit != resultUnit.getUnitType()) {
                partial = NumberValue.floatValueConversion(partial, resultUnit.getUnitType(), firstUnit);
            }
            result += (double)(partial * partial);
        }
        result = Math.sqrt(result);
        return this.createNumberValue(firstUnit, (float)result, true);
    }

    private CSSNumberValue functionHypot2(CSSValueList<? extends CSSValue> arguments, Unit resultUnit) throws DOMException {
        CSSTypedValue arg = this.typedArgument(arguments, 0);
        CSSTypedValue arg2 = this.typedArgument(arguments, 1);
        Unit arg2Type = new Unit();
        float f1 = this.evalValue(arg, resultUnit);
        float f2 = this.evalValue(arg2, arg2Type);
        if (resultUnit.getUnitType() != arg2Type.getUnitType()) {
            f2 = NumberValue.floatValueConversion(f2, arg2Type.getUnitType(), resultUnit.getUnitType());
        }
        float result = (float)Math.hypot(f1, f2);
        return this.createNumberValue(resultUnit.getUnitType(), result, true);
    }

    private CSSNumberValue functionAbs(CSSValueList<? extends CSSValue> arguments, Unit resultUnit) throws DOMException {
        if (arguments.getLength() != 1) {
            throw new DOMException(12, "abs() functions take one argument.");
        }
        CSSTypedValue arg = this.typedArgument(arguments, 0);
        CSSTypedValue typed = this.evaluate(arg, resultUnit);
        float fval = this.floatValue(typed, resultUnit);
        float result = Math.abs(fval);
        return this.createNumberValue(resultUnit.getUnitType(), result, typed.isCalculatedNumber());
    }

    private CSSNumberValue functionSign(CSSValueList<? extends CSSValue> arguments, Unit resultUnit) throws DOMException {
        if (arguments.getLength() != 1) {
            throw new DOMException(12, "sign() functions take one argument.");
        }
        CSSTypedValue arg = this.typedArgument(arguments, 0);
        float fval = this.evalValue(arg, resultUnit);
        resultUnit.setUnitType((short)0);
        resultUnit.setExponent(0);
        float result = Math.signum(fval);
        return this.createNumberValue((short)0, result, false);
    }

    CSSTypedValue unknownFunction(CSSFunctionValue function, Unit resultUnit) {
        resultUnit.setUnitType((short)255);
        return function;
    }

    private CSSTypedValue typedArgument(CSSValueList<? extends CSSValue> arguments, int index) {
        CSSValue arg = arguments.item(index);
        return this.enforceTyped(arg);
    }

    private float evalValue(CSSTypedValue value, Unit resultUnit) throws DOMException {
        CSSTypedValue typed = this.evaluate(value, resultUnit);
        return this.floatValue(typed, resultUnit);
    }

    private float floatValue(CSSTypedValue typed, Unit resultUnit) throws DOMException {
        float result;
        short resultType = resultUnit.getUnitType();
        short type = typed.getUnitType();
        if (type == 0) {
            result = typed.getFloatValue((short)0);
        } else if (type != 2) {
            result = typed.getFloatValue(resultType);
        } else {
            short preferredUnit = this.getPreferredUnit();
            result = this.percentage(typed, preferredUnit);
            resultUnit.setUnitType(preferredUnit);
        }
        return result;
    }

    protected CSSNumberValue createNumberValue(short unit, float valueInSpecifiedUnit, boolean calculated) {
        NumberValue value = NumberValue.createCSSNumberValue(unit, valueInSpecifiedUnit);
        value.setCalculatedNumber(calculated);
        return value;
    }

    short getPreferredUnit() {
        return this.preferredUnit;
    }

    public CSSTypedValue evaluateExpression(CSSExpressionValue calc) throws DOMException {
        Unit resultUnit = new Unit();
        CSSTypedValue result = this.evaluateExpression(calc.getExpression(), resultUnit);
        int exp = resultUnit.getExponent();
        if (exp > 1 || exp < 0) {
            throw new DOMException(17, "Resulting unit is not valid CSS unit.");
        }
        float fv = result.getFloatValue(result.getUnitType());
        if (Float.isNaN(fv)) {
            throw new DOMException(15, "Result is not a number (NaN).");
        }
        if (calc.isExpectingInteger()) {
            ((CSSNumberValue)result).roundToInteger();
        }
        return result;
    }

    CSSTypedValue evaluateExpression(CSSExpression expression, Unit resultUnit) throws DOMException {
        float result;
        switch (expression.getPartType()) {
            case SUM: {
                AlgebraicExpression sum = (AlgebraicExpression)expression;
                result = this.sum(sum, resultUnit);
                if (expression.getParentExpression() != null || !expression.isInverseOperation()) break;
                result = -result;
                break;
            }
            case PRODUCT: {
                AlgebraicExpression prod = (AlgebraicExpression)expression;
                result = this.multiply(prod, resultUnit);
                break;
            }
            default: {
                return this.evaluate(((CSSOperandExpression)expression).getOperand(), resultUnit);
            }
        }
        NumberValue value = NumberValue.createCSSNumberValue(resultUnit.getUnitType(), result);
        value.setCalculatedNumber(true);
        value.setAbsolutizedUnit();
        return value;
    }

    private float sum(AlgebraicExpression sumop, Unit resultUnit) throws DOMException {
        int len = sumop.getLength();
        if (len == 0) {
            throw new DOMException(12, "Sum without operands.");
        }
        CSSExpression op = sumop.item(0);
        float result = this.evalValue(this.evaluateExpression(op, resultUnit), resultUnit);
        if (op.isInverseOperation()) {
            result = -result;
        }
        short firstUnit = resultUnit.getUnitType();
        for (int i = 1; i < len; ++i) {
            op = sumop.item(i);
            float partial = this.evalValue(this.evaluateExpression(op, resultUnit), resultUnit);
            short partialUnit = resultUnit.getUnitType();
            if (firstUnit != partialUnit) {
                partial = NumberValue.floatValueConversion(partial, partialUnit, firstUnit);
            }
            if (op.isInverseOperation()) {
                result -= partial;
                continue;
            }
            result += partial;
        }
        resultUnit.setUnitType(firstUnit);
        return result;
    }

    private float multiply(AlgebraicExpression product, Unit resultUnit) throws DOMException {
        float result = 1.0f;
        short firstUnit = 0;
        int unitExp = 0;
        int len = product.getLength();
        for (int i = 0; i < len; ++i) {
            CSSExpression op = product.item(i);
            CSSTypedValue partialValue = this.evaluateExpression(op, resultUnit);
            float partial = this.evalValue(partialValue, resultUnit);
            short partialUnit = resultUnit.getUnitType();
            if (partialUnit != 0) {
                if (firstUnit == 0) {
                    firstUnit = partialUnit;
                } else {
                    try {
                        partial = NumberValue.floatValueConversion(partial, partialUnit, firstUnit);
                    }
                    catch (DOMException e) {
                        if (op.isInverseOperation()) {
                            throw e;
                        }
                        partial = this.unitCancellation(partial, partialUnit, firstUnit, e);
                        if (--unitExp == 0) {
                            firstUnit = 0;
                        }
                        result *= partial;
                        continue;
                    }
                    partialUnit = firstUnit;
                }
            }
            if (op.isInverseOperation()) {
                if (partialUnit != 0) {
                    firstUnit = --unitExp != 0 ? partialUnit : (short)0;
                }
                if (!Float.isNaN(result /= partial)) continue;
                throw new DOMException(15, "Found NaN.");
            }
            if (partialUnit != 0) {
                firstUnit = ++unitExp != 0 ? partialUnit : (short)0;
            }
            result *= partial;
        }
        if (unitExp < 0) {
            if (firstUnit == 100) {
                firstUnit = 90;
                unitExp = -unitExp;
            } else if (firstUnit == 101) {
                firstUnit = 91;
                unitExp = -unitExp;
            } else if (firstUnit == 90) {
                firstUnit = 100;
                unitExp = -unitExp;
            } else if (firstUnit == 91) {
                firstUnit = 101;
                unitExp = -unitExp;
            }
        }
        resultUnit.setUnitType(firstUnit);
        resultUnit.setExponent(unitExp);
        return result;
    }

    private float unitCancellation(float partial, short partialUnit, short firstUnit, DOMException exception) throws DOMException {
        if (partialUnit == 90 || partialUnit == 91) {
            if (firstUnit == 100) {
                return NumberValue.floatValueConversion(partial, partialUnit, (short)90);
            }
            if (firstUnit == 101) {
                return NumberValue.floatValueConversion(partial, partialUnit, (short)91);
            }
        } else if (partialUnit == 100 || partialUnit == 101) {
            if (firstUnit == 90) {
                return NumberValue.floatValueConversion(partial, partialUnit, (short)100);
            }
            if (firstUnit == 91) {
                return NumberValue.floatValueConversion(partial, partialUnit, (short)101);
            }
        }
        throw exception;
    }

    private CSSTypedValue evaluate(CSSPrimitiveValue partialValue, Unit resultUnit) {
        CSSTypedValue typed;
        switch (partialValue.getPrimitiveType()) {
            case MATH_FUNCTION: {
                typed = this.evaluateFunction((CSSMathFunctionValue)partialValue, resultUnit);
                break;
            }
            case EXPRESSION: {
                CSSExpression expr = ((CSSExpressionValue)partialValue).getExpression();
                typed = this.evaluateExpression(expr, resultUnit);
                break;
            }
            case FUNCTION: {
                typed = this.unknownFunction((CSSFunctionValue)partialValue, resultUnit);
                break;
            }
            default: {
                typed = this.absoluteValue(partialValue);
                resultUnit.setUnitType(typed.getUnitType());
            }
        }
        return typed;
    }

    protected CSSTypedValue absoluteValue(CSSPrimitiveValue partialValue) throws DOMException {
        while (partialValue.getCssValueType() == CSSValue.CssType.PROXY) {
            CSSValue value = this.absoluteProxyValue(partialValue);
            if (value == null || !value.isPrimitiveValue()) {
                throw new DOMException(15, "Unable to evaluate: " + partialValue.getCssText());
            }
            partialValue = (CSSPrimitiveValue)value;
        }
        if (partialValue.getCssValueType() == CSSValue.CssType.TYPED) {
            return this.absoluteTypedValue((CSSTypedValue)partialValue);
        }
        throw new DOMException(15, "Unexpected value: " + partialValue.getCssText());
    }

    protected CSSTypedValue absoluteTypedValue(CSSTypedValue partialValue) {
        return partialValue;
    }

    protected CSSValue absoluteProxyValue(CSSPrimitiveValue partialValue) {
        throw new DOMException(15, "Unexpected value: " + partialValue.getCssText());
    }

    protected float percentage(CSSTypedValue value, short resultType) throws DOMException {
        throw new DOMException(9, "Unexpected percentage in calc()");
    }

    static interface FunctionEvaluator {
        public CSSNumberValue evaluateFunction(Evaluator var1, CSSMathFunctionValue var2, Unit var3);
    }
}

