/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.CSSMathFunctionValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.Dimension;
import io.sf.carte.doc.style.css.parser.DimensionalAnalyzer;
import io.sf.carte.doc.style.css.parser.LexicalUnitImpl;
import io.sf.carte.doc.style.css.parser.MathFunctionUnitImpl;
import org.w3c.dom.DOMException;

class PowFunctionUnitImpl
extends MathFunctionUnitImpl {
    private static final long serialVersionUID = 1L;

    public PowFunctionUnitImpl(CSSMathFunctionValue.MathFunction functionID) {
        super(functionID);
    }

    @Override
    public Dimension dimension(DimensionalAnalyzer analyzer) throws DOMException {
        if (this.parameters == null) {
            throw new DOMException(12, "Missing argument in pow() function.");
        }
        Dimension dim = analyzer.expressionDimension(this.parameters);
        if (dim != null && dim.category != CSSValueSyntax.Category.number && dim.category != CSSValueSyntax.Category.integer) {
            LexicalUnitImpl comma = analyzer.getNextLexicalUnit();
            if (comma == null || comma.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                throw new DOMException(12, "Expected comma in pow() function.");
            }
            LexicalUnitImpl expUnit = comma.nextLexicalUnit;
            if (expUnit == null) {
                throw new DOMException(12, "Missing argument in pow() function.");
            }
            switch (expUnit.getLexicalUnitType()) {
                case INTEGER: {
                    dim.exponent *= expUnit.getIntegerValue();
                    break;
                }
                case REAL: {
                    dim.exponent = Math.round((float)dim.exponent * expUnit.getFloatValue());
                    dim.exponentAccuracy = 1;
                    break;
                }
                case VAR: {
                    dim.exponentAccuracy = (short)2;
                    break;
                }
                case FUNCTION: 
                case ATTR: 
                case CALC: 
                case SUB_EXPRESSION: 
                case MATH_FUNCTION: {
                    DimensionalAnalyzer subAnal = new DimensionalAnalyzer();
                    Dimension dimexp = subAnal.expressionDimension(expUnit);
                    if (subAnal.getNextLexicalUnit() != null) {
                        throw new DOMException(12, "Unexpected argument in pow() function: " + subAnal.getNextLexicalUnit().toString());
                    }
                    if (dimexp == null) {
                        dim.exponentAccuracy = (short)2;
                        break;
                    }
                    if (dimexp.category == CSSValueSyntax.Category.number || dimexp.category == CSSValueSyntax.Category.integer) {
                        if (dimexp.exponentAccuracy == 2) {
                            dim.exponentAccuracy = (short)2;
                            break;
                        }
                        dim.exponentAccuracy = 1;
                        break;
                    }
                }
                default: {
                    throw new DOMException(12, "Invalid argument in pow() function: " + expUnit.getCssText());
                }
            }
        }
        return dim;
    }

    @Override
    PowFunctionUnitImpl instantiateLexicalUnit() {
        return new PowFunctionUnitImpl(this.getMathFunction());
    }
}

