/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.UnitStringToId;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.FunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import java.util.Locale;

class AttrUnitImpl
extends FunctionUnitImpl {
    private static final long serialVersionUID = 1L;

    public AttrUnitImpl() {
        super(LexicalUnit.LexicalType.ATTR);
    }

    @Override
    AttrUnitImpl instantiateLexicalUnit() {
        return new AttrUnitImpl();
    }

    @Override
    CSSValueSyntax.Match typeMatch(CSSValueSyntax rootSyntax, CSSValueSyntax syntax) {
        CSSValueSyntax.Match result = CSSValueSyntax.Match.FALSE;
        LexicalUnit param = this.getParameters();
        if (param != null) {
            LexicalUnit fallback = null;
            if ((param = param.getNextLexicalUnit()) == null) {
                return syntax.getCategory() == CSSValueSyntax.Category.string ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
            }
            short unit = 1;
            CSSValueSyntax attrSyntax = null;
            LexicalUnit.LexicalType luType = param.getLexicalUnitType();
            if (luType == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                attrSyntax = SyntaxParser.createSimpleSyntax("string");
                fallback = param.getNextLexicalUnit();
            } else {
                switch (luType) {
                    case OPERATOR_COMMA: {
                        break;
                    }
                    case TYPE_FUNCTION: {
                        LexicalUnit typeParam = param.getParameters();
                        try {
                            attrSyntax = typeParam.getSyntax();
                            break;
                        }
                        catch (IllegalStateException e) {
                            return CSSValueSyntax.Match.FALSE;
                        }
                    }
                    case IDENT: {
                        String s = param.getStringValue().toLowerCase(Locale.ROOT);
                        if ("string".equals(s)) {
                            attrSyntax = SyntaxParser.createSimpleSyntax("string");
                            break;
                        }
                        unit = UnitStringToId.unitFromString(s);
                        break;
                    }
                    case OPERATOR_MOD: {
                        unit = 2;
                        break;
                    }
                    case VAR: {
                        return CSSValueSyntax.Match.PENDING;
                    }
                    default: {
                        return CSSValueSyntax.Match.FALSE;
                    }
                }
                param = param.getNextLexicalUnit();
                if (param != null) {
                    if (param.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        return CSSValueSyntax.Match.FALSE;
                    }
                    fallback = param.getNextLexicalUnit();
                }
            }
            CSSValueSyntax typeMatch = null;
            CSSValueSyntax comp = rootSyntax;
            block9: do {
                CSSValueSyntax.Match attrTypeMatch;
                if (attrSyntax == null) {
                    if (AttrUnitImpl.unitMatchesCategory(unit, comp.getCategory())) {
                        attrTypeMatch = CSSValueSyntax.Match.TRUE;
                        result = CSSValueSyntax.Match.PENDING;
                        typeMatch = comp;
                    } else {
                        attrTypeMatch = CSSValueSyntax.Match.FALSE;
                    }
                } else {
                    attrTypeMatch = AttrUnitImpl.matchAttrTypeSyntax(this.isParameter(), attrSyntax, comp.getCategory());
                    if (attrTypeMatch != CSSValueSyntax.Match.FALSE) {
                        result = CSSValueSyntax.Match.PENDING;
                        typeMatch = comp;
                    }
                }
                if (fallback != null) {
                    CSSValueSyntax fallbackComp = rootSyntax;
                    do {
                        CSSValueSyntax.Match match;
                        if ((match = fallback.matches(fallbackComp)) == CSSValueSyntax.Match.FALSE) {
                            if (attrTypeMatch == CSSValueSyntax.Match.FALSE || attrSyntax == null || attrSyntax.getCategory() != CSSValueSyntax.Category.url || fallback.getLexicalUnitType() != LexicalUnit.LexicalType.STRING || !AttrUnitImpl.hasNoSiblings(this) || fallback.getNextLexicalUnit() != null) continue;
                            result = CSSValueSyntax.Match.TRUE;
                        } else if (match == CSSValueSyntax.Match.PENDING) {
                            result = CSSValueSyntax.Match.PENDING;
                            if (attrTypeMatch != CSSValueSyntax.Match.FALSE) {
                                continue;
                            }
                        } else {
                            if (attrTypeMatch != CSSValueSyntax.Match.TRUE) {
                                result = CSSValueSyntax.Match.PENDING;
                                continue block9;
                            }
                            if (AttrUnitImpl.hasNoSiblings(this) || typeMatch == fallbackComp) {
                                result = CSSValueSyntax.Match.TRUE;
                            }
                        }
                        return result;
                    } while ((fallbackComp = fallbackComp.getNext()) != null);
                    continue;
                }
                if (attrTypeMatch != CSSValueSyntax.Match.TRUE) continue;
                return CSSValueSyntax.Match.TRUE;
            } while ((comp = comp.getNext()) != null);
        }
        return result;
    }

    private static CSSValueSyntax.Match matchAttrTypeSyntax(boolean calcContext, CSSValueSyntax typeSyntax, CSSValueSyntax.Category cat) {
        CSSValueSyntax.Match expected = CSSValueSyntax.Match.FALSE;
        do {
            CSSValueSyntax.Category typeCategory;
            CSSValueSyntax.Match match;
            if ((match = AttrUnitImpl.categoryMatch(calcContext, false, typeCategory = typeSyntax.getCategory(), cat)) != CSSValueSyntax.Match.FALSE) {
                if (expected == CSSValueSyntax.Match.PENDING) continue;
                expected = CSSValueSyntax.Match.TRUE;
                break;
            }
            if (expected != CSSValueSyntax.Match.TRUE) continue;
            expected = CSSValueSyntax.Match.PENDING;
        } while ((typeSyntax = typeSyntax.getNext()) != null);
        return expected;
    }

    private static boolean hasNoSiblings(LexicalUnit lexicalUnit) {
        return lexicalUnit.getNextLexicalUnit() == null && lexicalUnit.getPreviousLexicalUnit() == null;
    }
}

