/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.URIValue;
import io.sf.carte.doc.style.css.property.URIValueWrapper;
import io.sf.carte.doc.style.css.property.ValueList;
import java.net.URI;
import java.net.URL;
import org.w3c.dom.Node;

class WrappedCSSStyleDeclaration
extends BaseCSSStyleDeclaration {
    private static final long serialVersionUID = 1L;
    private final String hrefcontext;
    private final String oldHrefContext;

    protected WrappedCSSStyleDeclaration(BaseCSSDeclarationRule parentRule) {
        super(parentRule);
        this.oldHrefContext = this.hrefcontext = WrappedCSSStyleDeclaration.getHrefContext(parentRule);
    }

    protected WrappedCSSStyleDeclaration(BaseCSSStyleDeclaration copiedObject, String oldHrefContext) {
        super(copiedObject);
        this.hrefcontext = WrappedCSSStyleDeclaration.getHrefContext(this.getParentRule());
        this.oldHrefContext = oldHrefContext;
    }

    static String getHrefContext(BaseCSSDeclarationRule parentRule) {
        URL baseurl;
        String hrefcontext = null;
        AbstractCSSStyleSheet parentSheet = parentRule.getParentStyleSheet();
        Node node = parentSheet.getOwnerNode();
        String parentHref = parentSheet.getHref();
        if (parentHref != null) {
            try {
                URL docUrl;
                URI sheetURI = new URI(parentHref);
                if (!sheetURI.isAbsolute() && node != null && (docUrl = ((CSSDocument)node.getOwnerDocument()).getBaseURL()) != null) {
                    try {
                        URI nodeBase = docUrl.toURI();
                        sheetURI = nodeBase.resolve(sheetURI);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                hrefcontext = sheetURI.toASCIIString();
            }
            catch (Exception e) {
                parentRule.getStyleDeclarationErrorHandler().malformedURIValue(parentHref);
            }
        } else if (node != null && (baseurl = ((CSSDocument)node.getOwnerDocument()).getBaseURL()) != null) {
            hrefcontext = baseurl.toExternalForm();
        }
        return hrefcontext;
    }

    @Override
    protected StyleValue getCSSValue(String propertyName) {
        StyleValue value = super.getCSSValue(propertyName);
        if (value != null) {
            value = WrappedCSSStyleDeclaration.wrapCSSValue(value, this.oldHrefContext, this.hrefcontext);
        }
        return value;
    }

    static StyleValue wrapCSSValue(StyleValue value, String oldHrefContext, String hrefcontext) {
        CSSValue.CssType type = value.getCssValueType();
        if (type == CSSValue.CssType.LIST) {
            if (hrefcontext != null) {
                value = ((ValueList)value).wrap(oldHrefContext, hrefcontext);
            }
        } else if (value.getPrimitiveType() == CSSValue.Type.URI && hrefcontext != null) {
            value = new URIValueWrapper((URIValue)value, oldHrefContext, hrefcontext);
        }
        return value;
    }

    @Override
    public BaseCSSStyleDeclaration clone() {
        return new WrappedCSSStyleDeclaration(this.getParentRule());
    }
}

