/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueList;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.DeclarationFormattingContext;
import io.sf.carte.doc.style.css.impl.CSSUtil;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.style.css.om.PendingValue;
import io.sf.carte.doc.style.css.om.ShorthandValue;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.property.ColorIdentifiers;
import io.sf.carte.doc.style.css.property.IdentifierValue;
import io.sf.carte.doc.style.css.property.PropertyDatabase;
import io.sf.carte.doc.style.css.property.ShorthandDatabase;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.SystemDefaultValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.URIValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueList;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

abstract class ShorthandBuilder {
    private static final ShorthandDatabase shorthandDb = ShorthandDatabase.getInstance();
    private final String shorthandName;
    private final BaseCSSStyleDeclaration parentStyle;
    private final String[] subp;
    private final Set<String> impPtySet = new TreeSet<String>();
    private final Set<String> ptySet = new TreeSet<String>();

    ShorthandBuilder(String shorthandName, BaseCSSStyleDeclaration parentStyle) {
        this.shorthandName = shorthandName;
        this.parentStyle = parentStyle;
        this.subp = ShorthandBuilder.getShorthandDatabase().getShorthandSubproperties(shorthandName);
    }

    BaseCSSStyleDeclaration getParentStyle() {
        return this.parentStyle;
    }

    String getShorthandName() {
        return this.shorthandName;
    }

    static ShorthandDatabase getShorthandDatabase() {
        return shorthandDb;
    }

    String[] getLonghandProperties() {
        return this.getLonghandProperties(this.getShorthandName());
    }

    String[] getLonghandProperties(String shorthandName) {
        return ShorthandBuilder.getShorthandDatabase().getLonghandProperties(shorthandName);
    }

    String[] getSubproperties() {
        return this.subp;
    }

    StyleValue getCSSValue(String propertyName) {
        return this.parentStyle.getCSSValue(propertyName);
    }

    StyleValue getInitialPropertyValue(String propertyName) {
        if (this.parentStyle instanceof ComputedCSSStyle) {
            return this.parentStyle.defaultPropertyValue(propertyName);
        }
        StyleValue defval = PropertyDatabase.getInstance().getInitialValue(propertyName);
        if (defval == null) {
            if (propertyName.equals("color")) {
                defval = SystemDefaultValue.getInstance();
            } else if (propertyName.equals("font-family")) {
                defval = SystemDefaultValue.getInstance();
            } else if (propertyName.equals("text-align")) {
                String directionValue = this.parentStyle.getPropertyValue("direction");
                defval = directionValue.equals("rtl") ? new IdentifierValue("right") : new IdentifierValue("left");
            } else if (propertyName.equals("background-color")) {
                defval = new IdentifierValue("transparent");
            } else if (propertyName.endsWith("-color")) {
                defval = new IdentifierValue("currentcolor");
            } else if (propertyName.equals("quotes")) {
                defval = this.parentStyle.getValueFactory().parseProperty("\" \"");
            }
        }
        return defval;
    }

    boolean isPropertyAssigned(String propertyName) {
        return this.parentStyle.isPropertySet(propertyName);
    }

    boolean isPropertyAssigned(String propertyName, boolean important) {
        return this.parentStyle.isPropertySet(propertyName, important);
    }

    boolean isPropertyInAnySet(String property) {
        return this.ptySet.contains(property) || this.impPtySet.contains(property);
    }

    boolean isPropertyInImportantSet(String property) {
        return this.impPtySet.contains(property);
    }

    void addAssignedProperty(String propertyName, boolean important) {
        if (important) {
            this.impPtySet.add(propertyName);
        } else {
            this.ptySet.add(propertyName);
        }
    }

    boolean removeAssignedProperty(String property) {
        return this.ptySet.remove(property) || this.impPtySet.remove(property);
    }

    public void appendMinifiedCssText(StringBuilder buf) {
        int len = buf.length();
        switch (this.appendShorthandText(buf)) {
            case 1: {
                buf.setLength(len);
            }
            case 2: {
                this.appendMinifiedIndividualProperties(buf);
            }
        }
    }

    protected void appendMinifiedIndividualProperties(StringBuilder buf) {
        this.appendPropertiesInSet(buf, this.impPtySet, true);
        this.appendPropertiesInSet(buf, this.ptySet, false);
    }

    void appendPropertiesInSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
        BufferSimpleWriter wri = new BufferSimpleWriter(buf);
        DeclarationFormattingContext context = this.getParentStyle().getFormattingContext();
        int iniLen = buf.length();
        for (String property : declaredSet) {
            StyleValue value = this.getCSSValue(property);
            if (value.getPrimitiveType() != CSSValue.Type.INTERNAL) {
                buf.append(property).append(':');
                BaseCSSStyleDeclaration.appendMinifiedCssText(wri, context, value, property);
                this.appendPriority(buf, important);
                continue;
            }
            buf.setLength(iniLen);
            this.appendPropertiesWithInternal(wri, context, declaredSet, important);
            break;
        }
    }

    private void appendPropertiesWithInternal(BufferSimpleWriter wri, DeclarationFormattingContext context, Set<String> declaredSet, boolean important) {
        StyleValue value;
        StringBuilder buf = wri.getBuffer();
        HashSet<String> pendingSet = new HashSet<String>();
        HashSet<String> nonPendingSet = new HashSet<String>(declaredSet.size() - 1);
        for (String property : declaredSet) {
            value = this.getCSSValue(property);
            if (value.getPrimitiveType() == CSSValue.Type.INTERNAL) {
                String shname = ((PendingValue)value).getShorthandName();
                if (!pendingSet.add(shname) || !shname.equals(this.getShorthandName()) && !this.isResponsibleShorthand(shname)) continue;
                ShorthandValue shval = (ShorthandValue)this.getCSSValue(shname);
                this.parentStyle.appendShorthandMinifiedCssText(buf, shname, shval);
                continue;
            }
            nonPendingSet.add(property);
        }
        for (String property : nonPendingSet) {
            value = this.getCSSValue(property);
            buf.append(property).append(':');
            BaseCSSStyleDeclaration.appendMinifiedCssText(wri, context, value, property);
            this.appendPriority(buf, important);
        }
    }

    protected boolean isResponsibleShorthand(String shname) {
        return true;
    }

    int appendShorthandText(StringBuilder buf) {
        this.preprocessSet();
        int sz = this.getMinimumSetSize();
        if (this.getTotalSetSize() < sz) {
            return 1;
        }
        return this.processPriorities(buf);
    }

    protected void preprocessSet() {
    }

    protected int getTotalSetSize() {
        return this.impPtySet.size() + this.ptySet.size();
    }

    boolean hasPropertiesToExclude(Set<String> declaredSet) {
        for (String property : declaredSet) {
            if (!this.isPropertyToExclude(property)) continue;
            return true;
        }
        return false;
    }

    boolean isPropertyToExclude(String property) {
        return this.isExcludedValue(this.getCSSValue(property));
    }

    boolean isExcludedValue(StyleValue cssValue) {
        if (cssValue.isPrimitiveValue()) {
            return this.isExcludedType(cssValue.getPrimitiveType());
        }
        if (cssValue.getCssValueType() == CSSValue.CssType.LIST) {
            CSSValueList list = (CSSValueList)((Object)cssValue);
            for (StyleValue item : list) {
                if (!this.isExcludedValue(item)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isExcludedType(CSSValue.Type type) {
        return type == CSSValue.Type.LEXICAL;
    }

    int processPriorities(StringBuilder buf) {
        int sz = this.getMinimumSetSize();
        int impsz = this.impPtySet.size();
        if (impsz < sz) {
            int ret = this.appendShorthandSet(buf, this.ptySet, false);
            if (ret != 0) {
                return ret;
            }
            if (impsz != 0) {
                this.appendPropertiesInSet(buf, this.impPtySet, true);
            }
        } else {
            if (this.ptySet.size() != 0) {
                int len = buf.length();
                int ret = this.appendShorthandSet(buf, this.ptySet, false);
                switch (ret) {
                    case 0: {
                        this.ptySet.clear();
                        break;
                    }
                    case 1: {
                        buf.setLength(len);
                        this.appendPropertiesInSet(buf, this.ptySet, false);
                    }
                }
            }
            return this.appendShorthandSet(buf, this.impPtySet, true);
        }
        return 0;
    }

    byte checkValuesForInherit(Set<String> declaredSet) {
        return this.checkValuesForInherit(this.getShorthandName(), declaredSet);
    }

    byte checkValuesForInherit(String shorthand, Set<String> declaredSet) {
        String[] properties;
        int count = 0;
        int expect = 0;
        for (String propertyName : properties = this.getLonghandProperties(shorthand)) {
            if (!declaredSet.contains(propertyName)) continue;
            expect = (byte)(expect + 1);
            if (!this.isInherit(this.getCSSValue(propertyName))) continue;
            count = (byte)(count + 1);
        }
        if (count == 0) {
            return 0;
        }
        if (count == expect) {
            return 1;
        }
        return 2;
    }

    byte checkDeclaredValuesForInherit(Set<String> declaredSet) {
        byte count = 0;
        for (String propertyName : declaredSet) {
            if (!this.isInherit(this.getCSSValue(propertyName))) continue;
            count = (byte)(count + 1);
        }
        if (count == 0) {
            return 0;
        }
        if (count == (byte)declaredSet.size()) {
            return 1;
        }
        return 2;
    }

    boolean isInherit(StyleValue value) {
        return value != null && value.getPrimitiveType() == CSSValue.Type.INHERIT;
    }

    byte checkDeclaredValuesForKeyword(CSSValue.Type type, Set<String> declaredSet) {
        byte count = 0;
        for (String propertyName : declaredSet) {
            StyleValue val = this.getCSSValue(propertyName);
            if (type != val.getPrimitiveType()) continue;
            count = (byte)(count + 1);
        }
        if (count == 0) {
            return 0;
        }
        if (count == (byte)declaredSet.size()) {
            return 1;
        }
        return 2;
    }

    byte checkValuesForType(CSSValue.Type type, boolean important) {
        Set<String> declaredSet = important ? this.impPtySet : this.ptySet;
        return this.checkValuesForType(type, this.getShorthandName(), declaredSet);
    }

    byte checkValuesForType(CSSValue.Type type, Set<String> declaredSet) {
        return this.checkValuesForType(type, this.getShorthandName(), declaredSet);
    }

    byte checkValuesForType(CSSValue.Type type, String shorthand, Set<String> declaredSet) {
        String[] properties;
        int count = 0;
        int expect = 0;
        for (String propertyName : properties = this.getLonghandProperties(shorthand)) {
            if (!declaredSet.contains(propertyName)) continue;
            expect = (byte)(expect + 1);
            StyleValue cssValue = this.getCSSValue(propertyName);
            if (cssValue.getPrimitiveType() != type) continue;
            count = (byte)(count + 1);
        }
        if (count == 0) {
            return 0;
        }
        if (count == expect) {
            return 1;
        }
        return 2;
    }

    boolean isValueOfType(CSSValue.Type keyword, String propertyName) {
        StyleValue cssValue = this.getCSSValue(propertyName);
        return cssValue != null && cssValue.getPrimitiveType() == keyword;
    }

    static boolean isCssValueOfType(CSSValue.Type keyword, StyleValue cssValue) {
        return cssValue != null && cssValue.getPrimitiveType() == keyword;
    }

    String getValueTextIfNotInitial(String propertyName, StyleValue cssVal) {
        if (cssVal != null && !cssVal.isSystemDefault() && cssVal.getPrimitiveType() != CSSValue.Type.INITIAL && !this.valueEquals(this.getInitialPropertyValue(propertyName), cssVal)) {
            return cssVal.getMinifiedCssText(propertyName);
        }
        return null;
    }

    boolean isInitialValue(String propertyName) {
        StyleValue cssVal = this.getCSSValue(propertyName);
        return cssVal.isSystemDefault() || this.isEffectiveInitialKeyword(cssVal) || this.valueEquals(this.getInitialPropertyValue(propertyName), cssVal);
    }

    protected boolean isNotInitialValue(StyleValue cssVal, String propertyName) {
        return cssVal != null && !cssVal.isSystemDefault() && !this.isEffectiveInitialKeyword(cssVal) && !this.valueEquals(this.getInitialPropertyValue(propertyName), cssVal);
    }

    boolean isEffectiveInitialKeyword(StyleValue cssVal) {
        CSSValue.Type keyword = cssVal.getPrimitiveType();
        return keyword == CSSValue.Type.INITIAL || !this.isInheritedProperty() && keyword == CSSValue.Type.UNSET;
    }

    boolean isInheritedProperty() {
        return false;
    }

    static boolean containsControl(String ident) {
        int len = ident.length();
        for (int i = 0; i < len; ++i) {
            char c = ident.charAt(i);
            if (!Character.isISOControl(c)) continue;
            return true;
        }
        return false;
    }

    static boolean isIdentOrKeyword(StyleValue value) {
        if (value.getCssValueType() == CSSValue.CssType.LIST) {
            ValueList list = (ValueList)value;
            for (StyleValue item : list) {
                if (item.getPrimitiveType() == CSSValue.Type.IDENT) continue;
                return false;
            }
            return true;
        }
        return value.getPrimitiveType() == CSSValue.Type.IDENT || value.getCssValueType() == CSSValue.CssType.KEYWORD;
    }

    static boolean isUnknownIdentifier(String propertyName, StyleValue value) {
        if (value.getCssValueType() == CSSValue.CssType.TYPED) {
            String s;
            CSSTypedValue primi = (CSSTypedValue)((Object)value);
            if (primi.getPrimitiveType() == CSSValue.Type.IDENT && !"none".equalsIgnoreCase(s = primi.getStringValue())) {
                return !ShorthandBuilder.getShorthandDatabase().isIdentifierValue(propertyName, s);
            }
        } else if (value.getCssValueType() == CSSValue.CssType.LIST) {
            ValueList list = (ValueList)value;
            int len = list.getLength();
            for (int i = 0; i < len; ++i) {
                if (!ShorthandBuilder.isUnknownIdentifier(propertyName, list.item(i))) continue;
                return true;
            }
        }
        return false;
    }

    static boolean isImagePrimitiveValue(TypedValue primi) {
        CSSValueSyntax syn = SyntaxParser.createSimpleSyntax("image");
        return primi.matches(syn) == CSSValueSyntax.Match.TRUE || primi.getPrimitiveType() == CSSValue.Type.FUNCTION && ShorthandBuilder.isImageFunction(primi);
    }

    private static boolean isImageFunction(TypedValue primi) {
        String name = primi.getStringValue().toLowerCase(Locale.ROOT);
        return CSSUtil.isUnimplementedImageFunction(name);
    }

    boolean valueEquals(StyleValue value1, StyleValue value2) {
        if (value2 == null) {
            return value1 == null;
        }
        if (value1 == null) {
            return false;
        }
        if (value2.isSystemDefault() != value1.isSystemDefault()) {
            return false;
        }
        if (value1.getCssValueType() == CSSValue.CssType.TYPED && value2.getCssValueType() == CSSValue.CssType.TYPED) {
            TypedValue pvalue1 = (TypedValue)value1;
            CSSValue.Type type1 = pvalue1.getPrimitiveType();
            TypedValue pvalue2 = (TypedValue)value2;
            CSSValue.Type type2 = pvalue2.getPrimitiveType();
            if (type1 == CSSValue.Type.IDENT) {
                if (type2 == CSSValue.Type.COLOR) {
                    return this.testColorIdentifier(pvalue2, pvalue1.getStringValue().toLowerCase(Locale.ROOT));
                }
                if (type2 == CSSValue.Type.IDENT) {
                    return pvalue1.getStringValue().equalsIgnoreCase(pvalue2.getStringValue());
                }
            } else if (type1 == CSSValue.Type.COLOR && type2 == CSSValue.Type.IDENT) {
                return this.testColorIdentifier(pvalue1, pvalue2.getStringValue());
            }
        }
        return value1.equals(value2);
    }

    private boolean testColorIdentifier(TypedValue color, String ident) {
        String spec = "transparent".equals(ident) ? "rgba(0,0,0,0)" : ColorIdentifiers.getInstance().getColor(ident);
        if (spec != null) {
            ValueFactory factory = new ValueFactory();
            try {
                CSSTypedValue val = (CSSTypedValue)((Object)factory.parseProperty(spec));
                return val.toRGBColor().equals(color.toRGBColor());
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        return false;
    }

    boolean appendValueIfNotInitial(BufferSimpleWriter wri, DeclarationFormattingContext context, String propertyName, boolean prepend) {
        StringBuilder buf = wri.getBuffer();
        StyleValue cssVal = this.getCSSValue(propertyName);
        if (this.isNotInitialValue(cssVal, propertyName)) {
            if (prepend) {
                buf.append(' ');
            }
            try {
                context.writeMinifiedValue((SimpleWriter)wri, propertyName, cssVal);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        return prepend;
    }

    boolean appendDeclarationIfNotInitial(BufferSimpleWriter wri, DeclarationFormattingContext context, String propertyName, boolean importantShorthand) {
        StyleValue cssVal = this.getCSSValue(propertyName);
        boolean impPty = "important".equalsIgnoreCase(this.parentStyle.getPropertyPriority(propertyName));
        if (this.isNotInitialValue(cssVal, propertyName) && impPty == importantShorthand) {
            StringBuilder buf = wri.getBuffer();
            buf.append(propertyName).append(':');
            try {
                context.writeMinifiedValue((SimpleWriter)wri, propertyName, cssVal);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (impPty) {
                buf.append('!').append("important");
            }
            buf.append(';');
            return true;
        }
        return false;
    }

    boolean appendDeclarationIfNotKeyword(CSSValue.Type keyword, BufferSimpleWriter wri, DeclarationFormattingContext context, String propertyName, boolean importantShorthand) {
        StyleValue cssVal = this.getCSSValue(propertyName);
        boolean impPty = "important".equalsIgnoreCase(this.parentStyle.getPropertyPriority(propertyName));
        if (!ShorthandBuilder.isCssValueOfType(keyword, cssVal) && impPty == importantShorthand) {
            StringBuilder buf = wri.getBuffer();
            buf.append(propertyName).append(':');
            try {
                context.writeMinifiedValue((SimpleWriter)wri, propertyName, cssVal);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (impPty) {
                buf.append('!').append("important");
            }
            buf.append(';');
            return true;
        }
        return false;
    }

    void appendPriority(StringBuilder buf, boolean important) {
        if (important) {
            buf.append("!important;");
        } else {
            buf.append(';');
        }
    }

    boolean appendImage(StringBuilder buf, boolean prepend, StyleValue value) {
        String text;
        StringBuilder sb = new StringBuilder(64);
        BufferSimpleWriter wri = new BufferSimpleWriter(sb);
        DeclarationFormattingContext context = this.getParentStyle().getFormattingContext();
        CSSValue.CssType category = value.getCssValueType();
        if (category == CSSValue.CssType.TYPED) {
            CSSTypedValue pvalue = (CSSTypedValue)((Object)value);
            CSSValue.Type type = pvalue.getPrimitiveType();
            if (type == CSSValue.Type.URI) {
                URL url = ((URIValue)pvalue).getURLValue();
                if (url != null) {
                    String baseuri = this.getBaseURI();
                    text = baseuri != null ? ShorthandBuilder.relativeURI(baseuri, url) : url.toExternalForm();
                    text = "url('" + text + "')";
                } else {
                    try {
                        context.writeMinifiedValue((SimpleWriter)wri, "background-image", value);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    text = sb.toString();
                }
            } else if (type == CSSValue.Type.IDENT) {
                text = pvalue.getStringValue();
                if ("none".equalsIgnoreCase(text)) {
                    return false;
                }
            } else {
                try {
                    context.writeMinifiedValue((SimpleWriter)wri, "background-image", value);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                text = sb.toString();
            }
        } else {
            if (category == CSSValue.CssType.KEYWORD) {
                return false;
            }
            try {
                context.writeMinifiedValue((SimpleWriter)wri, "background-image", value);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            text = sb.toString();
        }
        if (prepend) {
            buf.append(' ');
        }
        buf.append(text);
        return true;
    }

    String getBaseURI() {
        Document document;
        AbstractCSSStyleSheet psheet;
        BaseCSSDeclarationRule prule = this.getParentStyle().getParentRule();
        if (prule != null && (psheet = prule.getParentStyleSheet()) != null) {
            return psheet.getHref();
        }
        Node node = this.getParentStyle().getOwnerNode();
        String baseuri = null;
        if (node != null && (document = node.getOwnerDocument()) != null) {
            baseuri = document.getBaseURI();
        }
        return baseuri;
    }

    static String relativeURI(String baseuri, URL url) {
        try {
            URI base = new URI(baseuri);
            if (ShorthandBuilder.sameTree(base, url)) {
                try {
                    return base.relativize(url.toURI()).toString();
                }
                catch (Exception exception) {}
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        String uri = url.toExternalForm();
        return uri;
    }

    static boolean sameTree(URI base, URL url) {
        if (url.getProtocol().equals(base.getScheme())) {
            String bhost = base.getHost();
            String uhost = url.getHost();
            if (bhost != null) {
                if (bhost.equals(uhost)) {
                    int bport = base.getPort();
                    int uport = url.getPort();
                    if (bport == -1) {
                        bport = url.getDefaultPort();
                    }
                    if (uport == -1) {
                        uport = url.getDefaultPort();
                    }
                    return bport == uport;
                }
            } else {
                return uhost == null;
            }
        }
        return false;
    }

    protected int getMinimumSetSize() {
        return this.getLonghandProperties().length;
    }

    abstract int appendShorthandSet(StringBuilder var1, Set<String> var2, boolean var3);
}

