/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.BaseShorthandSetter;
import io.sf.carte.doc.style.css.om.PendingValue;
import io.sf.carte.doc.style.css.om.ShorthandValue;
import io.sf.carte.doc.style.css.property.LexicalValue;
import java.util.ArrayList;
import java.util.Collections;

class PendingSubstitutionSetter
extends BaseShorthandSetter {
    private boolean priorityImportant = false;
    private LexicalUnit lexicalValue = null;

    PendingSubstitutionSetter(BaseCSSStyleDeclaration style, String shorthandName) {
        super(style, shorthandName);
    }

    @Override
    public void init(LexicalUnit shorthandValue, boolean important) {
        this.lexicalValue = shorthandValue;
        this.priorityImportant = important;
    }

    @Override
    public short assignSubproperties() {
        String[] longhands;
        PendingValue pending = new PendingValue(this.getShorthandName(), this.lexicalValue);
        for (String longhand : longhands = this.getLonghands()) {
            if (!this.priorityImportant && this.styleDeclaration.isPropertyImportant(longhand)) continue;
            this.styleDeclaration.setProperty(longhand, pending, this.priorityImportant);
        }
        return 0;
    }

    @Override
    public String getCssText() {
        return this.lexicalValue.toString();
    }

    String[] getLonghands() {
        String[] longhands = this.getShorthandDatabase().getLonghandProperties(this.getShorthandName());
        if ("border".equals(this.getShorthandName())) {
            ArrayList<String> lhs = new ArrayList<String>(longhands.length + 5);
            Collections.addAll(lhs, longhands);
            lhs.add("border-image-source");
            lhs.add("border-image-slice");
            lhs.add("border-image-width");
            lhs.add("border-image-outset");
            lhs.add("border-image-repeat");
            longhands = lhs.toArray(new String[0]);
        } else if ("font".equals(this.getShorthandName())) {
            ArrayList<String> lhs = new ArrayList<String>(longhands.length + 6);
            Collections.addAll(lhs, longhands);
            lhs.add("font-variant-caps");
            lhs.add("font-variant-ligatures");
            lhs.add("font-variant-position");
            lhs.add("font-variant-numeric");
            lhs.add("font-variant-alternates");
            lhs.add("font-variant-east-asian");
            longhands = lhs.toArray(new String[0]);
        }
        return longhands;
    }

    @Override
    public ShorthandValue createCSSShorthandValue(LexicalUnit value) {
        return ShorthandValue.createCSSShorthandValue(this.getShorthandDatabase(), this.getShorthandName(), value, this.priorityImportant, false);
    }

    @Override
    public String getMinifiedCssText() {
        return LexicalValue.serializeMinifiedSequence(this.lexicalValue);
    }
}

