/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.AlgebraicExpression;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSExpression;
import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.CSSFunctionValue;
import io.sf.carte.doc.style.css.CSSOperandExpression;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueList;
import io.sf.carte.doc.style.css.DeclarationFormattingContext;
import io.sf.carte.doc.style.css.NodeStyleDeclaration;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.AnimationShorthandBuilder;
import io.sf.carte.doc.style.css.om.AnimationShorthandSetter;
import io.sf.carte.doc.style.css.om.BackgroundBuilder;
import io.sf.carte.doc.style.css.om.BackgroundShorthandSetter;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BorderBuilder;
import io.sf.carte.doc.style.css.om.BorderColorShorthandSetter;
import io.sf.carte.doc.style.css.om.BorderImageBuilder;
import io.sf.carte.doc.style.css.om.BorderImageShorthandSetter;
import io.sf.carte.doc.style.css.om.BorderRadiusBuilder;
import io.sf.carte.doc.style.css.om.BorderRadiusShorthandSetter;
import io.sf.carte.doc.style.css.om.BorderShorthandSetter;
import io.sf.carte.doc.style.css.om.BorderSideShorthandSetter;
import io.sf.carte.doc.style.css.om.BorderStyleShorthandSetter;
import io.sf.carte.doc.style.css.om.BorderWidthShorthandSetter;
import io.sf.carte.doc.style.css.om.BoxShorthandSetter;
import io.sf.carte.doc.style.css.om.CSSOMParser;
import io.sf.carte.doc.style.css.om.ColumnRuleShorthandSetter;
import io.sf.carte.doc.style.css.om.ColumnsShorthandSetter;
import io.sf.carte.doc.style.css.om.CueShorthandSetter;
import io.sf.carte.doc.style.css.om.DefaultStyleFormattingContext;
import io.sf.carte.doc.style.css.om.FlexShorthandBuilder;
import io.sf.carte.doc.style.css.om.FlexShorthandSetter;
import io.sf.carte.doc.style.css.om.FontBuilder;
import io.sf.carte.doc.style.css.om.FontShorthandSetter;
import io.sf.carte.doc.style.css.om.FontVariantBuilder;
import io.sf.carte.doc.style.css.om.FontVariantShorthandSetter;
import io.sf.carte.doc.style.css.om.GenericShorthandBuilder;
import io.sf.carte.doc.style.css.om.GridAreaShorthandBuilder;
import io.sf.carte.doc.style.css.om.GridAreaShorthandSetter;
import io.sf.carte.doc.style.css.om.GridPlacementShorthandBuilder;
import io.sf.carte.doc.style.css.om.GridPlacementShorthandSetter;
import io.sf.carte.doc.style.css.om.GridShorthandBuilder;
import io.sf.carte.doc.style.css.om.GridShorthandSetter;
import io.sf.carte.doc.style.css.om.GridTemplateShorthandSetter;
import io.sf.carte.doc.style.css.om.ListStyleShorthandBuilder;
import io.sf.carte.doc.style.css.om.ListStyleShorthandSetter;
import io.sf.carte.doc.style.css.om.MarginBuilder;
import io.sf.carte.doc.style.css.om.MarginShorthandSetter;
import io.sf.carte.doc.style.css.om.MaskBuilder;
import io.sf.carte.doc.style.css.om.MaskShorthandSetter;
import io.sf.carte.doc.style.css.om.OrderedTwoIdentifierShorthandSetter;
import io.sf.carte.doc.style.css.om.OrderedTwoLPIShorthandSetter;
import io.sf.carte.doc.style.css.om.OrderedTwoValueShorthandBuilder;
import io.sf.carte.doc.style.css.om.PaddingBuilder;
import io.sf.carte.doc.style.css.om.PendingSubstitutionSetter;
import io.sf.carte.doc.style.css.om.PropertyCSSHandler;
import io.sf.carte.doc.style.css.om.SafeSystemDefaultValue;
import io.sf.carte.doc.style.css.om.SequenceShorthandBuilder;
import io.sf.carte.doc.style.css.om.SequenceShorthandSetter;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.om.ShorthandValue;
import io.sf.carte.doc.style.css.om.SubpropertySetter;
import io.sf.carte.doc.style.css.om.TransitionShorthandBuilder;
import io.sf.carte.doc.style.css.om.TransitionShorthandSetter;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.doc.style.css.property.IdentifierValue;
import io.sf.carte.doc.style.css.property.LexicalValue;
import io.sf.carte.doc.style.css.property.PropertyDatabase;
import io.sf.carte.doc.style.css.property.ShorthandDatabase;
import io.sf.carte.doc.style.css.property.StringValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.SystemDefaultValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueList;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.Diff;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSS2Properties;

public class BaseCSSStyleDeclaration
extends AbstractCSSStyleDeclaration
implements CSS2Properties,
Cloneable {
    private static final long serialVersionUID = 2L;
    private final BaseCSSDeclarationRule parentRule;
    private HashMap<String, StyleValue> propValue;
    private ArrayList<String> propertyList;
    private ArrayList<String> priorities;
    private ArrayList<String> shorthandSet;
    private LinkedList<Object> prefValues = null;

    protected BaseCSSStyleDeclaration(BaseCSSDeclarationRule parentRule) {
        this.parentRule = parentRule;
        this.propValue = new HashMap();
        this.propertyList = new ArrayList();
        this.priorities = new ArrayList();
        this.shorthandSet = new ArrayList(6);
    }

    public BaseCSSStyleDeclaration() {
        this.parentRule = null;
        this.propValue = new HashMap();
        this.propertyList = new ArrayList();
        this.priorities = new ArrayList();
        this.shorthandSet = new ArrayList(6);
    }

    protected BaseCSSStyleDeclaration(BaseCSSStyleDeclaration copiedObject) {
        this.parentRule = copiedObject.getParentRule();
        this.setProperties(copiedObject);
    }

    void setProperties(BaseCSSStyleDeclaration other) {
        this.priorities = (ArrayList)other.priorities.clone();
        this.propertyList = (ArrayList)other.propertyList.clone();
        this.propValue = this.deepClone(other.propValue);
        this.shorthandSet = (ArrayList)other.shorthandSet.clone();
    }

    private HashMap<String, StyleValue> deepClone(HashMap<String, StyleValue> cloneFrom) {
        HashMap<String, StyleValue> propValue = new HashMap<String, StyleValue>(cloneFrom.size());
        for (Map.Entry<String, StyleValue> entry : cloneFrom.entrySet()) {
            StyleValue value = entry.getValue();
            if (value.getCssValueType() == CSSValue.CssType.SHORTHAND) {
                value = value.clone();
            }
            propValue.put(entry.getKey(), value);
        }
        return propValue;
    }

    @Override
    public String getMinifiedCssText() {
        LinkedList<String> unusedShorthands = new LinkedList<String>(this.shorthandSet);
        int sz = this.propertyList.size();
        StringBuilder sb = new StringBuilder(50 + sz * 10);
        for (int i = 0; i < sz; ++i) {
            String ptyname = this.propertyList.get(i);
            String prio = this.priorities.get(i);
            boolean important = "important".equals(prio);
            StyleValue cssVal = this.propValue.get(ptyname);
            CSSValue.CssType type = cssVal.getCssValueType();
            if (type != CSSValue.CssType.SHORTHAND && cssVal.isSubproperty()) {
                Iterator it = unusedShorthands.iterator();
                while (it.hasNext()) {
                    String sh = (String)it.next();
                    ShorthandValue shval = (ShorthandValue)this.propValue.get(sh);
                    if (!shval.isSetSubproperty(ptyname) || important != shval.isImportant()) continue;
                    it.remove();
                    this.appendShorthandMinifiedCssText(sb, sh, shval);
                }
                continue;
            }
            cssVal = this.getCSSValue(ptyname);
            this.appendLonghandMinifiedCssText(sb, ptyname, cssVal, important);
            if (i == sz - 1) continue;
            sb.append(';');
        }
        if (this.prefValues != null) {
            this.minifiedPrefixedDeclaration(sb);
        }
        return sb.toString();
    }

    private void minifiedPrefixedDeclaration(StringBuilder sb) {
        int len = sb.length();
        if (len > 0 && sb.charAt(len - 1) != ';') {
            sb.append(';');
        }
        Iterator it = this.prefValues.iterator();
        while (true) {
            String property = (String)it.next();
            StyleValue value = (StyleValue)it.next();
            boolean important = (Boolean)it.next();
            this.appendLonghandMinifiedCssText(sb, property, value, important);
            if (!it.hasNext()) break;
            sb.append(';');
        }
    }

    protected void appendShorthandMinifiedCssText(StringBuilder sb, String shorthandName, ShorthandValue shval) {
        sb.append(shorthandName).append(':').append(shval.getMinifiedCssText(shorthandName));
        if (shval.isImportant()) {
            sb.append("!important");
        }
        sb.append(';');
    }

    protected void appendLonghandMinifiedCssText(StringBuilder sb, String ptyname, StyleValue cssVal, boolean important) {
        sb.append(ptyname).append(':').append(cssVal.getMinifiedCssText(ptyname));
        if (important) {
            sb.append("!important");
        }
    }

    @Override
    public String getCssText() {
        AbstractCSSStyleSheet sheet;
        StyleFormattingContext context = null;
        BaseCSSDeclarationRule prule = this.getParentRule();
        if (prule != null && (sheet = prule.getParentStyleSheet()) != null) {
            context = sheet.getStyleSheetFactory().getStyleFormattingFactory().createStyleFormattingContext();
        }
        if (context == null) {
            context = new DefaultStyleFormattingContext();
        }
        BufferSimpleWriter sw = new BufferSimpleWriter(50 + this.propertyList.size() * 16);
        try {
            this.writeCssText((SimpleWriter)sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        LinkedList<String> unusedShorthands = new LinkedList<String>(this.shorthandSet);
        int sz = this.propertyList.size();
        for (int i = 0; i < sz; ++i) {
            String ptyname = this.propertyList.get(i);
            String prio = this.priorities.get(i);
            boolean important = "important".equals(prio);
            CSSValue cssVal = this.propValue.get(ptyname);
            CSSValue.CssType type = cssVal.getCssValueType();
            if (type != CSSValue.CssType.SHORTHAND && ((StyleValue)cssVal).isSubproperty()) {
                Iterator it = unusedShorthands.iterator();
                while (it.hasNext()) {
                    String sh = (String)it.next();
                    ShorthandValue shval = (ShorthandValue)this.propValue.get(sh);
                    if (!shval.isSetSubproperty(ptyname) || important != shval.isImportant()) continue;
                    it.remove();
                    this.writeShorthandCssText(wri, context, sh, shval);
                }
                continue;
            }
            StyleValue ptyvalue = this.getCSSValue(ptyname);
            this.writeLonghandCssText(wri, context, ptyname, ptyvalue, important);
        }
        if (this.prefValues != null) {
            this.writePrefixedDeclaration(wri, context);
        }
    }

    protected void writeShorthandCssText(SimpleWriter wri, StyleFormattingContext context, String shorthandName, ShorthandValue shval) throws IOException {
        context.startPropertyDeclaration(wri);
        wri.write((CharSequence)shorthandName);
        context.writeColon(wri);
        context.writeShorthandValue(wri, shorthandName, shval);
        if (shval.isImportant()) {
            context.writeImportantPriority(wri);
        }
        context.writeSemiColon(wri);
        context.endPropertyDeclaration(wri);
    }

    protected void writeLonghandCssText(SimpleWriter wri, StyleFormattingContext context, String ptyname, StyleValue ptyvalue, boolean important) throws IOException {
        context.startPropertyDeclaration(wri);
        wri.write((CharSequence)ptyname);
        context.writeColon(wri);
        context.writeValue(wri, ptyname, ptyvalue);
        if (important) {
            context.writeImportantPriority(wri);
        }
        context.writeSemiColon(wri);
        context.endPropertyDeclaration(wri);
    }

    private void writePrefixedDeclaration(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        Iterator it = this.prefValues.iterator();
        while (it.hasNext()) {
            String property = (String)it.next();
            StyleValue value = (StyleValue)it.next();
            boolean important = (Boolean)it.next();
            context.startPropertyDeclaration(wri);
            wri.write((CharSequence)property);
            context.writeColon(wri);
            context.writeValue(wri, property, value);
            if (important) {
                context.writeImportantPriority(wri);
            }
            context.writeSemiColon(wri);
            context.endPropertyDeclaration(wri);
        }
    }

    String getComputedPlainCssText() {
        if (!this.propertyList.isEmpty()) {
            int sz = this.propertyList.size();
            BufferSimpleWriter wri = new BufferSimpleWriter(50 + sz * 18);
            DeclarationFormattingContext formatter = this.getFormattingContext();
            try {
                this.writeComputedCssText((SimpleWriter)wri, formatter);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return wri.toString();
        }
        return "";
    }

    void writeComputedCssText(SimpleWriter wri, DeclarationFormattingContext context) throws IOException {
        for (String ptyname : this.propertyList) {
            context.startPropertyDeclaration(wri);
            wri.write((CharSequence)ptyname);
            context.writeColon(wri);
            context.writeValue(wri, ptyname, this.getCSSValue(ptyname));
            context.writeSemiColon(wri);
            context.endPropertyDeclaration(wri);
        }
    }

    String getOptimizedCssText() {
        int sz = this.propertyList.size();
        ArrayList<String> ptyList = new ArrayList<String>(sz);
        HashSet<String> prioSet = new HashSet<String>(sz);
        HashMap<String, ShorthandBuilder> builders = new HashMap<String, ShorthandBuilder>();
        ShorthandDatabase sdb = ShorthandDatabase.getInstance();
        StringBuilder sb = new StringBuilder(50 + sz * 24);
        for (int i = 0; i < sz; ++i) {
            String ptyname = this.propertyList.get(i);
            String shorthand = sdb.getShorthand(ptyname);
            String prio = this.priorities.get(i);
            boolean isimportant = "important".equals(prio);
            if (shorthand != null) {
                String prefShorthand;
                ShorthandBuilder builder;
                String topsh = sdb.getShorthand(shorthand);
                if (topsh != null) {
                    shorthand = topsh;
                }
                if ((builder = (ShorthandBuilder)builders.get(prefShorthand = '&' + shorthand)) == null) {
                    builder = this.createBuilder(shorthand);
                    if (builder == null) {
                        ptyList.add(ptyname);
                        if (!isimportant) continue;
                        prioSet.add(ptyname);
                        continue;
                    }
                    builders.put(prefShorthand, builder);
                    ptyList.add(prefShorthand);
                }
                builder.addAssignedProperty(ptyname, isimportant);
                continue;
            }
            ptyList.add(ptyname);
            if (!isimportant) continue;
            prioSet.add(ptyname);
        }
        if (ptyList.contains("&border-image") && ptyList.contains("&border")) {
            ptyList.remove("&border-image");
            builders.remove("&border-image");
        }
        if (ptyList.contains("&font-variant") && ptyList.contains("&font")) {
            ptyList.remove("&font-variant");
            builders.remove("&font-variant");
        }
        if (ptyList.contains("&grid-row") && ptyList.contains("&grid-column")) {
            ptyList.remove("&grid-row");
            ptyList.remove("&grid-column");
            if (!ptyList.contains("&grid-area")) {
                ptyList.add("&grid-area");
                builders.put("&grid-area", this.createBuilder("grid-area"));
            }
            builders.remove("&grid-row");
            builders.remove("&grid-column");
        } else if (ptyList.contains("&grid-row") && ptyList.contains("&grid-area")) {
            ptyList.remove("&grid-row");
            builders.remove("&grid-row");
        } else if (ptyList.contains("&grid-column") && ptyList.contains("&grid-area")) {
            ptyList.remove("&grid-column");
            builders.remove("&grid-column");
        }
        DeclarationFormattingContext formatter = this.getFormattingContext();
        BufferSimpleWriter wri = new BufferSimpleWriter(sb);
        sz = ptyList.size();
        for (int i = 0; i < sz; ++i) {
            String ptyname = (String)ptyList.get(i);
            if (ptyname.charAt(0) == '&') {
                ((ShorthandBuilder)builders.get(ptyname)).appendMinifiedCssText(sb);
                continue;
            }
            StyleValue value = this.getCSSValue(ptyname);
            sb.append(ptyname).append(':');
            BaseCSSStyleDeclaration.appendMinifiedCssText(wri, formatter, value, ptyname);
            if (prioSet.contains(ptyname)) {
                sb.append("!important");
            }
            sb.append(';');
        }
        return sb.toString();
    }

    DeclarationFormattingContext getFormattingContext() {
        AbstractCSSStyleSheetFactory factory = this.getStyleSheetFactory();
        DeclarationFormattingContext context = factory != null ? factory.getStyleFormattingFactory().createComputedStyleFormattingContext() : new DefaultStyleFormattingContext();
        return context;
    }

    static void appendCssText(StringBuilder buf, StyleValue value) {
        String text = !value.isSystemDefault() ? value.getCssText() : "initial";
        buf.append(text);
    }

    static void appendMinifiedCssText(BufferSimpleWriter wri, DeclarationFormattingContext context, StyleValue value, String ptyname) {
        if (!value.isSystemDefault()) {
            try {
                context.writeMinifiedValue((SimpleWriter)wri, ptyname, value);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            StringBuilder buf = wri.getBuffer();
            try {
                if (buf.charAt(buf.length() - 1) == ' ') {
                    buf.setLength(buf.length() - 1);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        } else {
            wri.write((CharSequence)"initial");
        }
    }

    ShorthandBuilder createBuilder(String shorthand) {
        if ("border".equals(shorthand)) {
            return new BorderBuilder(this);
        }
        if ("background".equals(shorthand)) {
            return new BackgroundBuilder(this);
        }
        if ("border-image".equals(shorthand)) {
            return new BorderImageBuilder(this);
        }
        if ("margin".equals(shorthand)) {
            return new MarginBuilder(this);
        }
        if ("padding".equals(shorthand)) {
            return new PaddingBuilder(this);
        }
        if ("font".equals(shorthand)) {
            return new FontBuilder(this);
        }
        if ("font-variant".equals(shorthand)) {
            return new FontVariantBuilder(this);
        }
        if ("border-radius".equals(shorthand)) {
            return new BorderRadiusBuilder(this);
        }
        if ("list-style".equals(shorthand)) {
            return new ListStyleShorthandBuilder(this);
        }
        if ("text-decoration".equals(shorthand) || "outline".equals(shorthand) || "text-emphasis".equals(shorthand) || "column-rule".equals(shorthand)) {
            return new GenericShorthandBuilder(shorthand, this, "none");
        }
        if ("flex".equals(shorthand)) {
            return new FlexShorthandBuilder(this);
        }
        if ("flex-flow".equals(shorthand)) {
            return new GenericShorthandBuilder(shorthand, this, "row");
        }
        if ("columns".equals(shorthand)) {
            return new GenericShorthandBuilder(shorthand, this, "auto");
        }
        if ("grid-column".equals(shorthand) || "grid-row".equals(shorthand)) {
            return new GridPlacementShorthandBuilder(shorthand, this);
        }
        if ("grid-area".equals(shorthand)) {
            return new GridAreaShorthandBuilder(this);
        }
        if ("grid".equals(shorthand) || "grid-template".equals(shorthand)) {
            return new GridShorthandBuilder(this);
        }
        if ("animation".equals(shorthand)) {
            return new AnimationShorthandBuilder(this);
        }
        if ("transition".equals(shorthand)) {
            return new TransitionShorthandBuilder(this);
        }
        if ("mask".equals(shorthand)) {
            return new MaskBuilder(this);
        }
        if ("cue".equals(shorthand) || "pause".equals(shorthand) || "rest".equals(shorthand)) {
            return new SequenceShorthandBuilder(shorthand, this);
        }
        if ("place-content".equals(shorthand) || "place-items".equals(shorthand) || "place-self".equals(shorthand) || "gap".equals(shorthand)) {
            return new OrderedTwoValueShorthandBuilder(shorthand, this, "normal");
        }
        return null;
    }

    @Override
    public StyleDeclarationErrorHandler getStyleDeclarationErrorHandler() {
        BaseCSSDeclarationRule prule = this.getParentRule();
        if (prule != null) {
            return prule.getStyleDeclarationErrorHandler();
        }
        return null;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        Parser parser = this.createSACParser();
        StyleDeclarationHandler handler = new StyleDeclarationHandler();
        handler.setLexicalPropertyListener(this);
        parser.setErrorHandler(handler);
        parser.setDocumentHandler(handler);
        StringReader re = new StringReader(cssText);
        this.clear();
        try {
            parser.parseStyleDeclaration(re);
        }
        catch (CSSParseException e) {
            DOMException ex = new DOMException(12, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
    }

    private Parser createSACParser() throws DOMException {
        AbstractCSSStyleSheetFactory factory = this.getStyleSheetFactory();
        Parser parser = factory != null ? factory.createSACParser() : new CSSOMParser();
        return parser;
    }

    @Override
    protected AbstractCSSStyleSheetFactory getStyleSheetFactory() {
        AbstractCSSStyleSheet sheet;
        BaseCSSDeclarationRule prule = this.getParentRule();
        if (prule != null && (sheet = prule.getParentStyleSheet()) != null) {
            return sheet.getStyleSheetFactory();
        }
        return null;
    }

    protected ValueFactory getValueFactory() {
        AbstractCSSStyleSheetFactory factory = this.getStyleSheetFactory();
        return factory != null ? factory.getValueFactory() : new ValueFactory();
    }

    @Override
    public String getPropertyValue(String propertyName) {
        String result;
        StyleValue value = this.getCSSValue(propertyName = this.getCanonicalPropertyName(propertyName));
        if (value != null) {
            CSSValue.CssType type = value.getCssValueType();
            if (type == CSSValue.CssType.TYPED) {
                CSSValue.Type ptype = value.getPrimitiveType();
                if (ptype == CSSValue.Type.STRING || ptype == CSSValue.Type.IDENT) {
                    return ((CSSTypedValue)((Object)value)).getStringValue();
                }
            } else if (type == CSSValue.CssType.SHORTHAND && ((HashSet)((ShorthandValue)value).getLonghands()).size() < this.getLonghandPropertyCount(propertyName)) {
                return "";
            }
            result = value.getCssText();
        } else if (this.prefValues != null && this.prefValues.contains(propertyName)) {
            int idx = this.prefValues.lastIndexOf(propertyName);
            result = this.prefValues.get(idx + 1).toString();
        } else {
            result = "";
        }
        return result;
    }

    private int getLonghandPropertyCount(String propertyName) {
        String[] longhands;
        int count = "font".equals(propertyName) ? 17 : ((longhands = ShorthandDatabase.getInstance().getLonghandProperties(propertyName)) != null ? longhands.length : Integer.MAX_VALUE);
        return count;
    }

    @Override
    public StyleValue getPropertyCSSValue(String propertyName) {
        propertyName = this.getCanonicalPropertyName(propertyName);
        if (ShorthandDatabase.getInstance().isShorthand(propertyName)) {
            return null;
        }
        return this.getCSSValue(propertyName);
    }

    String getCanonicalPropertyName(String propertyName) {
        if (propertyName.length() > 2 && (propertyName.charAt(0) != '-' || propertyName.charAt(1) != '-')) {
            propertyName = propertyName.toLowerCase(Locale.ROOT);
        }
        return propertyName;
    }

    protected StyleValue getCSSValue(String propertyName) {
        return this.getDeclaredCSSValue(propertyName);
    }

    protected StyleValue getDeclaredCSSValue(String propertyName) {
        return this.propValue.get(propertyName);
    }

    public StyleValue computeBoundProperty(String masterProperty, String propertyName, StyleValue value) {
        ValueList list;
        StyleValue bimg = this.getCSSValue(masterProperty);
        if (bimg == null) {
            return null;
        }
        int layers = 1;
        if (bimg.getCssValueType() == CSSValue.CssType.LIST && (list = (ValueList)bimg).isCommaSeparated()) {
            layers = list.getLength();
        }
        if (layers == 1) {
            if (value == null) {
                value = PropertyDatabase.getInstance().getInitialValue(propertyName);
            }
        } else {
            value = this.computeSubpropertyList(value, layers);
        }
        return value;
    }

    ValueList computeSubpropertyList(StyleValue value, int layers) {
        ValueList list;
        block6: {
            int items;
            if (value.getCssValueType() == CSSValue.CssType.LIST && ((ValueList)value).isCommaSeparated()) {
                list = (ValueList)value.clone();
                items = list.getLength();
            } else {
                list = ValueList.createCSValueList();
                list.add(value);
                items = 1;
            }
            if (layers == items) break block6;
            if (layers < items) {
                while (items > layers) {
                    list.remove(--items);
                }
            } else {
                int j = 0;
                while (items++ < layers) {
                    list.add(list.item(j++));
                }
            }
        }
        return list;
    }

    @Override
    public String removeProperty(String propertyName) {
        ShorthandDatabase sdb;
        if (propertyName == null) {
            return "";
        }
        String oldcsstext = "";
        int idx = this.propertyList.indexOf(propertyName = this.getCanonicalPropertyName(propertyName));
        if (idx >= 0 && !this.propValue.get(propertyName).isSubproperty()) {
            oldcsstext = this.propValue.remove(propertyName).getCssText();
            this.propertyList.remove(idx);
            this.priorities.remove(idx);
            if (!this.shorthandSet.isEmpty() && (sdb = ShorthandDatabase.getInstance()).isShorthandSubproperty(propertyName)) {
                this.resetFromShorthand(propertyName, sdb);
            }
        } else if (this.shorthandSet.contains(propertyName)) {
            ShorthandValue shval = (ShorthandValue)this.propValue.get(propertyName);
            this.propValue.remove(propertyName);
            this.shorthandSet.remove(propertyName);
            oldcsstext = shval.getCssText();
            sdb = ShorthandDatabase.getInstance();
            this.removeSubproperties(shval, sdb);
        }
        if (this.prefValues != null) {
            Iterator it = this.prefValues.iterator();
            while (it.hasNext()) {
                String property = (String)it.next();
                if (property.equals(propertyName)) {
                    it.remove();
                    it.next();
                    it.remove();
                    it.next();
                    it.remove();
                    break;
                }
                it.next();
                it.next();
            }
            if (this.prefValues.isEmpty()) {
                this.prefValues = null;
            }
        }
        return oldcsstext;
    }

    private boolean resetFromShorthand(String propertyName, ShorthandDatabase sdb) {
        String shorthand = propertyName;
        int shidx = -1;
        for (String shname : this.shorthandSet) {
            ShorthandValue shval;
            String pty;
            int i;
            if (!sdb.isShorthandSubpropertyOf(shname, propertyName) || (i = this.propertyList.indexOf(pty = (String)((HashSet)(shval = (ShorthandValue)this.propValue.get(shname)).getLonghands()).iterator().next())) <= shidx) continue;
            shidx = i;
            shorthand = shname;
        }
        if (shidx != -1) {
            ShorthandValue shval = (ShorthandValue)this.propValue.get(shorthand);
            ((HashSet)shval.getLonghands()).add(propertyName);
            BaseCSSStyleDeclaration copy = new BaseCSSStyleDeclaration();
            copy.setSubproperties(shorthand, shval.getLexicalUnit(), shval.isImportant(), shval.isAttrTainted());
            this.propValue.put(propertyName, copy.propValue.get(propertyName));
            this.priorities.add(shidx, shval.isImportant() ? "important" : null);
            this.propertyList.add(shidx, propertyName);
            return true;
        }
        return false;
    }

    private void removeSubproperties(ShorthandValue shval, ShorthandDatabase sdb) {
        Set longhands = shval.getLonghands();
        for (String property : longhands) {
            int idx = this.propertyList.indexOf(property);
            this.propertyList.remove(idx);
            this.priorities.remove(idx);
            this.propValue.remove(property);
            if (this.shorthandSet.isEmpty()) continue;
            this.resetFromShorthand(property, sdb);
        }
    }

    @Override
    public String getPropertyPriority(String propertyName) {
        int idx = this.propertyList.indexOf(propertyName);
        if (idx == -1) {
            return this.getUnknownPropertyPriority(propertyName);
        }
        String prio = this.priorities.get(idx);
        if (prio != null) {
            return prio;
        }
        return "";
    }

    String getUnknownPropertyPriority(String propertyName) {
        if (this.shorthandSet.contains(propertyName) && ((ShorthandValue)this.propValue.get(propertyName)).isImportant()) {
            return "important";
        }
        return this.checkShorthandPriority(propertyName);
    }

    String checkShorthandPriority(String propertyName) {
        ShorthandDatabase sdb = ShorthandDatabase.getInstance();
        if (sdb.isShorthand(propertyName)) {
            String[] longhands;
            for (String longhand : longhands = sdb.getLonghandProperties(propertyName)) {
                if (this.isPropertyImportant(longhand)) continue;
                return "";
            }
            return "important";
        }
        return "";
    }

    @Override
    public void setLexicalProperty(String propertyName, LexicalUnit value, boolean important) throws DOMException {
        propertyName = this.getCanonicalPropertyName(propertyName);
        LexicalValue lexicalValue = new LexicalValue();
        lexicalValue.setLexicalUnit(value);
        this.setProperty(propertyName, lexicalValue, important);
    }

    @Override
    public void setProperty(String propertyName, LexicalUnit value, boolean important) throws DOMException {
        propertyName = this.getCanonicalPropertyName(propertyName);
        ShorthandDatabase sdb = ShorthandDatabase.getInstance();
        if (sdb.isShorthand(propertyName)) {
            this.setShorthandProperty(sdb, propertyName, value, important);
        } else {
            this.setLonghandProperty(propertyName, value, important);
        }
    }

    private void setShorthandProperty(ShorthandDatabase sdb, String propertyName, LexicalUnit value, boolean important) throws DOMException {
        ShorthandValue overriddenVal = (ShorthandValue)this.propValue.get(propertyName);
        if (overriddenVal == null || important || !overriddenVal.isImportant()) {
            LinkedList<String> shadowedShorthands = null;
            if (!this.shorthandSet.isEmpty()) {
                if (this.shorthandSet.contains(propertyName)) {
                    shadowedShorthands = new LinkedList<String>();
                    shadowedShorthands.add(propertyName);
                }
                for (String sh : this.shorthandSet) {
                    if (sdb.isShorthandSubpropertyOf(propertyName, sh)) {
                        if (!important && ((ShorthandValue)this.propValue.get(sh)).isImportant()) continue;
                        if (shadowedShorthands == null) {
                            shadowedShorthands = new LinkedList();
                        }
                        shadowedShorthands.add(sh);
                        continue;
                    }
                    if (!sdb.isShorthandSubpropertyOf(sh, propertyName) || important || !((ShorthandValue)this.propValue.get(sh)).isImportant()) continue;
                    return;
                }
            }
            this.setShorthandLonghands(propertyName, value, important, shadowedShorthands, false);
        }
    }

    boolean setShorthandLonghands(String propertyName, LexicalUnit value, boolean important, LinkedList<String> shadowedShorthands, boolean attrTainted) {
        try {
            SubpropertySetter shorthandSetter = this.setSubproperties(propertyName, value, important, attrTainted);
            if (shorthandSetter == null) {
                return false;
            }
            String shorthandText = shorthandSetter.getCssText();
            if (!shorthandText.isEmpty()) {
                ShorthandValue shVal = shorthandSetter.createCSSShorthandValue(value);
                shVal.setShorthandText(shorthandText, shorthandSetter.getMinifiedCssText());
                if (shadowedShorthands != null) {
                    for (String shadowed : shadowedShorthands) {
                        this.shorthandSet.remove(shadowed);
                        this.propValue.remove(shadowed);
                    }
                }
                this.propValue.put(propertyName, shVal);
                this.shorthandSet.add(propertyName);
            } else {
                this.shorthandWarning(propertyName, value, important);
            }
            return true;
        }
        catch (DOMException e) {
            this.shorthandError(propertyName, value, important, shadowedShorthands, e);
            return false;
        }
    }

    void shorthandWarning(String propertyName, LexicalUnit value, boolean important) {
        StyleDeclarationErrorHandler errHandler = this.getStyleDeclarationErrorHandler();
        if (errHandler != null) {
            errHandler.shorthandWarning(propertyName, BaseCSSStyleDeclaration.lexicalUnitToString(value));
        }
    }

    void compatWarning(String propertyName, LexicalUnit value, boolean important) {
        StyleDeclarationErrorHandler errHandler = this.getStyleDeclarationErrorHandler();
        if (errHandler != null) {
            String s = BaseCSSStyleDeclaration.lexicalUnitToString(value);
            StringBuilder sb = new StringBuilder(s.length());
            sb.append(s);
            if (important) {
                sb.append("!important");
            }
            errHandler.compatWarning(propertyName, sb.toString());
        }
    }

    protected void shorthandError(String propertyName, LexicalUnit value, boolean important, LinkedList<String> shadowedShorthands, DOMException e) {
        StyleDeclarationErrorHandler errHandler = this.getStyleDeclarationErrorHandler();
        if (errHandler != null) {
            CSSPropertyValueException ex = new CSSPropertyValueException("Wrong value for " + propertyName);
            ex.setValueText(BaseCSSStyleDeclaration.lexicalUnitToString(value));
            errHandler.wrongValue(propertyName, ex);
        }
    }

    protected void setLonghandProperty(String propertyName, LexicalUnit value, boolean important) throws DOMException {
        StyleValue cssvalue;
        ValueFactory factory = this.getValueFactory();
        try {
            cssvalue = factory.createCSSValue(value, this);
        }
        catch (DOMException e) {
            if (propertyName.charAt(0) == '-') {
                LexicalValue lexval = new LexicalValue();
                lexval.setLexicalUnit(value);
                cssvalue = lexval;
            }
            StyleDeclarationErrorHandler errHandler = this.getStyleDeclarationErrorHandler();
            if (errHandler != null) {
                CSSPropertyValueException ex = new CSSPropertyValueException("Wrong value for " + propertyName, e);
                ex.setValueText(BaseCSSStyleDeclaration.lexicalUnitToString(value));
                errHandler.wrongValue(propertyName, ex);
            }
            throw e;
        }
        if (propertyName.equals("font-family") || propertyName.equals("content")) {
            if (cssvalue.getCssValueType() == CSSValue.CssType.LIST) {
                ValueList list = (ValueList)cssvalue;
                if (list.isCommaSeparated()) {
                    int sz = list.getLength();
                    for (int i = 0; i < sz; ++i) {
                        if (list.item(i).getCssValueType() != CSSValue.CssType.LIST) continue;
                        list.set(i, this.listToString((ValueList)list.item(i)));
                    }
                } else {
                    cssvalue = this.listToString(list);
                }
            }
        } else if (propertyName.equals("background-position") && cssvalue.getCssValueType() == CSSValue.CssType.LIST) {
            ValueList list = (ValueList)cssvalue;
            if (list.isCommaSeparated()) {
                int sz = list.getLength();
                for (int i = 0; i < sz; ++i) {
                    StyleValue item = list.item(i);
                    if (item.getCssValueType() != CSSValue.CssType.LIST || BaseCSSStyleDeclaration.checkBackgroundPosition((ValueList)item)) continue;
                    list.remove(i--);
                    this.wrongBackgroundPositionError(item.getCssText());
                }
                if (list.getLength() == 0) {
                    return;
                }
            } else if (!BaseCSSStyleDeclaration.checkBackgroundPosition(list)) {
                this.wrongBackgroundPositionError(list.getCssText());
                return;
            }
        }
        this.setProperty(propertyName, cssvalue, important);
    }

    private void wrongBackgroundPositionError(String cssText) {
        StyleDeclarationErrorHandler errHandler = this.getStyleDeclarationErrorHandler();
        if (errHandler != null) {
            CSSPropertyValueException ex = new CSSPropertyValueException("Wrong value for background-position");
            ex.setValueText(cssText);
            errHandler.wrongValue("background-position", ex);
        }
    }

    private StyleValue listToString(ValueList list) {
        int len = list.getLength();
        boolean allItemsAreIdent = true;
        for (int i = 1; i < len; ++i) {
            StyleValue cssval = list.item(i);
            if (cssval.getCssValueType() == CSSValue.CssType.TYPED && cssval.getPrimitiveType() == CSSValue.Type.IDENT) continue;
            allItemsAreIdent = false;
            break;
        }
        if (allItemsAreIdent) {
            StringBuilder buf = new StringBuilder(len * 7 + 8);
            buf.append(list.item(0).getCssText());
            for (int i = 1; i < len; ++i) {
                buf.append(' ').append(list.item(i).getCssText());
            }
            StringValue csstr = new StringValue();
            csstr.setStringValue(CSSValue.Type.STRING, buf.toString());
            return csstr;
        }
        return list;
    }

    private static boolean checkBackgroundPosition(ValueList list) {
        int count = list.getLength();
        if (count < 3) {
            return true;
        }
        if (count == 4) {
            return list.item(0).getPrimitiveType() == CSSValue.Type.IDENT && list.item(1).getPrimitiveType() != CSSValue.Type.IDENT && list.item(2).getPrimitiveType() == CSSValue.Type.IDENT && list.item(3).getPrimitiveType() != CSSValue.Type.IDENT;
        }
        if (list.item(0).getPrimitiveType() != CSSValue.Type.IDENT) {
            return false;
        }
        if (list.item(1).getPrimitiveType() == CSSValue.Type.IDENT && list.item(2).getPrimitiveType() != CSSValue.Type.IDENT) {
            return true;
        }
        return list.item(1).getPrimitiveType() != CSSValue.Type.IDENT && list.item(2).getPrimitiveType() == CSSValue.Type.IDENT;
    }

    @Override
    public void setProperty(String propertyName, String value, String priority) throws DOMException {
        LexicalUnit lunit;
        Parser parser;
        if (value.length() == 0) {
            this.removeProperty(propertyName);
            return;
        }
        try {
            parser = this.createSACParser();
        }
        catch (DOMException e) {
            throw new DOMException(7, e.getMessage());
        }
        StringReader re = new StringReader(value);
        try {
            lunit = parser.parsePropertyValue(re);
        }
        catch (CSSParseException e) {
            DOMException ex = new DOMException(12, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        boolean important = "important".equalsIgnoreCase(priority);
        this.setProperty(propertyName, lunit, important);
    }

    boolean setProperty(String propertyName, StyleValue cssValue, boolean important) {
        String priority;
        propertyName = propertyName.intern();
        String string = priority = important ? "important" : null;
        if (!this.propertyList.contains(propertyName)) {
            this.addProperty(propertyName, cssValue, priority);
            return true;
        }
        return this.replaceProperty(propertyName, cssValue, priority);
    }

    boolean replaceProperty(String propertyName, StyleValue cssValue, String priority) {
        int idx = this.propertyList.indexOf(propertyName);
        boolean overriddenImportant = "important".equals(this.priorities.get(idx));
        if ((!overriddenImportant || "important".equals(priority)) && this.addOverrideProperty(propertyName, cssValue, priority)) {
            this.propertyList.remove(idx);
            this.priorities.remove(idx);
            return true;
        }
        return false;
    }

    @Override
    protected void addProperty(String propertyName, StyleValue cssValue, String priority) {
        if (cssValue.getCssValueType() == CSSValue.CssType.SHORTHAND) {
            this.addShorthandName(propertyName);
        } else {
            this.propertyList.add(propertyName);
            this.priorities.add(priority);
            StyleValue ovValue = this.propValue.get(propertyName);
            if (ovValue != null && ovValue.isSubproperty()) {
                this.overrideShorthands(propertyName, priority);
            }
        }
        this.propValue.put(propertyName, cssValue);
    }

    protected boolean addOverrideProperty(String propertyName, StyleValue cssValue, String priority) {
        this.addProperty(propertyName, cssValue, priority);
        return true;
    }

    private void addShorthandName(String shorthandName) {
        if (this.shorthandSet.contains(shorthandName)) {
            this.shorthandSet.remove(shorthandName);
        }
        this.shorthandSet.add(shorthandName);
    }

    private void overrideShorthands(String longhandName, String priority) {
        Iterator<String> it = this.shorthandSet.iterator();
        while (it.hasNext()) {
            String shName = it.next();
            ShorthandValue shval = (ShorthandValue)this.propValue.get(shName);
            if (shval.isImportant() && !"important".equals(priority) || !shval.overrideByLonghand(longhandName)) continue;
            it.remove();
            this.propValue.remove(shName);
            return;
        }
    }

    void addPrefixedValue(String propertyName, StyleValue prefVal, boolean importantPriority) {
        if (this.prefValues == null) {
            this.prefValues = new LinkedList();
        }
        this.prefValues.add(propertyName);
        this.prefValues.add(prefVal);
        this.prefValues.add(importantPriority);
    }

    boolean addCompatProperty(String propertyName, StyleValue cssValue, String priority) {
        if (cssValue.getCssValueType() == CSSValue.CssType.SHORTHAND) {
            this.addShorthandName(propertyName);
        } else {
            StyleValue overridden = this.propValue.get(propertyName);
            if (BaseCSSStyleDeclaration.hasUnknown(cssValue)) {
                this.compatLonghand(propertyName, cssValue, "important".equals(priority), overridden != null);
                return false;
            }
            this.propertyList.add(propertyName);
            this.priorities.add(priority);
            StyleValue ovValue = this.propValue.get(propertyName);
            if (ovValue != null && ovValue.isSubproperty()) {
                this.overrideShorthands(propertyName, priority);
            }
        }
        this.propValue.put(propertyName, cssValue);
        return true;
    }

    private static boolean hasUnknown(CSSValue cssValue) {
        block7: {
            CSSValue.CssType type;
            block6: {
                type = cssValue.getCssValueType();
                if (type != CSSValue.CssType.TYPED) break block6;
                CSSValue.Type ptype = cssValue.getPrimitiveType();
                if (ptype == CSSValue.Type.UNKNOWN) {
                    return true;
                }
                if (ptype == CSSValue.Type.FUNCTION || ptype == CSSValue.Type.MATH_FUNCTION) {
                    CSSFunctionValue function = (CSSFunctionValue)cssValue;
                    CSSValueList<? extends CSSValue> list = function.getArguments();
                    for (CSSValue cSSValue : list) {
                        if (!BaseCSSStyleDeclaration.hasUnknown(cSSValue)) continue;
                        return true;
                    }
                } else if (ptype == CSSValue.Type.EXPRESSION) {
                    CSSExpressionValue calc = (CSSExpressionValue)cssValue;
                    return BaseCSSStyleDeclaration.hasUnknown(calc.getExpression());
                }
                break block7;
            }
            if (type != CSSValue.CssType.LIST) break block7;
            ValueList list = (ValueList)cssValue;
            for (CSSValue value : list) {
                if (!BaseCSSStyleDeclaration.hasUnknown(value)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasUnknown(CSSExpression expression) {
        if (expression.getPartType() == CSSExpression.AlgebraicPart.OPERAND) {
            return BaseCSSStyleDeclaration.hasUnknown(((CSSOperandExpression)expression).getOperand());
        }
        AlgebraicExpression ae = (AlgebraicExpression)expression;
        int len = ae.getLength();
        for (int i = 0; i < len; ++i) {
            CSSExpression expr = ae.item(i);
            if (!BaseCSSStyleDeclaration.hasUnknown(expr)) continue;
            return true;
        }
        return false;
    }

    protected void compatLonghand(String propertyName, StyleValue overridden, boolean priorityImportant, boolean isOverridden) {
    }

    boolean isPropertySet(String propertyName) {
        return this.propertyList.contains(propertyName);
    }

    boolean isPropertyImportant(String propertyName) {
        int idx = this.propertyList.indexOf(propertyName);
        if (idx != -1) {
            String prio = this.priorities.get(idx);
            return prio != null && prio.length() != 0;
        }
        return false;
    }

    boolean isPropertySet(String propertyName, boolean important) {
        int idx = this.propertyList.indexOf(propertyName);
        if (idx != -1) {
            String prio = this.priorities.get(idx);
            boolean prioImportant = prio != null && prio.length() != 0;
            return prioImportant == important;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.propertyList.isEmpty();
    }

    @Override
    public int getLength() {
        return this.propertyList.size();
    }

    @Override
    public String item(int index) {
        if (index < 0 || index > this.propertyList.size()) {
            return "";
        }
        return this.propertyList.get(index);
    }

    @Override
    void clear() {
        this.propValue.clear();
        this.propertyList.clear();
        this.priorities.clear();
        this.shorthandSet.clear();
        this.prefValues = null;
        StyleDeclarationErrorHandler errHandler = this.getStyleDeclarationErrorHandler();
        if (errHandler != null) {
            errHandler.reset();
        }
    }

    @Override
    public BaseCSSDeclarationRule getParentRule() {
        return this.parentRule;
    }

    public Node getOwnerNode() {
        AbstractCSSStyleSheet sheet;
        if (this.parentRule != null && (sheet = this.parentRule.getParentStyleSheet()) != null) {
            return sheet.getOwnerNode();
        }
        return null;
    }

    public void addStyle(BaseCSSStyleDeclaration style) {
        ShorthandDatabase sdb = ShorthandDatabase.getInstance();
        HashSet<String> addedShorthands = new HashSet<String>(style.shorthandSet.size());
        int i = -1;
        for (String propertyName : style.propertyList) {
            String shorthand;
            ++i;
            int pIndex = this.propertyList.indexOf(propertyName);
            if (pIndex == -1) {
                this.propertyList.add(propertyName);
                this.priorities.add(style.priorities.get(i));
            } else if (!"important".equals(this.priorities.get(pIndex))) {
                this.priorities.set(pIndex, style.priorities.get(i));
            } else if (!"important".equals(style.priorities.get(i))) continue;
            StyleValue value = style.getCSSValue(propertyName);
            if (value.isSubproperty() && !addedShorthands.contains(shorthand = sdb.getShorthand(propertyName))) {
                StyleValue shvalue;
                String bigshorthand = sdb.getShorthand(shorthand);
                if (bigshorthand != null && style.shorthandSet.contains(bigshorthand)) {
                    addedShorthands.add(bigshorthand);
                    this.addShorthandName(bigshorthand);
                    shvalue = style.propValue.get(bigshorthand);
                    this.setPropertyCSSValue(bigshorthand, shvalue, null);
                }
                if ((shvalue = style.propValue.get(shorthand)) != null) {
                    addedShorthands.add(shorthand);
                    this.addShorthandName(shorthand);
                    this.setPropertyCSSValue(shorthand, shvalue, null);
                }
            }
            String href = null;
            if ("background-image".equals(propertyName) || "border-image-source".equals(propertyName)) {
                href = style.getParentRule() != null ? style.getParentRule().getParentStyleSheet().getHref() : ((NodeStyleDeclaration)((Object)style)).getOwnerNode().getOwnerDocument().getBaseURI();
            }
            this.setPropertyCSSValue(propertyName, value, href);
        }
    }

    protected void setPropertyCSSValue(String propertyName, StyleValue value, String hrefcontext) {
        this.propValue.put(propertyName, value);
    }

    @Override
    protected void prioritySplit(AbstractCSSStyleDeclaration importantDecl, AbstractCSSStyleDeclaration normalDecl) {
        StyleValue value;
        int psz = this.propertyList.size();
        for (int i = 0; i < psz; ++i) {
            String propertyName = this.propertyList.get(i);
            value = this.propValue.get(propertyName);
            String priority = this.priorities.get(i);
            if ("important".equals(priority)) {
                importantDecl.addProperty(propertyName, value, priority);
                continue;
            }
            normalDecl.addProperty(propertyName, value, priority);
        }
        for (String sh : this.shorthandSet) {
            value = (ShorthandValue)this.propValue.get(sh);
            if (((ShorthandValue)value).isImportant()) {
                importantDecl.addProperty(sh, value, "important");
                continue;
            }
            normalDecl.addProperty(sh, value, null);
        }
    }

    public StyleDatabase getStyleDatabase() {
        Node node;
        AbstractCSSStyleSheet pSheet;
        if (this.parentRule != null && (pSheet = this.parentRule.getParentStyleSheet()) != null && (node = pSheet.getOwnerNode()) != null) {
            StyleDatabase sdb = node.getNodeType() != 9 ? ((CSSDocument)node.getOwnerDocument()).getStyleDatabase() : ((CSSDocument)node).getStyleDatabase();
            return sdb;
        }
        return null;
    }

    StyleValue defaultPropertyValue(String propertyName) {
        StyleValue defval = PropertyDatabase.getInstance().getInitialValue(propertyName);
        if (defval == null) {
            if (propertyName.equals("color")) {
                defval = this.getColorInitialValue();
            } else if (propertyName.equals("font-family")) {
                defval = this.getFontFamilyInitialValue();
            } else if (propertyName.equals("text-align")) {
                String directionValue = this.getPropertyValue("direction");
                defval = directionValue.equals("rtl") ? new IdentifierValue("right") : new IdentifierValue("left");
            } else if (propertyName.endsWith("-color")) {
                defval = this.getCurrentColor();
            } else if (propertyName.equals("quotes")) {
                defval = this.getValueFactory().parseProperty("\" \"");
            }
        }
        return defval;
    }

    private TypedValue getColorInitialValue() {
        TypedValue value;
        StyleDatabase sdb = this.getStyleDatabase();
        if (sdb == null) {
            value = this.getSystemDefaultValue("color");
        } else {
            value = (TypedValue)sdb.getInitialColor();
            value = new SafeSystemDefaultValue((CSSTypedValue)value);
        }
        return value;
    }

    private StyleValue getFontFamilyInitialValue() {
        StyleValue value;
        StyleDatabase sdb = this.getStyleDatabase();
        value = sdb == null ? this.getSystemDefaultValue("font-family") : ((value = this.getValueFactory().parseProperty(sdb.getDefaultGenericFontFamily())).getCssValueType() == CSSValue.CssType.TYPED ? new SafeSystemDefaultValue((CSSTypedValue)((TypedValue)value)) : this.getSystemDefaultValue("font-family"));
        return value;
    }

    private TypedValue getSystemDefaultValue(String propertyName) {
        AbstractCSSStyleSheetFactory factory = this.getStyleSheetFactory();
        TypedValue value = factory != null ? factory.getSystemDefaultValue(propertyName) : SystemDefaultValue.getInstance();
        return value;
    }

    protected TypedValue getCurrentColor() {
        return new IdentifierValue("currentcolor");
    }

    public TypedValue getCSSColor() {
        StyleValue cssvalue = this.getCSSValue("color");
        TypedValue color = cssvalue == null || cssvalue.getCssValueType() != CSSValue.CssType.TYPED ? this.getColorInitialValue() : (TypedValue)cssvalue;
        return color;
    }

    ArrayList<String> getShorthandSet() {
        return this.shorthandSet;
    }

    private SubpropertySetter setSubproperties(String propertyName, LexicalUnit value, boolean important, boolean attrTainted) throws DOMException {
        ShorthandDatabase sdb = ShorthandDatabase.getInstance();
        if (sdb.isShorthand(propertyName)) {
            ShorthandSetter setter;
            if (BaseCSSStyleDeclaration.isOrContainsProxy(value)) {
                PendingSubstitutionSetter setter2 = new PendingSubstitutionSetter(this, propertyName);
                setter2.init(value, important);
                setter2.assignSubproperties();
                return setter2;
            }
            if ("font".equals(propertyName)) {
                String decl;
                if (this.getStyleDatabase() != null && value.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && value.getNextLexicalUnit() == null && (decl = this.getStyleDatabase().getSystemFontDeclaration(value.getStringValue())) != null) {
                    return this.setSystemFont(decl, important);
                }
                setter = new FontShorthandSetter(this);
            } else {
                setter = "margin".equals(propertyName) ? new MarginShorthandSetter(this) : ("padding".equals(propertyName) ? new BoxShorthandSetter(this, "padding") : ("border".equals(propertyName) ? new BorderShorthandSetter(this) : ("border-width".equals(propertyName) ? new BorderWidthShorthandSetter(this) : ("border-style".equals(propertyName) ? new BorderStyleShorthandSetter(this) : ("border-color".equals(propertyName) ? new BorderColorShorthandSetter(this) : ("border-top".equals(propertyName) ? new BorderSideShorthandSetter(this, propertyName, "top") : ("border-right".equals(propertyName) ? new BorderSideShorthandSetter(this, propertyName, "right") : ("border-bottom".equals(propertyName) ? new BorderSideShorthandSetter(this, propertyName, "bottom") : ("border-left".equals(propertyName) ? new BorderSideShorthandSetter(this, propertyName, "left") : ("background".equals(propertyName) ? new BackgroundShorthandSetter(this) : ("transition".equals(propertyName) ? new TransitionShorthandSetter(this) : ("border-image".equals(propertyName) ? new BorderImageShorthandSetter(this) : ("font-variant".equals(propertyName) ? new FontVariantShorthandSetter(this) : ("border-radius".equals(propertyName) ? new BorderRadiusShorthandSetter(this) : ("list-style".equals(propertyName) ? new ListStyleShorthandSetter(this) : ("animation".equals(propertyName) ? new AnimationShorthandSetter(this) : ("mask".equals(propertyName) ? new MaskShorthandSetter(this) : ("flex".equals(propertyName) ? new FlexShorthandSetter(this) : ("grid".equals(propertyName) ? new GridShorthandSetter(this) : ("grid-template".equals(propertyName) ? new GridTemplateShorthandSetter(this) : ("grid-area".equals(propertyName) ? new GridAreaShorthandSetter(this) : ("grid-column".equals(propertyName) || "grid-row".equals(propertyName) ? new GridPlacementShorthandSetter(this, propertyName) : ("columns".equals(propertyName) ? new ColumnsShorthandSetter(this) : ("column-rule".equals(propertyName) ? new ColumnRuleShorthandSetter(this) : ("place-content".equals(propertyName) || "place-items".equals(propertyName) || "place-self".equals(propertyName) ? new OrderedTwoIdentifierShorthandSetter(this, propertyName) : ("gap".equals(propertyName) ? new OrderedTwoLPIShorthandSetter(this, propertyName) : ("cue".equals(propertyName) ? new CueShorthandSetter(this, propertyName) : ("pause".equals(propertyName) || "rest".equals(propertyName) ? new SequenceShorthandSetter(this, propertyName) : new ShorthandSetter(this, propertyName)))))))))))))))))))))))))))));
            }
            setter.init(value, important);
            setter.setAttrTainted(attrTainted);
            short result = setter.assignSubproperties();
            if (result == 2) {
                throw new DOMException(12, "Invalid property declaration: " + value.toString());
            }
            if (result == 0) {
                return setter;
            }
        }
        return null;
    }

    private static boolean isOrContainsProxy(LexicalUnit lunit) {
        do {
            LexicalUnit.LexicalType type;
            if ((type = lunit.getLexicalUnitType()) != LexicalUnit.LexicalType.VAR && type != LexicalUnit.LexicalType.ATTR && (lunit.getParameters() == null || !BaseCSSStyleDeclaration.isOrContainsProxy(lunit.getParameters())) && (lunit.getSubValues() == null || !BaseCSSStyleDeclaration.isOrContainsProxy(lunit.getSubValues()))) continue;
            return true;
        } while ((lunit = lunit.getNextLexicalUnit()) != null);
        return false;
    }

    private SubpropertySetter setSystemFont(String fontDecl, boolean important) throws DOMException {
        StringReader re = new StringReader(fontDecl);
        LexicalUnit lunit = null;
        try {
            lunit = this.createSACParser().parsePropertyValue(re);
        }
        catch (CSSParseException e) {
            DOMException ex = new DOMException(12, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return this.setSubproperties("font", lunit, important, false);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        TreeSet<String> propertyNames = new TreeSet<String>(this.propertyList);
        for (String property : propertyNames) {
            result = 31 * result + property.hashCode();
            result = 31 * result + this.propValue.get(property).hashCode();
            String prio = this.priorities.get(this.propertyList.indexOf(property));
            result = 31 * result + (prio == null ? 0 : prio.hashCode());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseCSSStyleDeclaration)) {
            return false;
        }
        BaseCSSStyleDeclaration other = (BaseCSSStyleDeclaration)obj;
        if (this.propertyList.size() != other.propertyList.size()) {
            return false;
        }
        for (String property : this.propertyList) {
            if (!other.propertyList.contains(property)) {
                return false;
            }
            StyleValue value = this.propValue.get(property);
            if (!value.equals(other.propValue.get(property))) {
                return false;
            }
            int idx = this.propertyList.indexOf(property);
            int idxo = other.propertyList.indexOf(property);
            String prio = this.priorities.get(idx);
            String prioo = other.priorities.get(idxo);
            if (!(prio == null ? prioo != null : !prio.equals(prioo))) continue;
            return false;
        }
        return true;
    }

    public Diff<String> diff(BaseCSSStyleDeclaration other) {
        PropertyDiff diff = new PropertyDiff();
        for (String property : this.propertyList) {
            StyleValue otherValue;
            if (!other.propertyList.contains(property)) {
                diff.leftSide.add(property);
                continue;
            }
            StyleValue value = this.getCSSValue(property);
            if (this.valueEquals(value, otherValue = other.getCSSValue(property))) {
                int idx = this.propertyList.indexOf(property);
                int idxo = other.propertyList.indexOf(property);
                String prio = this.priorities.get(idx);
                String prioo = other.priorities.get(idxo);
                if (prio == null ? prioo == null : prio.equals(prioo)) continue;
            }
            diff.differentValues.add(property);
        }
        for (String property : other.propertyList) {
            if (this.propertyList.contains(property)) continue;
            diff.rightSide.add(property);
        }
        return diff;
    }

    private boolean valueEquals(StyleValue value, StyleValue otherValue) {
        return value != null ? value.equals(otherValue) : otherValue == null;
    }

    public String toString() {
        return this.getCssText();
    }

    public BaseCSSStyleDeclaration clone() {
        return new BaseCSSStyleDeclaration(this);
    }

    static String lexicalUnitToString(LexicalUnit value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    @Override
    public String getAzimuth() {
        return this.getPropertyValue("azimuth");
    }

    @Override
    public void setAzimuth(String azimuth) throws DOMException {
        this.getPropertyCSSValue("azimuth").setCssText(azimuth);
    }

    @Override
    public String getBackground() {
        return this.getPropertyValue("background");
    }

    @Override
    public void setBackground(String background) throws DOMException {
        this.getPropertyCSSValue("background").setCssText(background);
    }

    @Override
    public String getBackgroundAttachment() {
        return this.getPropertyValue("background-attachment");
    }

    @Override
    public void setBackgroundAttachment(String backgroundAttachment) throws DOMException {
        this.getPropertyCSSValue("background-attachment").setCssText(backgroundAttachment);
    }

    @Override
    public String getBackgroundColor() {
        return this.getPropertyValue("background-color");
    }

    @Override
    public void setBackgroundColor(String backgroundColor) throws DOMException {
        this.getPropertyCSSValue("background-color").setCssText(backgroundColor);
    }

    @Override
    public String getBackgroundImage() {
        return this.getPropertyValue("background-image");
    }

    @Override
    public void setBackgroundImage(String backgroundImage) throws DOMException {
        this.getPropertyCSSValue("background-attachment").setCssText(backgroundImage);
    }

    @Override
    public String getBackgroundPosition() {
        return this.getPropertyValue("background-position");
    }

    @Override
    public void setBackgroundPosition(String backgroundPosition) throws DOMException {
        this.getPropertyCSSValue("background-position").setCssText(backgroundPosition);
    }

    @Override
    public String getBackgroundRepeat() {
        return this.getPropertyValue("background-repeat");
    }

    @Override
    public void setBackgroundRepeat(String backgroundRepeat) throws DOMException {
        this.getPropertyCSSValue("background-repeat").setCssText(backgroundRepeat);
    }

    @Override
    public String getBorder() {
        return this.getPropertyValue("border");
    }

    @Override
    public void setBorder(String border) throws DOMException {
        this.getPropertyCSSValue("border").setCssText(border);
    }

    @Override
    public String getBorderCollapse() {
        return this.getPropertyValue("border-collapse");
    }

    @Override
    public void setBorderCollapse(String borderCollapse) throws DOMException {
        this.getPropertyCSSValue("border-collapse").setCssText(borderCollapse);
    }

    @Override
    public String getBorderColor() {
        return this.getPropertyValue("border-color");
    }

    @Override
    public void setBorderColor(String borderColor) throws DOMException {
        this.getPropertyCSSValue("border-color").setCssText(borderColor);
    }

    @Override
    public String getBorderSpacing() {
        return this.getPropertyValue("border-spacing");
    }

    @Override
    public void setBorderSpacing(String borderSpacing) throws DOMException {
        this.getPropertyCSSValue("border-spacing").setCssText(borderSpacing);
    }

    @Override
    public String getBorderStyle() {
        return this.getPropertyValue("border-style");
    }

    @Override
    public void setBorderStyle(String borderStyle) throws DOMException {
        this.getPropertyCSSValue("border-style").setCssText(borderStyle);
    }

    @Override
    public String getBorderTop() {
        return this.getPropertyValue("border-top");
    }

    @Override
    public void setBorderTop(String borderTop) throws DOMException {
        this.getPropertyCSSValue("border-top").setCssText(borderTop);
    }

    @Override
    public String getBorderRight() {
        return this.getPropertyValue("border-right");
    }

    @Override
    public void setBorderRight(String borderRight) throws DOMException {
        this.getPropertyCSSValue("border-right").setCssText(borderRight);
    }

    @Override
    public String getBorderBottom() {
        return this.getPropertyValue("border-bottom");
    }

    @Override
    public void setBorderBottom(String borderBottom) throws DOMException {
        this.getPropertyCSSValue("border-bottom").setCssText(borderBottom);
    }

    @Override
    public String getBorderLeft() {
        return this.getPropertyValue("border-left");
    }

    @Override
    public void setBorderLeft(String borderLeft) throws DOMException {
        this.getPropertyCSSValue("border-left").setCssText(borderLeft);
    }

    @Override
    public String getBorderTopColor() {
        return this.getPropertyValue("border-top-color");
    }

    @Override
    public void setBorderTopColor(String borderTopColor) throws DOMException {
        this.getPropertyCSSValue("border-top-color").setCssText(borderTopColor);
    }

    @Override
    public String getBorderRightColor() {
        return this.getPropertyValue("border-right-color");
    }

    @Override
    public void setBorderRightColor(String borderRightColor) throws DOMException {
        this.getPropertyCSSValue("border-right-color").setCssText(borderRightColor);
    }

    @Override
    public String getBorderBottomColor() {
        return this.getPropertyValue("border-bottom-color");
    }

    @Override
    public void setBorderBottomColor(String borderBottomColor) throws DOMException {
        this.getPropertyCSSValue("border-bottom-color").setCssText(borderBottomColor);
    }

    @Override
    public String getBorderLeftColor() {
        return this.getPropertyValue("border-left-color");
    }

    @Override
    public void setBorderLeftColor(String borderLeftColor) throws DOMException {
        this.getPropertyCSSValue("border-left-color").setCssText(borderLeftColor);
    }

    @Override
    public String getBorderTopStyle() {
        return this.getPropertyValue("border-top-style");
    }

    @Override
    public void setBorderTopStyle(String borderTopStyle) throws DOMException {
        this.getPropertyCSSValue("border-top-style").setCssText(borderTopStyle);
    }

    @Override
    public String getBorderRightStyle() {
        return this.getPropertyValue("border-right-style");
    }

    @Override
    public void setBorderRightStyle(String borderRightStyle) throws DOMException {
        this.getPropertyCSSValue("border-right-style").setCssText(borderRightStyle);
    }

    @Override
    public String getBorderBottomStyle() {
        return this.getPropertyValue("border-bottom-style");
    }

    @Override
    public void setBorderBottomStyle(String borderBottomStyle) throws DOMException {
        this.getPropertyCSSValue("border-bottom-style").setCssText(borderBottomStyle);
    }

    @Override
    public String getBorderLeftStyle() {
        return this.getPropertyValue("border-left-style");
    }

    @Override
    public void setBorderLeftStyle(String borderLeftStyle) throws DOMException {
        this.getPropertyCSSValue("border-left-style").setCssText(borderLeftStyle);
    }

    @Override
    public String getBorderTopWidth() {
        return this.getPropertyValue("border-top-width");
    }

    @Override
    public void setBorderTopWidth(String borderTopWidth) throws DOMException {
        this.getPropertyCSSValue("border-top-width").setCssText(borderTopWidth);
    }

    @Override
    public String getBorderRightWidth() {
        return this.getPropertyValue("border-right-width");
    }

    @Override
    public void setBorderRightWidth(String borderRightWidth) throws DOMException {
        this.getPropertyCSSValue("border-right-width").setCssText(borderRightWidth);
    }

    @Override
    public String getBorderBottomWidth() {
        return this.getPropertyValue("border-bottom-width");
    }

    @Override
    public void setBorderBottomWidth(String borderBottomWidth) throws DOMException {
        this.getPropertyCSSValue("border-bottom-width").setCssText(borderBottomWidth);
    }

    @Override
    public String getBorderLeftWidth() {
        return this.getPropertyValue("border-left-width");
    }

    @Override
    public void setBorderLeftWidth(String borderLeftWidth) throws DOMException {
        this.getPropertyCSSValue("border-left-width").setCssText(borderLeftWidth);
    }

    @Override
    public String getBorderWidth() {
        return this.getPropertyValue("border-width");
    }

    @Override
    public void setBorderWidth(String borderWidth) throws DOMException {
        this.getPropertyCSSValue("border-width").setCssText(borderWidth);
    }

    @Override
    public String getBottom() {
        return this.getPropertyValue("bottom");
    }

    @Override
    public void setBottom(String bottom) throws DOMException {
        this.getPropertyCSSValue("bottom").setCssText(bottom);
    }

    @Override
    public String getCaptionSide() {
        return this.getPropertyValue("caption-side");
    }

    @Override
    public void setCaptionSide(String captionSide) throws DOMException {
        this.getPropertyCSSValue("caption-side").setCssText(captionSide);
    }

    @Override
    public String getClear() {
        return this.getPropertyValue("clear");
    }

    @Override
    public void setClear(String clear) throws DOMException {
        this.getPropertyCSSValue("clear").setCssText(clear);
    }

    @Override
    public String getClip() {
        return this.getPropertyValue("clip");
    }

    @Override
    public void setClip(String clip) throws DOMException {
        this.getPropertyCSSValue("clip").setCssText(clip);
    }

    @Override
    public String getColor() {
        return this.getPropertyValue("color");
    }

    @Override
    public void setColor(String color) throws DOMException {
        this.getPropertyCSSValue("color").setCssText(color);
    }

    @Override
    public String getContent() {
        return this.getPropertyValue("content");
    }

    @Override
    public void setContent(String content) throws DOMException {
        this.getPropertyCSSValue("content").setCssText(content);
    }

    @Override
    public String getCounterIncrement() {
        return this.getPropertyValue("counter-increment");
    }

    @Override
    public void setCounterIncrement(String counterIncrement) throws DOMException {
        this.getPropertyCSSValue("counter-increment").setCssText(counterIncrement);
    }

    @Override
    public String getCounterReset() {
        return this.getPropertyValue("counter-reset");
    }

    @Override
    public void setCounterReset(String counterReset) throws DOMException {
        this.getPropertyCSSValue("counter-reset").setCssText(counterReset);
    }

    @Override
    public String getCue() {
        return this.getPropertyValue("cue");
    }

    @Override
    public void setCue(String cue) throws DOMException {
        this.getPropertyCSSValue("cue").setCssText(cue);
    }

    @Override
    public String getCueAfter() {
        return this.getPropertyValue("cue-after");
    }

    @Override
    public void setCueAfter(String cueAfter) throws DOMException {
        this.getPropertyCSSValue("cue-after").setCssText(cueAfter);
    }

    @Override
    public String getCueBefore() {
        return this.getPropertyValue("cue-before");
    }

    @Override
    public void setCueBefore(String cueBefore) throws DOMException {
        this.getPropertyCSSValue("cue-before").setCssText(cueBefore);
    }

    @Override
    public String getCursor() {
        return this.getPropertyValue("cursor");
    }

    @Override
    public void setCursor(String cursor) throws DOMException {
        this.getPropertyCSSValue("cursor").setCssText(cursor);
    }

    @Override
    public String getDirection() {
        return this.getPropertyValue("direction");
    }

    @Override
    public void setDirection(String direction) throws DOMException {
        this.getPropertyCSSValue("direction").setCssText(direction);
    }

    @Override
    public String getDisplay() {
        return this.getPropertyValue("display");
    }

    @Override
    public void setDisplay(String display) throws DOMException {
        this.getPropertyCSSValue("display").setCssText(display);
    }

    @Override
    public String getElevation() {
        return this.getPropertyValue("elevation");
    }

    @Override
    public void setElevation(String elevation) throws DOMException {
        this.getPropertyCSSValue("elevation").setCssText(elevation);
    }

    @Override
    public String getEmptyCells() {
        return this.getPropertyValue("empty-cells");
    }

    @Override
    public void setEmptyCells(String emptyCells) throws DOMException {
        this.getPropertyCSSValue("empty-cells").setCssText(emptyCells);
    }

    @Override
    public String getCssFloat() {
        return this.getPropertyValue("css-float");
    }

    @Override
    public void setCssFloat(String cssFloat) throws DOMException {
        this.getPropertyCSSValue("css-float").setCssText(cssFloat);
    }

    @Override
    public String getFont() {
        return this.getPropertyValue("font");
    }

    @Override
    public void setFont(String font) throws DOMException {
        this.getPropertyCSSValue("font").setCssText(font);
    }

    @Override
    public String getFontFamily() {
        return this.getPropertyValue("font-family");
    }

    @Override
    public void setFontFamily(String fontFamily) throws DOMException {
        this.getPropertyCSSValue("font-family").setCssText(fontFamily);
    }

    @Override
    public String getFontSize() {
        return this.getPropertyValue("font-size");
    }

    @Override
    public void setFontSize(String fontSize) throws DOMException {
        this.getPropertyCSSValue("font-size").setCssText(fontSize);
    }

    @Override
    public String getFontSizeAdjust() {
        return this.getPropertyValue("font-size-adjust");
    }

    @Override
    public void setFontSizeAdjust(String fontSizeAdjust) throws DOMException {
        this.getPropertyCSSValue("font-size-adjust").setCssText(fontSizeAdjust);
    }

    @Override
    public String getFontStretch() {
        return this.getPropertyValue("font-stretch");
    }

    @Override
    public void setFontStretch(String fontStretch) throws DOMException {
        this.getPropertyCSSValue("font-stretch").setCssText(fontStretch);
    }

    @Override
    public String getFontStyle() {
        return this.getPropertyValue("font-style");
    }

    @Override
    public void setFontStyle(String fontStyle) throws DOMException {
        this.getPropertyCSSValue("font-style").setCssText(fontStyle);
    }

    @Override
    public String getFontVariant() {
        return this.getPropertyValue("font-variant");
    }

    @Override
    public void setFontVariant(String fontVariant) throws DOMException {
        this.getPropertyCSSValue("font-variant").setCssText(fontVariant);
    }

    @Override
    public String getFontWeight() {
        return this.getPropertyValue("font-weight");
    }

    @Override
    public void setFontWeight(String fontWeight) throws DOMException {
        this.getPropertyCSSValue("font-weight").setCssText(fontWeight);
    }

    @Override
    public String getHeight() {
        return this.getPropertyValue("height");
    }

    @Override
    public void setHeight(String height) throws DOMException {
        this.getPropertyCSSValue("height").setCssText(height);
    }

    @Override
    public String getLeft() {
        return this.getPropertyValue("left");
    }

    @Override
    public void setLeft(String left) throws DOMException {
        this.getPropertyCSSValue("left").setCssText(left);
    }

    @Override
    public String getLetterSpacing() {
        return this.getPropertyValue("letter-spacing");
    }

    @Override
    public void setLetterSpacing(String letterSpacing) throws DOMException {
        this.getPropertyCSSValue("letter-spacing").setCssText(letterSpacing);
    }

    @Override
    public String getLineHeight() {
        return this.getPropertyValue("line-height");
    }

    @Override
    public void setLineHeight(String lineHeight) throws DOMException {
        this.getPropertyCSSValue("line-height").setCssText(lineHeight);
    }

    @Override
    public String getListStyle() {
        return this.getPropertyValue("list-style");
    }

    @Override
    public void setListStyle(String listStyle) throws DOMException {
        this.getPropertyCSSValue("list-style").setCssText(listStyle);
    }

    @Override
    public String getListStyleImage() {
        return this.getPropertyValue("list-style-image");
    }

    @Override
    public void setListStyleImage(String listStyleImage) throws DOMException {
        this.getPropertyCSSValue("list-style-image").setCssText(listStyleImage);
    }

    @Override
    public String getListStylePosition() {
        return this.getPropertyValue("list-style-position");
    }

    @Override
    public void setListStylePosition(String listStylePosition) throws DOMException {
        this.getPropertyCSSValue("list-style-position").setCssText(listStylePosition);
    }

    @Override
    public String getListStyleType() {
        return this.getPropertyValue("list-style-type");
    }

    @Override
    public void setListStyleType(String listStyleType) throws DOMException {
        this.getPropertyCSSValue("list-style-type").setCssText(listStyleType);
    }

    @Override
    public String getMargin() {
        return this.getPropertyValue("margin");
    }

    @Override
    public void setMargin(String margin) throws DOMException {
        this.getPropertyCSSValue("margin").setCssText(margin);
    }

    @Override
    public String getMarginTop() {
        return this.getPropertyValue("margin-top");
    }

    @Override
    public void setMarginTop(String marginTop) throws DOMException {
        this.getPropertyCSSValue("margin-top").setCssText(marginTop);
    }

    @Override
    public String getMarginRight() {
        return this.getPropertyValue("margin-right");
    }

    @Override
    public void setMarginRight(String marginRight) throws DOMException {
        this.getPropertyCSSValue("margin-right").setCssText(marginRight);
    }

    @Override
    public String getMarginBottom() {
        return this.getPropertyValue("margin-bottom");
    }

    @Override
    public void setMarginBottom(String marginBottom) throws DOMException {
        this.getPropertyCSSValue("margin-bottom").setCssText(marginBottom);
    }

    @Override
    public String getMarginLeft() {
        return this.getPropertyValue("margin-left");
    }

    @Override
    public void setMarginLeft(String marginLeft) throws DOMException {
        this.getPropertyCSSValue("margin-left").setCssText(marginLeft);
    }

    @Override
    public String getMarkerOffset() {
        return this.getPropertyValue("marker-offset");
    }

    @Override
    public void setMarkerOffset(String markerOffset) throws DOMException {
        this.getPropertyCSSValue("marker-offset").setCssText(markerOffset);
    }

    @Override
    public String getMarks() {
        return this.getPropertyValue("marks");
    }

    @Override
    public void setMarks(String marks) throws DOMException {
        this.getPropertyCSSValue("marks").setCssText(marks);
    }

    @Override
    public String getMaxHeight() {
        return this.getPropertyValue("max-height");
    }

    @Override
    public void setMaxHeight(String maxHeight) throws DOMException {
        this.getPropertyCSSValue("max-height").setCssText(maxHeight);
    }

    @Override
    public String getMaxWidth() {
        return this.getPropertyValue("max-width");
    }

    @Override
    public void setMaxWidth(String maxWidth) throws DOMException {
        this.getPropertyCSSValue("max-width").setCssText(maxWidth);
    }

    @Override
    public String getMinHeight() {
        return this.getPropertyValue("min-height");
    }

    @Override
    public void setMinHeight(String minHeight) throws DOMException {
        this.getPropertyCSSValue("min-height").setCssText(minHeight);
    }

    @Override
    public String getMinWidth() {
        return this.getPropertyValue("min-width");
    }

    @Override
    public void setMinWidth(String minWidth) throws DOMException {
        this.getPropertyCSSValue("min-width").setCssText(minWidth);
    }

    @Override
    public String getOrphans() {
        return this.getPropertyValue("orphans");
    }

    @Override
    public void setOrphans(String orphans) throws DOMException {
        this.getPropertyCSSValue("orphans").setCssText(orphans);
    }

    @Override
    public String getOutline() {
        return this.getPropertyValue("outline");
    }

    @Override
    public void setOutline(String outline) throws DOMException {
        this.getPropertyCSSValue("outline").setCssText(outline);
    }

    @Override
    public String getOutlineColor() {
        return this.getPropertyValue("outline-color");
    }

    @Override
    public void setOutlineColor(String outlineColor) throws DOMException {
        this.getPropertyCSSValue("outline-color").setCssText(outlineColor);
    }

    @Override
    public String getOutlineStyle() {
        return this.getPropertyValue("outline-style");
    }

    @Override
    public void setOutlineStyle(String outlineStyle) throws DOMException {
        this.getPropertyCSSValue("outline-style").setCssText(outlineStyle);
    }

    @Override
    public String getOutlineWidth() {
        return this.getPropertyValue("outline-width");
    }

    @Override
    public void setOutlineWidth(String outlineWidth) throws DOMException {
        this.getPropertyCSSValue("outline-width").setCssText(outlineWidth);
    }

    @Override
    public String getOverflow() {
        return this.getPropertyValue("overflow");
    }

    @Override
    public void setOverflow(String overflow) throws DOMException {
        this.getPropertyCSSValue("overflow").setCssText(overflow);
    }

    @Override
    public String getPadding() {
        return this.getPropertyValue("padding");
    }

    @Override
    public void setPadding(String padding) throws DOMException {
        this.getPropertyCSSValue("padding").setCssText(padding);
    }

    @Override
    public String getPaddingTop() {
        return this.getPropertyValue("padding-top");
    }

    @Override
    public void setPaddingTop(String paddingTop) throws DOMException {
        this.getPropertyCSSValue("padding-top").setCssText(paddingTop);
    }

    @Override
    public String getPaddingRight() {
        return this.getPropertyValue("padding-right");
    }

    @Override
    public void setPaddingRight(String paddingRight) throws DOMException {
        this.getPropertyCSSValue("padding-right").setCssText(paddingRight);
    }

    @Override
    public String getPaddingBottom() {
        return this.getPropertyValue("padding-bottom");
    }

    @Override
    public void setPaddingBottom(String paddingBottom) throws DOMException {
        this.getPropertyCSSValue("padding-bottom").setCssText(paddingBottom);
    }

    @Override
    public String getPaddingLeft() {
        return this.getPropertyValue("padding-left");
    }

    @Override
    public void setPaddingLeft(String paddingLeft) throws DOMException {
        this.getPropertyCSSValue("padding-left").setCssText(paddingLeft);
    }

    @Override
    public String getPage() {
        return this.getPropertyValue("page");
    }

    @Override
    public void setPage(String page) throws DOMException {
        this.getPropertyCSSValue("page").setCssText(page);
    }

    @Override
    public String getPageBreakAfter() {
        return this.getPropertyValue("page-break-after");
    }

    @Override
    public void setPageBreakAfter(String pageBreakAfter) throws DOMException {
        this.getPropertyCSSValue("page-break-after").setCssText(pageBreakAfter);
    }

    @Override
    public String getPageBreakBefore() {
        return this.getPropertyValue("page-break-before");
    }

    @Override
    public void setPageBreakBefore(String pageBreakBefore) throws DOMException {
        this.getPropertyCSSValue("page-break-before").setCssText(pageBreakBefore);
    }

    @Override
    public String getPageBreakInside() {
        return this.getPropertyValue("page-break-inside");
    }

    @Override
    public void setPageBreakInside(String pageBreakInside) throws DOMException {
        this.getPropertyCSSValue("page-break-inside").setCssText(pageBreakInside);
    }

    @Override
    public String getPause() {
        return this.getPropertyValue("pause");
    }

    @Override
    public void setPause(String pause) throws DOMException {
        this.getPropertyCSSValue("pause").setCssText(pause);
    }

    @Override
    public String getPauseAfter() {
        return this.getPropertyValue("pause-after");
    }

    @Override
    public void setPauseAfter(String pauseAfter) throws DOMException {
        this.getPropertyCSSValue("pause-after").setCssText(pauseAfter);
    }

    @Override
    public String getPauseBefore() {
        return this.getPropertyValue("pause-before");
    }

    @Override
    public void setPauseBefore(String pauseBefore) throws DOMException {
        this.getPropertyCSSValue("pause-before").setCssText(pauseBefore);
    }

    @Override
    public String getPitch() {
        return this.getPropertyValue("pitch");
    }

    @Override
    public void setPitch(String pitch) throws DOMException {
        this.getPropertyCSSValue("pitch").setCssText(pitch);
    }

    @Override
    public String getPitchRange() {
        return this.getPropertyValue("pitch-range");
    }

    @Override
    public void setPitchRange(String pitchRange) throws DOMException {
        this.getPropertyCSSValue("pitch-range").setCssText(pitchRange);
    }

    @Override
    public String getPlayDuring() {
        return this.getPropertyValue("play-during");
    }

    @Override
    public void setPlayDuring(String playDuring) throws DOMException {
        this.getPropertyCSSValue("play-during").setCssText(playDuring);
    }

    @Override
    public String getPosition() {
        return this.getPropertyValue("position");
    }

    @Override
    public void setPosition(String position) throws DOMException {
        this.getPropertyCSSValue("position").setCssText(position);
    }

    @Override
    public String getQuotes() {
        return this.getPropertyValue("quotes");
    }

    @Override
    public void setQuotes(String quotes) throws DOMException {
        this.getPropertyCSSValue("quotes").setCssText(quotes);
    }

    @Override
    public String getRichness() {
        return this.getPropertyValue("richness");
    }

    @Override
    public void setRichness(String richness) throws DOMException {
        this.getPropertyCSSValue("richness").setCssText(richness);
    }

    @Override
    public String getRight() {
        return this.getPropertyValue("right");
    }

    @Override
    public void setRight(String right) throws DOMException {
        this.getPropertyCSSValue("right").setCssText(right);
    }

    @Override
    public String getSize() {
        return this.getPropertyValue("size");
    }

    @Override
    public void setSize(String size) throws DOMException {
        this.getPropertyCSSValue("size").setCssText(size);
    }

    @Override
    public String getSpeak() {
        return this.getPropertyValue("speak");
    }

    @Override
    public void setSpeak(String speak) throws DOMException {
        this.getPropertyCSSValue("speak").setCssText(speak);
    }

    @Override
    public String getSpeakHeader() {
        return this.getPropertyValue("speak-header");
    }

    @Override
    public void setSpeakHeader(String speakHeader) throws DOMException {
        this.getPropertyCSSValue("speak-header").setCssText(speakHeader);
    }

    @Override
    public String getSpeakNumeral() {
        return this.getPropertyValue("speak-numeral");
    }

    @Override
    public void setSpeakNumeral(String speakNumeral) throws DOMException {
        this.getPropertyCSSValue("speak-numeral").setCssText(speakNumeral);
    }

    @Override
    public String getSpeakPunctuation() {
        return this.getPropertyValue("speak-punctuation");
    }

    @Override
    public void setSpeakPunctuation(String speakPunctuation) throws DOMException {
        this.getPropertyCSSValue("speak-punctuation").setCssText(speakPunctuation);
    }

    @Override
    public String getSpeechRate() {
        return this.getPropertyValue("speech-rate");
    }

    @Override
    public void setSpeechRate(String speechRate) throws DOMException {
        this.getPropertyCSSValue("speech-rate").setCssText(speechRate);
    }

    @Override
    public String getStress() {
        return this.getPropertyValue("stress");
    }

    @Override
    public void setStress(String stress) throws DOMException {
        this.getPropertyCSSValue("stress").setCssText(stress);
    }

    @Override
    public String getTableLayout() {
        return this.getPropertyValue("table-layout");
    }

    @Override
    public void setTableLayout(String tableLayout) throws DOMException {
        this.getPropertyCSSValue("table-layout").setCssText(tableLayout);
    }

    @Override
    public String getTextAlign() {
        return this.getPropertyValue("text-align");
    }

    @Override
    public void setTextAlign(String textAlign) throws DOMException {
        this.getPropertyCSSValue("text-align").setCssText(textAlign);
    }

    @Override
    public String getTextDecoration() {
        return this.getPropertyValue("text-decoration");
    }

    @Override
    public void setTextDecoration(String textDecoration) throws DOMException {
        this.getPropertyCSSValue("text-decoration").setCssText(textDecoration);
    }

    @Override
    public String getTextIndent() {
        return this.getPropertyValue("text-indent");
    }

    @Override
    public void setTextIndent(String textIndent) throws DOMException {
        this.getPropertyCSSValue("text-indent").setCssText(textIndent);
    }

    @Override
    public String getTextShadow() {
        return this.getPropertyValue("text-shadow");
    }

    @Override
    public void setTextShadow(String textShadow) throws DOMException {
        this.getPropertyCSSValue("text-shadow").setCssText(textShadow);
    }

    @Override
    public String getTextTransform() {
        return this.getPropertyValue("text-transform");
    }

    @Override
    public void setTextTransform(String textTransform) throws DOMException {
        this.getPropertyCSSValue("text-transform").setCssText(textTransform);
    }

    @Override
    public String getTop() {
        return this.getPropertyValue("top");
    }

    @Override
    public void setTop(String top) throws DOMException {
        this.getPropertyCSSValue("top").setCssText(top);
    }

    @Override
    public String getUnicodeBidi() {
        return this.getPropertyValue("unicode-bidi");
    }

    @Override
    public void setUnicodeBidi(String unicodeBidi) throws DOMException {
        this.getPropertyCSSValue("unicode-bidi").setCssText(unicodeBidi);
    }

    @Override
    public String getVerticalAlign() {
        return this.getPropertyValue("vertical-align");
    }

    @Override
    public void setVerticalAlign(String verticalAlign) throws DOMException {
        this.getPropertyCSSValue("vertical-align").setCssText(verticalAlign);
    }

    @Override
    public String getVisibility() {
        return this.getPropertyValue("visibility");
    }

    @Override
    public void setVisibility(String visibility) throws DOMException {
        this.getPropertyCSSValue("visibility").setCssText(visibility);
    }

    @Override
    public String getVoiceFamily() {
        return this.getPropertyValue("voice-family");
    }

    @Override
    public void setVoiceFamily(String voiceFamily) throws DOMException {
        this.getPropertyCSSValue("voice-family").setCssText(voiceFamily);
    }

    @Override
    public String getVolume() {
        return this.getPropertyValue("volume");
    }

    @Override
    public void setVolume(String volume) throws DOMException {
        this.getPropertyCSSValue("volume").setCssText(volume);
    }

    @Override
    public String getWhiteSpace() {
        return this.getPropertyValue("white-space");
    }

    @Override
    public void setWhiteSpace(String whiteSpace) throws DOMException {
        this.getPropertyCSSValue("white-space").setCssText(whiteSpace);
    }

    @Override
    public String getWidows() {
        return null;
    }

    @Override
    public void setWidows(String widows) throws DOMException {
        this.getPropertyCSSValue("widows").setCssText(widows);
    }

    @Override
    public String getWidth() {
        return this.getPropertyValue("width");
    }

    @Override
    public void setWidth(String width) throws DOMException {
        this.getPropertyCSSValue("width").setCssText(width);
    }

    @Override
    public String getWordSpacing() {
        return this.getPropertyValue("word-spacing");
    }

    @Override
    public void setWordSpacing(String wordSpacing) throws DOMException {
        this.getPropertyCSSValue("word-spacing").setCssText(wordSpacing);
    }

    @Override
    public String getZIndex() {
        return this.getPropertyValue("z-index");
    }

    @Override
    public void setZIndex(String zIndex) throws DOMException {
        this.getPropertyCSSValue("z-index").setCssText(zIndex);
    }

    private class StyleDeclarationHandler
    extends PropertyCSSHandler {
        private StyleDeclarationHandler() {
        }

        @Override
        public void property(String name, LexicalUnit value, boolean important) {
            block2: {
                try {
                    super.property(name, value, important);
                }
                catch (DOMException e) {
                    if (BaseCSSStyleDeclaration.this.getStyleDeclarationErrorHandler() == null) break block2;
                    CSSPropertyValueException ex = new CSSPropertyValueException(e);
                    ex.setValueText(value.toString());
                    BaseCSSStyleDeclaration.this.getStyleDeclarationErrorHandler().wrongValue(name, ex);
                }
            }
        }

        @Override
        public void warning(CSSParseException exception) throws CSSParseException {
            if (BaseCSSStyleDeclaration.this.getStyleDeclarationErrorHandler() != null) {
                BaseCSSStyleDeclaration.this.getStyleDeclarationErrorHandler().sacWarning(exception, BaseCSSStyleDeclaration.this.propertyList.size() - 1);
            }
        }

        @Override
        public void error(CSSParseException exception) throws CSSParseException {
            if (BaseCSSStyleDeclaration.this.getStyleDeclarationErrorHandler() != null) {
                BaseCSSStyleDeclaration.this.getStyleDeclarationErrorHandler().sacError(exception, BaseCSSStyleDeclaration.this.propertyList.size() - 1);
            }
        }
    }

    private static class PropertyDiff
    implements Diff<String> {
        LinkedList<String> leftSide = new LinkedList();
        LinkedList<String> rightSide = new LinkedList();
        LinkedList<String> differentValues = new LinkedList();

        private PropertyDiff() {
        }

        public boolean hasDifferences() {
            return !this.leftSide.isEmpty() || !this.rightSide.isEmpty() || !this.differentValues.isEmpty();
        }

        public String[] getLeftSide() {
            if (this.leftSide.isEmpty()) {
                return null;
            }
            return this.leftSide.toArray(new String[0]);
        }

        public String[] getRightSide() {
            if (this.rightSide.isEmpty()) {
                return null;
            }
            return this.rightSide.toArray(new String[0]);
        }

        public String[] getDifferent() {
            if (this.differentValues.isEmpty()) {
                return null;
            }
            return this.differentValues.toArray(new String[0]);
        }
    }
}

