/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.base.JSCompObjects;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeClass;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.Property;
import com.google.javascript.rhino.jstype.PropertyMap;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.TypeStringBuilder;
import java.util.Objects;
import java.util.TreeSet;
import org.jspecify.nullness.Nullable;

public class PrototypeObjectType
extends ObjectType {
    private static final JSTypeClass TYPE_CLASS = JSTypeClass.PROTOTYPE_OBJECT;
    private final String className;
    private final int templateParamCount;
    private final PropertyMap properties = new PropertyMap();
    private final boolean nativeType;
    private final boolean anonymousType;
    private ObjectType implicitPrototypeFallback;
    private @Nullable FunctionType ownerFunction = null;
    private boolean prettyPrint = false;
    private static final int MAX_PRETTY_PRINTED_PROPERTIES = 10;

    PrototypeObjectType(Builder<?> builder) {
        super(builder.registry, builder.templateTypeMap);
        this.className = builder.className;
        this.templateParamCount = builder.templateParamCount;
        this.nativeType = builder.nativeType;
        this.anonymousType = builder.anonymousType;
        this.properties.setParentSource(this);
        if (this.nativeType || builder.implicitPrototype != null) {
            this.setImplicitPrototype(builder.implicitPrototype);
        } else {
            this.setImplicitPrototype(this.registry.getNativeObjectType(JSTypeNative.OBJECT_TYPE));
        }
        if (this.anonymousType) {
            Preconditions.checkState((this.className == null ? 1 : 0) != 0);
        }
        Preconditions.checkNotNull((Object)this.templateTypeMap);
        Preconditions.checkState((this.templateTypeMap.size() >= this.templateParamCount ? 1 : 0) != 0);
        this.registry.getResolver().resolveIfClosed(this, TYPE_CLASS);
    }

    @Override
    JSTypeClass getTypeClass() {
        return TYPE_CLASS;
    }

    static Builder<?> builder(JSTypeRegistry registry) {
        return new Builder(registry);
    }

    @Override
    PropertyMap getPropertyMap() {
        return this.properties;
    }

    @Override
    boolean defineProperty(String name, JSType type, boolean inferred, Node propertyNode) {
        if (this.hasOwnDeclaredProperty(name)) {
            return false;
        }
        Property newProp = new Property(name, type, inferred, propertyNode);
        this.properties.putProperty(name, newProp);
        return true;
    }

    @Override
    public void setPropertyJSDocInfo(String propertyName, JSDocInfo info) {
        if (info != null) {
            Property property;
            if (this.properties.getOwnProperty(propertyName) == null) {
                this.defineInferredProperty(propertyName, this.getPropertyType(propertyName), null);
            }
            if ((property = this.properties.getOwnProperty(propertyName)) != null) {
                property.setJSDocInfo(info);
            }
        }
    }

    @Override
    public void setPropertyNode(String propertyName, Node defSite) {
        Property property = this.properties.getOwnProperty(propertyName);
        if (property != null) {
            property.setNode(defSite);
        }
    }

    @Override
    public boolean matchesNumberContext() {
        return this.isNumberObjectType() || this.isDateType() || this.isBooleanObjectType() || this.isStringObjectType() || this.hasOverriddenNativeProperty("valueOf");
    }

    @Override
    public boolean matchesStringContext() {
        return this.isTheObjectType() || this.isStringObjectType() || this.isDateType() || this.isRegexpType() || this.isArrayType() || this.isNumberObjectType() || this.isBigIntObjectType() || this.isBooleanObjectType() || this.hasOverriddenNativeProperty("toString");
    }

    @Override
    public boolean matchesSymbolContext() {
        return this.isSymbolObjectType();
    }

    private boolean hasOverriddenNativeProperty(String propertyName) {
        if (this.isNativeObjectType()) {
            return false;
        }
        JSType propertyType = this.getPropertyType(propertyName);
        ObjectType nativeType = this.isFunctionType() ? this.registry.getNativeObjectType(JSTypeNative.FUNCTION_PROTOTYPE) : this.registry.getNativeObjectType(JSTypeNative.OBJECT_PROTOTYPE);
        JSType nativePropertyType = nativeType.getPropertyType(propertyName);
        return !JSCompObjects.identical(propertyType, nativePropertyType);
    }

    @Override
    public boolean matchesObjectContext() {
        return true;
    }

    @Override
    void appendTo(TypeStringBuilder sb) {
        if (this.hasReferenceName()) {
            sb.append(sb.isForAnnotations() ? this.getNormalizedReferenceName() : this.getReferenceName());
            return;
        }
        if (!this.prettyPrint) {
            sb.append(sb.isForAnnotations() ? "?" : "{...}");
            return;
        }
        TreeSet<String> propertyNames = new TreeSet<String>();
        for (ObjectType current = this; current != null && !((ObjectType)current).isNativeObjectType() && propertyNames.size() <= 10; current = ((ObjectType)current).getImplicitPrototype()) {
            propertyNames.addAll(current.getOwnPropertyNames());
        }
        this.prettyPrint = false;
        boolean multiline = !sb.isForAnnotations() && propertyNames.size() > 1;
        sb.append("{").indent(() -> {
            if (multiline) {
                sb.breakLineAndIndent();
            }
            int i = 0;
            for (String property : propertyNames) {
                if (!sb.isForAnnotations() && ++i > 10) {
                    sb.append("...");
                    break;
                }
                sb.append(property).append(": ").appendNonNull(this.getPropertyType(property));
                if (i >= propertyNames.size()) continue;
                sb.append(",");
                if (multiline) {
                    sb.breakLineAndIndent();
                    continue;
                }
                sb.append(" ");
            }
        });
        if (multiline) {
            sb.breakLineAndIndent();
        }
        sb.append("}");
        this.prettyPrint = true;
    }

    void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    @Override
    public FunctionType getConstructor() {
        return null;
    }

    @Override
    public ObjectType getImplicitPrototype() {
        return this.implicitPrototypeFallback;
    }

    final void setImplicitPrototype(ObjectType implicitPrototype) {
        Preconditions.checkState((!this.hasCachedValues() ? 1 : 0) != 0);
        this.implicitPrototypeFallback = implicitPrototype;
        if (implicitPrototype != null) {
            this.maybeLoosenTypecheckingDueToForwardReferencedSupertype(implicitPrototype);
        }
    }

    @Override
    public final int getTemplateParamCount() {
        return this.templateParamCount;
    }

    @Override
    public @Nullable String getReferenceName() {
        if (this.className != null) {
            return this.className;
        }
        if (this.ownerFunction != null) {
            return this.ownerFunction.getReferenceName() + ".prototype";
        }
        return null;
    }

    public boolean isAnonymous() {
        return this.anonymousType;
    }

    @Override
    public boolean isNativeObjectType() {
        return this.nativeType;
    }

    @Override
    void setOwnerFunction(FunctionType type) {
        Preconditions.checkState((this.ownerFunction == null || type == null ? 1 : 0) != 0);
        this.ownerFunction = type;
    }

    @Override
    public FunctionType getOwnerFunction() {
        return this.ownerFunction;
    }

    @Override
    public Iterable<ObjectType> getCtorImplementedInterfaces() {
        return this.isFunctionPrototypeType() ? this.getOwnerFunction().getImplementedInterfaces() : ImmutableList.of();
    }

    @Override
    public Iterable<ObjectType> getCtorExtendedInterfaces() {
        return this.isFunctionPrototypeType() ? this.getOwnerFunction().getExtendedInterfaces() : ImmutableList.of();
    }

    @Override
    JSType resolveInternal(ErrorReporter reporter) {
        ObjectType implicitPrototype = this.getImplicitPrototype();
        if (implicitPrototype != null) {
            this.implicitPrototypeFallback = (ObjectType)implicitPrototype.resolve(reporter);
        }
        for (Property prop : this.properties.values()) {
            prop.setType(PrototypeObjectType.safeResolve(prop.getType(), reporter));
        }
        return this;
    }

    @Override
    public void matchConstraint(JSType constraint) {
        if (this.hasReferenceName()) {
            return;
        }
        if (constraint.isRecordType()) {
            this.matchRecordTypeConstraint(constraint.toObjectType());
        } else if (constraint.isUnionType()) {
            for (JSType alt : constraint.toMaybeUnionType().getAlternates()) {
                if (!alt.isRecordType()) continue;
                this.matchRecordTypeConstraint(alt.toObjectType());
            }
        }
    }

    public void matchRecordTypeConstraint(ObjectType constraintObj) {
        for (String prop : constraintObj.getOwnPropertyNames()) {
            JSType propType = constraintObj.getPropertyType(prop);
            if (this.isPropertyTypeDeclared(prop)) continue;
            JSType typeToInfer = propType;
            if (!this.hasProperty(prop)) {
                typeToInfer = this.getNativeType(JSTypeNative.VOID_TYPE).getLeastSupertype(propType);
            }
            this.defineInferredProperty(prop, typeToInfer, null);
        }
    }

    @Override
    int recursionUnsafeHashCode() {
        if (this.isStructuralType()) {
            return Objects.hash(this.className, this.properties);
        }
        return System.identityHashCode(this);
    }

    static class Builder<T extends Builder<T>> {
        final JSTypeRegistry registry;
        private String className;
        private ObjectType implicitPrototype;
        private boolean nativeType;
        private boolean anonymousType;
        private TemplateTypeMap templateTypeMap;
        private int templateParamCount;

        Builder(JSTypeRegistry registry) {
            this.registry = registry;
            this.templateTypeMap = registry.getEmptyTemplateTypeMap();
        }

        T setName(String x) {
            this.className = x;
            return this.castThis();
        }

        final T setImplicitPrototype(ObjectType x) {
            this.implicitPrototype = x;
            return this.castThis();
        }

        final T setNative(boolean x) {
            this.nativeType = x;
            return this.castThis();
        }

        final T setAnonymous(boolean x) {
            this.anonymousType = x;
            return this.castThis();
        }

        final T setTemplateTypeMap(TemplateTypeMap x) {
            this.templateTypeMap = x;
            return this.castThis();
        }

        final T setTemplateParamCount(int x) {
            this.templateParamCount = x;
            return this.castThis();
        }

        final T castThis() {
            return (T)this;
        }

        PrototypeObjectType build() {
            return new PrototypeObjectType(this);
        }
    }
}

