/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.serialization;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.javascript.jscomp.base.IdentityRef;
import com.google.javascript.jscomp.base.JSCompObjects;
import com.google.javascript.jscomp.base.Tri;
import com.google.javascript.jscomp.colors.Color;
import com.google.javascript.jscomp.colors.ColorId;
import com.google.javascript.jscomp.colors.ColorRegistry;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.jscomp.serialization.MalformedTypedAstException;
import com.google.javascript.jscomp.serialization.ObjectTypeProto;
import com.google.javascript.jscomp.serialization.StringPool;
import com.google.javascript.jscomp.serialization.SubtypingEdge;
import com.google.javascript.jscomp.serialization.TypePointers;
import com.google.javascript.jscomp.serialization.TypePool;
import com.google.javascript.jscomp.serialization.TypeProto;
import java.util.ArrayDeque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public final class ColorPool {
    private final LinkedHashMap<ColorId, Color> idToColor;
    private final ColorRegistry colorRegistry;
    private final ImmutableList<ShardView> shardViews;
    private static final Color PENDING_COLOR = Color.singleBuilder().setId(ColorId.fromUnsigned(-559038737)).build();

    private ColorPool(LinkedHashMap<ColorId, Color> idToColor, ColorRegistry colorRegistry, ImmutableList<ShardView> shardViews) {
        this.idToColor = idToColor;
        this.colorRegistry = colorRegistry;
        this.shardViews = shardViews;
    }

    public Color getColor(ColorId id) {
        return this.idToColor.get(id);
    }

    public ColorRegistry getRegistry() {
        return this.colorRegistry;
    }

    ShardView getOnlyShardForTesting() {
        return (ShardView)Iterables.getOnlyElement(this.shardViews);
    }

    public static Builder builder() {
        return new Builder();
    }

    static ColorPool fromOnlyShardForTesting(TypePool typePool, StringPool stringPool) {
        return ColorPool.builder().addShardAnd(typePool, stringPool).forTesting().build();
    }

    private static ImmutableList<ColorId> createTrimmedOffsetToId(TypePool typePool) {
        TypeProto proto;
        int i;
        Object[] ids = new ColorId[typePool.getTypeCount()];
        block8: for (i = 0; i < ids.length; ++i) {
            proto = typePool.getType(i);
            switch (proto.getKindCase()) {
                case OBJECT: {
                    ids[i] = ColorId.fromBytes(proto.getObject().getUuid());
                    continue block8;
                }
                case UNION: {
                    continue block8;
                }
                default: {
                    throw new MalformedTypedAstException(proto);
                }
            }
        }
        block9: for (i = 0; i < ids.length; ++i) {
            proto = typePool.getType(i);
            switch (proto.getKindCase()) {
                case OBJECT: {
                    continue block9;
                }
                case UNION: {
                    MalformedTypedAstException.checkWellFormed(proto.getUnion().getUnionMemberCount() > 1, "Union has too few members", proto);
                    LinkedHashSet<ColorId> members = new LinkedHashSet<ColorId>();
                    for (Integer memberPointer : proto.getUnion().getUnionMemberList()) {
                        Object memberId = TypePointers.isAxiomatic(memberPointer) ? ((Color)TypePointers.OFFSET_TO_AXIOMATIC_COLOR.get(memberPointer.intValue())).getId() : ids[TypePointers.trimOffset(memberPointer)];
                        MalformedTypedAstException.checkWellFormed(memberId != null, "Union member not found", proto);
                        members.add((ColorId)memberId);
                    }
                    ids[i] = ColorId.union(members);
                    continue block9;
                }
                default: {
                    throw new AssertionError(proto);
                }
            }
        }
        LinkedHashSet<Object> seenIds = new LinkedHashSet<Object>();
        for (int i2 = 0; i2 < ids.length; ++i2) {
            TypeProto proto2 = typePool.getType(i2);
            MalformedTypedAstException.checkWellFormed(seenIds.add(ids[i2]), "Duplicate ID in single shard", proto2);
        }
        return ImmutableList.copyOf((Object[])ids);
    }

    private static int validatePointer(int offset, ShardView shard) {
        MalformedTypedAstException.checkWellFormed(0 <= offset && offset < TypePointers.untrimOffset(shard.trimmedOffsetToId.size()), "Pointer offset outside of shard", offset);
        return offset;
    }

    public static final class Builder {
        private final LinkedHashMap<IdentityRef<TypePool>, ShardView> protoToShard = new LinkedHashMap();
        private final LinkedHashMap<ColorId, Color> idToColor = new LinkedHashMap();
        private final ColorRegistry.Builder registry = ColorRegistry.builder();
        private final HashBasedTable<ColorId, ShardView, TypeProto> idToProto = HashBasedTable.create();
        private boolean forTesting = false;
        private final ArrayDeque<ColorId> reconcilationDebugStack = new ArrayDeque();

        private Builder() {
            this.idToColor.putAll((Map<ColorId, Color>)StandardColors.AXIOMATIC_COLORS);
        }

        @CanIgnoreReturnValue
        public Builder addShardAnd(TypePool typePool, StringPool stringPool) {
            this.addShard(typePool, stringPool);
            return this;
        }

        @CanIgnoreReturnValue
        private Builder forTesting() {
            this.forTesting = true;
            return this;
        }

        public ShardView addShard(TypePool typePool, StringPool stringPool) {
            Preconditions.checkState((boolean)this.idToProto.isEmpty(), (Object)"build has already been called");
            IdentityRef<TypePool> typePoolRef = IdentityRef.of(typePool);
            ShardView existing = this.protoToShard.get(typePoolRef);
            if (existing != null) {
                Preconditions.checkState((boolean)JSCompObjects.identical(typePool, TypePool.getDefaultInstance()), (Object)typePool);
                return existing;
            }
            ImmutableList<ColorId> trimmedOffsetToId = ColorPool.createTrimmedOffsetToId(typePool);
            ShardView shard = new ShardView(typePool, stringPool, trimmedOffsetToId);
            this.protoToShard.put(typePoolRef, shard);
            if (typePool.hasDebugInfo()) {
                for (TypePool.DebugInfo.Mismatch m : typePool.getDebugInfo().getMismatchList()) {
                    for (Integer pointer : m.getInvolvedColorList()) {
                        this.registry.addMismatchLocation(shard.getId(pointer), m.getSourceRef());
                    }
                }
            }
            return shard;
        }

        public ColorPool build() {
            Preconditions.checkState((boolean)this.idToProto.isEmpty(), (Object)"build has already been called");
            for (ShardView shard : this.protoToShard.values()) {
                for (int i = 0; i < shard.typePool.getTypeCount(); ++i) {
                    ColorId id = (ColorId)shard.trimmedOffsetToId.get(i);
                    this.idToProto.put((Object)id, (Object)shard, (Object)shard.typePool.getType(i));
                }
            }
            for (ColorId id : StandardColors.AXIOMATIC_COLORS.keySet()) {
                MalformedTypedAstException.checkWellFormed(!this.idToProto.containsRow((Object)id), "Found serialized definiton for axiomatic color", id);
            }
            for (ColorId id : this.idToProto.rowKeySet()) {
                this.lookupOrReconcileColor(id);
            }
            for (ColorId colorId : ColorRegistry.REQUIRED_IDS) {
                this.registry.setNativeColor(this.idToColor.computeIfAbsent(colorId, unused -> Color.singleBuilder().setId(colorId).build()));
            }
            for (ShardView shard : this.protoToShard.values()) {
                for (SubtypingEdge edge : shard.typePool.getDisambiguationEdgesList()) {
                    this.registry.addDisambiguationEdge(this.idToColor.get(shard.getId(ColorPool.validatePointer(edge.getSubtype(), shard))), this.idToColor.get(shard.getId(ColorPool.validatePointer(edge.getSupertype(), shard))));
                }
            }
            ColorPool colorPool = new ColorPool(this.idToColor, this.registry.build(), (ImmutableList<ShardView>)(this.forTesting ? ImmutableList.copyOf(this.protoToShard.values()) : ImmutableList.of()));
            for (ShardView shard : this.protoToShard.values()) {
                shard.updateStateAfterColorPoolIsBuilt(colorPool);
            }
            return colorPool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Color lookupOrReconcileColor(ColorId id) {
            this.reconcilationDebugStack.addLast(id);
            try {
                Color result;
                Color existing = this.idToColor.putIfAbsent(id, PENDING_COLOR);
                if (existing != null) {
                    if (JSCompObjects.identical(existing, PENDING_COLOR)) {
                        throw new MalformedTypedAstException((Object)("Cyclic Color structure detected: " + this.reconcilationDebugStack.stream().map(x$0 -> this.idToProto.row(x$0)).map(ImmutableMap::copyOf).collect(ImmutableList.toImmutableList())));
                    }
                    Color color = existing;
                    return color;
                }
                Map viewToProto = this.idToProto.row((Object)id);
                TypeProto sample = (TypeProto)Iterables.getFirst(viewToProto.values(), null);
                Preconditions.checkNotNull((Object)sample, (Object)id);
                switch (sample.getKindCase()) {
                    case OBJECT: {
                        result = this.reconcileObjectProtos(id, viewToProto);
                        break;
                    }
                    case UNION: {
                        result = this.reconcileUnionProtos(id, viewToProto);
                        break;
                    }
                    default: {
                        throw new AssertionError(sample);
                    }
                }
                Preconditions.checkState((result != null ? 1 : 0) != 0, (Object)id);
                this.idToColor.put(id, result);
                Color color = result;
                return color;
            }
            finally {
                this.reconcilationDebugStack.removeLast();
            }
        }

        /*
         * WARNING - void declaration
         */
        private Color reconcileObjectProtos(ColorId id, Map<ShardView, TypeProto> viewToProto) {
            ImmutableSet.Builder instanceColors = ImmutableSet.builder();
            ImmutableSet.Builder prototypes = ImmutableSet.builder();
            ImmutableSet.Builder ownProperties = ImmutableSet.builder();
            Tri isClosureAssert = Tri.UNKNOWN;
            boolean isConstructor = false;
            boolean isInvalidating = false;
            boolean propertiesKeepOriginalName = false;
            for (Map.Entry<ShardView, TypeProto> entry : viewToProto.entrySet()) {
                void var16_17;
                ShardView shard = entry.getKey();
                TypeProto proto = entry.getValue();
                Preconditions.checkState((boolean)proto.hasObject());
                ObjectTypeProto objProto = proto.getObject();
                for (Integer n : objProto.getInstanceTypeList()) {
                    instanceColors.add((Object)this.lookupOrReconcileColor(shard.getId(n)));
                }
                boolean isClosureAssertBool = objProto.getClosureAssert();
                MalformedTypedAstException.checkWellFormed(isClosureAssert.toBoolean(isClosureAssertBool) == isClosureAssertBool, "Inconsistent values for closure_assert", objProto);
                isClosureAssert = Tri.forBoolean(isClosureAssertBool);
                isConstructor |= objProto.getMarkedConstructor();
                isInvalidating |= objProto.getIsInvalidating();
                propertiesKeepOriginalName |= objProto.getPropertiesKeepOriginalName();
                for (Integer p3 : objProto.getPrototypeList()) {
                    prototypes.add((Object)this.lookupOrReconcileColor(shard.getId(p3)));
                }
                boolean bl = false;
                while (var16_17 < objProto.getOwnPropertyCount()) {
                    ownProperties.add((Object)shard.stringPool.get(objProto.getOwnProperty((int)var16_17)));
                    ++var16_17;
                }
            }
            return Color.singleBuilder().setId(id).setInstanceColors((ImmutableSet<Color>)instanceColors.build()).setPrototypes((ImmutableSet<Color>)prototypes.build()).setOwnProperties((ImmutableSet<String>)ownProperties.build()).setClosureAssert(isClosureAssert.toBoolean(false)).setConstructor(isConstructor).setInvalidating(isInvalidating).setPropertiesKeepOriginalName(propertiesKeepOriginalName).build();
        }

        private Color reconcileUnionProtos(ColorId id, Map<ShardView, TypeProto> viewToProto) {
            LinkedHashSet<Color> union = new LinkedHashSet<Color>();
            viewToProto.forEach((shard, proto) -> {
                Preconditions.checkState((boolean)proto.hasUnion(), (Object)proto);
                for (Integer memberPointer : proto.getUnion().getUnionMemberList()) {
                    ColorId memberId = shard.getId(memberPointer);
                    Color member = this.lookupOrReconcileColor(memberId);
                    MalformedTypedAstException.checkWellFormed(!member.isUnion(), "Reconciling union with non-union", proto);
                    union.add(member);
                }
            });
            Color result = Color.createUnion(union);
            Preconditions.checkState((boolean)id.equals(result.getId()), (String)"%s == %s", (Object)id, (Object)result);
            return result;
        }
    }

    public static final class ShardView {
        private final ImmutableList<ColorId> trimmedOffsetToId;
        private TypePool typePool;
        private StringPool stringPool;
        private ColorPool colorPool;

        private ShardView(TypePool typePool, StringPool stringPool, ImmutableList<ColorId> trimmedOffsetToId) {
            this.typePool = typePool;
            this.stringPool = stringPool;
            this.trimmedOffsetToId = trimmedOffsetToId;
        }

        public Color getColor(int pointer) {
            Preconditions.checkState((this.colorPool != null ? 1 : 0) != 0, (Object)this);
            return this.colorPool.getColor(this.getId(pointer));
        }

        private ColorId getId(int untrimmedOffset) {
            if (TypePointers.isAxiomatic(untrimmedOffset)) {
                return ((Color)TypePointers.OFFSET_TO_AXIOMATIC_COLOR.get(untrimmedOffset)).getId();
            }
            return (ColorId)this.trimmedOffsetToId.get(TypePointers.trimOffset(untrimmedOffset));
        }

        private void updateStateAfterColorPoolIsBuilt(ColorPool colorPool) {
            this.colorPool = colorPool;
            this.typePool = null;
            this.stringPool = null;
        }
    }
}

