/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing.parser.util;

import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import com.google.javascript.jscomp.base.format.SimpleFormat;
import com.google.javascript.jscomp.parsing.parser.util.SourcePosition;

public abstract class ErrorReporter {
    private boolean hadError;

    @FormatMethod
    public final void reportError(SourcePosition location, @FormatString String format, Object ... arguments) {
        this.hadError = true;
        String message = SimpleFormat.format(format, arguments);
        this.reportError(location, message);
    }

    protected abstract void reportError(SourcePosition var1, String var2);

    @FormatMethod
    public final void reportWarning(SourcePosition location, @FormatString String format, Object ... arguments) {
        String message = SimpleFormat.format(format, arguments);
        this.reportWarning(location, message);
    }

    protected abstract void reportWarning(SourcePosition var1, String var2);

    public final boolean hadError() {
        return this.hadError;
    }
}

