/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.ijs;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.ijs.ClassUtil;
import com.google.javascript.jscomp.ijs.FileInfo;
import com.google.javascript.jscomp.ijs.PotentialDeclaration;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.QualifiedName;
import org.jspecify.nullness.Nullable;

abstract class ProcessConstJsdocCallback
extends NodeTraversal.AbstractPostOrderCallback {
    private static final QualifiedName GOOG_DEFINE = QualifiedName.of("goog.define");
    private static final QualifiedName GOOG_PROVIDE = QualifiedName.of("goog.provide");
    private static final QualifiedName GOOG_REQUIRE = QualifiedName.of("goog.require");
    private static final QualifiedName CJS_REQUIRE = QualifiedName.of("require");
    private final FileInfo currentFile;

    ProcessConstJsdocCallback(FileInfo currentFile) {
        this.currentFile = currentFile;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        block0 : switch (n.getToken()) {
            case CLASS: {
                if (!NodeUtil.isStatementParent(parent)) break;
                this.currentFile.recordNameDeclaration(n.getFirstChild());
                break;
            }
            case MEMBER_FIELD_DEF: {
                if (NodeUtil.getRValueOfLValue(n) != null) {
                    this.processDeclarationWithRhs(t, n);
                }
                this.currentFile.recordMemberFieldDef(n);
                break;
            }
            case FUNCTION: {
                if (NodeUtil.isStatementParent(parent)) {
                    this.currentFile.recordNameDeclaration(n.getFirstChild());
                    break;
                }
                if (!ClassUtil.isClassMethod(n) || !ClassUtil.hasNamedClass(n)) break;
                this.currentFile.recordMethod(n);
                break;
            }
            case EXPR_RESULT: {
                Node expr = n.getFirstChild();
                switch (expr.getToken()) {
                    case CALL: {
                        Node callee = expr.getFirstChild();
                        if (GOOG_PROVIDE.matches(callee)) {
                            this.currentFile.markProvided(expr.getLastChild().getString());
                            break block0;
                        }
                        if (GOOG_REQUIRE.matches(callee) || CJS_REQUIRE.matches(callee)) {
                            this.currentFile.recordImport(expr.getLastChild().getString());
                            break block0;
                        }
                        if (!GOOG_DEFINE.matches(callee)) break block0;
                        this.currentFile.recordDefine(expr);
                        break block0;
                    }
                    case ASSIGN: {
                        this.recordDeclaration(t, expr.getFirstChild(), expr.getLastChild());
                        break block0;
                    }
                    case GETPROP: {
                        this.currentFile.recordNameDeclaration(expr);
                        break block0;
                    }
                }
                throw new RuntimeException("Unexpected declaration: " + expr);
            }
            case VAR: 
            case CONST: 
            case LET: {
                Preconditions.checkState((boolean)n.hasOneChild(), (Object)n);
                this.recordDeclaration(t, n.getFirstChild(), n.getFirstChild().getLastChild());
                break;
            }
            case STRING_KEY: {
                if (!parent.isObjectLit() || !n.hasOneChild()) break;
                this.processDeclarationWithRhs(t, n);
                this.currentFile.recordStringKeyDeclaration(n);
                break;
            }
        }
    }

    private void recordDeclaration(NodeTraversal t, Node lhs, @Nullable Node rhs) {
        if (rhs != null && rhs.isCall() && GOOG_DEFINE.matches(rhs.getFirstChild()) && lhs.isQualifiedName()) {
            this.currentFile.recordDefine(rhs);
        } else {
            this.recordNameDeclaration(lhs, rhs);
            if (!lhs.isDestructuringLhs() && rhs != null) {
                this.processDeclarationWithRhs(t, lhs);
            }
        }
    }

    private void recordNameDeclaration(Node lhs, @Nullable Node rhs) {
        Preconditions.checkArgument((NodeUtil.isNameDeclaration(lhs.getParent()) || lhs.getParent().isAssign() ? 1 : 0) != 0);
        boolean isImport = PotentialDeclaration.isImportRhs(rhs);
        boolean isAlias = PotentialDeclaration.isAliasDeclaration(lhs, rhs);
        NodeUtil.visitLhsNodesInNode(lhs.getParent(), name -> {
            if (isAlias || isImport) {
                this.currentFile.recordAliasDeclaration((Node)name);
            } else {
                this.currentFile.recordNameDeclaration((Node)name);
            }
        });
    }

    private void processDeclarationWithRhs(NodeTraversal t, Node lhs) {
        Preconditions.checkArgument((lhs.isQualifiedName() || lhs.isStringKey() || lhs.isMemberFieldDef() ? 1 : 0) != 0, (Object)lhs);
        Preconditions.checkState((NodeUtil.getRValueOfLValue(lhs) != null ? 1 : 0) != 0, (Object)lhs);
        if (PotentialDeclaration.isConstToBeInferred(lhs)) {
            this.processConstWithRhs(t, lhs);
        }
    }

    protected abstract void processConstWithRhs(NodeTraversal var1, Node var2);
}

