/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.graph;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.javascript.jscomp.graph.Annotation;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.Graph;
import com.google.javascript.jscomp.graph.GraphNode;
import com.google.javascript.jscomp.graph.GraphvizGraph;
import com.google.javascript.jscomp.graph.SubGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.nullness.Nullable;

public class LinkedDirectedGraph<N, E>
extends DiGraph<N, E>
implements GraphvizGraph {
    protected final Map<N, LinkedDiGraphNode<N, E>> nodes = new LinkedHashMap<N, LinkedDiGraphNode<N, E>>();
    private final boolean useNodeAnnotations;
    private final boolean useEdgeAnnotations;

    @Override
    public SubGraph<N, E> newSubGraph() {
        return new Graph.SimpleSubGraph(this);
    }

    public static <N, E> LinkedDirectedGraph<N, E> createWithoutAnnotations() {
        return new LinkedDirectedGraph<N, E>(false, false);
    }

    public static <N, E> LinkedDirectedGraph<N, E> create() {
        return new LinkedDirectedGraph<N, E>(true, true);
    }

    protected LinkedDirectedGraph(boolean useNodeAnnotations, boolean useEdgeAnnotations) {
        this.useNodeAnnotations = useNodeAnnotations;
        this.useEdgeAnnotations = useEdgeAnnotations;
    }

    @Override
    public void connect(N srcValue, E edgeValue, N destValue) {
        LinkedDiGraphNode src = (LinkedDiGraphNode)this.getNodeOrFail(srcValue);
        LinkedDiGraphNode dest = (LinkedDiGraphNode)this.getNodeOrFail(destValue);
        LinkedDiGraphEdge edge = this.useEdgeAnnotations ? new AnnotatedLinkedDiGraphEdge(src, edgeValue, dest) : new LinkedDiGraphEdge(src, edgeValue, dest);
        src.getOutEdges().add(edge);
        dest.getInEdges().add(edge);
    }

    @Override
    public void connect(DiGraph.DiGraphNode<N, E> src, E edgeValue, DiGraph.DiGraphNode<N, E> dest) {
        LinkedDiGraphNode lSrc = (LinkedDiGraphNode)src;
        LinkedDiGraphNode lDest = (LinkedDiGraphNode)dest;
        LinkedDiGraphEdge edge = this.useEdgeAnnotations ? new AnnotatedLinkedDiGraphEdge(lSrc, edgeValue, lDest) : new LinkedDiGraphEdge(lSrc, edgeValue, lDest);
        lSrc.getOutEdges().add(edge);
        lDest.getInEdges().add(edge);
    }

    public void connectIfNotConnectedInDirection(N srcValue, E edgeValue, N destValue) {
        DiGraph.DiGraphNode src = this.createNode((Object)srcValue);
        DiGraph.DiGraphNode dest = this.createNode((Object)destValue);
        if (!this.isConnectedInDirection((N)src, (Predicate<E>)Predicates.equalTo(edgeValue), (N)dest)) {
            this.connect(src, edgeValue, dest);
        }
    }

    @Override
    public void disconnect(N n1, N n2) {
        this.disconnectInDirection(n1, n2);
        this.disconnectInDirection(n2, n1);
    }

    @Override
    public void disconnectInDirection(N srcValue, N destValue) {
        LinkedDiGraphNode src = (LinkedDiGraphNode)this.getNodeOrFail(srcValue);
        LinkedDiGraphNode dest = (LinkedDiGraphNode)this.getNodeOrFail(destValue);
        for (DiGraph.DiGraphEdge diGraphEdge : this.getEdgesInDirection(srcValue, destValue)) {
            src.getOutEdges().remove(diGraphEdge);
            dest.getInEdges().remove(diGraphEdge);
        }
    }

    @Override
    public Collection<LinkedDiGraphNode<N, E>> getNodes() {
        return Collections.unmodifiableCollection(this.nodes.values());
    }

    @Override
    public LinkedDiGraphNode<N, E> getNode(N nodeValue) {
        return this.nodes.get(nodeValue);
    }

    @Override
    public List<LinkedDiGraphEdge<N, E>> getInEdges(N nodeValue) {
        LinkedDiGraphNode node = (LinkedDiGraphNode)this.getNodeOrFail(nodeValue);
        return Collections.unmodifiableList(node.getInEdges());
    }

    @Override
    public List<LinkedDiGraphEdge<N, E>> getOutEdges(N nodeValue) {
        LinkedDiGraphNode node = (LinkedDiGraphNode)this.getNodeOrFail(nodeValue);
        return Collections.unmodifiableList(node.getOutEdges());
    }

    @Override
    public LinkedDiGraphNode<N, E> createNode(N nodeValue) {
        return this.nodes.computeIfAbsent(nodeValue, k -> this.useNodeAnnotations ? new AnnotatedLinkedDiGraphNode(k) : new LinkedDiGraphNode(k));
    }

    @Override
    public List<LinkedDiGraphEdge<N, E>> getEdges(N n1, N n2) {
        List<LinkedDiGraphEdge<N, E>> forwardEdges = this.getEdgesInDirection(n1, n2);
        List<LinkedDiGraphEdge<N, E>> backwardEdges = this.getEdgesInDirection(n2, n1);
        int totalSize = forwardEdges.size() + backwardEdges.size();
        ArrayList<LinkedDiGraphEdge<N, LinkedDiGraphEdge<N, E>>> edges = new ArrayList<LinkedDiGraphEdge<N, LinkedDiGraphEdge<N, E>>>(totalSize);
        edges.addAll(forwardEdges);
        edges.addAll(backwardEdges);
        return edges;
    }

    @Override
    public List<LinkedDiGraphEdge<N, E>> getEdges() {
        ArrayList<LinkedDiGraphEdge<N, E>> result = new ArrayList<LinkedDiGraphEdge<N, E>>();
        for (LinkedDiGraphNode<N, E> node : this.nodes.values()) {
            result.addAll(node.getOutEdges());
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public @Nullable Graph.GraphEdge<N, E> getFirstEdge(N n1, N n2) {
        LinkedDiGraphNode dNode1 = (LinkedDiGraphNode)this.getNodeOrFail(n1);
        LinkedDiGraphNode dNode2 = (LinkedDiGraphNode)this.getNodeOrFail(n2);
        for (DiGraph.DiGraphEdge diGraphEdge : dNode1.getOutEdges()) {
            if (diGraphEdge.getDestination() != dNode2) continue;
            return diGraphEdge;
        }
        for (DiGraph.DiGraphEdge diGraphEdge : dNode2.getOutEdges()) {
            if (diGraphEdge.getDestination() != dNode1) continue;
            return diGraphEdge;
        }
        return null;
    }

    @Override
    public List<LinkedDiGraphEdge<N, E>> getEdgesInDirection(N n1, N n2) {
        LinkedDiGraphNode dNode1 = (LinkedDiGraphNode)this.getNodeOrFail(n1);
        LinkedDiGraphNode dNode2 = (LinkedDiGraphNode)this.getNodeOrFail(n2);
        ArrayList edges = new ArrayList();
        for (LinkedDiGraphEdge outEdge : dNode1.getOutEdges()) {
            if (outEdge.getDestination() != dNode2) continue;
            edges.add(outEdge);
        }
        return edges;
    }

    @Override
    public boolean isConnectedInDirection(N source, N dest) {
        return this.isConnectedInDirection(source, Predicates.alwaysTrue(), dest);
    }

    @Override
    public boolean isConnectedInDirection(N source, E edgeValue, N dest) {
        return this.isConnectedInDirection(source, Predicates.equalTo(edgeValue), dest);
    }

    @Override
    public boolean isConnectedInDirection(LinkedDiGraphNode<N, E> source, Predicate<E> edgeFilter, LinkedDiGraphNode<N, E> dest) {
        List<LinkedDiGraphEdge<N, E>> inEdges;
        int inEdgesLen;
        List<LinkedDiGraphEdge<N, E>> outEdges = source.getOutEdges();
        int outEdgesLen = outEdges.size();
        if (outEdgesLen < (inEdgesLen = (inEdges = dest.getInEdges()).size())) {
            for (DiGraph.DiGraphEdge diGraphEdge : outEdges) {
                if (diGraphEdge.getDestination() != dest || !edgeFilter.apply(diGraphEdge.getValue())) continue;
                return true;
            }
        } else {
            for (DiGraph.DiGraphEdge diGraphEdge : inEdges) {
                if (diGraphEdge.getSource() != source || !edgeFilter.apply(diGraphEdge.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    private boolean isConnectedInDirection(N n1, Predicate<E> edgeMatcher, N n2) {
        LinkedDiGraphNode dNode1 = (LinkedDiGraphNode)this.getNodeOrFail(n1);
        LinkedDiGraphNode dNode2 = (LinkedDiGraphNode)this.getNodeOrFail(n2);
        return this.isConnectedInDirection((N)dNode1, edgeMatcher, (N)dNode2);
    }

    @Override
    public List<LinkedDiGraphNode<N, E>> getDirectedPredNodes(N nodeValue) {
        return this.getDirectedPredNodes(this.nodes.get(nodeValue));
    }

    @Override
    public List<LinkedDiGraphNode<N, E>> getDirectedPredNodes(DiGraph.DiGraphNode<N, E> dNode) {
        Preconditions.checkNotNull(dNode);
        LinkedDiGraphNode lNode = (LinkedDiGraphNode)dNode;
        ArrayList<LinkedDiGraphNode<N, DiGraph.DiGraphNode>> nodeList = new ArrayList<LinkedDiGraphNode<N, DiGraph.DiGraphNode>>(lNode.getInEdges().size());
        for (LinkedDiGraphEdge edge : lNode.getInEdges()) {
            nodeList.add((LinkedDiGraphNode<N, DiGraph.DiGraphNode>)edge.getSource());
        }
        return nodeList;
    }

    @Override
    public List<LinkedDiGraphNode<N, E>> getDirectedSuccNodes(N nodeValue) {
        return this.getDirectedSuccNodes(this.nodes.get(nodeValue));
    }

    @Override
    public List<LinkedDiGraphNode<N, E>> getDirectedSuccNodes(DiGraph.DiGraphNode<N, E> dNode) {
        Preconditions.checkNotNull(dNode);
        LinkedDiGraphNode lNode = (LinkedDiGraphNode)dNode;
        ArrayList<LinkedDiGraphNode<N, DiGraph.DiGraphNode>> nodeList = new ArrayList<LinkedDiGraphNode<N, DiGraph.DiGraphNode>>(lNode.getOutEdges().size());
        for (LinkedDiGraphEdge edge : lNode.getOutEdges()) {
            nodeList.add((LinkedDiGraphNode<N, DiGraph.DiGraphNode>)edge.getDestination());
        }
        return nodeList;
    }

    @Override
    public List<GraphvizGraph.GraphvizEdge> getGraphvizEdges() {
        ArrayList<GraphvizGraph.GraphvizEdge> edgeList = new ArrayList<GraphvizGraph.GraphvizEdge>();
        for (LinkedDiGraphNode<N, E> node : this.nodes.values()) {
            for (DiGraph.DiGraphEdge diGraphEdge : node.getOutEdges()) {
                edgeList.add((LinkedDiGraphEdge)diGraphEdge);
            }
        }
        return edgeList;
    }

    @Override
    public List<GraphvizGraph.GraphvizNode> getGraphvizNodes() {
        ArrayList<GraphvizGraph.GraphvizNode> nodeList = new ArrayList<GraphvizGraph.GraphvizNode>(this.nodes.size());
        for (LinkedDiGraphNode<N, E> node : this.nodes.values()) {
            nodeList.add(node);
        }
        return nodeList;
    }

    @Override
    public String getName() {
        return "LinkedGraph";
    }

    @Override
    public boolean isDirected() {
        return true;
    }

    @Override
    public int getNodeCount() {
        return this.nodes.size();
    }

    @Override
    public List<GraphNode<N, E>> getNeighborNodes(N value) {
        DiGraph.DiGraphNode node = this.getNode((Object)value);
        ArrayList result = new ArrayList(((LinkedDiGraphNode)node).getInEdges().size() + ((LinkedDiGraphNode)node).getOutEdges().size());
        for (DiGraph.DiGraphEdge diGraphEdge : ((LinkedDiGraphNode)node).getInEdges()) {
            result.add(diGraphEdge.getSource());
        }
        for (DiGraph.DiGraphEdge diGraphEdge : ((LinkedDiGraphNode)node).getOutEdges()) {
            result.add(diGraphEdge.getDestination());
        }
        return result;
    }

    @Override
    public int getNodeDegree(N value) {
        LinkedDiGraphNode node = (LinkedDiGraphNode)this.getNodeOrFail(value);
        return node.getInEdges().size() + node.getOutEdges().size();
    }

    static final class AnnotatedLinkedDiGraphEdge<N, E>
    extends LinkedDiGraphEdge<N, E> {
        Annotation annotation;

        private AnnotatedLinkedDiGraphEdge(LinkedDiGraphNode<N, E> sourceNode, E edgeValue, LinkedDiGraphNode<N, E> destNode) {
            super(sourceNode, edgeValue, destNode);
        }

        @Override
        public <A extends Annotation> A getAnnotation() {
            return (A)this.annotation;
        }

        @Override
        public void setAnnotation(Annotation data) {
            this.annotation = data;
        }
    }

    public static class LinkedDiGraphEdge<N, E>
    implements DiGraph.DiGraphEdge<N, E>,
    GraphvizGraph.GraphvizEdge {
        private final LinkedDiGraphNode<N, E> sourceNode;
        private final LinkedDiGraphNode<N, E> destNode;
        protected final E value;

        private LinkedDiGraphEdge(LinkedDiGraphNode<N, E> sourceNode, E edgeValue, LinkedDiGraphNode<N, E> destNode) {
            this.value = edgeValue;
            this.sourceNode = sourceNode;
            this.destNode = destNode;
        }

        @Override
        public LinkedDiGraphNode<N, E> getSource() {
            return this.sourceNode;
        }

        @Override
        public LinkedDiGraphNode<N, E> getDestination() {
            return this.destNode;
        }

        @Override
        public E getValue() {
            return this.value;
        }

        @Override
        public <A extends Annotation> A getAnnotation() {
            throw new UnsupportedOperationException("Graph initialized with edge annotations turned off");
        }

        @Override
        public void setAnnotation(Annotation data) {
            throw new UnsupportedOperationException("Graph initialized with edge annotations turned off");
        }

        @Override
        public String getColor() {
            return "black";
        }

        @Override
        public String getLabel() {
            return String.valueOf(this.value);
        }

        @Override
        public String getNode1Id() {
            return this.sourceNode.getId();
        }

        @Override
        public String getNode2Id() {
            return this.destNode.getId();
        }

        public String toString() {
            return this.sourceNode + " -> " + this.destNode;
        }

        @Override
        public GraphNode<N, E> getNodeA() {
            return this.sourceNode;
        }

        @Override
        public GraphNode<N, E> getNodeB() {
            return this.destNode;
        }
    }

    static final class AnnotatedLinkedDiGraphNode<N, E>
    extends LinkedDiGraphNode<N, E> {
        Annotation annotation;

        private AnnotatedLinkedDiGraphNode(N nodeValue) {
            super(nodeValue);
        }

        @Override
        public <A extends Annotation> A getAnnotation() {
            return (A)this.annotation;
        }

        @Override
        public void setAnnotation(Annotation data) {
            this.annotation = data;
        }

        @Override
        public String getLabel() {
            Object result = this.toString();
            if (this.annotation != null) {
                result = (String)result + "\n" + this.annotation;
            }
            return result;
        }
    }

    public static class LinkedDiGraphNode<N, E>
    implements DiGraph.DiGraphNode<N, E>,
    GraphvizGraph.GraphvizNode {
        private final List<LinkedDiGraphEdge<N, E>> inEdgeList = new ArrayList<LinkedDiGraphEdge<N, E>>(1);
        private final List<LinkedDiGraphEdge<N, E>> outEdgeList = new ArrayList<LinkedDiGraphEdge<N, E>>(1);
        protected final N value;
        private int priority = -1;

        private LinkedDiGraphNode(N nodeValue) {
            this.value = nodeValue;
        }

        @Override
        public N getValue() {
            return this.value;
        }

        @Override
        public <A extends Annotation> A getAnnotation() {
            throw new UnsupportedOperationException("Graph initialized with node annotations turned off");
        }

        @Override
        public void setAnnotation(Annotation data) {
            throw new UnsupportedOperationException("Graph initialized with node annotations turned off");
        }

        @Override
        public String getColor() {
            return "white";
        }

        @Override
        public String getId() {
            return "LDN" + this.hashCode();
        }

        @Override
        public String getLabel() {
            return this.toString();
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @Override
        public List<LinkedDiGraphEdge<N, E>> getInEdges() {
            return this.inEdgeList;
        }

        @Override
        public List<LinkedDiGraphEdge<N, E>> getOutEdges() {
            return this.outEdgeList;
        }

        @Override
        public boolean hasPriority() {
            return this.priority >= 0;
        }

        @Override
        public int getPriority() {
            Preconditions.checkState((this.priority >= 0 ? 1 : 0) != 0, (Object)"priority not set");
            return this.priority;
        }

        @Override
        public void setPriority(int priority) {
            Preconditions.checkArgument((priority >= 0 ? 1 : 0) != 0, (Object)"priorities must be non-negative");
            this.priority = priority;
        }
    }
}

