/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultimap;
import com.google.common.collect.TreeMultiset;
import com.google.javascript.jscomp.BasicErrorManager;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.GatherModuleMetadata;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.modules.ModuleMetadataMap;
import com.google.javascript.jscomp.parsing.Config;
import com.google.javascript.jscomp.parsing.ParserRunner;
import com.google.javascript.jscomp.parsing.parser.trees.Comment;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class JsFileFullParser {
    private JsFileFullParser() {
    }

    public static FileInfo parse(String code, String filename, Reporter reporter) {
        final DelegatingReporter errorReporter = new DelegatingReporter(reporter);
        Compiler compiler = new Compiler(new BasicErrorManager(){

            @Override
            public void println(CheckLevel level, JSError error) {
                if (level == CheckLevel.ERROR) {
                    errorReporter.error(error.getDescription(), error.getSourceName(), error.getLineNumber(), error.getCharno());
                } else if (level == CheckLevel.WARNING) {
                    errorReporter.warning(error.getDescription(), error.getSourceName(), error.getLineNumber(), error.getCharno());
                }
            }

            @Override
            protected void printSummary() {
            }
        });
        SourceFile source = SourceFile.fromCode(filename, code);
        CompilerOptions options = new CompilerOptions();
        options.setChecksOnly(true);
        compiler.init((List<SourceFile>)ImmutableList.of(), (List<SourceFile>)ImmutableList.of((Object)source), options);
        Config config = ParserRunner.createConfig(Config.LanguageMode.ES_NEXT, Config.JsDocParsing.INCLUDE_DESCRIPTIONS_NO_WHITESPACE, Config.RunMode.STOP_AFTER_ERROR, (Set<String>)ImmutableSet.of(), true, Config.StrictMode.SLOPPY);
        FileInfo info = new FileInfo();
        ParserRunner.ParseResult parsed = ParserRunner.parse(source, code, config, errorReporter);
        if (errorReporter.seenError) {
            return info;
        }
        parsed.ast.setInputId(new InputId(filename));
        String version = parsed.features.version();
        if (!version.equals("es3")) {
            info.loadFlags.put((Object)"lang", (Object)version);
        }
        for (Comment comment : parsed.comments) {
            if (comment.type != Comment.Type.JSDOC) continue;
            JsFileFullParser.parseComment(comment, info);
        }
        GatherModuleMetadata gatherModuleMetadata = new GatherModuleMetadata(compiler, false, ModuleLoader.ResolutionMode.BROWSER);
        gatherModuleMetadata.process(new Node(Token.ROOT), parsed.ast);
        compiler.generateReport();
        if (compiler.getModuleMetadataMap().getModulesByPath().size() != 1) {
            return info;
        }
        ModuleMetadataMap.ModuleMetadata module = (ModuleMetadataMap.ModuleMetadata)Iterables.getOnlyElement((Iterable)compiler.getModuleMetadataMap().getModulesByPath().values());
        if (module.isEs6Module()) {
            info.loadFlags.put((Object)"module", (Object)"es6");
        } else if (module.isGoogModule()) {
            info.loadFlags.put((Object)"module", (Object)"goog");
        }
        switch (module.moduleType()) {
            case GOOG_PROVIDE: {
                info.moduleType = FileInfo.ModuleType.GOOG_PROVIDE;
                break;
            }
            case GOOG_MODULE: {
                info.moduleType = FileInfo.ModuleType.GOOG_MODULE;
                break;
            }
            case LEGACY_GOOG_MODULE: {
                info.moduleType = FileInfo.ModuleType.GOOG_MODULE;
                info.isLegacyNamespace = true;
                break;
            }
            case ES6_MODULE: {
                info.moduleType = FileInfo.ModuleType.ES_MODULE;
                break;
            }
            case COMMON_JS: 
            case SCRIPT: {
                info.moduleType = FileInfo.ModuleType.UNKNOWN;
            }
        }
        info.goog = module.usesClosure();
        JsFileFullParser.recordModuleMetadata(info, module);
        return info;
    }

    private static void recordModuleMetadata(FileInfo info, ModuleMetadataMap.ModuleMetadata module) {
        info.importedModules.addAll((Collection<String>)module.es6ImportSpecifiers().elementSet());
        if (module.usesClosure()) {
            info.provides.addAll(module.googNamespaces());
            info.requires.addAll(module.stronglyRequiredGoogNamespaces());
            info.maybeRequires.addAll(module.maybeRequiredGoogNamespaces());
            info.dynamicRequires.addAll((Collection<String>)module.dynamicallyRequiredGoogNamespaces().elementSet());
            info.readToggles.addAll((Collection<String>)module.readToggles().elementSet());
            info.typeRequires.addAll(module.weaklyRequiredGoogNamespaces());
            info.testonly = module.isTestOnly();
        }
        for (ModuleMetadataMap.ModuleMetadata nested : module.nestedModules()) {
            JsFileFullParser.recordModuleMetadata(info, nested);
        }
    }

    private static void parseComment(Comment comment, FileInfo info) {
        boolean fileOverview = comment.value.contains("@fileoverview");
        block34: for (CommentAnnotation annotation : CommentAnnotation.parse(comment.value)) {
            switch (annotation.name) {
                case "@fileoverview": 
                case "@author": 
                case "@see": 
                case "@link": {
                    continue block34;
                }
                case "@mods": {
                    if (annotation.value.isEmpty()) continue block34;
                    info.mods.add(annotation.value);
                    continue block34;
                }
                case "@visibility": {
                    if (annotation.value.isEmpty()) continue block34;
                    info.visibility.add((Object)annotation.value);
                    continue block34;
                }
                case "@modName": {
                    if (annotation.value.isEmpty()) continue block34;
                    info.modName.add(annotation.value);
                    continue block34;
                }
                case "@config": {
                    info.isConfig = true;
                    continue block34;
                }
                case "@provideGoog": {
                    info.provideGoog = true;
                    continue block34;
                }
                case "@requirecss": {
                    if (annotation.value.isEmpty()) continue block34;
                    info.requiresCss.add((Object)annotation.value);
                    continue block34;
                }
                case "@deltemplate": 
                case "@hassoydeltemplate": {
                    if (annotation.value.isEmpty()) continue block34;
                    info.deltemplates.add(annotation.value);
                    continue block34;
                }
                case "@delcall": 
                case "@hassoydelcall": {
                    if (annotation.value.isEmpty()) continue block34;
                    info.delcalls.add(annotation.value);
                    continue block34;
                }
                case "@externs": {
                    info.isExterns = true;
                    continue block34;
                }
                case "@enhanceable": 
                case "@pintomodule": {
                    info.customAnnotations.put((Object)annotation.name.substring(1), (Object)annotation.value);
                    continue block34;
                }
                case "@enhance": {
                    if (annotation.value.isEmpty()) continue block34;
                    info.customAnnotations.put((Object)annotation.name.substring(1), (Object)annotation.value);
                    continue block34;
                }
            }
            if (!fileOverview) continue;
            info.customAnnotations.put((Object)annotation.name.substring(1), (Object)annotation.value);
        }
    }

    private static final class DelegatingReporter
    implements ErrorReporter {
        final Reporter delegate;
        private boolean seenError = false;

        DelegatingReporter(Reporter delegate) {
            this.delegate = (Reporter)Preconditions.checkNotNull((Object)delegate);
        }

        @Override
        public void warning(String message, String sourceName, int line, int lineOffset) {
            this.delegate.report(false, message, sourceName, line, lineOffset);
        }

        @Override
        public void error(String message, String sourceName, int line, int lineOffset) {
            this.seenError = true;
            this.delegate.report(true, message, sourceName, line, lineOffset);
        }
    }

    public static interface Reporter {
        public void report(boolean var1, String var2, String var3, int var4, int var5);
    }

    private static class CommentAnnotation {
        final String name;
        final String value;
        private static final Pattern ANNOTATION_RE = Pattern.compile((String)"(?:[^a-zA-Z0-9_$]|^)(@[a-zA-Z]+)(?:\\s*\\{\\s*([^}\\t\\n\\v\\f\\r ]+)\\s*\\})?");
        private static final int ANNOTATION_NAME_GROUP = 1;
        private static final int ANNOTATION_VALUE_GROUP = 2;

        CommentAnnotation(String name, String value) {
            this.name = name;
            this.value = value;
        }

        static List<CommentAnnotation> parse(String comment) {
            ArrayList<CommentAnnotation> out = new ArrayList<CommentAnnotation>();
            Matcher matcher = ANNOTATION_RE.matcher((CharSequence)comment);
            while (matcher.find()) {
                String name = matcher.group(1);
                String value = Strings.nullToEmpty((String)matcher.group(2));
                out.add(new CommentAnnotation(name, value));
            }
            return out;
        }
    }

    public static final class FileInfo {
        public boolean goog = false;
        public boolean isConfig = false;
        public boolean isExterns = false;
        public boolean provideGoog = false;
        public boolean testonly = false;
        public ModuleType moduleType = ModuleType.UNKNOWN;
        public boolean isLegacyNamespace = false;
        public final Set<String> delcalls = new TreeSet<String>();
        public final Set<String> deltemplates = new TreeSet<String>();
        public final Set<String> importedModules = new LinkedHashSet<String>();
        public final Set<String> dynamicRequires = new LinkedHashSet<String>();
        public final Set<String> readToggles = new LinkedHashSet<String>();
        public final List<String> modName = new ArrayList<String>();
        public final List<String> mods = new ArrayList<String>();
        public final Multiset<String> provides = TreeMultiset.create();
        public final Multiset<String> requires = TreeMultiset.create();
        public final Multiset<String> typeRequires = TreeMultiset.create();
        public final Multiset<String> maybeRequires = TreeMultiset.create();
        public final Multiset<String> requiresCss = TreeMultiset.create();
        public final Multiset<String> visibility = TreeMultiset.create();
        public final Multimap<String, String> customAnnotations = TreeMultimap.create();
        public final Multimap<String, String> loadFlags = TreeMultimap.create();

        public static enum ModuleType {
            UNKNOWN,
            GOOG_PROVIDE,
            GOOG_MODULE,
            ES_MODULE;

        }
    }
}

