/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.CodeConsumer;
import com.google.javascript.jscomp.CodeGenerator;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSDocInfoPrinter;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jspecify.nullness.Nullable;

class TypedCodeGenerator
extends CodeGenerator {
    private final JSTypeRegistry registry;
    private final JSDocInfoPrinter jsDocInfoPrinter;

    TypedCodeGenerator(CodeConsumer consumer, CompilerOptions options, JSTypeRegistry registry) {
        super(consumer, options);
        Preconditions.checkNotNull((Object)registry);
        this.registry = registry;
        this.jsDocInfoPrinter = new JSDocInfoPrinter(options.getUseOriginalNamesInOutput());
    }

    @Override
    protected void add(Node n, CodeGenerator.Context context) {
        this.maybeAddTypeAnnotation(n);
        super.add(n, context);
    }

    private void maybeAddTypeAnnotation(Node n) {
        Node parent = n.getParent();
        if (parent == null) {
            return;
        }
        if (parent.isBlock() || parent.isScript() || parent.isClassMembers()) {
            if (n.isClass() || n.isFunction() || n.isMemberFunctionDef()) {
                this.add(this.getTypeAnnotation(n));
            } else if (n.isExprResult() && n.getFirstChild().isAssign()) {
                Node assign = n.getFirstChild();
                if (NodeUtil.isNamespaceDecl(assign.getFirstChild())) {
                    this.add(this.jsDocInfoPrinter.print(assign.getJSDocInfo()));
                } else {
                    Node rhs = assign.getLastChild();
                    this.add(this.getTypeAnnotation(rhs));
                }
            } else if (NodeUtil.isNameDeclaration(n) && n.getFirstFirstChild() != null) {
                if (NodeUtil.isNamespaceDecl(n.getFirstChild()) && n.getJSDocInfo() != null) {
                    this.add(this.jsDocInfoPrinter.print(n.getJSDocInfo()));
                } else {
                    this.add(this.getTypeAnnotation(n.getFirstFirstChild()));
                }
            }
        }
    }

    private String getTypeAnnotation(Node node) {
        boolean nodeOriginallyHadJSDoc;
        if (node.isMemberFunctionDef()) {
            return this.getMemberFunctionAnnotation(node.getOnlyChild());
        }
        if (node.isClass()) {
            return this.getClassAnnotation(node.getJSType());
        }
        if (node.isFunction()) {
            return this.getFunctionAnnotation(node);
        }
        boolean bl = nodeOriginallyHadJSDoc = NodeUtil.getBestJSDocInfo(node) != null;
        if (!nodeOriginallyHadJSDoc) {
            return "";
        }
        JSType type = node.getJSType();
        if (type == null) {
            return "";
        }
        if (type.isFunctionType()) {
            return this.getFunctionAnnotation(node);
        }
        if (type.isEnumType()) {
            return "/** @enum {" + type.toMaybeObjectType().getEnumeratedTypeOfEnumObject().toAnnotationString(JSType.Nullability.EXPLICIT) + "} */\n";
        }
        if (!(type.isUnknownType() || type.isEmptyType() || type.isVoidType() || type.isFunctionPrototypeType())) {
            return "/** @type {" + node.getJSType().toAnnotationString(JSType.Nullability.EXPLICIT) + "} */\n";
        }
        return "";
    }

    private String getFunctionAnnotation(Node fnNode) {
        JSType type = fnNode.getJSType();
        Preconditions.checkState((fnNode.isFunction() || type.isFunctionType() ? 1 : 0) != 0);
        if (type == null || type.isUnknownType()) {
            return "";
        }
        FunctionType funType = type.toMaybeFunctionType();
        if (type.equals(this.registry.getNativeType(JSTypeNative.FUNCTION_TYPE))) {
            return "/** @type {!Function} */\n";
        }
        StringBuilder sb = new StringBuilder("/**\n");
        Node paramNode = null;
        if (fnNode != null && fnNode.isFunction()) {
            paramNode = NodeUtil.getFunctionParameters(fnNode).getFirstChild();
        }
        this.appendFunctionParamAnnotations(sb, funType, paramNode);
        JSType retType = funType.getReturnType();
        if (!(retType == null || retType.isEmptyType() || funType.isInterface() || funType.isConstructor() && retType.isVoidType())) {
            sb.append(" * ");
            TypedCodeGenerator.appendAnnotation(sb, "return", retType.toAnnotationString(JSType.Nullability.EXPLICIT));
            sb.append("\n");
        }
        if (funType.isConstructor()) {
            this.appendClassAnnotations(sb, funType);
            sb.append(" * @constructor\n");
        } else if (funType.isInterface()) {
            this.appendInterfaceAnnotations(sb, funType);
        } else {
            JSType thisType = funType.getTypeOfThis();
            if (!(thisType == null || thisType.isUnknownType() || thisType.isVoidType() || fnNode != null && thisType.equals(this.findMethodOwner(fnNode)))) {
                sb.append(" * ");
                TypedCodeGenerator.appendAnnotation(sb, "this", thisType.toAnnotationString(JSType.Nullability.EXPLICIT));
                sb.append("\n");
            }
        }
        this.appendTemplateAnnotations(sb, (Collection<? extends JSType>)funType.getTypeParameters());
        sb.append(" */\n");
        return sb.toString();
    }

    private String getMemberFunctionAnnotation(Node fnNode) {
        Preconditions.checkState((fnNode.isFunction() && fnNode.getParent().isMemberFunctionDef() ? 1 : 0) != 0, (Object)fnNode);
        JSType type = fnNode.getJSType();
        if (type == null || type.isUnknownType()) {
            return "";
        }
        FunctionType funType = type.toMaybeFunctionType();
        StringBuilder sb = new StringBuilder("/**\n");
        Node paramNode = NodeUtil.getFunctionParameters(fnNode).getFirstChild();
        this.appendFunctionParamAnnotations(sb, funType, paramNode);
        if (NodeUtil.isEs6Constructor(fnNode)) {
            this.appendTemplateAnnotations(sb, (Collection<? extends JSType>)funType.getConstructorOnlyTemplateParameters());
        } else {
            this.appendTemplateAnnotations(sb, (Collection<? extends JSType>)funType.getTypeParameters());
            JSType retType = funType.getReturnType();
            if (retType != null && !retType.isEmptyType()) {
                sb.append(" * ");
                TypedCodeGenerator.appendAnnotation(sb, "return", retType.toAnnotationString(JSType.Nullability.EXPLICIT));
                sb.append("\n");
            }
        }
        sb.append(" */\n");
        return sb.toString();
    }

    private void appendFunctionParamAnnotations(StringBuilder sb, FunctionType funType, Node paramNode) {
        int minArity = funType.getMinArity();
        int maxArity = funType.getMaxArity();
        ImmutableList<FunctionType.Parameter> formals = funType.getParameters();
        for (int i = 0; i < formals.size(); ++i) {
            sb.append(" * ");
            TypedCodeGenerator.appendAnnotation(sb, "param", this.getParameterJSDocType((List<FunctionType.Parameter>)formals, i, minArity, maxArity));
            String parameterName = this.getParameterJSDocName(paramNode, i);
            sb.append(" ").append(parameterName).append("\n");
            if (paramNode == null) continue;
            paramNode = paramNode.getNext();
        }
    }

    private String getClassAnnotation(JSType classType) {
        if (classType == null || classType.isUnknownType()) {
            return "";
        }
        Preconditions.checkState((boolean)classType.isFunctionType(), (Object)classType);
        FunctionType funType = classType.toMaybeFunctionType();
        StringBuilder sb = new StringBuilder();
        if (funType.isInterface()) {
            this.appendInterfaceAnnotations(sb, funType);
        } else {
            Preconditions.checkState((boolean)funType.isConstructor(), (Object)funType);
            this.appendClassAnnotations(sb, funType);
        }
        this.appendTemplateAnnotations(sb, (Collection<? extends JSType>)funType.getTypeParameters());
        String jsdocContent = sb.toString();
        if (jsdocContent.isEmpty()) {
            return jsdocContent;
        }
        return "/**\n" + jsdocContent + " */\n";
    }

    private void appendTemplateAnnotations(StringBuilder sb, Collection<? extends JSType> typeParams) {
        if (!typeParams.isEmpty()) {
            sb.append(" * @template ");
            sb.append(typeParams.stream().map(this::formatTypeVar).collect(Collectors.joining(",")));
            sb.append("\n");
        }
    }

    private String getParameterJSDocName(Node paramNode, int paramIndex) {
        Node nameNode = null;
        if (paramNode != null) {
            Preconditions.checkArgument((boolean)paramNode.getParent().isParamList(), (Object)paramNode);
            if (paramNode.isRest()) {
                paramNode = paramNode.getOnlyChild();
            } else if (paramNode.isDefaultValue()) {
                paramNode = paramNode.getFirstChild();
            }
            if (paramNode.isName()) {
                nameNode = paramNode;
            } else {
                Preconditions.checkState((paramNode.isObjectPattern() || paramNode.isArrayPattern() ? 1 : 0) != 0, (Object)paramNode);
                nameNode = null;
            }
        }
        if (nameNode == null) {
            return "p" + paramIndex;
        }
        Preconditions.checkState((boolean)nameNode.isName(), (Object)nameNode);
        return nameNode.getString();
    }

    private String formatTypeVar(JSType var) {
        return var.toAnnotationString(JSType.Nullability.IMPLICIT);
    }

    private void appendClassAnnotations(StringBuilder sb, FunctionType funType) {
        ObjectType superInstance;
        FunctionType superConstructor = funType.getInstanceType().getSuperClassConstructor();
        if (superConstructor != null && !(superInstance = superConstructor.getInstanceType()).toString().equals("Object")) {
            sb.append(" * ");
            TypedCodeGenerator.appendAnnotation(sb, "extends", superInstance.toAnnotationString(JSType.Nullability.IMPLICIT));
            sb.append("\n");
        }
        TreeSet<String> interfaces = new TreeSet<String>();
        for (ObjectType objectType : funType.getAncestorInterfaces()) {
            interfaces.add(objectType.toAnnotationString(JSType.Nullability.IMPLICIT));
        }
        for (String string : interfaces) {
            sb.append(" * ");
            TypedCodeGenerator.appendAnnotation(sb, "implements", string);
            sb.append("\n");
        }
    }

    private void appendInterfaceAnnotations(StringBuilder sb, FunctionType funType) {
        TreeSet<String> interfaces = new TreeSet<String>();
        for (ObjectType interfaceType : funType.getAncestorInterfaces()) {
            interfaces.add(interfaceType.toAnnotationString(JSType.Nullability.IMPLICIT));
        }
        for (String interfaze : interfaces) {
            sb.append(" * ");
            TypedCodeGenerator.appendAnnotation(sb, "extends", interfaze);
            sb.append("\n");
        }
        if (funType.isStructuralInterface()) {
            sb.append(" * @record\n");
        } else {
            sb.append(" * @interface\n");
        }
    }

    private @Nullable ObjectType findMethodOwner(Node n) {
        if (n == null) {
            return null;
        }
        Node parent = n.getParent();
        FunctionType ctor = null;
        if (parent.isAssign()) {
            Node target = parent.getFirstChild();
            if (NodeUtil.isPrototypeProperty(target)) {
                JSType type = this.registry.getGlobalType(target.getFirstFirstChild().getQualifiedName());
                ctor = type != null ? ((ObjectType)type).getConstructor() : null;
            }
        } else if (parent.isClass()) {
            ctor = parent.getJSType().toMaybeFunctionType();
        }
        return ctor != null ? ctor.getInstanceType() : null;
    }

    private static void appendAnnotation(StringBuilder sb, String name, String type) {
        sb.append("@").append(name).append(" {").append(type).append("}");
    }

    private String getParameterJSDocType(List<FunctionType.Parameter> parameters, int index, int minArgs, int maxArgs) {
        boolean isRestArgument;
        JSType type = parameters.get(index).getJSType();
        if (index < minArgs) {
            return type.toAnnotationString(JSType.Nullability.EXPLICIT);
        }
        boolean bl = isRestArgument = maxArgs == Integer.MAX_VALUE && index == parameters.size() - 1;
        if (isRestArgument) {
            return "..." + this.restrictByUndefined(type).toAnnotationString(JSType.Nullability.EXPLICIT);
        }
        return this.restrictByUndefined(type).toAnnotationString(JSType.Nullability.EXPLICIT) + "=";
    }

    private JSType restrictByUndefined(JSType type) {
        if (!type.isVoidable()) {
            return type;
        }
        JSType restricted = type.restrictByNotNullOrUndefined();
        if (type.isNullable()) {
            JSType nullType = this.registry.getNativeType(JSTypeNative.NULL_TYPE);
            return this.registry.createUnionType((List<? extends JSType>)ImmutableList.of((Object)restricted, (Object)nullType));
        }
        return restricted.isEmptyType() ? type : restricted;
    }
}

