/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import org.jspecify.nullness.Nullable;

public final class SourceInformationAnnotator
extends NodeTraversal.AbstractPostOrderCallback {
    private final @Nullable String sourceFileToCheck;

    private SourceInformationAnnotator(@Nullable String sourceFileToCheck) {
        this.sourceFileToCheck = sourceFileToCheck;
    }

    static SourceInformationAnnotator create() {
        return new SourceInformationAnnotator(null);
    }

    static SourceInformationAnnotator createWithAnnotationChecks(String sourceFile) {
        return new SourceInformationAnnotator(sourceFile);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        String functionName;
        if (this.sourceFileToCheck != null) {
            Preconditions.checkState((boolean)this.sourceFileToCheck.equals(n.getSourceFileName()));
        }
        if (SourceInformationAnnotator.isStringNodeRequiringOriginalName(n)) {
            SourceInformationAnnotator.setOriginalName(n, n);
            return;
        }
        if (n.isFunction() && (functionName = NodeUtil.getNearestFunctionName(n)) != null) {
            SourceInformationAnnotator.setOriginalName(n, functionName);
        }
    }

    public static boolean isStringNodeRequiringOriginalName(Node node) {
        switch (node.getToken()) {
            case GETPROP: 
            case OPTCHAIN_GETPROP: 
            case NAME: {
                return true;
            }
            case MEMBER_FUNCTION_DEF: 
            case GETTER_DEF: 
            case SETTER_DEF: 
            case STRING_KEY: {
                return node.getParent().isObjectLit() && !node.isQuotedStringKey();
            }
        }
        return false;
    }

    private static void setOriginalName(Node n, String name) {
        if (!name.isEmpty() && n.getOriginalName() == null) {
            n.setOriginalName(name);
        }
    }

    private static void setOriginalName(Node n, Node name) {
        if (!name.getString().isEmpty() && n.getOriginalName() == null) {
            n.setOriginalNameFromName(name);
        }
    }
}

