/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.CharStreams;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.InlineMe;
import com.google.javascript.jscomp.JSCompZipFileCache;
import com.google.javascript.jscomp.Platform;
import com.google.javascript.jscomp.Region;
import com.google.javascript.jscomp.SimpleRegion;
import com.google.javascript.jscomp.serialization.SourceFileProto;
import com.google.javascript.rhino.StaticSourceFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jspecify.nullness.Nullable;

public final class SourceFile
implements StaticSourceFile {
    private static final String UTF8_BOM = "\ufeff";
    private static final String BANG_SLASH = "!" + Platform.getFileSeperator();
    private static final int SOURCE_EXCERPT_REGION_LENGTH = 5;
    private final String fileName;
    private StaticSourceFile.SourceKind kind;
    private final CodeLoader loader;
    private int @Nullable [] lineOffsets = null;
    private volatile @Nullable String code = null;
    private int numLines = -1;
    private int numBytes = -1;

    private SourceFile(CodeLoader loader, String fileName, StaticSourceFile.SourceKind kind) {
        if (Strings.isNullOrEmpty((String)fileName)) {
            throw new IllegalArgumentException("a source must have a name");
        }
        if (!"/".equals(Platform.getFileSeperator())) {
            fileName = fileName.replace(Platform.getFileSeperator(), "/");
        }
        this.loader = loader;
        this.fileName = fileName;
        this.kind = kind;
    }

    @Override
    public int getLineOffset(int lineno) {
        this.findLineOffsets();
        if (lineno < 1 || lineno > this.lineOffsets.length) {
            throw new IllegalArgumentException("Expected line number between 1 and " + this.lineOffsets.length + "\nActual: " + lineno);
        }
        return this.lineOffsets[lineno - 1];
    }

    int getNumLines() {
        if (this.numLines < 0) {
            try {
                String string = this.getCode();
            }
            catch (IOException e) {
                return 0;
            }
        }
        return this.numLines;
    }

    int getNumBytes() {
        if (this.numBytes < 0) {
            try {
                String string = this.getCode();
            }
            catch (IOException e) {
                return 0;
            }
        }
        return this.numBytes;
    }

    private void findLineOffsets() {
        if (this.lineOffsets != null) {
            return;
        }
        String localCode = this.code;
        if (localCode == null) {
            try {
                localCode = this.getCode();
            }
            catch (IOException e) {
                localCode = "";
                this.lineOffsets = new int[1];
                return;
            }
        }
        int[] offsets = new int[this.numLines];
        int index = 1;
        int offset = 0;
        while ((offset = localCode.indexOf(10, offset)) != -1) {
            offsets[index++] = ++offset;
        }
        Preconditions.checkState((index == offsets.length ? 1 : 0) != 0);
        this.lineOffsets = offsets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getCode() throws IOException {
        if (this.code == null) {
            SourceFile sourceFile = this;
            synchronized (sourceFile) {
                if (this.code == null) {
                    this.setCodeAndDoBookkeeping(this.loader.loadUncachedCode());
                }
            }
        }
        return this.code;
    }

    @Deprecated
    final void setCodeDeprecated(String code) {
        this.setCodeAndDoBookkeeping(code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GwtIncompatible(value="java.io.Reader")
    public Reader getCodeReader() throws IOException {
        if (this.code == null) {
            SourceFile sourceFile = this;
            synchronized (sourceFile) {
                Reader uncachedReader;
                if (this.code == null && (uncachedReader = this.loader.openUncachedReader()) != null) {
                    return uncachedReader;
                }
            }
        }
        return new StringReader(this.getCode());
    }

    private void setCodeAndDoBookkeeping(@Nullable String sourceCode) {
        this.code = null;
        this.lineOffsets = null;
        if (sourceCode != null) {
            if (sourceCode.startsWith(UTF8_BOM)) {
                sourceCode = sourceCode.substring(UTF8_BOM.length());
            }
            this.code = sourceCode;
            this.numBytes = sourceCode.length();
            int numLines = 1;
            int index = 0;
            while ((index = sourceCode.indexOf(10, index)) != -1) {
                ++index;
                ++numLines;
            }
            this.numLines = numLines;
        }
    }

    @Deprecated
    @InlineMe(replacement="this.getName()")
    public String getOriginalPath() {
        return this.getName();
    }

    public void clearCachedSource() {
        this.setCodeAndDoBookkeeping(null);
    }

    boolean hasSourceInMemory() {
        return this.code != null;
    }

    @Override
    public String getName() {
        return this.fileName;
    }

    @Override
    public StaticSourceFile.SourceKind getKind() {
        return this.kind;
    }

    public void setKind(StaticSourceFile.SourceKind kind) {
        this.kind = kind;
    }

    @Override
    public int getLineOfOffset(int offset) {
        this.findLineOffsets();
        int search = Arrays.binarySearch(this.lineOffsets, offset);
        if (search >= 0) {
            return search + 1;
        }
        int insertionPoint = -1 * (search + 1);
        return Math.min(insertionPoint - 1, this.lineOffsets.length - 1) + 1;
    }

    @Override
    public int getColumnOfOffset(int offset) {
        int line = this.getLineOfOffset(offset);
        return offset - this.lineOffsets[line - 1];
    }

    public @Nullable String getLine(int lineNumber) {
        int pos;
        String js;
        try {
            js = this.getCode();
        }
        catch (IOException e) {
            return null;
        }
        this.findLineOffsets();
        if (lineNumber > this.lineOffsets.length) {
            return null;
        }
        if (lineNumber < 1) {
            lineNumber = 1;
        }
        if (js.indexOf(10, pos = this.lineOffsets[lineNumber - 1]) == -1) {
            if (pos >= js.length()) {
                return null;
            }
            return js.substring(pos);
        }
        return js.substring(pos, js.indexOf(10, pos));
    }

    public @Nullable Region getLines(int lineNumber, int length) {
        int endLine;
        int pos;
        String js;
        try {
            js = this.getCode();
        }
        catch (IOException e) {
            return null;
        }
        this.findLineOffsets();
        if (lineNumber > this.lineOffsets.length) {
            return null;
        }
        if (lineNumber < 1) {
            lineNumber = 1;
        }
        if (length <= 0) {
            length = 1;
        }
        if ((pos = this.lineOffsets[lineNumber - 1]) == js.length()) {
            return new SimpleRegion(lineNumber, lineNumber, "");
        }
        int endChar = pos;
        for (endLine = lineNumber; endChar < pos + length && endLine <= this.lineOffsets.length; ++endLine) {
            endChar = endLine < this.lineOffsets.length ? this.lineOffsets[endLine] : js.length();
        }
        if (js.charAt(endChar - 1) == '\n') {
            return new SimpleRegion(lineNumber, endLine, js.substring(pos, endChar - 1));
        }
        return new SimpleRegion(lineNumber, endLine, js.substring(pos, endChar));
    }

    public @Nullable Region getRegion(int lineNumber) {
        int nextpos;
        String js = "";
        try {
            js = this.getCode();
        }
        catch (IOException e) {
            return null;
        }
        int pos = 0;
        int startLine = Math.max(1, lineNumber - 3 + 1);
        for (int n = 1; n < startLine && (nextpos = js.indexOf(10, pos)) != -1; ++n) {
            pos = nextpos + 1;
        }
        int end = pos;
        int endLine = startLine;
        int n = 0;
        while (n < 5 && (end = js.indexOf(10, end)) != -1) {
            ++end;
            ++n;
            ++endLine;
        }
        if (lineNumber >= endLine) {
            return null;
        }
        if (end == -1) {
            int last = js.length() - 1;
            if (js.charAt(last) == '\n') {
                return new SimpleRegion(startLine, endLine, js.substring(pos, last));
            }
            return new SimpleRegion(startLine, endLine, js.substring(pos));
        }
        return new SimpleRegion(startLine, endLine, js.substring(pos, end));
    }

    public String toString() {
        return this.fileName;
    }

    @GwtIncompatible(value="fromZipInput")
    public static List<SourceFile> fromZipFile(String zipName, Charset inputCharset) throws IOException {
        try (FileInputStream input = new FileInputStream(zipName);){
            List<SourceFile> list = SourceFile.fromZipInput(zipName, input, inputCharset);
            return list;
        }
    }

    @GwtIncompatible(value="java.util.zip.ZipInputStream")
    public static List<SourceFile> fromZipInput(String zipName, InputStream input, Charset inputCharset) throws IOException {
        String absoluteZipPath = new File(zipName).getAbsolutePath();
        ArrayList<SourceFile> sourceFiles = new ArrayList<SourceFile>();
        try (ZipInputStream in = new ZipInputStream(input, inputCharset);){
            ZipEntry zipEntry;
            while ((zipEntry = in.getNextEntry()) != null) {
                String entryName = zipEntry.getName();
                if (!entryName.endsWith(".js")) continue;
                sourceFiles.add(SourceFile.builder().withCharset(inputCharset).withOriginalPath(zipName + BANG_SLASH + entryName).withZipEntryPath(absoluteZipPath, entryName).build());
            }
        }
        return sourceFiles;
    }

    @GwtIncompatible(value="java.io.File")
    public static SourceFile fromFile(String fileName, Charset charset) {
        return SourceFile.builder().withPath(fileName).withCharset(charset).build();
    }

    @GwtIncompatible(value="java.io.File")
    public static SourceFile fromFile(String fileName) {
        return SourceFile.builder().withPath(fileName).build();
    }

    @GwtIncompatible(value="java.io.File")
    public static SourceFile fromPath(Path path, Charset charset) {
        return SourceFile.builder().withPath(path).withCharset(charset).build();
    }

    public static SourceFile fromCode(String fileName, String code, StaticSourceFile.SourceKind kind) {
        return SourceFile.builder().withPath(fileName).withKind(kind).withContent(code).build();
    }

    public static SourceFile fromCode(String fileName, String code) {
        return SourceFile.builder().withPath(fileName).withContent(code).build();
    }

    public void restoreCachedStateFrom(SourceFileProto protoSourceFile) {
        Preconditions.checkState((boolean)protoSourceFile.getFilename().equals(this.getName()), (String)"Cannot restore state for %s from %s", (Object)this.getName(), (Object)protoSourceFile.getFilename());
        if (protoSourceFile.getSourceKind() == SourceFileProto.SourceKind.EXTERN) {
            Preconditions.checkState((this.getKind() == StaticSourceFile.SourceKind.EXTERN ? 1 : 0) != 0, (String)"TypedAST compilations must pass all extern files as externs, not js, but found %s", (Object)this.getName());
        }
        int protoNumLines = protoSourceFile.getNumLinesPlusOne() - 1;
        int protoNumBytes = protoSourceFile.getNumBytesPlusOne() - 1;
        this.numLines = protoNumLines != -1 ? protoNumLines : this.numLines;
        this.numBytes = protoNumBytes != -1 ? protoNumBytes : this.numBytes;
    }

    @GwtIncompatible(value="java.io.Reader")
    public static SourceFile fromProto(SourceFileProto protoSourceFile) {
        StaticSourceFile.SourceKind sourceKind = SourceFile.getSourceKindFromProto(protoSourceFile);
        SourceFile sourceFile = SourceFile.fromProto(protoSourceFile, sourceKind);
        sourceFile.numLines = protoSourceFile.getNumLinesPlusOne() - 1;
        sourceFile.numBytes = protoSourceFile.getNumBytesPlusOne() - 1;
        return sourceFile;
    }

    private static SourceFile fromProto(SourceFileProto protoSourceFile, StaticSourceFile.SourceKind sourceKind) {
        switch (protoSourceFile.getLoaderCase()) {
            case PRELOADED_CONTENTS: {
                return SourceFile.fromCode(protoSourceFile.getFilename(), protoSourceFile.getPreloadedContents(), sourceKind);
            }
            case FILE_ON_DISK: {
                String pathOnDisk = protoSourceFile.getFileOnDisk().getActualPath().isEmpty() ? protoSourceFile.getFilename() : protoSourceFile.getFileOnDisk().getActualPath();
                return SourceFile.builder().withCharset(SourceFile.toCharset(protoSourceFile.getFileOnDisk().getCharset())).withOriginalPath(protoSourceFile.getFilename()).withKind(sourceKind).withPath(pathOnDisk).build();
            }
            case ZIP_ENTRY: {
                SourceFileProto.ZipEntryOnDisk zipEntry = protoSourceFile.getZipEntry();
                return SourceFile.builder().withKind(sourceKind).withOriginalPath(protoSourceFile.getFilename()).withCharset(SourceFile.toCharset(zipEntry.getCharset())).withZipEntryPath(zipEntry.getZipPath(), zipEntry.getEntryName()).build();
            }
        }
        throw new AssertionError();
    }

    private static StaticSourceFile.SourceKind getSourceKindFromProto(SourceFileProto protoSourceFile) {
        switch (protoSourceFile.getSourceKind()) {
            case EXTERN: {
                return StaticSourceFile.SourceKind.EXTERN;
            }
            case CODE: {
                return StaticSourceFile.SourceKind.STRONG;
            }
        }
        throw new AssertionError();
    }

    private static Charset toCharset(String protoCharset) {
        if (protoCharset.isEmpty()) {
            return StandardCharsets.UTF_8;
        }
        return Charset.forName(protoCharset);
    }

    public static Builder builder() {
        return new Builder();
    }

    public SourceFileProto getProto() {
        return this.loader.toProtoLocationBuilder(this.getName()).setFilename(this.getName()).setSourceKind(SourceFile.sourceKindToProto(this.getKind())).setNumLinesPlusOne(this.numLines + 1).setNumBytesPlusOne(this.numBytes + 1).build();
    }

    private static SourceFileProto.SourceKind sourceKindToProto(StaticSourceFile.SourceKind sourceKind) {
        switch (sourceKind) {
            case EXTERN: {
                return SourceFileProto.SourceKind.EXTERN;
            }
            case STRONG: 
            case WEAK: {
                return SourceFileProto.SourceKind.CODE;
            }
        }
        throw new AssertionError();
    }

    private static abstract class CodeLoader
    implements Serializable {
        private CodeLoader() {
        }

        String loadUncachedCode() throws IOException {
            throw new AssertionError();
        }

        Reader openUncachedReader() throws IOException {
            return null;
        }

        abstract SourceFileProto.Builder toProtoLocationBuilder(String var1);

        static final class AtZip
        extends CodeLoader {
            private static final long serialVersionUID = 1L;
            private final String zipName;
            private final String entryName;
            private final String serializableCharset;

            AtZip(String zipName, String entryName, Charset c) {
                this.zipName = zipName;
                this.entryName = entryName;
                this.serializableCharset = c.name();
            }

            @Override
            @GwtIncompatible
            String loadUncachedCode() throws IOException {
                return CharStreams.toString((Readable)this.openUncachedReader());
            }

            @Override
            @GwtIncompatible
            Reader openUncachedReader() throws IOException {
                return new InputStreamReader(JSCompZipFileCache.getEntryStream(this.zipName, this.entryName), this.getCharset());
            }

            private Charset getCharset() {
                return Charset.forName(this.serializableCharset);
            }

            @Override
            SourceFileProto.Builder toProtoLocationBuilder(String fileName) {
                return SourceFileProto.newBuilder().setFilename(fileName).setZipEntry(SourceFileProto.ZipEntryOnDisk.newBuilder().setEntryName(this.entryName).setZipPath(this.zipName).setCharset(this.getCharset().equals(StandardCharsets.UTF_8) ? "" : this.serializableCharset).build());
            }
        }

        static final class OnDisk
        extends CodeLoader {
            private static final long serialVersionUID = 1L;
            private final String serializableCharset;
            private final Path relativePath;

            OnDisk(Path relativePath, Charset c) {
                this.serializableCharset = c.name();
                this.relativePath = relativePath;
            }

            @Override
            @GwtIncompatible
            String loadUncachedCode() throws IOException {
                try {
                    return Files.readString(this.relativePath, this.getCharset());
                }
                catch (CharacterCodingException e) {
                    throw new IOException("Failed to read: " + this.relativePath + ", is this input UTF-8 encoded?", e);
                }
            }

            @Override
            @GwtIncompatible
            Reader openUncachedReader() throws IOException {
                return Files.newBufferedReader(this.relativePath, this.getCharset());
            }

            private Charset getCharset() {
                return Charset.forName(this.serializableCharset);
            }

            @Override
            SourceFileProto.Builder toProtoLocationBuilder(String fileName) {
                String actualPath = this.relativePath.toString();
                return SourceFileProto.newBuilder().setFileOnDisk(SourceFileProto.FileOnDisk.newBuilder().setActualPath(fileName.equals(actualPath) ? "" : actualPath).setCharset(this.getCharset().equals(StandardCharsets.UTF_8) ? "" : this.serializableCharset));
            }
        }

        static final class Preloaded
        extends CodeLoader {
            private static final long serialVersionUID = 2L;
            private final String preloadedCode;

            Preloaded(String preloadedCode) {
                this.preloadedCode = (String)Preconditions.checkNotNull((Object)preloadedCode);
            }

            @Override
            String loadUncachedCode() {
                return this.preloadedCode;
            }

            @Override
            SourceFileProto.Builder toProtoLocationBuilder(String fileName) {
                return SourceFileProto.newBuilder().setPreloadedContents(this.preloadedCode);
            }
        }
    }

    public static final class Builder {
        private StaticSourceFile.SourceKind kind = StaticSourceFile.SourceKind.STRONG;
        private Charset charset = StandardCharsets.UTF_8;
        private @Nullable String originalPath = null;
        private @Nullable String path = null;
        private @Nullable Path pathWithFilesystem = null;
        private @Nullable String zipEntryPath = null;
        private @Nullable Supplier<String> lazyContent = null;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public Builder withKind(StaticSourceFile.SourceKind kind) {
            this.kind = kind;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withCharset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder withPath(String path) {
            return this.withPathInternal(path, null);
        }

        public Builder withPath(Path path) {
            return this.withPathInternal(path.toString(), path);
        }

        @CanIgnoreReturnValue
        public Builder withContent(String x) {
            this.lazyContent = x::toString;
            return this;
        }

        @CanIgnoreReturnValue
        @GwtIncompatible
        public Builder withContent(InputStream x) {
            this.lazyContent = () -> {
                Preconditions.checkState((this.charset != null ? 1 : 0) != 0);
                try {
                    return CharStreams.toString((Readable)new InputStreamReader(x, this.charset));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            };
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withZipEntryPath(String zipPath, String entryPath) {
            this.path = zipPath;
            this.zipEntryPath = entryPath;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withOriginalPath(String originalPath) {
            this.originalPath = originalPath;
            return this;
        }

        public SourceFile build() {
            String displayPath;
            String string = this.originalPath != null ? this.originalPath : (displayPath = this.zipEntryPath == null ? this.path : this.path + BANG_SLASH + this.zipEntryPath);
            if (this.lazyContent != null) {
                return new SourceFile(new CodeLoader.Preloaded(this.lazyContent.get()), displayPath, this.kind);
            }
            if (this.zipEntryPath != null) {
                return new SourceFile(new CodeLoader.AtZip(this.path, this.zipEntryPath, this.charset), displayPath, this.kind);
            }
            return new SourceFile(new CodeLoader.OnDisk(this.pathWithFilesystem != null ? this.pathWithFilesystem : Paths.get(this.path, new String[0]), this.charset), displayPath, this.kind);
        }

        private Builder withPathInternal(String path, @Nullable Path pathWithFilesystem) {
            int bangSlashIndex = path.indexOf(BANG_SLASH);
            if (bangSlashIndex >= 0) {
                String zipPath = path.substring(0, bangSlashIndex);
                String entryPath = path.substring(bangSlashIndex + BANG_SLASH.length());
                if (zipPath.endsWith(".zip") && (entryPath.endsWith(".js") || entryPath.endsWith(".js.map"))) {
                    return this.withZipEntryPath(zipPath, entryPath);
                }
            }
            this.path = path;
            this.pathWithFilesystem = pathWithFilesystem;
            return this;
        }
    }
}

