/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticScope;

public final class RewriteObjectSpread
implements NodeTraversal.Callback,
CompilerPass {
    private final AbstractCompiler compiler;
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.OBJECT_LITERALS_WITH_SPREAD);
    private final AstFactory astFactory;
    private final StaticScope namespace;

    public RewriteObjectSpread(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
        this.namespace = this.compiler.getTranspilationNamespace();
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, root, transpiledFeatures, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, root, transpiledFeatures);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case OBJECTLIT: {
                this.visitObject(n);
                break;
            }
        }
    }

    private void visitObject(Node obj) {
        for (Node child = obj.getFirstChild(); child != null; child = child.getNext()) {
            if (!child.isSpread()) continue;
            this.visitObjectWithSpread(obj);
            return;
        }
    }

    private void visitObjectWithSpread(Node obj) {
        Preconditions.checkArgument((boolean)obj.isObjectLit());
        Node result = this.astFactory.createObjectDotAssignCall(this.namespace, AstFactory.type(obj), this.astFactory.createObjectLit(new Node[0]));
        Node trailingObjectLiteral = null;
        Node child = obj.getFirstChild();
        while (child != null) {
            Node next = child.getNext();
            if (child.isSpread()) {
                Node spreaded = child.removeFirstChild();
                result.addChildToBack(spreaded);
                trailingObjectLiteral = null;
            } else {
                if (trailingObjectLiteral == null) {
                    trailingObjectLiteral = this.astFactory.createObjectLit(new Node[0]);
                    result.addChildToBack(trailingObjectLiteral);
                }
                trailingObjectLiteral.addChildToBack(child.detach());
            }
            child = next;
        }
        result.srcrefTreeIfMissing(obj);
        obj.replaceWith(result);
        this.compiler.reportChangeToEnclosingScope(result);
    }
}

