/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.TranspilationUtil;
import com.google.javascript.jscomp.colors.Color;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticScope;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jspecify.nullness.Nullable;

public final class RewriteAsyncFunctions
implements NodeTraversal.Callback,
CompilerPass {
    private static final String ASYNC_ARGUMENTS = "$jscomp$async$arguments";
    private static final String ASYNC_THIS = "$jscomp$async$this";
    private static final String ASYNC_SUPER_PROP_GETTER_PREFIX = "$jscomp$async$super$get$";
    private final StaticScope namespace;
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.ASYNC_FUNCTIONS);
    private final Deque<LexicalContext> contextStack;
    private final AbstractCompiler compiler;
    private final AstFactory astFactory;

    private RewriteAsyncFunctions(AbstractCompiler compiler, AstFactory astFactory, StaticScope namespace) {
        this.compiler = (AbstractCompiler)Preconditions.checkNotNull((Object)compiler);
        this.astFactory = (AstFactory)Preconditions.checkNotNull((Object)astFactory);
        this.namespace = (StaticScope)Preconditions.checkNotNull((Object)namespace);
        this.contextStack = new ArrayDeque<LexicalContext>();
    }

    static RewriteAsyncFunctions create(AbstractCompiler compiler) {
        AstFactory astFactory = compiler.createAstFactory();
        StaticScope namespace = compiler.getTranspilationNamespace();
        return new RewriteAsyncFunctions(compiler, astFactory, namespace);
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, root, transpiledFeatures, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, root, transpiledFeatures);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        if (parent == null) {
            Preconditions.checkState((boolean)this.contextStack.isEmpty());
            this.contextStack.push(new RootContext(n));
        } else {
            LexicalContext parentContext = this.contextStack.peek();
            LexicalContext nodeContext = parentContext.getContextForNode(n);
            if (nodeContext != parentContext) {
                this.contextStack.push(nodeContext);
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        LexicalContext context = this.contextStack.peek();
        context.visit(t, n);
        if (context.getContextRootNode() == n) {
            this.contextStack.pop();
        }
    }

    private void convertAsyncFunction(NodeTraversal t, FunctionContext functionContext) {
        Node originalFunction = functionContext.getContextRootNode();
        originalFunction.setIsAsyncFunction(false);
        Node originalBody = originalFunction.getLastChild();
        if (originalFunction.isFromExterns()) {
            if (!NodeUtil.isEmptyBlock(originalBody)) {
                originalBody.replaceWith(this.astFactory.createBlock(new Node[0]));
                NodeUtil.markFunctionsDeleted(originalBody, this.compiler);
            }
            return;
        }
        Node newBody = this.astFactory.createBlock(new Node[0]);
        originalBody.replaceWith(newBody);
        if (functionContext.mustAddAsyncThisVariable) {
            newBody.addChildToBack(this.astFactory.createSingleConstNameDeclaration(ASYNC_THIS, this.astFactory.createThis(functionContext.typeOfThis)));
            NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.CONST_DECLARATIONS, this.compiler);
        }
        if (functionContext.mustAddAsyncArgumentsVariable) {
            newBody.addChildToBack(this.astFactory.createArgumentsAliasDeclaration(ASYNC_ARGUMENTS));
            NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.CONST_DECLARATIONS, this.compiler);
        }
        for (SuperPropertyWrapperInfo superPropertyWrapperInfo : functionContext.superPropertyWrappers.asCollection()) {
            Node arrowFunction = functionContext.createWrapperArrowFunction(superPropertyWrapperInfo);
            Node arrowFunctionDeclarationStatement = this.astFactory.createSingleConstNameDeclaration(superPropertyWrapperInfo.wrapperFunctionName, arrowFunction);
            newBody.addChildToBack(arrowFunctionDeclarationStatement);
            this.compiler.reportChangeToChangeScope(arrowFunction);
            Node enclosingScript = t.getCurrentScript();
            NodeUtil.addFeatureToScript(enclosingScript, FeatureSet.Feature.ARROW_FUNCTIONS, this.compiler);
            NodeUtil.addFeatureToScript(enclosingScript, FeatureSet.Feature.CONST_DECLARATIONS, this.compiler);
        }
        if (!originalBody.isBlock()) {
            originalBody = this.astFactory.createBlock(this.astFactory.createReturn(originalBody)).srcrefTreeIfMissing(originalBody);
        }
        Node generatorFunction = this.astFactory.createZeroArgGeneratorFunction("", originalBody, null);
        this.compiler.reportChangeToChangeScope(generatorFunction);
        NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.GENERATORS, this.compiler);
        newBody.addChildToBack(this.astFactory.createReturn(this.astFactory.createJscompAsyncExecutePromiseGeneratorFunctionCall(this.namespace, generatorFunction)));
        newBody.srcrefTreeIfMissing(originalBody);
        this.compiler.reportChangeToEnclosingScope(newBody);
    }

    private final class FunctionContext
    extends LexicalContext {
        final @Nullable FunctionContext asyncThisAndArgumentsContext;
        final SuperPropertyWrappers superPropertyWrappers;
        boolean mustAddAsyncThisVariable;
        @Nullable AstFactory.Type typeOfThis;
        boolean mustAddAsyncArgumentsVariable;

        FunctionContext(Node contextRootNode) {
            super(contextRootNode);
            this.superPropertyWrappers = new SuperPropertyWrappers();
            this.mustAddAsyncThisVariable = false;
            this.mustAddAsyncArgumentsVariable = false;
            this.asyncThisAndArgumentsContext = contextRootNode.isAsyncFunction() ? this : null;
        }

        FunctionContext(FunctionContext outer, Node contextRootNode) {
            super(contextRootNode);
            this.superPropertyWrappers = new SuperPropertyWrappers();
            this.mustAddAsyncThisVariable = false;
            this.mustAddAsyncArgumentsVariable = false;
            Preconditions.checkState((boolean)contextRootNode.isFunction(), (Object)contextRootNode);
            this.asyncThisAndArgumentsContext = contextRootNode.isAsyncFunction() ? (contextRootNode.isArrowFunction() ? (outer.asyncThisAndArgumentsContext == null ? this : outer.asyncThisAndArgumentsContext) : this) : (contextRootNode.isArrowFunction() ? outer.asyncThisAndArgumentsContext : null);
        }

        @Override
        public LexicalContext getContextForNode(Node n) {
            if (n == this.contextRootNode) {
                return this;
            }
            if (n.isFunction()) {
                return new FunctionContext(this, n);
            }
            if (n.isParamList()) {
                return new ParameterListContext(this, n);
            }
            return this;
        }

        private void recordAsyncThisReplacementWasDone(AstFactory.Type typeOfThis) {
            this.asyncThisAndArgumentsContext.mustAddAsyncThisVariable = true;
            this.asyncThisAndArgumentsContext.typeOfThis = typeOfThis;
        }

        private SuperPropertyWrapperInfo getOrCreateSuperPropertyWrapperInfo(Node superDotPropertyNode) {
            return this.asyncThisAndArgumentsContext.superPropertyWrappers.getOrCreateSuperPropertyWrapperInfo(superDotPropertyNode);
        }

        private void recordAsyncArgumentsReplacementWasDone() {
            this.asyncThisAndArgumentsContext.mustAddAsyncArgumentsVariable = true;
        }

        private Node createThisVariableReference(AstFactory.Type typeOfThis) {
            this.recordAsyncThisReplacementWasDone(typeOfThis);
            return RewriteAsyncFunctions.this.astFactory.createName(RewriteAsyncFunctions.ASYNC_THIS, typeOfThis);
        }

        private Node createWrapperArrowFunction(SuperPropertyWrapperInfo wrapperInfo) {
            Node superDotProperty = wrapperInfo.firstInstanceOfSuperDotProperty.cloneTree();
            return RewriteAsyncFunctions.this.astFactory.createZeroArgArrowFunctionForExpression(RewriteAsyncFunctions.this.astFactory.createBlock(RewriteAsyncFunctions.this.astFactory.createReturn(superDotProperty)));
        }

        @Override
        public void visit(NodeTraversal t, Node n) {
            if (this.contextRootNode == n && this.contextRootNode.isAsyncFunction()) {
                RewriteAsyncFunctions.this.convertAsyncFunction(t, this);
            } else if (this.asyncThisAndArgumentsContext != null) {
                switch (n.getToken()) {
                    case NAME: {
                        if (!n.matchesName("arguments")) break;
                        n.setString(RewriteAsyncFunctions.ASYNC_ARGUMENTS);
                        if (RewriteAsyncFunctions.this.compiler.getLifeCycleStage().isNormalized()) {
                            n.putBooleanProp(Node.IS_CONSTANT_NAME, true);
                        }
                        this.asyncThisAndArgumentsContext.recordAsyncArgumentsReplacementWasDone();
                        RewriteAsyncFunctions.this.compiler.reportChangeToChangeScope(this.contextRootNode);
                        break;
                    }
                    case THIS: {
                        n.replaceWith(this.asyncThisAndArgumentsContext.createThisVariableReference(AstFactory.type(n)));
                        RewriteAsyncFunctions.this.compiler.reportChangeToChangeScope(this.contextRootNode);
                        break;
                    }
                    case SUPER: {
                        Node parent = n.getParent();
                        if (!parent.isGetProp()) {
                            RewriteAsyncFunctions.this.compiler.report(JSError.make(parent, TranspilationUtil.CANNOT_CONVERT_YET, "super expression"));
                        }
                        Node superDotProperty = parent;
                        SuperPropertyWrapperInfo superPropertyWrapperInfo = this.asyncThisAndArgumentsContext.getOrCreateSuperPropertyWrapperInfo(superDotProperty);
                        Node getPropReplacement = superPropertyWrapperInfo.createWrapperFunctionCallNode();
                        Node grandparent = superDotProperty.getParent();
                        if (grandparent.isCall() && grandparent.getFirstChild() == superDotProperty) {
                            getPropReplacement = RewriteAsyncFunctions.this.astFactory.createGetPropWithUnknownType(getPropReplacement, "call");
                            Node thisAlias = RewriteAsyncFunctions.this.astFactory.createThisAliasReferenceForEs6Class(RewriteAsyncFunctions.ASYNC_THIS, NodeUtil.getEnclosingClass(this.asyncThisAndArgumentsContext.getContextRootNode())).srcref(superDotProperty);
                            thisAlias.insertAfter(superDotProperty);
                            this.asyncThisAndArgumentsContext.recordAsyncThisReplacementWasDone(AstFactory.type(thisAlias));
                        }
                        getPropReplacement.srcrefTree(superDotProperty);
                        superDotProperty.replaceWith(getPropReplacement);
                        RewriteAsyncFunctions.this.compiler.reportChangeToChangeScope(this.contextRootNode);
                        break;
                    }
                    case AWAIT: {
                        n.replaceWith(RewriteAsyncFunctions.this.astFactory.createYield(AstFactory.type(n), n.removeFirstChild()));
                        break;
                    }
                }
            }
        }
    }

    private final class ParameterListContext
    extends LexicalContext {
        final FunctionContext functionContext;

        public ParameterListContext(FunctionContext functionContext, Node contextRootNode) {
            super(contextRootNode);
            this.functionContext = (FunctionContext)Preconditions.checkNotNull((Object)functionContext);
        }

        @Override
        public LexicalContext getContextForNode(Node n) {
            if (n.isFunction()) {
                return new FunctionContext(this.functionContext, n);
            }
            return this;
        }

        @Override
        public void visit(NodeTraversal t, Node n) {
            if (this.functionContext.asyncThisAndArgumentsContext != null && this.functionContext.asyncThisAndArgumentsContext != this.functionContext) {
                this.functionContext.visit(t, n);
            }
        }
    }

    private final class RootContext
    extends LexicalContext {
        private RootContext(Node contextRootNode) {
            super(contextRootNode);
        }

        @Override
        public LexicalContext getContextForNode(Node n) {
            if (n.isFunction()) {
                return new FunctionContext(n);
            }
            return this;
        }

        @Override
        public void visit(NodeTraversal t, Node n) {
        }
    }

    private static abstract class LexicalContext {
        final Node contextRootNode;

        LexicalContext(Node contextRootNode) {
            this.contextRootNode = (Node)Preconditions.checkNotNull((Object)contextRootNode);
        }

        Node getContextRootNode() {
            return this.contextRootNode;
        }

        public abstract LexicalContext getContextForNode(Node var1);

        public abstract void visit(NodeTraversal var1, Node var2);
    }

    private final class SuperPropertyWrappers {
        private final Map<String, SuperPropertyWrapperInfo> propertyNameToTypeMap = new LinkedHashMap<String, SuperPropertyWrapperInfo>();

        private SuperPropertyWrappers() {
        }

        private SuperPropertyWrapperInfo getOrCreateSuperPropertyWrapperInfo(Node superDotPropertyNode) {
            SuperPropertyWrapperInfo superPropertyWrapperInfo;
            Preconditions.checkArgument((boolean)superDotPropertyNode.isGetProp(), (Object)superDotPropertyNode);
            Node superNode = superDotPropertyNode.getFirstChild();
            Preconditions.checkArgument((boolean)superNode.isSuper(), (Object)superNode);
            String propertyName = superDotPropertyNode.getString();
            Color propertyType = superDotPropertyNode.getColor();
            if (this.propertyNameToTypeMap.containsKey(propertyName)) {
                superPropertyWrapperInfo = this.propertyNameToTypeMap.get(propertyName);
                Color existingColor = superPropertyWrapperInfo.getPropertyType();
                Preconditions.checkState((boolean)Objects.equals(existingColor, propertyType), (String)"Previous reference type: %s differs from current reference type: %s", (Object)existingColor, (Object)propertyType);
            } else {
                superPropertyWrapperInfo = this.createNewInfo(superDotPropertyNode);
                this.propertyNameToTypeMap.put(propertyName, superPropertyWrapperInfo);
            }
            return superPropertyWrapperInfo;
        }

        private SuperPropertyWrapperInfo createNewInfo(Node firstSuperDotPropertyNode) {
            Preconditions.checkArgument((boolean)firstSuperDotPropertyNode.isGetProp(), (Object)firstSuperDotPropertyNode);
            String propertyName = firstSuperDotPropertyNode.getString();
            String wrapperFunctionName = RewriteAsyncFunctions.ASYNC_SUPER_PROP_GETTER_PREFIX + propertyName;
            return new SuperPropertyWrapperInfo(firstSuperDotPropertyNode, wrapperFunctionName, AstFactory.type(firstSuperDotPropertyNode));
        }

        private Collection<SuperPropertyWrapperInfo> asCollection() {
            return this.propertyNameToTypeMap.values();
        }
    }

    private final class SuperPropertyWrapperInfo {
        private final Node firstInstanceOfSuperDotProperty;
        private final String wrapperFunctionName;
        private final @Nullable AstFactory.Type wrapperFunctionReturnType;

        private SuperPropertyWrapperInfo(Node firstSuperDotPropertyNode, String wrapperFunctionName, AstFactory.Type wrapperFunctionReturnType) {
            this.firstInstanceOfSuperDotProperty = firstSuperDotPropertyNode;
            this.wrapperFunctionName = wrapperFunctionName;
            this.wrapperFunctionReturnType = wrapperFunctionReturnType;
        }

        private @Nullable Color getPropertyType() {
            return this.firstInstanceOfSuperDotProperty.getColor();
        }

        private Node createWrapperFunctionNameNode() {
            return RewriteAsyncFunctions.this.astFactory.createName(this.wrapperFunctionName, AstFactory.type(StandardColors.TOP_OBJECT));
        }

        private Node createWrapperFunctionCallNode() {
            return RewriteAsyncFunctions.this.astFactory.createCall(this.createWrapperFunctionNameNode(), this.wrapperFunctionReturnType, new Node[0]);
        }
    }
}

