/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractVar;
import com.google.javascript.jscomp.AccessorSummary;
import com.google.javascript.jscomp.AstAnalyzer;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PolyfillUsageFinder;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.base.format.SimpleFormat;
import com.google.javascript.jscomp.diagnostic.LogFile;
import com.google.javascript.jscomp.resources.ResourceLoader;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.jspecify.nullness.Nullable;

class RemoveUnusedCode
implements CompilerPass {
    private static final ImmutableSet<String> IMPLICITLY_USED_PROPERTIES = ImmutableSet.of((Object)"length", (Object)"toString", (Object)"valueOf", (Object)"constructor", (Object)"prototype");
    private final AbstractCompiler compiler;
    private final AstAnalyzer astAnalyzer;
    private final CodingConvention codingConvention;
    private final boolean removeLocalVars;
    private final boolean removeGlobals;
    private final boolean preserveFunctionExpressionNames;
    private final Deque<Continuation> worklist = new ArrayDeque<Continuation>();
    private final LinkedHashMap<Var, VarInfo> varInfoMap = new LinkedHashMap();
    private final Set<String> pinnedPropertyNames = new HashSet<String>((Collection<String>)IMPLICITLY_USED_PROPERTIES);
    private final Multimap<String, Removable> removablesForPropertyNames = HashMultimap.create();
    private final VarInfo canonicalUnremovableVarInfo;
    private final List<Scope> allFunctionParamScopes = new ArrayList<Scope>();
    private final Multimap<String, PolyfillInfo> polyfills = HashMultimap.create();
    private final Set<Node> guardedUsages = new HashSet<Node>();
    private final PolyfillUsageFinder.Polyfills polyfillsFromTable;
    private final SyntacticScopeCreator scopeCreator;
    private final boolean removeUnusedPrototypeProperties;
    private final boolean removeUnusedThisProperties;
    private final boolean removeUnusedObjectDefinePropertiesDefinitions;
    private final boolean removeUnusedPolyfills;
    private final boolean assumeGettersArePure;
    private @Nullable LogFile removalLog;
    private @Nullable LogFile unremovableLog;
    private static final String DOT_PROTOTYPE = ".prototype";

    RemoveUnusedCode(Builder builder) {
        this.compiler = builder.compiler;
        this.astAnalyzer = this.compiler.getAstAnalyzer();
        this.codingConvention = builder.compiler.getCodingConvention();
        this.scopeCreator = new SyntacticScopeCreator(builder.compiler);
        this.removeLocalVars = builder.removeLocalVars;
        this.removeGlobals = builder.removeGlobals;
        this.preserveFunctionExpressionNames = builder.preserveFunctionExpressionNames;
        this.removeUnusedPrototypeProperties = builder.removeUnusedPrototypeProperties;
        this.removeUnusedThisProperties = builder.removeUnusedThisProperties;
        this.removeUnusedObjectDefinePropertiesDefinitions = builder.removeUnusedObjectDefinePropertiesDefinitions;
        this.removeUnusedPolyfills = builder.removeUnusedPolyfills;
        this.polyfillsFromTable = PolyfillUsageFinder.Polyfills.fromTable(ResourceLoader.loadTextResource(RemoveUnusedCode.class, "js/polyfills.txt"));
        this.assumeGettersArePure = builder.assumeGettersArePure;
        this.canonicalUnremovableVarInfo = new CanonicalUnremovableVarInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState((boolean)this.compiler.getLifeCycleStage().isNormalized());
        this.pinnedPropertyNames.addAll((Collection<String>)this.compiler.getExternProperties());
        try (LogFile removalLogFile = this.compiler.createOrReopenIndexedLog(this.getClass(), "removals.log", new String[0]);
             LogFile keepLogFile = this.compiler.createOrReopenIndexedLog(this.getClass(), "unremovable.log", new String[0]);){
            this.removalLog = removalLogFile;
            this.unremovableLog = keepLogFile;
            this.traverseAndRemoveUnusedReferences(root);
        }
        finally {
            this.removalLog = null;
            this.unremovableLog = null;
        }
    }

    private void traverseAndRemoveUnusedReferences(Node root) {
        Scope scope = this.scopeCreator.createScope(root.getParent(), (Scope)null);
        if (!scope.hasSlot("JSCompiler_renameProperty")) {
            scope.declare("JSCompiler_renameProperty", null, null);
        }
        new PolyfillUsageFinder(this.compiler, this.polyfillsFromTable).traverseOnlyGuarded(root, this::storePolyfill);
        this.worklist.add(new Continuation(root, scope));
        while (!this.worklist.isEmpty()) {
            Continuation continuation = this.worklist.remove();
            continuation.apply();
        }
        this.removeUnreferencedVarsAndPolyfills();
        this.removeIndependentlyRemovableProperties();
        for (Scope fparamScope : this.allFunctionParamScopes) {
            this.removeUnreferencedFunctionArgs(fparamScope);
        }
    }

    private void storePolyfill(PolyfillUsageFinder.PolyfillUsage polyfillUsage) {
        this.guardedUsages.add(polyfillUsage.node());
    }

    private void removeIndependentlyRemovableProperties() {
        for (String propName : this.removablesForPropertyNames.keySet()) {
            this.removalLog.log(RemovalLogRecord.forProperty(propName));
            for (Removable removable : this.removablesForPropertyNames.get((Object)propName)) {
                removable.remove(this.compiler);
            }
        }
    }

    private void traverseNode(Node n, Scope scope) {
        Node parent = n.getParent();
        Token type = n.getToken();
        switch (type) {
            case CATCH: {
                this.traverseCatch(n, scope);
                break;
            }
            case FUNCTION: {
                VarInfo varInfo = null;
                if (NodeUtil.isFunctionDeclaration(n)) {
                    varInfo = this.traverseNameNode(n.getFirstChild(), scope);
                    FunctionDeclaration functionDeclaration = new RemovableBuilder().addContinuation(new Continuation(n, scope)).buildFunctionDeclaration(n);
                    varInfo.addRemovable(functionDeclaration);
                    if (!parent.isExport()) break;
                    varInfo.setIsExplicitlyNotRemovable(() -> "exported class");
                    break;
                }
                this.traverseFunction(n, scope);
                break;
            }
            case ASSIGN: {
                this.traverseAssign(n, scope);
                break;
            }
            case ASSIGN_BITOR: 
            case ASSIGN_BITXOR: 
            case ASSIGN_BITAND: 
            case ASSIGN_LSH: 
            case ASSIGN_RSH: 
            case ASSIGN_URSH: 
            case ASSIGN_ADD: 
            case ASSIGN_SUB: 
            case ASSIGN_MUL: 
            case ASSIGN_EXPONENT: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: {
                this.traverseCompoundAssign(n, scope);
                break;
            }
            case INC: 
            case DEC: {
                this.traverseIncrementOrDecrementOp(n, scope);
                break;
            }
            case CALL: 
            case OPTCHAIN_CALL: {
                this.traverseCall(n, scope);
                break;
            }
            case SWITCH: 
            case BLOCK: {
                this.traverseChildren(n, NodeUtil.createsBlockScope(n) ? this.scopeCreator.createScope(n, scope) : scope);
                break;
            }
            case MODULE_BODY: {
                this.traverseChildren(n, this.scopeCreator.createScope(n, scope));
                break;
            }
            case CLASS: {
                this.traverseClass(n, scope);
                break;
            }
            case CLASS_MEMBERS: {
                this.traverseClassMembers(n, scope);
                break;
            }
            case ARRAY_PATTERN: 
            case PARAM_LIST: {
                this.traverseIndirectAssignmentList(n, scope);
                break;
            }
            case OBJECT_PATTERN: {
                this.traverseObjectPattern(n, scope);
                break;
            }
            case OBJECTLIT: {
                this.traverseObjectLiteral(n, scope);
                break;
            }
            case FOR: {
                this.traverseVanillaFor(n, scope);
                break;
            }
            case FOR_IN: 
            case FOR_OF: 
            case FOR_AWAIT_OF: {
                this.traverseEnhancedFor(n, scope);
                break;
            }
            case LET: 
            case CONST: 
            case VAR: {
                Preconditions.checkState((boolean)NodeUtil.isStatement(n));
                this.traverseDeclarationStatement(n, scope);
                break;
            }
            case INSTANCEOF: {
                this.traverseInstanceof(n, scope);
                break;
            }
            case NAME: {
                Preconditions.checkState((!n.hasChildren() ? 1 : 0) != 0);
                if (parent.isParamList()) break;
                Preconditions.checkState((!NodeUtil.isNameDeclaration(parent) ? 1 : 0) != 0);
                Preconditions.checkState((!parent.isFunction() && !parent.isClass() || parent.getFirstChild() != n ? 1 : 0) != 0);
                this.traverseNameNode(n, scope).setIsExplicitlyNotRemovable(() -> SimpleFormat.format("reference found: %s", n.getLocation()));
                break;
            }
            case GETPROP: 
            case OPTCHAIN_GETPROP: {
                this.traverseNormalOrOptChainGetProp(n, scope);
                break;
            }
            default: {
                this.traverseChildren(n, scope);
            }
        }
    }

    private void traverseInstanceof(Node instanceofNode, Scope scope) {
        Preconditions.checkArgument((boolean)instanceofNode.isInstanceOf(), (Object)instanceofNode);
        Node lhs = instanceofNode.getFirstChild();
        Node rhs = lhs.getNext();
        this.traverseNode(lhs, scope);
        if (rhs.isName()) {
            VarInfo varInfo = this.traverseNameNode(rhs, scope);
            RemovableBuilder builder = new RemovableBuilder();
            varInfo.addRemovable(builder.buildInstanceofName(instanceofNode));
        } else {
            this.traverseNode(rhs, scope);
        }
    }

    private void traverseNormalOrOptChainGetProp(Node getProp, Scope scope) {
        RemovableBuilder builder;
        Preconditions.checkState((boolean)NodeUtil.isNormalOrOptChainGetProp(getProp), (Object)getProp);
        Node objectNode = getProp.getFirstChild();
        String propertyName = getProp.getString();
        if (this.polyfills.containsKey((Object)propertyName)) {
            for (PolyfillInfo info : this.polyfills.get((Object)propertyName)) {
                if (!info.isRemovable) continue;
                info.considerPossibleReference(getProp);
            }
        }
        if (NodeUtil.isExpressionResultUsed(getProp) || this.considerForAccessorSideEffects(getProp, AccessorSummary.PropertyAccessKind.GETTER_ONLY)) {
            this.markPropertyNameAsPinned(propertyName);
            this.traverseNode(objectNode, scope);
        } else if (objectNode.isThis()) {
            builder = new RemovableBuilder().setIsThisDotPropertyReference(true);
            this.considerForIndependentRemoval(builder.buildUnusedReadReference(getProp, getProp));
        } else if (RemoveUnusedCode.isDotPrototype(objectNode)) {
            builder = new RemovableBuilder().setIsPrototypeDotPropertyReference(true);
            Node objExpression = objectNode.getFirstChild();
            if (objExpression.isName()) {
                VarInfo varInfo = this.traverseNameNode(objExpression, scope);
                varInfo.addRemovable(builder.buildUnusedReadReference(getProp, getProp));
            } else {
                if (this.mayHaveSideEffects(objExpression)) {
                    this.traverseNode(objExpression, scope);
                } else {
                    builder.addContinuation(new Continuation(objExpression, scope));
                }
                this.considerForIndependentRemoval(builder.buildUnusedReadReference(getProp, getProp));
            }
        } else {
            this.markPropertyNameAsPinned(propertyName);
            this.traverseNode(objectNode, scope);
        }
    }

    private void traverseIncrementOrDecrementOp(Node incOrDecOp, Scope scope) {
        Preconditions.checkArgument((incOrDecOp.isInc() || incOrDecOp.isDec() ? 1 : 0) != 0, (Object)incOrDecOp);
        Node arg = incOrDecOp.getOnlyChild();
        if (NodeUtil.isExpressionResultUsed(incOrDecOp)) {
            this.traverseNode(arg, scope);
        } else if (arg.isGetProp()) {
            Node getPropObj = arg.getFirstChild();
            if (this.considerForAccessorSideEffects(arg, AccessorSummary.PropertyAccessKind.GETTER_AND_SETTER)) {
                this.traverseNode(getPropObj, scope);
            } else if (getPropObj.isThis()) {
                RemovableBuilder builder = new RemovableBuilder().setIsThisDotPropertyReference(true);
                this.considerForIndependentRemoval(builder.buildIncOrDepOp(incOrDecOp, arg, null));
            } else if (RemoveUnusedCode.isDotPrototype(getPropObj)) {
                Node exprObj = getPropObj.getFirstChild();
                RemovableBuilder builder = new RemovableBuilder().setIsPrototypeDotPropertyReference(true);
                if (exprObj.isName()) {
                    VarInfo varInfo = this.traverseNameNode(exprObj, scope);
                    varInfo.addRemovable(builder.buildIncOrDepOp(incOrDecOp, arg, null));
                } else {
                    Node toPreserve = null;
                    if (this.mayHaveSideEffects(exprObj)) {
                        toPreserve = exprObj;
                        this.traverseNode(exprObj, scope);
                    } else {
                        builder.addContinuation(new Continuation(exprObj, scope));
                    }
                    this.considerForIndependentRemoval(builder.buildIncOrDepOp(incOrDecOp, arg, toPreserve));
                }
            } else {
                this.traverseNode(arg, scope);
            }
        } else {
            this.traverseNode(arg, scope);
        }
    }

    private void traverseCompoundAssign(Node compoundAssignNode, Scope scope) {
        Node targetNode = compoundAssignNode.getFirstChild();
        Node valueNode = compoundAssignNode.getLastChild();
        if (targetNode.isGetProp()) {
            if (this.considerForAccessorSideEffects(targetNode, AccessorSummary.PropertyAccessKind.GETTER_AND_SETTER)) {
                this.traverseNode(targetNode.getFirstChild(), scope);
                this.traverseNode(valueNode, scope);
            } else if (targetNode.getFirstChild().isThis() && !NodeUtil.isExpressionResultUsed(compoundAssignNode)) {
                RemovableBuilder builder = new RemovableBuilder().setIsThisDotPropertyReference(true);
                this.traverseRemovableAssignValue(valueNode, builder, scope);
                this.considerForIndependentRemoval(builder.buildNamedPropertyAssign(compoundAssignNode, targetNode));
            } else {
                this.traverseNode(targetNode, scope);
                this.traverseNode(valueNode, scope);
            }
        } else {
            this.traverseNode(targetNode, scope);
            this.traverseNode(valueNode, scope);
        }
    }

    private VarInfo traverseNameNode(Node n, Scope scope) {
        if (this.polyfills.containsKey((Object)n.getString())) {
            for (PolyfillInfo info : this.polyfills.get((Object)n.getString())) {
                if (!info.isRemovable) continue;
                info.considerPossibleReference(n);
            }
        }
        return this.traverseVar(this.getVarForNameNode(n, scope));
    }

    private void traverseCall(Node callNode, Scope scope) {
        Node callee = callNode.getFirstChild();
        if (this.codingConvention.isPropertyRenameFunction(callee)) {
            Node propertyNameNode = callee.getNext();
            if (propertyNameNode != null && propertyNameNode.isStringLit()) {
                this.markPropertyNameAsPinned(propertyNameNode.getString());
            }
            this.traverseChildren(callNode, scope);
        } else if (NodeUtil.isObjectDefinePropertiesDefinition(callNode)) {
            this.traverseObjectDefinePropertiesCall(callNode, scope);
        } else if (this.removeUnusedPolyfills && RemoveUnusedCode.isJscompPolyfill(callee)) {
            Node firstArg = callee.getNext();
            String polyfillName = firstArg.getString();
            PolyfillInfo info = this.createPolyfillInfo(callNode, scope, polyfillName);
            this.polyfills.put((Object)info.key, (Object)info);
            this.traverseNode(callNode.getFirstChild(), scope);
        } else {
            Node parent = callNode.getParent();
            String classVarName = null;
            boolean classDefiningCall = false;
            if (parent.isExprResult() || parent.isComma() && parent.getFirstChild() == callNode) {
                CodingConvention.SubclassRelationship subclassRelationship = this.codingConvention.getClassesDefinedByCall(callNode);
                if (subclassRelationship != null) {
                    classVarName = subclassRelationship.subclassName;
                    classDefiningCall = true;
                } else {
                    classVarName = this.codingConvention.getSingletonGetterClassName(callNode);
                }
            }
            AbstractVar classVar = null;
            if (classVarName != null && NodeUtil.isValidSimpleName(classVarName)) {
                classVar = (Var)Preconditions.checkNotNull((Object)((Var)scope.getVar(classVarName)), (Object)classVarName);
            }
            if (classVar == null || !classVar.isGlobal()) {
                this.traverseChildren(callNode, scope);
            } else {
                RemovableBuilder builder = new RemovableBuilder();
                for (Node child = callNode.getFirstChild(); child != null; child = child.getNext()) {
                    builder.addContinuation(new Continuation(child, scope));
                }
                this.traverseVar((Var)classVar).addRemovable(builder.buildClassSetupCall(callNode, classDefiningCall));
            }
        }
    }

    private static boolean isJscompPolyfill(Node n) {
        switch (n.getToken()) {
            case NAME: {
                return n.getString().equals("$jscomp$polyfill") && n.getNext().isStringLit();
            }
            case GETPROP: {
                return n.getString().equals("polyfill") && n.getFirstChild().isName() && n.getFirstChild().getString().equals("$jscomp") && n.getNext().isStringLit();
            }
        }
        return false;
    }

    private void traverseObjectDefinePropertiesCall(Node callNode, Scope scope) {
        Node callee = callNode.getFirstChild();
        Node targetObject = callNode.getSecondChild();
        Node propertyDefinitions = targetObject.getNext();
        if ((targetObject.isName() || this.isNameDotPrototype(targetObject)) && !NodeUtil.isExpressionResultUsed(callNode)) {
            Node nameNode = targetObject.isName() ? targetObject : targetObject.getFirstChild();
            VarInfo varInfo = this.traverseNameNode(nameNode, scope);
            RemovableBuilder builder = new RemovableBuilder();
            builder.addContinuation(new Continuation(callee, scope));
            if (this.mayHaveSideEffects(propertyDefinitions)) {
                this.traverseNode(propertyDefinitions, scope);
            } else {
                builder.addContinuation(new Continuation(propertyDefinitions, scope));
            }
            varInfo.addRemovable(builder.buildClassSetupCall(callNode));
        } else {
            this.traverseNode(callee, scope);
            this.traverseNode(targetObject, scope);
            this.traverseNode(propertyDefinitions, scope);
        }
    }

    private void traverseObjectDefinePropertiesLiteral(Node propertyDefinitions, Scope scope) {
        for (Node property = propertyDefinitions.getFirstChild(); property != null; property = property.getNext()) {
            if (property.isQuotedStringKey()) {
                this.markPropertyNameAsPinned(property.getString());
                this.traverseNode(property.getOnlyChild(), scope);
                continue;
            }
            if (property.isStringKey()) {
                Node definition = property.getOnlyChild();
                if (this.mayHaveSideEffects(definition)) {
                    this.traverseNode(definition, scope);
                    continue;
                }
                this.considerForIndependentRemoval(new RemovableBuilder().addContinuation(new Continuation(definition, scope)).buildObjectDefinePropertiesDefinition(property));
                continue;
            }
            this.traverseNode(property, scope);
        }
    }

    private Var getVarForNameNode(Node nameNode, Scope scope) {
        return (Var)Preconditions.checkNotNull((Object)((Var)scope.getVar(nameNode.getString())), (Object)nameNode);
    }

    private void traverseObjectLiteral(Node objectLiteral, Scope scope) {
        Preconditions.checkArgument((boolean)objectLiteral.isObjectLit(), (Object)objectLiteral);
        if (this.isAssignmentToPrototype(objectLiteral.getParent())) {
            this.traversePrototypeLiteral(objectLiteral, scope);
        } else if (this.isObjectDefinePropertiesSecondArgument(objectLiteral)) {
            this.traverseObjectDefinePropertiesLiteral(objectLiteral, scope);
        } else {
            this.traverseNonPrototypeObjectLiteral(objectLiteral, scope);
        }
    }

    private boolean isObjectDefinePropertiesSecondArgument(Node n) {
        Node parent = n.getParent();
        return NodeUtil.isObjectDefinePropertiesDefinition(parent) && parent.getLastChild() == n;
    }

    private void traverseNonPrototypeObjectLiteral(Node objectLiteral, Scope scope) {
        for (Node propertyNode = objectLiteral.getFirstChild(); propertyNode != null; propertyNode = propertyNode.getNext()) {
            if (propertyNode.isStringKey()) {
                this.markPropertyNameAsPinned(propertyNode.getString());
                this.traverseNode(propertyNode.getFirstChild(), scope);
                continue;
            }
            this.traverseNode(propertyNode, scope);
        }
    }

    private void traversePrototypeLiteral(Node objectLiteral, Scope scope) {
        for (Node propertyNode = objectLiteral.getFirstChild(); propertyNode != null; propertyNode = propertyNode.getNext()) {
            if (propertyNode.isComputedProp() || propertyNode.isQuotedStringKey()) {
                this.traverseChildren(propertyNode, scope);
                continue;
            }
            Node valueNode = propertyNode.getOnlyChild();
            if (this.mayHaveSideEffects(valueNode)) {
                this.traverseNode(valueNode, scope);
                continue;
            }
            this.considerForIndependentRemoval(new RemovableBuilder().addContinuation(new Continuation(valueNode, scope)).buildClassOrPrototypeNamedProperty(propertyNode));
        }
    }

    private boolean isAssignmentToPrototype(Node n) {
        return n.isAssign() && RemoveUnusedCode.isDotPrototype(n.getFirstChild());
    }

    private static boolean isDotPrototype(Node n) {
        return NodeUtil.isNormalOrOptChainGetProp(n) && n.getString().equals("prototype");
    }

    private void traverseCatch(Node catchNode, Scope scope) {
        Node exceptionNameNode = catchNode.getFirstChild();
        Node block = exceptionNameNode.getNext();
        if (exceptionNameNode.isName()) {
            VarInfo exceptionVarInfo = this.traverseNameNode(exceptionNameNode, scope);
            exceptionVarInfo.setIsExplicitlyNotRemovable(() -> "catch variable");
        }
        this.traverseNode(block, scope);
    }

    private void traverseEnhancedFor(Node enhancedFor, Scope scope) {
        Scope forScope = this.scopeCreator.createScope(enhancedFor, scope);
        Node iterationTarget = enhancedFor.getFirstChild();
        Node collection = iterationTarget.getNext();
        Node body = collection.getNext();
        if (iterationTarget.isName()) {
            VarInfo varInfo = this.traverseNameNode(iterationTarget, forScope);
            varInfo.setIsExplicitlyNotRemovable(() -> "for-of or for-in loop variable");
        } else if (NodeUtil.isNameDeclaration(iterationTarget)) {
            Node declNode = iterationTarget.getOnlyChild();
            if (declNode.isDestructuringLhs()) {
                this.traverseNode(declNode, forScope);
            } else {
                Preconditions.checkState((boolean)declNode.isName());
                Preconditions.checkState((!declNode.hasChildren() ? 1 : 0) != 0);
                VarInfo varInfo = this.traverseNameNode(declNode, forScope);
                varInfo.setIsExplicitlyNotRemovable(() -> "for-of or for-in loop variable");
            }
        } else {
            this.traverseNode(iterationTarget, forScope);
        }
        this.traverseNode(collection, forScope);
        this.traverseNode(body, forScope);
    }

    private void traverseVanillaFor(Node forNode, Scope scope) {
        Scope forScope = this.scopeCreator.createScope(forNode, scope);
        Node initialization = forNode.getFirstChild();
        Node condition = initialization.getNext();
        Node update = condition.getNext();
        Node block = update.getNext();
        if (NodeUtil.isNameDeclaration(initialization)) {
            this.traverseVanillaForNameDeclarations(initialization, forScope);
        } else {
            this.traverseNode(initialization, forScope);
        }
        this.traverseNode(condition, forScope);
        this.traverseNode(update, forScope);
        this.traverseNode(block, forScope);
    }

    private void traverseVanillaForNameDeclarations(Node nameDeclaration, Scope scope) {
        for (Node child = nameDeclaration.getFirstChild(); child != null; child = child.getNext()) {
            if (!child.isName()) {
                this.traverseNode(child, scope);
                continue;
            }
            Node nameNode = child;
            @Nullable Node valueNode = child.getFirstChild();
            VarInfo varInfo = this.traverseNameNode(nameNode, scope);
            if (valueNode == null) {
                varInfo.addRemovable(new RemovableBuilder().buildVanillaForNameDeclaration(nameNode));
                continue;
            }
            if (this.mayHaveSideEffects(valueNode)) {
                varInfo.setIsExplicitlyNotRemovable(() -> "for-loop variable initialization has side-effects");
                this.traverseNode(valueNode, scope);
                continue;
            }
            VanillaForNameDeclaration vanillaForNameDeclaration = new RemovableBuilder().addContinuation(new Continuation(valueNode, scope)).buildVanillaForNameDeclaration(nameNode);
            varInfo.addRemovable(vanillaForNameDeclaration);
        }
    }

    private void traverseDeclarationStatement(Node declarationStatement, Scope scope) {
        Node nameNode = declarationStatement.getOnlyChild();
        if (!nameNode.isName()) {
            this.traverseNode(nameNode, scope);
        } else {
            Node valueNode = nameNode.getFirstChild();
            VarInfo varInfo = this.traverseNameNode(nameNode, scope);
            RemovableBuilder builder = new RemovableBuilder();
            if (valueNode == null) {
                varInfo.addRemovable(builder.buildNameDeclarationStatement(declarationStatement));
            } else {
                if (this.mayHaveSideEffects(valueNode)) {
                    this.traverseNode(valueNode, scope);
                } else {
                    builder.addContinuation(new Continuation(valueNode, scope));
                }
                NameDeclarationStatement removable = builder.buildNameDeclarationStatement(declarationStatement);
                varInfo.addRemovable(removable);
            }
        }
    }

    private void traverseAssign(Node assignNode, Scope scope) {
        Preconditions.checkState((boolean)NodeUtil.isAssignmentOp(assignNode));
        Node lhs = assignNode.getFirstChild();
        Node valueNode = assignNode.getLastChild();
        if (lhs.isName()) {
            VarInfo varInfo = this.traverseNameNode(lhs, scope);
            RemovableBuilder builder = new RemovableBuilder();
            this.traverseRemovableAssignValue(valueNode, builder, scope);
            varInfo.addRemovable(builder.buildVariableAssign(assignNode, varInfo));
        } else if (lhs.isGetElem()) {
            Node varNameNode;
            Node getElemObj = lhs.getFirstChild();
            Node getElemKey = lhs.getLastChild();
            Node node = getElemObj.isName() ? getElemObj : (varNameNode = this.isNameDotPrototype(getElemObj) ? getElemObj.getFirstChild() : null);
            if (varNameNode != null) {
                VarInfo varInfo = this.traverseNameNode(varNameNode, scope);
                RemovableBuilder builder = new RemovableBuilder();
                if (this.mayHaveSideEffects(getElemKey)) {
                    this.traverseNode(getElemKey, scope);
                } else {
                    builder.addContinuation(new Continuation(getElemKey, scope));
                }
                this.traverseRemovableAssignValue(valueNode, builder, scope);
                varInfo.addRemovable(builder.buildComputedPropertyAssign(assignNode, getElemKey, varInfo));
            } else {
                this.traverseNode(getElemObj, scope);
                this.traverseNode(getElemKey, scope);
                this.traverseNode(valueNode, scope);
            }
        } else if (lhs.isGetProp()) {
            boolean isPrototypeMethodDef;
            Node getPropLhs = lhs.getFirstChild();
            boolean isDotPrototypeLhs = RemoveUnusedCode.isDotPrototype(getPropLhs);
            boolean bl = isPrototypeMethodDef = isDotPrototypeLhs && valueNode.isFunction();
            if (!isPrototypeMethodDef && this.considerForAccessorSideEffects(lhs, AccessorSummary.PropertyAccessKind.SETTER_ONLY)) {
                this.traverseNode(getPropLhs, scope);
                this.traverseNode(valueNode, scope);
            } else if (getPropLhs.isName()) {
                VarInfo varInfo = this.traverseNameNode(getPropLhs, scope);
                RemovableBuilder builder = new RemovableBuilder();
                this.traverseRemovableAssignValue(valueNode, builder, scope);
                varInfo.addRemovable(builder.buildNamedPropertyAssign(assignNode, lhs, varInfo));
            } else if (isDotPrototypeLhs) {
                Node objExpression = getPropLhs.getFirstChild();
                RemovableBuilder builder = new RemovableBuilder().setIsPrototypeDotPropertyReference(true);
                this.traverseRemovableAssignValue(valueNode, builder, scope);
                if (objExpression.isName()) {
                    VarInfo varInfo = this.traverseNameNode(getPropLhs.getFirstChild(), scope);
                    varInfo.addRemovable(builder.buildNamedPropertyAssign(assignNode, lhs, varInfo));
                } else {
                    if (this.mayHaveSideEffects(objExpression)) {
                        this.traverseNode(objExpression, scope);
                    } else {
                        builder.addContinuation(new Continuation(objExpression, scope));
                    }
                    this.considerForIndependentRemoval(builder.buildAnonymousPrototypeNamedPropertyAssign(assignNode, lhs.getString()));
                }
            } else if (getPropLhs.isThis()) {
                RemovableBuilder builder = new RemovableBuilder().setIsThisDotPropertyReference(true);
                this.traverseRemovableAssignValue(valueNode, builder, scope);
                this.considerForIndependentRemoval(builder.buildNamedPropertyAssign(assignNode, lhs));
            } else {
                this.traverseNode(lhs, scope);
                this.traverseNode(valueNode, scope);
            }
        } else {
            this.traverseNode(lhs, scope);
            this.traverseNode(valueNode, scope);
        }
    }

    private void traverseRemovableAssignValue(Node valueNode, RemovableBuilder builder, Scope scope) {
        if (this.mayHaveSideEffects(valueNode) || NodeUtil.isExpressionResultUsed(valueNode.getParent())) {
            this.traverseNode(valueNode, scope);
        } else {
            builder.addContinuation(new Continuation(valueNode, scope));
        }
    }

    private boolean isNameDotPrototype(Node n) {
        return n.isGetProp() && n.getFirstChild().isName() && n.getString().equals("prototype");
    }

    private void traverseObjectPattern(Node pattern, Scope scope) {
        Preconditions.checkState((boolean)pattern.isObjectPattern(), (Object)pattern);
        block5: for (Node elem = pattern.getFirstChild(); elem != null; elem = elem.getNext()) {
            switch (elem.getToken()) {
                case COMPUTED_PROP: {
                    this.traverseIndirectAssignment(elem, elem.getSecondChild(), scope);
                    continue block5;
                }
                case STRING_KEY: {
                    if (!elem.isQuotedStringKey()) {
                        this.markPropertyNameAsPinned(elem.getString());
                    }
                    this.traverseIndirectAssignment(elem, elem.getOnlyChild(), scope);
                    continue block5;
                }
                case ITER_REST: 
                case OBJECT_REST: {
                    this.traverseIndirectAssignment(elem, elem.getOnlyChild(), scope);
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("Unexpected child of " + pattern.getToken() + ": " + elem.toStringTree());
                }
            }
        }
    }

    private void traverseIndirectAssignmentList(Node list, Scope scope) {
        Preconditions.checkState((list.isArrayPattern() || list.isParamList() ? 1 : 0) != 0, (Object)list);
        block5: for (Node elem = list.getFirstChild(); elem != null; elem = elem.getNext()) {
            switch (elem.getToken()) {
                case EMPTY: {
                    continue block5;
                }
                case ARRAY_PATTERN: 
                case OBJECT_PATTERN: 
                case NAME: 
                case GETPROP: 
                case DEFAULT_VALUE: 
                case GETELEM: {
                    this.traverseIndirectAssignment(elem, elem, scope);
                    continue block5;
                }
                case ITER_REST: 
                case OBJECT_REST: {
                    this.traverseIndirectAssignment(elem, elem.getOnlyChild(), scope);
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("Unexpected child of " + list.getToken() + ": " + elem.toStringTree());
                }
            }
        }
    }

    private void traverseIndirectAssignment(Node root, Node target, Scope scope) {
        Node rootParent = root.getParent();
        Preconditions.checkArgument((rootParent.isDestructuringPattern() || rootParent.isParamList() ? 1 : 0) != 0, (Object)rootParent);
        if (target.isDefaultValue()) {
            target = target.getFirstChild();
        }
        if (target.isGetProp()) {
            this.considerForAccessorSideEffects(target, AccessorSummary.PropertyAccessKind.SETTER_ONLY);
        }
        RemovableBuilder builder = new RemovableBuilder().addContinuation(new Continuation(root, scope));
        if (this.mayHaveSideEffects(root)) {
            this.traverseNode(root, scope);
        } else if (target.isName()) {
            VarInfo varInfo = this.traverseNameNode(target, scope);
            varInfo.addRemovable(builder.buildIndirectAssign(root, target));
        } else if (this.isNameDotPrototype(target) || RemoveUnusedCode.isThisDotProperty(target)) {
            this.considerForIndependentRemoval(builder.buildIndirectAssign(root, target));
        } else {
            this.traverseNode(root, scope);
        }
    }

    private void traverseChildren(Node n, Scope scope) {
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            this.traverseNode(c, scope);
        }
    }

    private void traverseClass(Node classNode, Scope scope) {
        Preconditions.checkArgument((boolean)classNode.isClass());
        if (NodeUtil.isClassDeclaration(classNode)) {
            this.traverseClassDeclaration(classNode, scope);
        } else {
            this.traverseClassExpression(classNode, scope);
        }
    }

    private void traverseClassDeclaration(Node classNode, Scope scope) {
        Preconditions.checkArgument((boolean)classNode.isClass());
        Node classNameNode = classNode.getFirstChild();
        Node baseClassExpression = classNameNode.getNext();
        Node classBodyNode = baseClassExpression.getNext();
        Scope classScope = this.scopeCreator.createScope(classNode, scope);
        VarInfo varInfo = this.traverseNameNode(classNameNode, scope);
        if (classNode.getParent().isExport()) {
            varInfo.setIsExplicitlyNotRemovable(() -> "exported class");
            this.traverseNode(baseClassExpression, scope);
            this.traverseChildren(classBodyNode, classScope);
        } else if (this.mayHaveSideEffects(baseClassExpression)) {
            varInfo.setIsExplicitlyNotRemovable(() -> "base class expression has side-effects");
            this.traverseNode(baseClassExpression, scope);
            this.traverseClassMembers(classBodyNode, classScope);
        } else if (this.mayHaveSideEffects(classBodyNode)) {
            varInfo.setIsExplicitlyNotRemovable(() -> "class body has side-effects");
            this.traverseNode(baseClassExpression, scope);
            this.traverseClassMembers(classBodyNode, classScope);
        } else {
            RemovableBuilder builder = new RemovableBuilder().addContinuation(new Continuation(baseClassExpression, classScope)).addContinuation(new Continuation(classBodyNode, classScope));
            varInfo.addRemovable(builder.buildClassDeclaration(classNode));
        }
    }

    private void traverseClassExpression(Node classNode, Scope scope) {
        Preconditions.checkArgument((boolean)classNode.isClass());
        Node classNameNode = classNode.getFirstChild();
        Node baseClassExpression = classNameNode.getNext();
        Node classBodyNode = baseClassExpression.getNext();
        Scope classScope = this.scopeCreator.createScope(classNode, scope);
        if (classNameNode.isName()) {
            VarInfo varInfo = this.traverseNameNode(classNameNode, classScope);
            varInfo.setHasNonLocalOrNonLiteralValue();
            varInfo.addRemovable(new RemovableBuilder().buildNamedClassExpression(classNode));
        }
        this.traverseNode(baseClassExpression, scope);
        this.traverseClassMembers(classBodyNode, classScope);
    }

    private void traverseClassMembers(Node node, Scope scope) {
        Preconditions.checkArgument((boolean)node.isClassMembers(), (Object)node);
        if (!this.removeUnusedPrototypeProperties) {
            this.traverseChildren(node, scope);
            return;
        }
        block5: for (Node member = node.getFirstChild(); member != null; member = member.getNext()) {
            switch (member.getToken()) {
                case GETTER_DEF: 
                case SETTER_DEF: 
                case MEMBER_FUNCTION_DEF: {
                    this.considerForIndependentRemoval(new RemovableBuilder().addContinuation(new Continuation(member, scope)).buildClassOrPrototypeNamedProperty(member));
                    continue block5;
                }
                case MEMBER_FIELD_DEF: {
                    if (member.hasChildren() && this.mayHaveSideEffects(member.getFirstChild())) continue block5;
                    this.considerForIndependentRemoval(new RemovableBuilder().addContinuation(new Continuation(member, scope)).buildClassOrPrototypeNamedProperty(member));
                    continue block5;
                }
                case COMPUTED_PROP: 
                case COMPUTED_FIELD_DEF: {
                    this.traverseChildren(member, scope);
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("Unexpected child of CLASS_MEMBERS: " + member.toStringTree());
                }
            }
        }
    }

    private void traverseFunction(Node function, Scope parentScope) {
        Preconditions.checkState((boolean)function.hasXChildren(3), (Object)function);
        Preconditions.checkState((boolean)function.isFunction(), (Object)function);
        Node paramlist = NodeUtil.getFunctionParameters(function);
        Node body = function.getLastChild();
        Preconditions.checkState((body.getNext() == null && body.isBlock() ? 1 : 0) != 0, (Object)body);
        Scope fparamScope = this.scopeCreator.createScope(function, parentScope);
        Scope fbodyScope = this.scopeCreator.createScope(body, fparamScope);
        Node nameNode = function.getFirstChild();
        if (!nameNode.getString().isEmpty()) {
            VarInfo varInfo = this.traverseNameNode(nameNode, fparamScope);
            if (NodeUtil.isExpressionResultUsed(function)) {
                varInfo.setHasNonLocalOrNonLiteralValue();
            }
        }
        this.traverseNode(paramlist, fparamScope);
        this.traverseChildren(body, fbodyScope);
        this.allFunctionParamScopes.add(fparamScope);
    }

    private boolean canRemoveParameters(Node parameterList) {
        Preconditions.checkState((boolean)parameterList.isParamList());
        Node function = parameterList.getParent();
        return this.removeGlobals && !NodeUtil.isGetOrSetKey(function.getParent());
    }

    private void removeUnreferencedFunctionArgs(Scope fparamScope) {
        if (!this.removeGlobals) {
            return;
        }
        Node function = fparamScope.getRootNode();
        Preconditions.checkState((boolean)function.isFunction());
        if (NodeUtil.isGetOrSetKey(function.getParent())) {
            return;
        }
        Node argList = NodeUtil.getFunctionParameters(function);
        this.maybeRemoveUnusedTrailingParameters(argList, fparamScope);
        this.markUnusedParameters(argList, fparamScope);
    }

    private void markPropertyNameAsPinned(String propertyName) {
        if (this.pinnedPropertyNames.add(propertyName)) {
            for (Removable removable : this.removablesForPropertyNames.removeAll((Object)propertyName)) {
                removable.applyContinuations();
            }
        }
    }

    private void considerForIndependentRemoval(Removable removable) {
        if (removable.isNamedProperty()) {
            String propertyName = removable.getPropertyName();
            if (this.pinnedPropertyNames.contains(propertyName) || this.codingConvention.isExported(propertyName, false)) {
                removable.applyContinuations();
            } else if (this.isIndependentlyRemovable(removable)) {
                this.removablesForPropertyNames.put((Object)propertyName, (Object)removable);
            } else {
                removable.applyContinuations();
                this.markPropertyNameAsPinned(propertyName);
            }
        } else {
            removable.applyContinuations();
        }
    }

    private boolean considerForAccessorSideEffects(Node getprop, AccessorSummary.PropertyAccessKind usage) {
        Preconditions.checkState((boolean)NodeUtil.isNormalOrOptChainGetProp(getprop), (Object)getprop);
        String propName = getprop.getString();
        AccessorSummary.PropertyAccessKind recorded = this.compiler.getAccessorSummary().getKind(propName);
        if (recorded.hasGetter() && usage.hasGetter() && !this.assumeGettersArePure || recorded.hasSetter() && usage.hasSetter()) {
            this.markPropertyNameAsPinned(propName);
            return true;
        }
        return false;
    }

    private boolean isIndependentlyRemovable(Removable removable) {
        if (removable.isPrototypeProperty()) {
            return this.removeUnusedPrototypeProperties;
        }
        if (removable.isObjectDefinePropertiesDefinition()) {
            return this.removeUnusedObjectDefinePropertiesDefinitions;
        }
        if (removable.isThisDotPropertyReference()) {
            return this.removeUnusedThisProperties;
        }
        if (removable.isStaticProperty()) {
            return this.removeUnusedThisProperties;
        }
        return false;
    }

    private void markUnusedParameters(Node paramList, Scope fparamScope) {
        Preconditions.checkArgument((boolean)paramList.isParamList(), (Object)paramList);
        for (Node param = paramList.getFirstChild(); param != null; param = param.getNext()) {
            VarInfo varInfo;
            Node paramNameNode;
            if (param.isUnusedParameter() || (paramNameNode = RemoveUnusedCode.nameOfParam(param)) == null || !(varInfo = this.traverseNameNode(paramNameNode, fparamScope)).isRemovable()) continue;
            param.setUnusedParameter(true);
            this.compiler.reportChangeToEnclosingScope(paramList);
            this.removalLog.log(RemovalLogRecord.forMarkingNamedArg(paramNameNode, paramList));
        }
    }

    private void maybeRemoveUnusedTrailingParameters(Node argList, Scope fparamScope) {
        Node lastArg;
        Preconditions.checkArgument((boolean)argList.isParamList(), (Object)argList);
        while ((lastArg = argList.getLastChild()) != null) {
            Node argNode = lastArg;
            if (lastArg.isDefaultValue()) {
                argNode = lastArg.getFirstChild();
                if (this.mayHaveSideEffects(lastArg.getLastChild())) break;
            }
            if (argNode.isRest()) {
                argNode = argNode.getFirstChild();
            }
            if (argNode.isDestructuringPattern()) {
                if (argNode.hasChildren()) break;
                NodeUtil.deleteNode(lastArg, this.compiler);
                this.removalLog.log(RemovalLogRecord.forDestructuringArg(argList));
                continue;
            }
            VarInfo varInfo = this.getVarInfo(this.getVarForNameNode(argNode, fparamScope));
            if (!varInfo.isRemovable()) break;
            NodeUtil.deleteNode(lastArg, this.compiler);
            this.removalLog.log(RemovalLogRecord.forNamedArg(argNode, argList));
        }
    }

    private VarInfo traverseVar(Var var) {
        Preconditions.checkNotNull((Object)var);
        if (this.removeLocalVars && var.isArguments()) {
            Scope functionScope = (Scope)((Scope)var.getScope()).getClosestHoistScope();
            Node paramList = NodeUtil.getFunctionParameters(functionScope.getRootNode());
            for (Node param = paramList.getFirstChild(); param != null; param = param.getNext()) {
                Node lValue = RemoveUnusedCode.nameOfParam(param);
                if (lValue == null) continue;
                this.getVarInfo(this.getVarForNameNode(lValue, functionScope)).setIsExplicitlyNotRemovable(() -> "parameter in function using arguments");
            }
            return this.canonicalUnremovableVarInfo;
        }
        return this.getVarInfo(var);
    }

    private static @Nullable Node nameOfParam(Node param) {
        switch (param.getToken()) {
            case NAME: {
                return param;
            }
            case DEFAULT_VALUE: {
                return RemoveUnusedCode.nameOfParam(param.getFirstChild());
            }
            case ITER_REST: {
                return RemoveUnusedCode.nameOfParam(param.getOnlyChild());
            }
            case ARRAY_PATTERN: 
            case OBJECT_PATTERN: {
                return null;
            }
        }
        throw new IllegalStateException("Unexpected child of PARAM_LIST: " + param.toStringTree());
    }

    private VarInfo getVarInfo(Var var) {
        Preconditions.checkNotNull((Object)var);
        boolean isGlobal = var.isGlobal();
        if (var.isExtern()) {
            this.unremovableLog.log(() -> SimpleFormat.format("%s: extern", var.getName()));
            return this.canonicalUnremovableVarInfo;
        }
        if (this.codingConvention.isExported(var.getName(), !isGlobal)) {
            this.unremovableLog.log(() -> SimpleFormat.format("%s: exported by convention", var.getName()));
            return this.canonicalUnremovableVarInfo;
        }
        if (var.isArguments()) {
            return this.canonicalUnremovableVarInfo;
        }
        VarInfo varInfo = this.varInfoMap.get(var);
        if (varInfo == null) {
            varInfo = new RealVarInfo(var.getName());
            if (var.getParentNode().isParamList()) {
                varInfo.setHasNonLocalOrNonLiteralValue();
            }
            if (!this.removeGlobals && isGlobal) {
                varInfo.setIsExplicitlyNotRemovable(() -> "not removing globals");
            } else if (!this.removeLocalVars && !isGlobal) {
                varInfo.setIsExplicitlyNotRemovable(() -> "not removing locals");
            }
            this.varInfoMap.put(var, varInfo);
        }
        return varInfo;
    }

    private void removeUnreferencedVarsAndPolyfills() {
        for (Map.Entry<Var, VarInfo> entry : this.varInfoMap.entrySet()) {
            Var var = entry.getKey();
            VarInfo varInfo = entry.getValue();
            if (!varInfo.isRemovable()) continue;
            this.removalLog.log(RemovalLogRecord.forVar(var));
            varInfo.removeAllRemovables();
            Node nameNode = var.getNameNode();
            Node toRemove = nameNode.getParent();
            if (toRemove == null || RemoveUnusedCode.alreadyRemoved(toRemove)) continue;
            if (NodeUtil.isFunctionExpression(toRemove)) {
                if (this.preserveFunctionExpressionNames) continue;
                Node fnNameNode = toRemove.getFirstChild();
                this.compiler.reportChangeToEnclosingScope(fnNameNode);
                fnNameNode.setString("");
                continue;
            }
            Preconditions.checkState((toRemove.isParamList() || toRemove.getParent().isParamList() && (toRemove.isDefaultValue() || toRemove.isRest()) ? 1 : 0) != 0, (String)"unremoved code: %s", (Object)toRemove);
        }
        Iterator iter = this.polyfills.values().iterator();
        while (iter.hasNext()) {
            PolyfillInfo polyfill = (PolyfillInfo)iter.next();
            if (!polyfill.isRemovable) continue;
            this.removalLog.log(RemovalLogRecord.forPolyfill(polyfill));
            polyfill.removable.remove(this.compiler);
            iter.remove();
        }
    }

    private static boolean isThisDotProperty(Node n) {
        return NodeUtil.isNormalOrOptChainGetProp(n) && n.getFirstChild().isThis();
    }

    private static boolean isDotPrototypeDotProperty(Node n) {
        return NodeUtil.isNormalOrOptChainGetProp(n) && RemoveUnusedCode.isDotPrototype(n.getFirstChild());
    }

    private static Node maybeUnwrapQnameOrDefaultValueNode(Node targetNode, Node valueNode) {
        Node lhsOfOr;
        if (valueNode.isOr() && targetNode.isQualifiedName() && (lhsOfOr = (Node)Preconditions.checkNotNull((Object)valueNode.getFirstChild())).isEquivalentTo(targetNode)) {
            return valueNode.getLastChild();
        }
        return valueNode;
    }

    private boolean mayHaveSideEffects(Node node) {
        JSDocInfo jsDocInfo;
        JSDocInfo jSDocInfo = jsDocInfo = node.isCall() ? node.getJSDocInfo() : null;
        if (jsDocInfo != null && jsDocInfo.isPureOrBreakMyCode()) {
            return false;
        }
        return this.astAnalyzer.mayHaveSideEffects(node);
    }

    private static boolean alreadyRemoved(Node n) {
        Node parent = n.getParent();
        if (parent == null) {
            return true;
        }
        if (parent.isRoot()) {
            return false;
        }
        return RemoveUnusedCode.alreadyRemoved(parent);
    }

    private PolyfillInfo createPolyfillInfo(Node call, Scope scope, String name) {
        Preconditions.checkState((boolean)call.getParent().isExprResult());
        RemovableBuilder builder = new RemovableBuilder();
        for (Node n = call.getFirstChild().getNext(); n != null; n = n.getNext()) {
            builder.addContinuation(new Continuation(n, scope));
        }
        Polyfill removable = builder.buildPolyfill(call.getParent());
        int lastDot = name.lastIndexOf(".");
        if (lastDot < 0) {
            return new GlobalPolyfillInfo(removable, name);
        }
        String owner = name.substring(0, lastDot);
        String prop = name.substring(lastDot + 1);
        if (owner.endsWith(DOT_PROTOTYPE)) {
            owner = owner.substring(0, owner.length() - DOT_PROTOTYPE.length());
            return new PrototypePropertyPolyfillInfo(removable, prop, owner);
        }
        return new StaticPropertyPolyfillInfo(removable, prop, owner);
    }

    void removeExpressionCompletely(Node expression) {
        Preconditions.checkState((!NodeUtil.isExpressionResultUsed(expression) ? 1 : 0) != 0, (Object)expression);
        Node parent = expression.getParent();
        if (parent.isExprResult()) {
            NodeUtil.deleteNode(parent, this.compiler);
        } else if (parent.isComma()) {
            Node otherChild = expression.getNext();
            if (otherChild == null) {
                otherChild = expression.getPrevious();
            }
            this.replaceNodeWith(parent, otherChild.detach());
        } else {
            this.replaceNodeWith(expression, IR.number(0.0).srcref(expression));
        }
    }

    void replaceNodeWith(Node n, Node replacement) {
        this.compiler.reportChangeToEnclosingScope(n);
        n.replaceWith(replacement);
        NodeUtil.markFunctionsDeleted(n, this.compiler);
    }

    private class VanillaForNameDeclaration
    extends Removable {
        private final Node nameNode;

        private VanillaForNameDeclaration(RemovableBuilder builder, Node nameNode) {
            super(nameNode, builder);
            this.nameNode = nameNode;
        }

        @Override
        void removeInternal(AbstractCompiler compiler) {
            Node declaration = (Node)Preconditions.checkNotNull((Object)this.nameNode.getParent());
            compiler.reportChangeToEnclosingScope(declaration);
            if (this.nameNode.getPrevious() == null && this.nameNode.getNext() == null) {
                declaration.replaceWith(IR.empty().srcref(declaration));
            } else {
                this.nameNode.detach();
            }
            NodeUtil.markFunctionsDeleted(this.nameNode, compiler);
        }
    }

    private class PrototypePropertyPolyfillInfo
    extends PolyfillInfo {
        final String polyfillOwnerName;

        PrototypePropertyPolyfillInfo(Polyfill removable, String key, String polyfillOwnerName) {
            super(removable, key);
            this.polyfillOwnerName = (String)Preconditions.checkNotNull((Object)polyfillOwnerName);
        }

        @Override
        String getName() {
            return this.polyfillOwnerName + ".prototype." + this.key;
        }

        @Override
        void considerPossibleReferenceInternal(Node possiblyReferencingNode) {
            if (NodeUtil.isNormalOrOptChainGetProp(possiblyReferencingNode)) {
                this.isRemovable = false;
            }
        }
    }

    private class StaticPropertyPolyfillInfo
    extends PolyfillInfo {
        final String polyfillOwnerName;

        StaticPropertyPolyfillInfo(Polyfill removable, String key, String ownerName) {
            super(removable, key);
            this.polyfillOwnerName = (String)Preconditions.checkNotNull((Object)ownerName);
        }

        @Override
        String getName() {
            return this.polyfillOwnerName + "." + this.key;
        }

        @Override
        void considerPossibleReferenceInternal(Node possiblyReferencingNode) {
            if (NodeUtil.isNormalOrOptChainGetProp(possiblyReferencingNode)) {
                this.isRemovable = false;
            }
        }
    }

    private class GlobalPolyfillInfo
    extends PolyfillInfo {
        GlobalPolyfillInfo(Polyfill removable, String name) {
            super(removable, name);
        }

        @Override
        void considerPossibleReferenceInternal(Node possiblyReferencingNode) {
            if (possiblyReferencingNode.isName()) {
                this.isRemovable = false;
            } else if (NodeUtil.isNormalOrOptChainGetProp(possiblyReferencingNode)) {
                this.isRemovable = false;
            }
        }
    }

    private abstract class PolyfillInfo {
        final Polyfill removable;
        final String key;
        boolean isRemovable = true;

        PolyfillInfo(Polyfill removable, String key) {
            this.removable = removable;
            this.key = key;
        }

        void considerPossibleReference(Node n) {
            if (this.isRemovable && !RemoveUnusedCode.this.guardedUsages.contains(n)) {
                this.considerPossibleReferenceInternal(n);
                if (!this.isRemovable) {
                    this.removable.applyContinuations();
                }
            }
        }

        String getName() {
            return this.key;
        }

        abstract void considerPossibleReferenceInternal(Node var1);
    }

    private final class RealVarInfo
    implements VarInfo {
        final String varName;
        final List<Removable> removables = new ArrayList<Removable>();
        boolean isEntirelyRemovable = true;
        boolean hasNonLocalOrNonLiteralValue = false;
        boolean hasFunctionOrClassLiteralValue = false;
        boolean requiresLocalLiteralValueForRemoval = false;

        public RealVarInfo(String varName) {
            this.varName = varName;
        }

        @Override
        public void addRemovable(Removable removable) {
            if (removable.isVariableAssignment()) {
                if (removable.isAssignedValueLocal()) {
                    Node localValue = removable.getLocalAssignedValue();
                    if (localValue != null && (localValue.isFunction() || localValue.isClass())) {
                        this.hasFunctionOrClassLiteralValue = true;
                    }
                } else {
                    this.hasNonLocalOrNonLiteralValue = true;
                }
            } else if (removable.isPrototypeAssignment() && !removable.isAssignedValueLocal()) {
                this.hasNonLocalOrNonLiteralValue = true;
            }
            if (removable.preventsRemovalOfVariableWithNonLocalValueOrPrototype()) {
                this.requiresLocalLiteralValueForRemoval = true;
            }
            if (this.hasNonLocalOrNonLiteralValue && this.requiresLocalLiteralValueForRemoval) {
                this.setIsExplicitlyNotRemovable(() -> "hasNonLocalOrNonLiteralValue && requiresLocalLiteralValueForRemoval");
            }
            if (this.isEntirelyRemovable) {
                this.removables.add(removable);
            } else {
                RemoveUnusedCode.this.considerForIndependentRemoval(removable);
            }
        }

        @Override
        public boolean isRemovable() {
            return this.isEntirelyRemovable;
        }

        @Override
        public void setIsExplicitlyNotRemovable(Supplier<String> reasonSupplier) {
            if (this.isEntirelyRemovable) {
                this.isEntirelyRemovable = false;
                RemoveUnusedCode.this.unremovableLog.log(SimpleFormat.format("%s: %s", this.varName, reasonSupplier.get()));
                for (Removable r : this.removables) {
                    RemoveUnusedCode.this.considerForIndependentRemoval(r);
                }
                this.removables.clear();
            }
        }

        @Override
        public void setHasNonLocalOrNonLiteralValue() {
            this.hasNonLocalOrNonLiteralValue = true;
        }

        @Override
        public boolean hasFunctionOrClassLiteralValue() {
            return this.hasFunctionOrClassLiteralValue;
        }

        @Override
        public void removeAllRemovables() {
            Preconditions.checkState((boolean)this.isEntirelyRemovable);
            for (Removable removable : this.removables) {
                removable.remove(RemoveUnusedCode.this.compiler);
            }
            this.removables.clear();
        }
    }

    private final class CanonicalUnremovableVarInfo
    implements VarInfo {
        private CanonicalUnremovableVarInfo() {
        }

        @Override
        public void addRemovable(Removable removable) {
            RemoveUnusedCode.this.considerForIndependentRemoval(removable);
        }

        @Override
        public boolean isRemovable() {
            return false;
        }

        @Override
        public void setIsExplicitlyNotRemovable(Supplier<String> reasonSupplier) {
        }

        @Override
        public void setHasNonLocalOrNonLiteralValue() {
        }

        @Override
        public boolean hasFunctionOrClassLiteralValue() {
            return false;
        }

        @Override
        public void removeAllRemovables() {
        }
    }

    private static interface VarInfo {
        public void addRemovable(Removable var1);

        public boolean isRemovable();

        public void setIsExplicitlyNotRemovable(Supplier<String> var1);

        public void setHasNonLocalOrNonLiteralValue();

        public boolean hasFunctionOrClassLiteralValue();

        public void removeAllRemovables();
    }

    private class ClassSetupCall
    extends Removable {
        final Node callNode;
        final boolean classDefiningCall;

        ClassSetupCall(RemovableBuilder builder, Node callNode, boolean classDefiningCall) {
            super(null, builder);
            this.callNode = callNode;
            this.classDefiningCall = classDefiningCall;
        }

        @Override
        public void removeInternal(AbstractCompiler compiler) {
            Node parent = this.callNode.getParent();
            Node replacement = null;
            this.callNode.removeFirstChild();
            Node arg = this.callNode.getLastChild();
            while (arg != null) {
                arg.detach();
                if (!this.classDefiningCall && RemoveUnusedCode.this.mayHaveSideEffects(arg)) {
                    replacement = replacement == null ? arg : IR.comma(arg, replacement).srcref(this.callNode);
                } else {
                    NodeUtil.markFunctionsDeleted(arg, compiler);
                }
                arg = this.callNode.getLastChild();
            }
            if (replacement != null) {
                RemoveUnusedCode.this.replaceNodeWith(this.callNode, replacement);
            } else if (parent.isExprResult()) {
                NodeUtil.deleteNode(parent, compiler);
            } else if (parent.isComma() || parent.isAnd() || parent.isOr()) {
                if (parent.getFirstChild() == this.callNode) {
                    Node rhs = (Node)Preconditions.checkNotNull((Object)this.callNode.getNext());
                    compiler.reportChangeToEnclosingScope(parent);
                    parent.replaceWith(rhs.detach());
                } else {
                    Node lhs = parent.getFirstChild();
                    compiler.reportChangeToEnclosingScope(parent);
                    parent.replaceWith(lhs.detach());
                }
            } else {
                compiler.reportChangeToEnclosingScope(parent);
                this.callNode.replaceWith(IR.number(0.0));
            }
        }

        @Override
        public boolean preventsRemovalOfVariableWithNonLocalValueOrPrototype() {
            return true;
        }

        public String toString() {
            return "ClassSetupCall:" + this.callNode;
        }
    }

    private class AnonymousPrototypeNamedPropertyAssign
    extends Removable {
        final Node assignNode;

        AnonymousPrototypeNamedPropertyAssign(RemovableBuilder builder, Node assignNode) {
            super(assignNode.getFirstChild(), builder);
            Preconditions.checkNotNull((Object)builder.propertyName);
            Preconditions.checkArgument((boolean)assignNode.isAssign(), (Object)assignNode);
            this.assignNode = assignNode;
        }

        @Override
        void removeInternal(AbstractCompiler compiler) {
            if (RemoveUnusedCode.alreadyRemoved(this.assignNode)) {
                return;
            }
            Node parent = this.assignNode.getParent();
            compiler.reportChangeToEnclosingScope(parent);
            Node lhs = this.assignNode.getFirstChild();
            Node rhs = this.assignNode.getLastChild();
            Preconditions.checkState((boolean)lhs.isGetProp(), (Object)lhs);
            Node objDotPrototype = lhs.getFirstChild();
            Preconditions.checkState((boolean)objDotPrototype.isGetProp(), (Object)objDotPrototype);
            Node objExpression = objDotPrototype.getFirstChild();
            Preconditions.checkState((boolean)objDotPrototype.getString().equals("prototype"), (Object)objDotPrototype);
            boolean mustPreserveRhs = RemoveUnusedCode.this.mayHaveSideEffects(rhs) || NodeUtil.isExpressionResultUsed(this.assignNode);
            boolean mustPreserveObjExpression = RemoveUnusedCode.this.mayHaveSideEffects(objExpression);
            if (mustPreserveRhs && mustPreserveObjExpression) {
                Node replacement = IR.comma(objExpression.detach(), rhs.detach()).srcref(this.assignNode);
                RemoveUnusedCode.this.replaceNodeWith(this.assignNode, replacement);
            } else if (mustPreserveObjExpression) {
                RemoveUnusedCode.this.replaceNodeWith(this.assignNode, objExpression.detach());
            } else if (mustPreserveRhs) {
                RemoveUnusedCode.this.replaceNodeWith(this.assignNode, rhs.detach());
            } else {
                RemoveUnusedCode.this.removeExpressionCompletely(this.assignNode);
            }
        }

        @Override
        boolean isPrototypeProperty() {
            return true;
        }

        public String toString() {
            return "AnonymousPrototypeNamedPropertyAssign:" + this.assignNode;
        }
    }

    private class Assign
    extends Removable {
        final Node assignNode;
        final Kind kind;
        final @Nullable VarInfo varInfo;

        Assign(RemovableBuilder builder, Node assignNode, @Nullable Kind kind, @Nullable Node propertyNode, VarInfo varInfo) {
            super(assignNode.getFirstChild(), builder);
            Preconditions.checkArgument((boolean)NodeUtil.isAssignmentOp(assignNode), (Object)assignNode);
            if (kind == Kind.VARIABLE) {
                Preconditions.checkArgument((propertyNode == null ? 1 : 0) != 0, (String)"got property node for simple variable assignment: %s", (Object)propertyNode);
                Preconditions.checkArgument((varInfo != null ? 1 : 0) != 0, (String)"missing VarInfo for variable assignment: %s", (Object)propertyNode);
            } else {
                Preconditions.checkArgument((propertyNode != null ? 1 : 0) != 0, (Object)"missing property node");
                if (kind == Kind.NAMED_PROPERTY) {
                    Preconditions.checkArgument((boolean)propertyNode.isGetProp(), (String)"property name is not a GETPROP: %s", (Object)propertyNode);
                }
            }
            this.assignNode = assignNode;
            this.kind = kind;
            this.varInfo = varInfo;
        }

        @Override
        boolean isVariableAssignment() {
            return this.kind == Kind.VARIABLE;
        }

        @Override
        boolean isAssignedValueLocal() {
            return this.getLocalAssignedValue() != null;
        }

        @Override
        @Nullable Node getLocalAssignedValue() {
            if (NodeUtil.isExpressionResultUsed(this.assignNode)) {
                return null;
            }
            Node valueNode = RemoveUnusedCode.maybeUnwrapQnameOrDefaultValueNode(this.assignNode.getFirstChild(), this.assignNode.getLastChild());
            if (NodeUtil.evaluatesToLocalValue(valueNode)) {
                return valueNode;
            }
            return null;
        }

        @Override
        public boolean preventsRemovalOfVariableWithNonLocalValueOrPrototype() {
            return this.isNamedPropertyAssignment() || this.isComputedPropertyAssignment();
        }

        @Override
        boolean isNamedPropertyAssignment() {
            return this.kind == Kind.NAMED_PROPERTY;
        }

        boolean isComputedPropertyAssignment() {
            return this.kind == Kind.COMPUTED_PROPERTY;
        }

        @Override
        public boolean isStaticProperty() {
            if (this.kind == Kind.NAMED_PROPERTY && this.varInfo != null && this.varInfo.hasFunctionOrClassLiteralValue()) {
                return this.targetNode.getFirstChild().isName();
            }
            return false;
        }

        @Override
        public void removeInternal(AbstractCompiler compiler) {
            boolean mustPreserveGetElmExpr;
            if (RemoveUnusedCode.alreadyRemoved(this.assignNode)) {
                return;
            }
            Node parent = this.assignNode.getParent();
            compiler.reportChangeToEnclosingScope(parent);
            Node lhs = this.assignNode.getFirstChild();
            Node rhs = this.assignNode.getSecondChild();
            boolean mustPreserveRhs = RemoveUnusedCode.this.mayHaveSideEffects(rhs) || NodeUtil.isExpressionResultUsed(this.assignNode);
            boolean bl = mustPreserveGetElmExpr = lhs.isGetElem() && RemoveUnusedCode.this.mayHaveSideEffects(lhs.getLastChild());
            if (mustPreserveRhs && mustPreserveGetElmExpr) {
                Node replacement = IR.comma(lhs.getLastChild().detach(), rhs.detach()).srcref(this.assignNode);
                RemoveUnusedCode.this.replaceNodeWith(this.assignNode, replacement);
            } else if (mustPreserveGetElmExpr) {
                RemoveUnusedCode.this.replaceNodeWith(this.assignNode, lhs.getLastChild().detach());
            } else if (mustPreserveRhs) {
                RemoveUnusedCode.this.replaceNodeWith(this.assignNode, rhs.detach());
            } else {
                RemoveUnusedCode.this.removeExpressionCompletely(this.assignNode);
            }
        }

        public String toString() {
            return "Assign:" + this.assignNode;
        }
    }

    static enum Kind {
        VARIABLE,
        NAMED_PROPERTY,
        COMPUTED_PROPERTY;

    }

    private class NameDeclarationStatement
    extends Removable {
        private final Node declarationStatement;

        public NameDeclarationStatement(RemovableBuilder builder, Node declarationStatement) {
            super(declarationStatement.getOnlyChild(), builder);
            Preconditions.checkArgument((boolean)NodeUtil.isNameDeclaration(declarationStatement), (Object)declarationStatement);
            this.declarationStatement = declarationStatement;
        }

        @Override
        void removeInternal(AbstractCompiler compiler) {
            Node nameNode = this.declarationStatement.getOnlyChild();
            Node valueNode = nameNode.getFirstChild();
            if (valueNode != null && RemoveUnusedCode.this.mayHaveSideEffects(valueNode)) {
                compiler.reportChangeToEnclosingScope(this.declarationStatement);
                valueNode.detach();
                this.declarationStatement.replaceWith(IR.exprResult(valueNode).srcref(valueNode));
            } else {
                NodeUtil.deleteNode(this.declarationStatement, compiler);
            }
        }

        @Override
        boolean isVariableAssignment() {
            return true;
        }

        @Override
        boolean isAssignedValueLocal() {
            Node nameNode = this.declarationStatement.getOnlyChild();
            Node initialValueNode = nameNode.getFirstChild();
            if (initialValueNode == null) {
                return true;
            }
            Node valueNode = RemoveUnusedCode.maybeUnwrapQnameOrDefaultValueNode(nameNode, initialValueNode);
            return NodeUtil.evaluatesToLocalValue(valueNode);
        }

        @Override
        @Nullable Node getLocalAssignedValue() {
            Node nameNode = this.declarationStatement.getOnlyChild();
            Node initialValueNode = nameNode.getFirstChild();
            if (initialValueNode == null) {
                return null;
            }
            Node valueNode = RemoveUnusedCode.maybeUnwrapQnameOrDefaultValueNode(nameNode, initialValueNode);
            return NodeUtil.evaluatesToLocalValue(valueNode) ? valueNode : null;
        }

        public String toString() {
            return "NameDeclStmt:" + this.declarationStatement;
        }
    }

    private class FunctionDeclaration
    extends Removable {
        final Node functionDeclarationNode;

        FunctionDeclaration(RemovableBuilder builder, Node functionDeclarationNode) {
            super(functionDeclarationNode.getFirstChild(), builder);
            this.functionDeclarationNode = functionDeclarationNode;
        }

        @Override
        public void removeInternal(AbstractCompiler compiler) {
            NodeUtil.deleteNode(this.functionDeclarationNode, compiler);
        }

        @Override
        boolean isVariableAssignment() {
            return true;
        }

        @Override
        boolean isAssignedValueLocal() {
            return true;
        }

        @Override
        @Nullable Node getLocalAssignedValue() {
            return this.functionDeclarationNode;
        }

        public String toString() {
            return "FunctionDeclaration:" + this.functionDeclarationNode;
        }
    }

    private class ObjectDefinePropertiesDefinition
    extends Removable {
        final Node propertyNode;

        ObjectDefinePropertiesDefinition(RemovableBuilder builder, Node propertyNode) {
            super(null, builder);
            this.propertyNode = propertyNode;
        }

        @Override
        public boolean isObjectDefinePropertiesDefinition() {
            return true;
        }

        @Override
        void removeInternal(AbstractCompiler compiler) {
            NodeUtil.deleteNode(this.propertyNode, compiler);
        }
    }

    private class ClassOrPrototypeNamedProperty
    extends Removable {
        final Node propertyNode;

        ClassOrPrototypeNamedProperty(RemovableBuilder builder, Node propertyNode) {
            super(null, builder);
            this.propertyNode = propertyNode;
        }

        @Override
        public boolean isStaticProperty() {
            return this.propertyNode.isStaticMember();
        }

        @Override
        boolean isClassOrPrototypeNamedProperty() {
            return !this.isStaticProperty();
        }

        @Override
        void removeInternal(AbstractCompiler compiler) {
            NodeUtil.deleteNode(this.propertyNode, compiler);
        }

        public String toString() {
            return "ClassOrPrototypeNamedProperty:" + this.propertyNode;
        }
    }

    private class NamedClassExpression
    extends Removable {
        final Node classNode;

        NamedClassExpression(RemovableBuilder builder, Node classNode) {
            super(classNode.getFirstChild(), builder);
            this.classNode = classNode;
        }

        @Override
        public void removeInternal(AbstractCompiler compiler) {
            Node nameNode;
            if (!RemoveUnusedCode.alreadyRemoved(this.classNode) && !(nameNode = this.classNode.getFirstChild()).isEmpty()) {
                nameNode.replaceWith(IR.empty().srcref(nameNode));
                compiler.reportChangeToEnclosingScope(this.classNode);
            }
        }

        public String toString() {
            return "NamedClassExpression:" + this.classNode;
        }
    }

    private class ClassDeclaration
    extends Removable {
        final Node classDeclarationNode;

        ClassDeclaration(RemovableBuilder builder, Node classDeclarationNode) {
            super(classDeclarationNode.getFirstChild(), builder);
            this.classDeclarationNode = classDeclarationNode;
        }

        @Override
        public void removeInternal(AbstractCompiler compiler) {
            NodeUtil.deleteNode(this.classDeclarationNode, compiler);
        }

        @Override
        boolean isVariableAssignment() {
            return true;
        }

        @Override
        boolean isAssignedValueLocal() {
            return true;
        }

        @Override
        @Nullable Node getLocalAssignedValue() {
            return this.classDeclarationNode;
        }

        public String toString() {
            return "ClassDeclaration:" + this.classDeclarationNode;
        }
    }

    private class Polyfill
    extends Removable {
        final Node polyfillNode;

        Polyfill(RemovableBuilder builder, Node polyfillNode) {
            super(null, builder);
            this.polyfillNode = polyfillNode;
        }

        @Override
        public void removeInternal(AbstractCompiler compiler) {
            NodeUtil.deleteNode(this.polyfillNode, compiler);
        }

        public String toString() {
            return "Polyfill:" + this.polyfillNode;
        }
    }

    private class IndirectAssign
    extends Removable {
        final Node root;

        IndirectAssign(RemovableBuilder builder, Node root, Node targetNode) {
            super(targetNode, builder);
            Node rootParent = root.getParent();
            Preconditions.checkState((rootParent.isDestructuringPattern() || rootParent.isParamList() ? 1 : 0) != 0, (Object)rootParent);
            Preconditions.checkState((targetNode.isName() || targetNode.isGetProp() ? 1 : 0) != 0, (Object)targetNode);
            this.root = root;
        }

        @Override
        boolean isVariableAssignment() {
            return this.targetNode.isName();
        }

        @Override
        boolean isThisDotPropertyReference() {
            return RemoveUnusedCode.isThisDotProperty(this.targetNode);
        }

        @Override
        boolean isNamedProperty() {
            return this.targetNode.isGetProp();
        }

        @Override
        public boolean preventsRemovalOfVariableWithNonLocalValueOrPrototype() {
            if (this.targetNode.isGetProp()) {
                Node getPropLhs = this.targetNode.getFirstChild();
                return getPropLhs.isName() || RemoveUnusedCode.this.isNameDotPrototype(getPropLhs);
            }
            return false;
        }

        @Override
        boolean isNamedPropertyAssignment() {
            return this.targetNode.isGetProp();
        }

        @Override
        String getPropertyName() {
            Preconditions.checkState((boolean)this.targetNode.isGetProp(), (Object)this.targetNode);
            return this.targetNode.getString();
        }

        @Override
        public void removeInternal(AbstractCompiler compiler) {
            if (!RemoveUnusedCode.alreadyRemoved(this.targetNode)) {
                this.removeRoot();
            }
        }

        private void removeRoot() {
            Node rootParent = this.root.getParent();
            switch (rootParent.getToken()) {
                case ARRAY_PATTERN: {
                    RemoveUnusedCode.this.replaceNodeWith(this.root, IR.empty().srcref(this.root));
                    Node maybeEmpty = rootParent.getLastChild();
                    while (maybeEmpty != null && maybeEmpty.isEmpty()) {
                        maybeEmpty.detach();
                        maybeEmpty = rootParent.getLastChild();
                    }
                    RemoveUnusedCode.this.compiler.reportChangeToEnclosingScope(rootParent);
                    break;
                }
                case PARAM_LIST: {
                    if (!this.root.isDefaultValue()) {
                        return;
                    }
                    RemoveUnusedCode.this.compiler.reportChangeToEnclosingScope(rootParent);
                    Node name = this.root.getFirstChild();
                    Preconditions.checkState((boolean)name.isName());
                    if (this.root == rootParent.getLastChild() && RemoveUnusedCode.this.removeGlobals && RemoveUnusedCode.this.canRemoveParameters(rootParent)) {
                        this.root.detach();
                    } else {
                        this.root.replaceWith(name.detach());
                    }
                    NodeUtil.markFunctionsDeleted(this.root, RemoveUnusedCode.this.compiler);
                    break;
                }
                case OBJECT_PATTERN: {
                    NodeUtil.deleteNode(this.root, RemoveUnusedCode.this.compiler);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected parent of indirect assignment: " + rootParent.toStringTree());
                }
            }
        }
    }

    private class IncOrDecOp
    extends Removable {
        final Node incOrDecNode;
        final @Nullable Node toPreserve;

        IncOrDecOp(RemovableBuilder builder, @Nullable Node incOrDecNode, Node toPreserve) {
            super(incOrDecNode.getOnlyChild(), builder);
            Preconditions.checkArgument((incOrDecNode.isInc() || incOrDecNode.isDec() ? 1 : 0) != 0, (Object)incOrDecNode);
            Node arg = incOrDecNode.getOnlyChild();
            Preconditions.checkState((RemoveUnusedCode.isThisDotProperty(arg) || RemoveUnusedCode.isDotPrototypeDotProperty(arg) ? 1 : 0) != 0, (Object)arg);
            this.incOrDecNode = incOrDecNode;
            this.toPreserve = toPreserve;
        }

        @Override
        void removeInternal(AbstractCompiler compiler) {
            if (RemoveUnusedCode.alreadyRemoved(this.incOrDecNode)) {
                return;
            }
            Node arg = this.incOrDecNode.getOnlyChild();
            Preconditions.checkState((boolean)arg.isGetProp(), (Object)arg);
            if (this.toPreserve == null) {
                RemoveUnusedCode.this.removeExpressionCompletely(this.incOrDecNode);
            } else {
                RemoveUnusedCode.this.replaceNodeWith(this.incOrDecNode, this.toPreserve.detach());
            }
        }

        public String toString() {
            return "IncOrDecOp:" + this.incOrDecNode;
        }
    }

    private class InstanceofName
    extends Removable {
        final Node instanceofNode;

        InstanceofName(RemovableBuilder builder, Node instanceofNode) {
            super(null, builder);
            Preconditions.checkArgument((boolean)instanceofNode.isInstanceOf(), (Object)instanceofNode);
            this.instanceofNode = instanceofNode;
        }

        @Override
        void removeInternal(AbstractCompiler compiler) {
            if (!RemoveUnusedCode.alreadyRemoved(this.instanceofNode)) {
                Node lhs = this.instanceofNode.getFirstChild();
                Node falseNode = IR.falseNode().srcref(this.instanceofNode);
                if (RemoveUnusedCode.this.mayHaveSideEffects(lhs)) {
                    RemoveUnusedCode.this.replaceNodeWith(this.instanceofNode, IR.comma(lhs.detach(), falseNode).srcref(this.instanceofNode));
                } else {
                    RemoveUnusedCode.this.replaceNodeWith(this.instanceofNode, falseNode);
                }
            }
        }

        @Override
        public boolean preventsRemovalOfVariableWithNonLocalValueOrPrototype() {
            return true;
        }

        public String toString() {
            return "InstanceofName:" + this.instanceofNode;
        }
    }

    private class UnusedReadReference
    extends Removable {
        final Node referenceNode;

        UnusedReadReference(RemovableBuilder builder, Node referenceNode) {
            super(null, builder);
            Preconditions.checkState((RemoveUnusedCode.isThisDotProperty(referenceNode) || RemoveUnusedCode.isDotPrototypeDotProperty(referenceNode) ? 1 : 0) != 0, (Object)referenceNode);
            this.referenceNode = referenceNode;
        }

        @Override
        void removeInternal(AbstractCompiler compiler) {
            if (!RemoveUnusedCode.alreadyRemoved(this.referenceNode)) {
                if (RemoveUnusedCode.isThisDotProperty(this.referenceNode)) {
                    RemoveUnusedCode.this.removeExpressionCompletely(this.referenceNode);
                } else {
                    Preconditions.checkState((boolean)RemoveUnusedCode.isDotPrototypeDotProperty(this.referenceNode), (Object)this.referenceNode);
                    Node objExpression = this.referenceNode.getFirstFirstChild();
                    if (RemoveUnusedCode.this.mayHaveSideEffects(objExpression)) {
                        RemoveUnusedCode.this.replaceNodeWith(this.referenceNode, objExpression.detach());
                    } else {
                        RemoveUnusedCode.this.removeExpressionCompletely(this.referenceNode);
                    }
                }
            }
        }

        public String toString() {
            return "UnusedReadReference:" + this.referenceNode;
        }
    }

    private class RemovableBuilder {
        final List<Continuation> continuations = new ArrayList<Continuation>();
        @Nullable String propertyName = null;
        boolean isPrototypeDotPropertyReference = false;
        boolean isThisDotPropertyReference = false;

        private RemovableBuilder() {
        }

        @CanIgnoreReturnValue
        RemovableBuilder addContinuation(Continuation continuation) {
            this.continuations.add(continuation);
            return this;
        }

        @CanIgnoreReturnValue
        RemovableBuilder setIsPrototypeDotPropertyReference(boolean value) {
            this.isPrototypeDotPropertyReference = value;
            return this;
        }

        @CanIgnoreReturnValue
        RemovableBuilder setIsThisDotPropertyReference(boolean value) {
            this.isThisDotPropertyReference = value;
            return this;
        }

        IndirectAssign buildIndirectAssign(Node root, Node targetNode) {
            return new IndirectAssign(this, root, targetNode);
        }

        Polyfill buildPolyfill(Node polyfillNode) {
            return new Polyfill(this, polyfillNode);
        }

        ClassDeclaration buildClassDeclaration(Node classNode) {
            return new ClassDeclaration(this, classNode);
        }

        NamedClassExpression buildNamedClassExpression(Node classNode) {
            return new NamedClassExpression(this, classNode);
        }

        ClassOrPrototypeNamedProperty buildClassOrPrototypeNamedProperty(Node propertyNode) {
            Preconditions.checkArgument((propertyNode.isMemberFunctionDef() || propertyNode.isMemberFieldDef() || NodeUtil.isGetOrSetKey(propertyNode) || propertyNode.isStringKey() && !propertyNode.isQuotedStringKey() ? 1 : 0) != 0, (Object)propertyNode);
            this.propertyName = propertyNode.getString();
            return new ClassOrPrototypeNamedProperty(this, propertyNode);
        }

        ObjectDefinePropertiesDefinition buildObjectDefinePropertiesDefinition(Node propertyNode) {
            this.propertyName = propertyNode.getString();
            return new ObjectDefinePropertiesDefinition(this, propertyNode);
        }

        FunctionDeclaration buildFunctionDeclaration(Node functionNode) {
            return new FunctionDeclaration(this, functionNode);
        }

        NameDeclarationStatement buildNameDeclarationStatement(Node declarationStatement) {
            return new NameDeclarationStatement(this, declarationStatement);
        }

        Assign buildNamedPropertyAssign(Node assignNode, Node propertyNode) {
            return this.buildNamedPropertyAssign(assignNode, propertyNode, null);
        }

        Assign buildNamedPropertyAssign(Node assignNode, Node propertyNode, @Nullable VarInfo varInfo) {
            this.propertyName = propertyNode.getString();
            return new Assign(this, assignNode, Kind.NAMED_PROPERTY, propertyNode, varInfo);
        }

        Assign buildComputedPropertyAssign(Node assignNode, Node propertyNode, VarInfo varInfo) {
            return new Assign(this, assignNode, Kind.COMPUTED_PROPERTY, propertyNode, varInfo);
        }

        Assign buildVariableAssign(Node assignNode, VarInfo varInfo) {
            return new Assign(this, assignNode, Kind.VARIABLE, null, varInfo);
        }

        ClassSetupCall buildClassSetupCall(Node callNode) {
            return this.buildClassSetupCall(callNode, false);
        }

        ClassSetupCall buildClassSetupCall(Node callNode, boolean classDefiningCall) {
            return new ClassSetupCall(this, callNode, classDefiningCall);
        }

        VanillaForNameDeclaration buildVanillaForNameDeclaration(Node nameNode) {
            return new VanillaForNameDeclaration(this, nameNode);
        }

        AnonymousPrototypeNamedPropertyAssign buildAnonymousPrototypeNamedPropertyAssign(Node assignNode, String propertyName) {
            this.propertyName = propertyName;
            return new AnonymousPrototypeNamedPropertyAssign(this, assignNode);
        }

        IncOrDecOp buildIncOrDepOp(Node incOrDecOp, Node propertyNode, @Nullable Node toPreseve) {
            this.propertyName = propertyNode.getString();
            return new IncOrDecOp(this, incOrDecOp, toPreseve);
        }

        UnusedReadReference buildUnusedReadReference(Node referenceNode, Node propertyNode) {
            this.propertyName = propertyNode.getString();
            return new UnusedReadReference(this, referenceNode);
        }

        public Removable buildInstanceofName(Node instanceofNode) {
            return new InstanceofName(this, instanceofNode);
        }
    }

    private abstract class Removable {
        private final List<Continuation> continuations;
        private final @Nullable String propertyName;
        protected final @Nullable Node targetNode;
        private final boolean isPrototypeDotPropertyReference;
        private final boolean isThisDotPropertyReference;
        private boolean continuationsAreApplied = false;
        private boolean isRemoved = false;

        Removable(Node targetNode, RemovableBuilder builder) {
            this.continuations = builder.continuations;
            this.propertyName = builder.propertyName;
            this.isPrototypeDotPropertyReference = builder.isPrototypeDotPropertyReference;
            this.isThisDotPropertyReference = builder.isThisDotPropertyReference;
            this.targetNode = targetNode;
        }

        String getPropertyName() {
            return (String)Preconditions.checkNotNull((Object)this.propertyName);
        }

        abstract void removeInternal(AbstractCompiler var1);

        void remove(AbstractCompiler compiler) {
            if (!this.isRemoved) {
                this.isRemoved = true;
                this.removeInternal(compiler);
            }
        }

        public void applyContinuations() {
            if (!this.continuationsAreApplied) {
                this.continuationsAreApplied = true;
                for (Continuation c : this.continuations) {
                    RemoveUnusedCode.this.worklist.add(c);
                }
                this.continuations.clear();
            }
        }

        boolean isVariableAssignment() {
            return false;
        }

        boolean isNamedProperty() {
            return this.propertyName != null;
        }

        boolean isNamedPropertyAssignment() {
            return false;
        }

        boolean isAssignedValueLocal() {
            return false;
        }

        @Nullable Node getLocalAssignedValue() {
            return null;
        }

        boolean isPrototypeAssignment() {
            return this.isNamedPropertyAssignment() && this.propertyName.equals("prototype");
        }

        boolean isPrototypeDotPropertyReference() {
            return this.isPrototypeDotPropertyReference;
        }

        boolean isClassOrPrototypeNamedProperty() {
            return false;
        }

        boolean isPrototypeProperty() {
            return this.isPrototypeDotPropertyReference() || this.isClassOrPrototypeNamedProperty();
        }

        boolean isThisDotPropertyReference() {
            return this.isThisDotPropertyReference;
        }

        public boolean isObjectDefinePropertiesDefinition() {
            return false;
        }

        public boolean isStaticProperty() {
            return false;
        }

        public boolean preventsRemovalOfVariableWithNonLocalValueOrPrototype() {
            return false;
        }
    }

    private class Continuation {
        private final Node node;
        private final Scope scope;

        Continuation(Node node, Scope scope) {
            this.node = node;
            this.scope = scope;
        }

        void apply() {
            if (this.node.isFunction()) {
                RemoveUnusedCode.this.traverseFunction(this.node, this.scope);
            } else {
                RemoveUnusedCode.this.traverseNode(this.node, this.scope);
            }
        }
    }

    private static class RemovalLogRecord
    implements Supplier<String> {
        private final String kind;
        private final Supplier<String> nameSupplier;
        private final Supplier<String> functionNameSupplier;

        @Override
        public String get() {
            return String.join((CharSequence)"\t", this.kind, this.nameSupplier.get(), this.functionNameSupplier.get());
        }

        RemovalLogRecord(String kind, Supplier<String> nameSupplier, Supplier<String> functionNameSupplier) {
            this.kind = (String)Preconditions.checkNotNull((Object)kind);
            this.nameSupplier = (Supplier)Preconditions.checkNotNull(nameSupplier);
            this.functionNameSupplier = (Supplier)Preconditions.checkNotNull(functionNameSupplier);
        }

        RemovalLogRecord(String kind, Supplier<String> nameSupplier) {
            this(kind, nameSupplier, () -> "");
        }

        static RemovalLogRecord forProperty(String propName) {
            return new RemovalLogRecord("prop", () -> propName);
        }

        static RemovalLogRecord forVar(Var var) {
            return new RemovalLogRecord("var", var::getName);
        }

        static RemovalLogRecord forPolyfill(PolyfillInfo polyfillInfo) {
            return new RemovalLogRecord("poly", polyfillInfo::getName);
        }

        static RemovalLogRecord forNamedArg(Node nameNode, Node argList) {
            return new RemovalLogRecord("arg", nameNode::getString, RemovalLogRecord.getLoggableFunctionNameSupplier(argList));
        }

        static RemovalLogRecord forDestructuringArg(Node argList) {
            return new RemovalLogRecord("arg", () -> "<pattern>", RemovalLogRecord.getLoggableFunctionNameSupplier(argList));
        }

        static RemovalLogRecord forMarkingNamedArg(Node nameNode, Node argList) {
            return new RemovalLogRecord("argmark", nameNode::getString, RemovalLogRecord.getLoggableFunctionNameSupplier(argList));
        }

        private static Supplier<String> getLoggableFunctionNameSupplier(Node argList) {
            return () -> {
                String functionName = NodeUtil.getNearestFunctionName(((Node)Preconditions.checkNotNull((Object)argList)).getParent());
                if (functionName == null) {
                    functionName = "<anonymous>";
                }
                return functionName;
            };
        }
    }

    public static class Builder {
        private final AbstractCompiler compiler;
        private boolean removeLocalVars = false;
        private boolean removeGlobals = false;
        private boolean preserveFunctionExpressionNames = false;
        private boolean removeUnusedPrototypeProperties = false;
        private boolean removeUnusedThisProperties = false;
        private boolean removeUnusedObjectDefinePropertiesDefinitions = false;
        private boolean removeUnusedPolyfills = false;
        private boolean assumeGettersArePure = false;

        Builder(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        @CanIgnoreReturnValue
        Builder removeLocalVars(boolean value) {
            this.removeLocalVars = value;
            return this;
        }

        @CanIgnoreReturnValue
        Builder removeGlobals(boolean value) {
            this.removeGlobals = value;
            return this;
        }

        @CanIgnoreReturnValue
        Builder preserveFunctionExpressionNames(boolean value) {
            this.preserveFunctionExpressionNames = value;
            return this;
        }

        @CanIgnoreReturnValue
        Builder removeUnusedPrototypeProperties(boolean value) {
            this.removeUnusedPrototypeProperties = value;
            return this;
        }

        @CanIgnoreReturnValue
        Builder removeUnusedThisProperties(boolean value) {
            this.removeUnusedThisProperties = value;
            return this;
        }

        @CanIgnoreReturnValue
        Builder removeUnusedObjectDefinePropertiesDefinitions(boolean value) {
            this.removeUnusedObjectDefinePropertiesDefinitions = value;
            return this;
        }

        @CanIgnoreReturnValue
        Builder removeUnusedPolyfills(boolean value) {
            this.removeUnusedPolyfills = value;
            return this;
        }

        @CanIgnoreReturnValue
        Builder assumeGettersArePure(boolean value) {
            this.assumeGettersArePure = value;
            return this;
        }

        RemoveUnusedCode build() {
            return new RemoveUnusedCode(this);
        }
    }
}

