/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.base.JSCompDoubles;
import com.google.javascript.jscomp.base.Tri;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.math.BigInteger;
import org.jspecify.nullness.Nullable;

class PeepholeFoldConstants
extends AbstractPeepholeOptimization {
    static final DiagnosticType INVALID_GETELEM_INDEX_ERROR = DiagnosticType.warning("JSC_INVALID_GETELEM_INDEX_ERROR", "Array index not integer: {0}");
    static final DiagnosticType FRACTIONAL_BITWISE_OPERAND = DiagnosticType.warning("JSC_FRACTIONAL_BITWISE_OPERAND", "Fractional bitwise operand: {0}");
    private static final double MAX_FOLD_NUMBER = Math.pow(2.0, 53.0);
    private final boolean late;
    private final boolean shouldUseTypes;

    PeepholeFoldConstants(boolean late, boolean shouldUseTypes) {
        this.late = late;
        this.shouldUseTypes = shouldUseTypes;
    }

    @Override
    Node optimizeSubtree(Node subtree) {
        switch (subtree.getToken()) {
            case OPTCHAIN_CALL: 
            case CALL: {
                return this.tryFoldUselessObjectDotDefinePropertiesCall(subtree);
            }
            case NEW: {
                return this.tryFoldCtorCall(subtree);
            }
            case TYPEOF: {
                return this.tryFoldTypeof(subtree);
            }
            case ITER_SPREAD: {
                return this.tryFoldSpread(subtree);
            }
            case ARRAYLIT: 
            case OBJECTLIT: {
                return this.tryFlattenArrayOrObjectLit(subtree);
            }
            case NOT: 
            case POS: 
            case NEG: 
            case BITNOT: {
                this.tryReduceOperandsForOp(subtree);
                return this.tryFoldUnaryOperator(subtree);
            }
            case VOID: {
                return this.tryReduceVoid(subtree);
            }
            case OPTCHAIN_GETPROP: 
            case GETPROP: {
                return this.tryFoldGetProp(subtree);
            }
        }
        this.tryReduceOperandsForOp(subtree);
        return this.tryFoldBinaryOperator(subtree);
    }

    private Node tryFoldBinaryOperator(Node subtree) {
        Node left = subtree.getFirstChild();
        if (left == null) {
            return subtree;
        }
        Node right = left.getNext();
        if (right == null) {
            return subtree;
        }
        switch (subtree.getToken()) {
            case GETELEM: 
            case OPTCHAIN_GETELEM: {
                return this.tryFoldGetElem(subtree, left, right);
            }
            case INSTANCEOF: {
                return this.tryFoldInstanceof(subtree, left, right);
            }
            case AND: 
            case OR: {
                return this.tryFoldAndOr(subtree, left, right);
            }
            case COALESCE: {
                return this.tryFoldCoalesce(subtree, left, right);
            }
            case LSH: 
            case RSH: 
            case URSH: {
                return this.tryFoldShift(subtree, left, right);
            }
            case ASSIGN: {
                return this.tryFoldAssign(subtree, left, right);
            }
            case ASSIGN_BITOR: 
            case ASSIGN_BITXOR: 
            case ASSIGN_BITAND: 
            case ASSIGN_LSH: 
            case ASSIGN_RSH: 
            case ASSIGN_URSH: 
            case ASSIGN_ADD: 
            case ASSIGN_SUB: 
            case ASSIGN_MUL: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: 
            case ASSIGN_EXPONENT: {
                return this.tryUnfoldAssignOp(subtree, left, right);
            }
            case ADD: {
                return this.tryFoldAdd(subtree, left, right);
            }
            case SUB: 
            case DIV: 
            case MOD: 
            case EXPONENT: {
                return this.tryFoldArithmeticOp(subtree, left, right);
            }
            case MUL: 
            case BITAND: 
            case BITOR: 
            case BITXOR: {
                Node result = this.tryFoldArithmeticOp(subtree, left, right);
                if (result != subtree) {
                    return result;
                }
                return this.tryFoldLeftChildOp(subtree, left, right);
            }
            case LT: 
            case GT: 
            case LE: 
            case GE: 
            case EQ: 
            case NE: 
            case SHEQ: 
            case SHNE: {
                return this.tryFoldComparison(subtree, left, right);
            }
        }
        return subtree;
    }

    private Node tryReduceVoid(Node n) {
        Node child = n.getFirstChild();
        if (!(child.isNumber() && child.getDouble() == 0.0 || this.mayHaveSideEffects(n))) {
            child.replaceWith(IR.number(0.0));
            this.reportChangeToEnclosingScope(n);
        }
        return n;
    }

    private void tryReduceOperandsForOp(Node n) {
        switch (n.getToken()) {
            case ADD: {
                Node left = n.getFirstChild();
                Node right = n.getLastChild();
                if (NodeUtil.mayBeString(left, this.shouldUseTypes) || NodeUtil.mayBeString(right, this.shouldUseTypes)) break;
                this.tryConvertOperandsToNumber(n);
                break;
            }
            case ASSIGN_BITOR: 
            case ASSIGN_BITXOR: 
            case ASSIGN_BITAND: 
            case ASSIGN_LSH: 
            case ASSIGN_RSH: 
            case ASSIGN_URSH: 
            case ASSIGN_SUB: 
            case ASSIGN_MUL: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: {
                this.tryConvertToNumber(n.getLastChild());
                break;
            }
            case POS: 
            case NEG: 
            case BITNOT: 
            case LSH: 
            case RSH: 
            case URSH: 
            case SUB: 
            case DIV: 
            case MOD: 
            case EXPONENT: 
            case MUL: 
            case BITAND: 
            case BITOR: 
            case BITXOR: {
                this.tryConvertOperandsToNumber(n);
                break;
            }
        }
    }

    private void tryConvertOperandsToNumber(Node n) {
        Node c = n.getFirstChild();
        while (c != null) {
            Node next = c.getNext();
            this.tryConvertToNumber(c);
            c = next;
        }
    }

    private void tryConvertToNumber(Node n) {
        switch (n.getToken()) {
            case NUMBER: {
                return;
            }
            case AND: 
            case OR: 
            case COALESCE: 
            case COMMA: {
                this.tryConvertToNumber(n.getLastChild());
                return;
            }
            case HOOK: {
                this.tryConvertToNumber(n.getSecondChild());
                this.tryConvertToNumber(n.getLastChild());
                return;
            }
            case NAME: {
                if (NodeUtil.isUndefined(n)) break;
                return;
            }
        }
        Double result = this.getSideEffectFreeNumberValue(n);
        if (result == null) {
            return;
        }
        double value = result;
        Node replacement = NodeUtil.numberNode(value, n);
        if (replacement.isEquivalentTo(n)) {
            return;
        }
        n.replaceWith(replacement);
        this.reportChangeToEnclosingScope(replacement);
    }

    private Node tryFoldTypeof(Node originalTypeofNode) {
        Preconditions.checkArgument((boolean)originalTypeofNode.isTypeOf());
        Node argumentNode = originalTypeofNode.getFirstChild();
        if (argumentNode == null || !NodeUtil.isLiteralValue(argumentNode, true)) {
            return originalTypeofNode;
        }
        String typeNameString = null;
        switch (argumentNode.getToken()) {
            case FUNCTION: {
                typeNameString = "function";
                break;
            }
            case STRINGLIT: {
                typeNameString = "string";
                break;
            }
            case NUMBER: {
                typeNameString = "number";
                break;
            }
            case TRUE: 
            case FALSE: {
                typeNameString = "boolean";
                break;
            }
            case ARRAYLIT: 
            case OBJECTLIT: 
            case NULL: {
                typeNameString = "object";
                break;
            }
            case VOID: {
                typeNameString = "undefined";
                break;
            }
            case NAME: {
                if (!"undefined".equals(argumentNode.getString())) break;
                typeNameString = "undefined";
                break;
            }
        }
        if (typeNameString != null) {
            Node newNode = IR.string(typeNameString);
            this.reportChangeToEnclosingScope(originalTypeofNode);
            originalTypeofNode.replaceWith(newNode);
            this.markFunctionsDeleted(originalTypeofNode);
            return newNode;
        }
        return originalTypeofNode;
    }

    private Node tryFoldUnaryOperator(Node n) {
        Preconditions.checkState((boolean)n.hasOneChild(), (Object)n);
        Node left = n.getFirstChild();
        Node parent = n.getParent();
        if (left == null) {
            return n;
        }
        Tri leftVal = this.getSideEffectFreeBooleanValue(left);
        if (leftVal == Tri.UNKNOWN) {
            return n;
        }
        switch (n.getToken()) {
            case NOT: {
                double numValue;
                if (this.late && left.isNumber() && ((numValue = left.getDouble()) == 0.0 || numValue == 1.0)) {
                    return n;
                }
                Node replacementNode = NodeUtil.booleanNode(!leftVal.toBoolean(true));
                n.replaceWith(replacementNode);
                this.reportChangeToEnclosingScope(parent);
                return replacementNode;
            }
            case POS: {
                if (NodeUtil.isNumericResult(left)) {
                    n.replaceWith(left.detach());
                    this.reportChangeToEnclosingScope(parent);
                    return left;
                }
                return n;
            }
            case NEG: {
                Node leftLeft;
                Node result = null;
                if (left.isName() && left.getString().equals("NaN")) {
                    result = left.detach();
                } else if (left.isNeg() && ((leftLeft = left.getOnlyChild()).isBigInt() || leftLeft.isNumber())) {
                    result = leftLeft.detach();
                }
                if (result != null) {
                    n.replaceWith(result);
                    this.reportChangeToEnclosingScope(parent);
                    return result;
                }
                return n;
            }
            case BITNOT: {
                Double doubleVal = this.getSideEffectFreeNumberValue(left);
                if (doubleVal != null) {
                    if (JSCompDoubles.isMathematicalInteger(doubleVal)) {
                        int intVal = JSCompDoubles.ecmascriptToInt32(doubleVal);
                        Node notIntValNode = NodeUtil.numberNode(~intVal, left);
                        n.replaceWith(notIntValNode);
                        this.reportChangeToEnclosingScope(parent);
                        return notIntValNode;
                    }
                    this.report(FRACTIONAL_BITWISE_OPERAND, left);
                    return n;
                }
                BigInteger bigintVal = this.getSideEffectFreeBigIntValue(n);
                if (bigintVal != null) {
                    Node bigintNotNode = PeepholeFoldConstants.bigintNode(bigintVal, n);
                    n.replaceWith(bigintNotNode);
                    this.reportChangeToEnclosingScope(parent);
                    return bigintNotNode;
                }
                return n;
            }
        }
        return n;
    }

    private boolean isReasonableDoubleValue(@Nullable Double x) {
        return x != null && !x.isInfinite() && !x.isNaN();
    }

    private Node tryFoldInstanceof(Node n, Node left, Node right) {
        Preconditions.checkArgument((boolean)n.isInstanceOf());
        if (NodeUtil.isLiteralValue(left, true) && !this.mayHaveSideEffects(right)) {
            Node replacementNode = null;
            if (NodeUtil.isImmutableValue(left)) {
                replacementNode = IR.falseNode();
            } else if (right.isName() && "Object".equals(right.getString())) {
                replacementNode = IR.trueNode();
            }
            if (replacementNode != null) {
                n.replaceWith(replacementNode);
                this.reportChangeToEnclosingScope(replacementNode);
                this.markFunctionsDeleted(n);
                return replacementNode;
            }
        }
        return n;
    }

    private Node tryFoldAssign(Node n, Node left, Node right) {
        Node newRight;
        Preconditions.checkArgument((boolean)n.isAssign());
        if (!this.late) {
            return n;
        }
        if (!right.hasChildren() || right.getSecondChild() != right.getLastChild()) {
            return n;
        }
        if (this.mayHaveSideEffects(left)) {
            return n;
        }
        if (this.areNodesEqualForInlining(left, right.getFirstChild())) {
            newRight = right.getLastChild();
        } else if (NodeUtil.isCommutative(right.getToken()) && this.areNodesEqualForInlining(left, right.getLastChild())) {
            newRight = right.getFirstChild();
        } else {
            return n;
        }
        Token newType = null;
        switch (right.getToken()) {
            case ADD: {
                newType = Token.ASSIGN_ADD;
                break;
            }
            case BITAND: {
                newType = Token.ASSIGN_BITAND;
                break;
            }
            case BITOR: {
                newType = Token.ASSIGN_BITOR;
                break;
            }
            case BITXOR: {
                newType = Token.ASSIGN_BITXOR;
                break;
            }
            case DIV: {
                newType = Token.ASSIGN_DIV;
                break;
            }
            case LSH: {
                newType = Token.ASSIGN_LSH;
                break;
            }
            case MOD: {
                newType = Token.ASSIGN_MOD;
                break;
            }
            case MUL: {
                newType = Token.ASSIGN_MUL;
                break;
            }
            case RSH: {
                newType = Token.ASSIGN_RSH;
                break;
            }
            case SUB: {
                newType = Token.ASSIGN_SUB;
                break;
            }
            case URSH: {
                newType = Token.ASSIGN_URSH;
                break;
            }
            case EXPONENT: {
                newType = Token.ASSIGN_EXPONENT;
                break;
            }
            default: {
                return n;
            }
        }
        Node newNode = new Node(newType, left.detach(), newRight.detach());
        n.replaceWith(newNode);
        this.reportChangeToEnclosingScope(newNode);
        return newNode;
    }

    private Node tryUnfoldAssignOp(Node n, Node left, Node right) {
        if (this.late) {
            return n;
        }
        if (!n.hasChildren() || n.getSecondChild() != n.getLastChild()) {
            return n;
        }
        if (this.mayHaveSideEffects(left)) {
            return n;
        }
        Token op = NodeUtil.getOpFromAssignmentOp(n);
        Node replacement = IR.assign(left.detach(), new Node(op, left.cloneTree(), right.detach()).srcref(n));
        n.replaceWith(replacement);
        this.reportChangeToEnclosingScope(replacement);
        return replacement;
    }

    private Node tryFoldAndOr(Node n, Node left, Node right) {
        Node parent = n.getParent();
        Node result = null;
        Node dropped = null;
        Token type = n.getToken();
        Tri leftVal = NodeUtil.getBooleanValue(left);
        if (leftVal != Tri.UNKNOWN) {
            boolean lval = leftVal.toBoolean(true);
            if (lval ? type == Token.OR : type == Token.AND) {
                result = left;
                dropped = right;
            } else if (!this.mayHaveSideEffects(left)) {
                result = right;
                dropped = left;
            } else {
                n.detachChildren();
                result = IR.comma(left, right);
                dropped = null;
            }
        } else if (parent.getToken() == type && n == parent.getFirstChild()) {
            Tri rightValue = NodeUtil.getBooleanValue(right);
            if (!this.mayHaveSideEffects(right) && (rightValue == Tri.FALSE && type == Token.OR || rightValue == Tri.TRUE && type == Token.AND)) {
                result = left;
                dropped = right;
            }
        }
        if (result != null) {
            n.detachChildren();
            n.replaceWith(result);
            this.reportChangeToEnclosingScope(result);
            if (dropped != null) {
                this.markFunctionsDeleted(dropped);
            }
            return result;
        }
        return n;
    }

    private Node tryFoldCoalesce(Node n, Node left, Node right) {
        Node result = null;
        NodeUtil.ValueType leftVal = NodeUtil.getKnownValueType(left);
        switch (leftVal) {
            case NULL: 
            case VOID: {
                if (!this.mayHaveSideEffects(left)) {
                    result = right;
                    this.markFunctionsDeleted(left);
                    break;
                }
                n.detachChildren();
                result = IR.comma(left, right);
                break;
            }
            case NUMBER: 
            case BIGINT: 
            case STRING: 
            case BOOLEAN: 
            case OBJECT: {
                result = left;
                this.markFunctionsDeleted(right);
                break;
            }
        }
        if (result != null) {
            n.detachChildren();
            n.replaceWith(result);
            this.reportChangeToEnclosingScope(result);
            return result;
        }
        return n;
    }

    private Node tryFoldAdjacentLiteralLeaves(Node n, Node left, Node right) {
        Node leftParent = n;
        Node rightParent = n;
        while (left.isAdd()) {
            leftParent = left;
            left = left.getSecondChild();
        }
        while (right.isAdd()) {
            rightParent = right;
            right = right.getFirstChild();
        }
        if (leftParent.isAdd() && left.isStringLit() && rightParent.isAdd() && NodeUtil.isLiteralValue(right, false)) {
            boolean foldIsTypeSafe;
            Node rightGrandparent = rightParent.getParent();
            Node rr = right.getNext();
            boolean bl = foldIsTypeSafe = rr != null && NodeUtil.isStringResult(rr) || rr != null && right.isStringLit() && rightGrandparent != null && rightGrandparent.isAdd() && NodeUtil.isStringResult(rightGrandparent.getSecondChild()) || rr == null;
            if (foldIsTypeSafe) {
                String result = left.getString() + NodeUtil.getStringValue(right);
                if (rightParent.getSecondChild().equals(right)) {
                    left.replaceWith(IR.string(result));
                    this.replace(rightParent, rightParent.getFirstChild().cloneTree(true));
                } else {
                    left.replaceWith(IR.string(result));
                    this.replace(rightParent, rightParent.getSecondChild().cloneTree(true));
                }
            }
        }
        return n;
    }

    private Node tryFoldAddConstantString(Node n, Node left, Node right) {
        if (left.isStringLit() || right.isStringLit() || left.isArrayLit() || right.isArrayLit()) {
            String leftString = this.getSideEffectFreeStringValue(left);
            String rightString = this.getSideEffectFreeStringValue(right);
            if (leftString != null && rightString != null) {
                Node newStringNode = IR.string(leftString + rightString);
                n.replaceWith(newStringNode);
                this.reportChangeToEnclosingScope(newStringNode);
                return newStringNode;
            }
        }
        return n;
    }

    private Node tryFoldArithmeticOp(Node n, Node left, Node right) {
        Node result = this.performArithmeticOp(n, left, right);
        if (result != null) {
            result.srcrefTreeIfMissing(n);
            this.reportChangeToEnclosingScope(n);
            n.replaceWith(result);
            return result;
        }
        return n;
    }

    private @Nullable Node performArithmeticOp(Node n, Node left, Node right) {
        double result;
        if (n.isAdd() && (NodeUtil.mayBeString(left, this.shouldUseTypes) || NodeUtil.mayBeString(right, this.shouldUseTypes))) {
            return null;
        }
        if (this.isBigInt(left) && this.isBigInt(right)) {
            return this.performBigIntArithmeticOp(n, left, right);
        }
        Double lValObj = this.getSideEffectFreeNumberValue(left);
        Double rValObj = this.getSideEffectFreeNumberValue(right);
        if (lValObj == null && rValObj == null || !this.isNumeric(left) || !this.isNumeric(right)) {
            return null;
        }
        switch (n.getToken()) {
            case ADD: {
                if (lValObj != null && rValObj != null) {
                    return this.maybeReplaceBinaryOpWithNumericResult(lValObj + rValObj, lValObj, rValObj);
                }
                if (lValObj != null && lValObj == 0.0) {
                    return right.cloneTree(true);
                }
                if (rValObj != null && rValObj == 0.0) {
                    return left.cloneTree(true);
                }
                return null;
            }
            case SUB: {
                if (lValObj != null && rValObj != null) {
                    return this.maybeReplaceBinaryOpWithNumericResult(lValObj - rValObj, lValObj, rValObj);
                }
                if (lValObj != null && lValObj == 0.0) {
                    return IR.neg(right.cloneTree(true));
                }
                if (rValObj != null && rValObj == 0.0) {
                    return left.cloneTree(true);
                }
                return null;
            }
            case MUL: {
                if (lValObj != null && rValObj != null) {
                    return this.maybeReplaceBinaryOpWithNumericResult(lValObj * rValObj, lValObj, rValObj);
                }
                if (lValObj != null) {
                    if (lValObj == 1.0) {
                        return right.cloneTree(true);
                    }
                } else if (rValObj == 1.0) {
                    return left.cloneTree(true);
                }
                return null;
            }
            case DIV: {
                if (lValObj != null && rValObj != null) {
                    if (rValObj == 0.0) {
                        return null;
                    }
                    return this.maybeReplaceBinaryOpWithNumericResult(lValObj / rValObj, lValObj, rValObj);
                }
                if (rValObj != null && rValObj == 1.0) {
                    return left.cloneTree(true);
                }
                return null;
            }
            case EXPONENT: {
                if (lValObj != null && rValObj != null) {
                    return this.maybeReplaceBinaryOpWithNumericResult(Math.pow(lValObj, rValObj), lValObj, rValObj);
                }
                return null;
            }
        }
        if (lValObj == null || rValObj == null) {
            return null;
        }
        double lval = lValObj;
        double rval = rValObj;
        switch (n.getToken()) {
            case BITAND: {
                result = JSCompDoubles.ecmascriptToInt32(lval) & JSCompDoubles.ecmascriptToInt32(rval);
                break;
            }
            case BITOR: {
                result = JSCompDoubles.ecmascriptToInt32(lval) | JSCompDoubles.ecmascriptToInt32(rval);
                break;
            }
            case BITXOR: {
                result = JSCompDoubles.ecmascriptToInt32(lval) ^ JSCompDoubles.ecmascriptToInt32(rval);
                break;
            }
            case MOD: {
                if (rval == 0.0) {
                    return null;
                }
                result = lval % rval;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected arithmetic operator: " + n.getToken());
            }
        }
        return this.maybeReplaceBinaryOpWithNumericResult(result, lval, rval);
    }

    private @Nullable Node performBigIntArithmeticOp(Node n, Node left, Node right) {
        BigInteger lVal = this.getSideEffectFreeBigIntValue(left);
        BigInteger rVal = this.getSideEffectFreeBigIntValue(right);
        if (lVal != null && rVal != null) {
            switch (n.getToken()) {
                case ADD: {
                    return PeepholeFoldConstants.bigintNode(lVal.add(rVal), n);
                }
                case SUB: {
                    return PeepholeFoldConstants.bigintNode(lVal.subtract(rVal), n);
                }
                case MUL: {
                    return PeepholeFoldConstants.bigintNode(lVal.multiply(rVal), n);
                }
                case DIV: {
                    if (!rVal.equals(BigInteger.ZERO)) {
                        return PeepholeFoldConstants.bigintNode(lVal.divide(rVal), n);
                    }
                    return null;
                }
                case EXPONENT: {
                    try {
                        return PeepholeFoldConstants.bigintNode(lVal.pow(rVal.intValueExact()), n);
                    }
                    catch (ArithmeticException exception) {
                        return null;
                    }
                }
                case MOD: {
                    return PeepholeFoldConstants.bigintNode(lVal.mod(rVal), n);
                }
                case BITAND: {
                    return PeepholeFoldConstants.bigintNode(lVal.and(rVal), n);
                }
                case BITOR: {
                    return PeepholeFoldConstants.bigintNode(lVal.or(rVal), n);
                }
                case BITXOR: {
                    return PeepholeFoldConstants.bigintNode(lVal.xor(rVal), n);
                }
            }
            return null;
        }
        switch (n.getToken()) {
            case ADD: {
                if (lVal != null && lVal.equals(BigInteger.ZERO)) {
                    return right.cloneTree(true);
                }
                if (rVal != null && rVal.equals(BigInteger.ZERO)) {
                    return left.cloneTree(true);
                }
                return null;
            }
            case SUB: {
                if (lVal != null && lVal.equals(BigInteger.ZERO)) {
                    return IR.neg(right.cloneTree(true));
                }
                if (rVal != null && rVal.equals(BigInteger.ZERO)) {
                    return left.cloneTree(true);
                }
                return null;
            }
            case MUL: {
                if (lVal != null && lVal.equals(BigInteger.ONE)) {
                    return right.cloneTree(true);
                }
                if (rVal != null && rVal.equals(BigInteger.ONE)) {
                    return left.cloneTree(true);
                }
                return null;
            }
            case DIV: {
                if (rVal != null && rVal.equals(BigInteger.ONE)) {
                    return left.cloneTree(true);
                }
                return null;
            }
        }
        return null;
    }

    private boolean isNumeric(Node n) {
        if (NodeUtil.isNumericResult(n)) {
            return true;
        }
        if (this.shouldUseTypes) {
            return n.getColor() != null && n.getColor().equals(StandardColors.NUMBER);
        }
        return false;
    }

    private boolean isBigInt(Node n) {
        if (NodeUtil.isBigIntResult(n)) {
            return true;
        }
        if (this.shouldUseTypes) {
            return n.getColor() != null && n.getColor().equals(StandardColors.BIGINT);
        }
        return false;
    }

    private @Nullable Node maybeReplaceBinaryOpWithNumericResult(double result, double lval, double rval) {
        if (String.valueOf(result).length() <= String.valueOf(lval).length() + String.valueOf(rval).length() + 1 && Math.abs(result) <= MAX_FOLD_NUMBER || Double.isNaN(result) || result == Double.POSITIVE_INFINITY || result == Double.NEGATIVE_INFINITY) {
            return NodeUtil.numberNode(result, null);
        }
        return null;
    }

    private Node tryFoldLeftChildOp(Node n, Node left, Node right) {
        Token opType = n.getToken();
        Preconditions.checkState((NodeUtil.isAssociative(opType) && NodeUtil.isCommutative(opType) || n.isAdd() ? 1 : 0) != 0);
        Preconditions.checkState((!n.isAdd() || !NodeUtil.mayBeString(n, this.shouldUseTypes) ? 1 : 0) != 0);
        Double rightValObj = this.getSideEffectFreeNumberValue(right);
        BigInteger rightBigInt = this.getSideEffectFreeBigIntValue(right);
        if ((rightValObj != null || rightBigInt != null) && left.getToken() == opType) {
            Preconditions.checkState((boolean)left.hasTwoChildren());
            Node ll = left.getFirstChild();
            Node lr = ll.getNext();
            Node valueToCombine = ll;
            Node replacement = this.performArithmeticOp(n, valueToCombine, right);
            if (replacement == null) {
                valueToCombine = lr;
                replacement = this.performArithmeticOp(n, valueToCombine, right);
            }
            if (replacement != null) {
                valueToCombine.detach();
                left.replaceWith(left.removeFirstChild());
                replacement.srcrefTreeIfMissing(right);
                right.replaceWith(replacement);
                this.reportChangeToEnclosingScope(n);
            }
        }
        return n;
    }

    private Node tryFoldAdd(Node node, Node left, Node right) {
        Preconditions.checkArgument((boolean)node.isAdd());
        if (NodeUtil.mayBeString(node, this.shouldUseTypes)) {
            if (NodeUtil.isLiteralValue(left, false) && NodeUtil.isLiteralValue(right, false)) {
                return this.tryFoldAddConstantString(node, left, right);
            }
            if (left.isStringLit() && left.getString().isEmpty() && this.isStringTyped(right)) {
                return this.replace(node, right.cloneTree(true));
            }
            if (right.isStringLit() && right.getString().isEmpty() && this.isStringTyped(left)) {
                return this.replace(node, left.cloneTree(true));
            }
            return this.tryFoldAdjacentLiteralLeaves(node, left, right);
        }
        Node result = this.tryFoldArithmeticOp(node, left, right);
        if (result != node) {
            return result;
        }
        return this.tryFoldLeftChildOp(node, left, right);
    }

    private Node replace(Node oldNode, Node newNode) {
        oldNode.replaceWith(newNode);
        this.reportChangeToEnclosingScope(newNode);
        return newNode;
    }

    private boolean isStringTyped(Node n) {
        if (NodeUtil.isStringResult(n)) {
            return true;
        }
        if (this.shouldUseTypes) {
            return n.getColor() != null && n.getColor().equals(StandardColors.STRING);
        }
        return false;
    }

    private Node tryFoldShift(Node n, Node left, Node right) {
        double result;
        Double leftVal = this.getSideEffectFreeNumberValue(left);
        Double rightVal = this.getSideEffectFreeNumberValue(right);
        if (!this.isReasonableDoubleValue(leftVal) || !this.isReasonableDoubleValue(rightVal)) {
            return n;
        }
        if (!JSCompDoubles.isMathematicalInteger(leftVal)) {
            this.report(FRACTIONAL_BITWISE_OPERAND, left);
            return n;
        }
        if (!JSCompDoubles.isMathematicalInteger(rightVal)) {
            this.report(FRACTIONAL_BITWISE_OPERAND, right);
            return n;
        }
        if (!(0.0 <= rightVal) || !(rightVal < 32.0)) {
            return n;
        }
        int rvalInt = rightVal.intValue();
        int bits = JSCompDoubles.ecmascriptToInt32(leftVal);
        switch (n.getToken()) {
            case LSH: {
                result = bits << rvalInt;
                break;
            }
            case RSH: {
                result = bits >> rvalInt;
                break;
            }
            case URSH: {
                result = 0xFFFFFFFFL & (long)(bits >>> rvalInt);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown shift operator: " + n.getToken()));
            }
        }
        Node newNumber = NodeUtil.numberNode(result, n);
        this.reportChangeToEnclosingScope(n);
        n.replaceWith(newNumber);
        return newNumber;
    }

    private Node tryFoldComparison(Node n, Node left, Node right) {
        Tri result = PeepholeFoldConstants.evaluateComparison(this, n.getToken(), left, right);
        if (result == Tri.UNKNOWN) {
            return n;
        }
        Node newNode = NodeUtil.booleanNode(result.toBoolean(true));
        this.reportChangeToEnclosingScope(n);
        n.replaceWith(newNode);
        this.markFunctionsDeleted(n);
        return newNode;
    }

    private static Tri tryAbstractRelationalComparison(AbstractPeepholeOptimization peepholeOptimization, Node left, Node right, boolean willNegate) {
        NodeUtil.ValueType leftValueType = NodeUtil.getKnownValueType(left);
        NodeUtil.ValueType rightValueType = NodeUtil.getKnownValueType(right);
        if (leftValueType == NodeUtil.ValueType.STRING && rightValueType == NodeUtil.ValueType.STRING) {
            String lvStr = peepholeOptimization.getSideEffectFreeStringValue(left);
            String rvStr = peepholeOptimization.getSideEffectFreeStringValue(right);
            if (lvStr != null && rvStr != null) {
                if (lvStr.indexOf(11) != -1 || rvStr.indexOf(11) != -1) {
                    return Tri.UNKNOWN;
                }
                return Tri.forBoolean(lvStr.compareTo(rvStr) < 0);
            }
            if (left.isTypeOf() && right.isTypeOf() && left.getFirstChild().isName() && right.getFirstChild().isName() && left.getFirstChild().getString().equals(right.getFirstChild().getString())) {
                return Tri.FALSE;
            }
        }
        BigInteger lvBig = peepholeOptimization.getSideEffectFreeBigIntValue(left);
        BigInteger rvBig = peepholeOptimization.getSideEffectFreeBigIntValue(right);
        if (lvBig != null && rvBig != null) {
            return Tri.forBoolean(lvBig.compareTo(rvBig) < 0);
        }
        Double lvNum = peepholeOptimization.getSideEffectFreeNumberValue(left);
        Double rvNum = peepholeOptimization.getSideEffectFreeNumberValue(right);
        if (lvNum != null && rvNum != null) {
            if (Double.isNaN(lvNum) || Double.isNaN(rvNum)) {
                return Tri.forBoolean(willNegate);
            }
            return Tri.forBoolean(lvNum < rvNum);
        }
        if (lvBig != null && rvNum != null) {
            return PeepholeFoldConstants.bigintLessThanDouble(lvBig, rvNum, Tri.FALSE, willNegate);
        }
        if (lvNum != null && rvBig != null) {
            return PeepholeFoldConstants.bigintLessThanDouble(rvBig, lvNum, Tri.TRUE, willNegate);
        }
        if (!willNegate && left.isName() && right.isName() && left.getString().equals(right.getString())) {
            return Tri.FALSE;
        }
        return Tri.UNKNOWN;
    }

    private static Tri bigintLessThanDouble(BigInteger bigint, double number, Tri invert, boolean willNegate) {
        if (Double.isNaN(number)) {
            return Tri.forBoolean(willNegate);
        }
        if (number == Double.POSITIVE_INFINITY) {
            return Tri.TRUE.xor(invert);
        }
        if (number == Double.NEGATIVE_INFINITY) {
            return Tri.FALSE.xor(invert);
        }
        if (!JSCompDoubles.isAtLeastIntegerPrecision(number)) {
            return Tri.UNKNOWN;
        }
        BigInteger numberAsBigInt = BigInteger.valueOf((long)number);
        int negativeMeansBigintSmaller = bigint.compareTo(numberAsBigInt);
        if (negativeMeansBigintSmaller < 0) {
            return Tri.TRUE.xor(invert);
        }
        if (negativeMeansBigintSmaller > 0) {
            return Tri.FALSE.xor(invert);
        }
        if (JSCompDoubles.isExactInt64(number)) {
            return Tri.FALSE;
        }
        return Tri.forBoolean(JSCompDoubles.isPositive(number)).xor(invert);
    }

    private static Tri tryAbstractEqualityComparison(AbstractPeepholeOptimization peepholeOptimization, Node left, Node right) {
        NodeUtil.ValueType leftValueType = NodeUtil.getKnownValueType(left);
        NodeUtil.ValueType rightValueType = NodeUtil.getKnownValueType(right);
        if (leftValueType != NodeUtil.ValueType.UNDETERMINED && rightValueType != NodeUtil.ValueType.UNDETERMINED) {
            if (leftValueType == rightValueType) {
                return PeepholeFoldConstants.tryStrictEqualityComparison(peepholeOptimization, left, right);
            }
            if (leftValueType == NodeUtil.ValueType.NULL && rightValueType == NodeUtil.ValueType.VOID || leftValueType == NodeUtil.ValueType.VOID && rightValueType == NodeUtil.ValueType.NULL) {
                return Tri.TRUE;
            }
            if (leftValueType == NodeUtil.ValueType.NUMBER && rightValueType == NodeUtil.ValueType.STRING || rightValueType == NodeUtil.ValueType.BOOLEAN) {
                Double rv = peepholeOptimization.getSideEffectFreeNumberValue(right);
                return rv == null ? Tri.UNKNOWN : PeepholeFoldConstants.tryAbstractEqualityComparison(peepholeOptimization, left, NodeUtil.numberNode(rv, right));
            }
            if (leftValueType == NodeUtil.ValueType.STRING && rightValueType == NodeUtil.ValueType.NUMBER || leftValueType == NodeUtil.ValueType.BOOLEAN) {
                Double lv = peepholeOptimization.getSideEffectFreeNumberValue(left);
                return lv == null ? Tri.UNKNOWN : PeepholeFoldConstants.tryAbstractEqualityComparison(peepholeOptimization, NodeUtil.numberNode(lv, left), right);
            }
            if (leftValueType == NodeUtil.ValueType.BIGINT || rightValueType == NodeUtil.ValueType.BIGINT) {
                BigInteger lv = peepholeOptimization.getSideEffectFreeBigIntValue(left);
                BigInteger rv = peepholeOptimization.getSideEffectFreeBigIntValue(right);
                if (lv != null && rv != null) {
                    return Tri.forBoolean(lv.equals(rv));
                }
            }
            if ((leftValueType == NodeUtil.ValueType.STRING || leftValueType == NodeUtil.ValueType.NUMBER) && rightValueType == NodeUtil.ValueType.OBJECT) {
                return Tri.UNKNOWN;
            }
            if (leftValueType == NodeUtil.ValueType.OBJECT && (rightValueType == NodeUtil.ValueType.STRING || rightValueType == NodeUtil.ValueType.NUMBER)) {
                return Tri.UNKNOWN;
            }
            return Tri.FALSE;
        }
        return Tri.UNKNOWN;
    }

    private static Tri tryStrictEqualityComparison(AbstractPeepholeOptimization peepholeOptimization, Node left, Node right) {
        NodeUtil.ValueType leftValueType = NodeUtil.getKnownValueType(left);
        NodeUtil.ValueType rightValueType = NodeUtil.getKnownValueType(right);
        if (leftValueType != NodeUtil.ValueType.UNDETERMINED && rightValueType != NodeUtil.ValueType.UNDETERMINED) {
            if (leftValueType != rightValueType) {
                return Tri.FALSE;
            }
            switch (leftValueType) {
                case NULL: 
                case VOID: {
                    return Tri.TRUE;
                }
                case NUMBER: {
                    if (NodeUtil.isNaN(left)) {
                        return Tri.FALSE;
                    }
                    if (NodeUtil.isNaN(right)) {
                        return Tri.FALSE;
                    }
                    Double lv = peepholeOptimization.getSideEffectFreeNumberValue(left);
                    Double rv = peepholeOptimization.getSideEffectFreeNumberValue(right);
                    if (lv == null || rv == null) break;
                    return Tri.forBoolean(lv.doubleValue() == rv.doubleValue());
                }
                case STRING: {
                    String lv = peepholeOptimization.getSideEffectFreeStringValue(left);
                    String rv = peepholeOptimization.getSideEffectFreeStringValue(right);
                    if (lv != null && rv != null) {
                        if (lv.indexOf(11) != -1 || rv.indexOf(11) != -1) {
                            return Tri.UNKNOWN;
                        }
                        return lv.equals(rv) ? Tri.TRUE : Tri.FALSE;
                    }
                    if (!left.isTypeOf() || !right.isTypeOf() || !left.getFirstChild().isName() || !right.getFirstChild().isName() || !left.getFirstChild().getString().equals(right.getFirstChild().getString())) break;
                    return Tri.TRUE;
                }
                case BOOLEAN: {
                    Tri lv = peepholeOptimization.getSideEffectFreeBooleanValue(left);
                    Tri rv = peepholeOptimization.getSideEffectFreeBooleanValue(right);
                    return lv.and(rv).or(lv.not().and(rv.not()));
                }
                case BIGINT: {
                    BigInteger lv = peepholeOptimization.getSideEffectFreeBigIntValue(left);
                    BigInteger rv = peepholeOptimization.getSideEffectFreeBigIntValue(right);
                    if (lv == null || rv == null) break;
                    return Tri.forBoolean(lv.equals(rv));
                }
                default: {
                    return Tri.UNKNOWN;
                }
            }
        }
        if (NodeUtil.isNaN(left) || NodeUtil.isNaN(right)) {
            return Tri.FALSE;
        }
        return Tri.UNKNOWN;
    }

    static Tri evaluateComparison(AbstractPeepholeOptimization peepholeOptimization, Token op, Node left, Node right) {
        if (peepholeOptimization.mayHaveSideEffects(left) || peepholeOptimization.mayHaveSideEffects(right)) {
            return Tri.UNKNOWN;
        }
        switch (op) {
            case EQ: {
                return PeepholeFoldConstants.tryAbstractEqualityComparison(peepholeOptimization, left, right);
            }
            case NE: {
                return PeepholeFoldConstants.tryAbstractEqualityComparison(peepholeOptimization, left, right).not();
            }
            case SHEQ: {
                return PeepholeFoldConstants.tryStrictEqualityComparison(peepholeOptimization, left, right);
            }
            case SHNE: {
                return PeepholeFoldConstants.tryStrictEqualityComparison(peepholeOptimization, left, right).not();
            }
            case LT: {
                return PeepholeFoldConstants.tryAbstractRelationalComparison(peepholeOptimization, left, right, false);
            }
            case GT: {
                return PeepholeFoldConstants.tryAbstractRelationalComparison(peepholeOptimization, right, left, false);
            }
            case LE: {
                return PeepholeFoldConstants.tryAbstractRelationalComparison(peepholeOptimization, right, left, true).not();
            }
            case GE: {
                return PeepholeFoldConstants.tryAbstractRelationalComparison(peepholeOptimization, left, right, true).not();
            }
        }
        throw new IllegalStateException("Unexpected operator for comparison");
    }

    private Node tryFoldCtorCall(Node n) {
        Preconditions.checkArgument((boolean)n.isNew());
        if (PeepholeFoldConstants.inForcedStringContext(n)) {
            return this.tryFoldInForcedStringContext(n);
        }
        return n;
    }

    private Node tryFoldUselessObjectDotDefinePropertiesCall(Node n) {
        Node srcObj;
        Preconditions.checkArgument((n.isCall() || n.isOptChainCall() ? 1 : 0) != 0);
        if (NodeUtil.isObjectDefinePropertiesDefinition(n) && (srcObj = n.getLastChild()).isObjectLit() && !srcObj.hasChildren()) {
            Node parent = n.getParent();
            Node destObj = n.getSecondChild().detach();
            n.replaceWith(destObj);
            this.reportChangeToEnclosingScope(parent);
        }
        return n;
    }

    private static boolean inForcedStringContext(Node n) {
        if (n.getParent().isGetElem() && n.getParent().getLastChild() == n) {
            return true;
        }
        return n.getParent().isAdd();
    }

    private Node tryFoldInForcedStringContext(Node n) {
        Preconditions.checkArgument((boolean)n.isNew());
        Node objectType = n.getFirstChild();
        if (!objectType.isName()) {
            return n;
        }
        if (objectType.getString().equals("String")) {
            Node value = objectType.getNext();
            String stringValue = value == null ? "" : this.getSideEffectFreeStringValue(value);
            if (stringValue == null) {
                return n;
            }
            Node parent = n.getParent();
            Node newString = IR.string(stringValue);
            n.replaceWith(newString);
            newString.srcrefIfMissing(parent);
            this.reportChangeToEnclosingScope(parent);
            return newString;
        }
        return n;
    }

    private Node tryFoldGetElem(Node n, Node left, Node right) {
        Preconditions.checkArgument((n.isGetElem() || n.isOptChainGetElem() ? 1 : 0) != 0);
        if (left.isObjectLit()) {
            if (right.isStringLit()) {
                return this.tryFoldObjectPropAccess(n, left, right.getString());
            }
        } else {
            if (left.isArrayLit()) {
                return this.tryFoldArrayAccess(n, left, right);
            }
            if (left.isStringLit()) {
                return this.tryFoldStringArrayAccess(n, left, right);
            }
        }
        return n;
    }

    private Node tryFoldGetProp(Node n) {
        Preconditions.checkArgument((n.isGetProp() || n.isOptChainGetProp() ? 1 : 0) != 0);
        Node left = n.getFirstChild();
        String name = n.getString();
        if (left.isObjectLit()) {
            return this.tryFoldObjectPropAccess(n, left, name);
        }
        if (name.equals("length")) {
            int knownLength = -1;
            switch (left.getToken()) {
                case ARRAYLIT: {
                    if (this.mayHaveSideEffects(left)) {
                        return n;
                    }
                    knownLength = left.getChildCount();
                    break;
                }
                case STRINGLIT: {
                    knownLength = left.getString().length();
                    break;
                }
                default: {
                    return n;
                }
            }
            Preconditions.checkState((knownLength != -1 ? 1 : 0) != 0);
            Node lengthNode = IR.number(knownLength);
            this.reportChangeToEnclosingScope(n);
            n.replaceWith(lengthNode);
            return lengthNode;
        }
        return n;
    }

    private Node tryFoldArrayAccess(Node n, Node left, Node right) {
        if (NodeUtil.isLValue(n)) {
            return n;
        }
        Double index = this.getSideEffectFreeNumberValue(right);
        if (!this.isReasonableDoubleValue(index)) {
            return n;
        }
        if (!JSCompDoubles.isExactInt32(index)) {
            this.report(INVALID_GETELEM_INDEX_ERROR, right);
            return n;
        }
        int intIndex = index.intValue();
        Node current = intIndex >= 0 ? left.getFirstChild() : null;
        Node elem = null;
        int i = 0;
        while (current != null) {
            if (current.isSpread()) {
                return n;
            }
            if (i != intIndex) {
                if (this.mayHaveSideEffects(current)) {
                    return n;
                }
            } else {
                elem = current;
            }
            current = current.getNext();
            ++i;
        }
        if (elem == null) {
            elem = NodeUtil.newUndefinedNode(left);
        } else if (elem.isEmpty()) {
            elem = NodeUtil.newUndefinedNode(elem);
        } else {
            elem.detach();
        }
        n.replaceWith(elem);
        this.reportChangeToEnclosingScope(elem);
        return elem;
    }

    private Node tryFoldSpread(Node spread) {
        Preconditions.checkState((boolean)spread.isSpread());
        Node parent = spread.getParent();
        Node child = spread.getOnlyChild();
        if (child.isArrayLit()) {
            for (Node n = child.getFirstChild(); n != null; n = n.getNext()) {
                if (!n.getToken().equals((Object)Token.EMPTY)) continue;
                return spread;
            }
            parent.addChildrenAfter(child.removeChildren(), spread);
            spread.detach();
            this.reportChangeToEnclosingScope(parent);
        }
        return parent;
    }

    private Node tryFlattenArrayOrObjectLit(Node parentLit) {
        for (Node child = parentLit.getFirstChild(); child != null; child = child.getNext()) {
            Node spread = child;
            if (!spread.isSpread()) continue;
            Node innerLit = spread.getOnlyChild();
            if (!parentLit.getToken().equals((Object)innerLit.getToken())) continue;
            parentLit.addChildrenAfter(innerLit.removeChildren(), spread);
            spread.detach();
            this.reportChangeToEnclosingScope(parentLit);
        }
        return parentLit;
    }

    private Node tryFoldStringArrayAccess(Node n, Node left, Node right) {
        if (NodeUtil.isLValue(n)) {
            return n;
        }
        Double index = this.getSideEffectFreeNumberValue(right);
        if (!this.isReasonableDoubleValue(index)) {
            return n;
        }
        int intIndex = index.intValue();
        if ((double)intIndex != index) {
            this.report(INVALID_GETELEM_INDEX_ERROR, right);
            return n;
        }
        Preconditions.checkState((boolean)left.isStringLit());
        String value = left.getString();
        if (intIndex < 0 || intIndex >= value.length()) {
            Node undefined = NodeUtil.newUndefinedNode(left);
            n.replaceWith(undefined);
            this.reportChangeToEnclosingScope(undefined);
            return undefined;
        }
        char c = '\u0000';
        for (int i = 0; i <= intIndex; ++i) {
            c = value.charAt(i);
            if (c >= ' ' && c <= 127) continue;
            return n;
        }
        Node elem = IR.string(Character.toString(c));
        n.replaceWith(elem);
        this.reportChangeToEnclosingScope(elem);
        return elem;
    }

    private Node tryFoldObjectPropAccess(Node n, Node left, String name) {
        Preconditions.checkArgument((boolean)NodeUtil.isNormalOrOptChainGet(n));
        if (!left.isObjectLit()) {
            return n;
        }
        if (NodeUtil.isLValue(n)) {
            Preconditions.checkState((!NodeUtil.isOptChainNode(n) ? 1 : 0) != 0);
            return n;
        }
        Node key = null;
        Node value = null;
        block6: for (Node c = left.getFirstChild(); c != null; c = c.getNext()) {
            switch (c.getToken()) {
                case SETTER_DEF: {
                    continue block6;
                }
                case OBJECT_SPREAD: {
                    key = null;
                    value = null;
                    continue block6;
                }
                case COMPUTED_PROP: {
                    Node prop = c.getFirstChild();
                    if (!prop.isStringLit()) {
                        return n;
                    }
                    if (!prop.getString().equals(name)) continue block6;
                    key = c;
                    value = c.getSecondChild();
                    continue block6;
                }
                case GETTER_DEF: 
                case STRING_KEY: 
                case MEMBER_FUNCTION_DEF: {
                    if (!c.getString().equals(name)) continue block6;
                    key = c;
                    value = key.getFirstChild();
                    continue block6;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        if (value == null) {
            return n;
        }
        if (NodeUtil.referencesSuper(value)) {
            return n;
        }
        Node tempValue = IR.nullNode();
        value.replaceWith(tempValue);
        boolean hasSideEffectBesidesValue = this.mayHaveSideEffects(left);
        tempValue.replaceWith(value);
        if (hasSideEffectBesidesValue) {
            return n;
        }
        boolean keyIsGetter = NodeUtil.isGetOrSetKey(key);
        boolean nIsInvoked = NodeUtil.isInvocationTarget(n);
        if ((keyIsGetter || nIsInvoked) && (!value.isFunction() || NodeUtil.referencesOwnReceiver(value))) {
            return n;
        }
        value.detach();
        Node parent = n.getParent();
        if (NodeUtil.isOptChainNode(parent)) {
            Node endOfCurrentChain = NodeUtil.getEndOfOptChainSegment(parent);
            NodeUtil.convertToNonOptionalChainSegment(endOfCurrentChain);
        }
        if (keyIsGetter) {
            value = IR.call(value, new Node[0]);
            value.putBooleanProp(Node.FREE_CALL, true);
        } else if (nIsInvoked) {
            n.getParent().putBooleanProp(Node.FREE_CALL, true);
        }
        n.replaceWith(value);
        this.reportChangeToEnclosingScope(value);
        this.markFunctionsDeleted(n);
        return n;
    }

    private static Node bigintNode(BigInteger val, Node srcref) {
        Node tree = val.signum() < 0 ? IR.neg(IR.bigint(val.negate())) : IR.bigint(val);
        return tree.srcrefTree(srcref);
    }
}

