/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.JSChunk;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.diagnostic.LogFile;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jspecify.nullness.Nullable;

public final class ParenthesizeFunctionsInChunks
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final Set<String> parenthesizeFunctionsInChunks;

    public ParenthesizeFunctionsInChunks(AbstractCompiler compiler, Set<String> parenthesizeFunctionsInChunks) {
        this.compiler = compiler;
        this.parenthesizeFunctionsInChunks = parenthesizeFunctionsInChunks;
    }

    @Override
    public void process(Node externs, Node root) {
        Traversal traversal = new Traversal(this.parenthesizeFunctionsInChunks);
        NodeTraversal.traverse(this.compiler, root, traversal);
        Map<String, Long> chunkToEagerCompileFnCounts = traversal.getChunkToEagerCompileFnCounts();
        try (LogFile log = this.compiler.createOrReopenLog(this.getClass(), "eager_compile_chunks.log", new String[0]);){
            for (Map.Entry<String, Long> entry : chunkToEagerCompileFnCounts.entrySet()) {
                log.log("%s: %d fn's marked for eager compile", entry.getKey(), entry.getValue());
            }
        }
    }

    private static class Traversal
    implements NodeTraversal.Callback {
        private final Set<String> parenthesizeFunctionsInChunks;
        private final Deque<Node> nestedBlockScopes = new ArrayDeque<Node>();
        private final ListMultimap<Node, Node> hoistNodesToScope = ArrayListMultimap.create();
        private final Map<String, Long> chunkToEagerCompileFnCounts = new LinkedHashMap<String, Long>();

        public Traversal(Set<String> parenthesizeFunctionsInChunks) {
            this.parenthesizeFunctionsInChunks = parenthesizeFunctionsInChunks;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            if (!this.shouldParenthesizeTree(t, n)) {
                return false;
            }
            if (parent != null && parent.isFunction()) {
                return false;
            }
            if (NodeUtil.isStatementBlock(n)) {
                this.nestedBlockScopes.push(n);
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (this.isInnerMostBlockScope(n)) {
                this.hoistChildrenToTopOfScope(n);
                this.nestedBlockScopes.pop();
            } else if (NodeUtil.isFunctionExpression(n)) {
                n.setMarkForParenthesize(true);
                this.incrementEagerlyCompiledFunctionCount(t);
            } else if (NodeUtil.isFunctionDeclaration(n)) {
                n.setMarkForParenthesize(true);
                this.addChildForHoistToScope(this.functionDeclarationToFunctionExpression(t, n));
                this.incrementEagerlyCompiledFunctionCount(t);
            }
        }

        public Map<String, Long> getChunkToEagerCompileFnCounts() {
            Preconditions.checkState((boolean)this.nestedBlockScopes.isEmpty(), (String)"Expected empty scope stack. Got: %s", this.nestedBlockScopes);
            Preconditions.checkState((boolean)this.hoistNodesToScope.isEmpty(), (String)"Expected empty hoist map. Got: %s", this.hoistNodesToScope);
            return this.chunkToEagerCompileFnCounts;
        }

        private boolean shouldParenthesizeTree(NodeTraversal t, Node n) {
            if (!n.isScript()) {
                return true;
            }
            String chunkName = this.getChunkName(t);
            return chunkName == null || this.parenthesizeFunctionsInChunks.contains(chunkName);
        }

        private void incrementEagerlyCompiledFunctionCount(NodeTraversal t) {
            this.chunkToEagerCompileFnCounts.merge(this.getChunkName(t), 1L, (oldValue, value) -> oldValue + 1L);
        }

        private @Nullable String getChunkName(NodeTraversal t) {
            JSChunk chunk = t.getChunk();
            return chunk != null ? chunk.getName() : null;
        }

        private boolean isInnerMostBlockScope(Node n) {
            return !this.nestedBlockScopes.isEmpty() && this.nestedBlockScopes.peek() == n;
        }

        private Node functionDeclarationToFunctionExpression(NodeTraversal t, Node n) {
            AbstractCompiler compiler = t.getCompiler();
            Node nameNode = n.getFirstChild();
            Node name = IR.name(nameNode.getString()).srcref(nameNode);
            Node var = IR.var(name).srcref(n);
            nameNode.setString("");
            compiler.reportChangeToEnclosingScope(n.getLastChild());
            n.replaceWith(var);
            compiler.reportChangeToEnclosingScope(var);
            name.addChildToFront(n);
            return var;
        }

        private void addChildForHoistToScope(Node node) {
            if (this.nestedBlockScopes.isEmpty()) {
                return;
            }
            Node innerMostBlockScope = this.nestedBlockScopes.peek();
            this.hoistNodesToScope.put((Object)innerMostBlockScope, (Object)node.detach());
        }

        private void hoistChildrenToTopOfScope(Node scope) {
            ArrayList nodes = new ArrayList(this.hoistNodesToScope.removeAll((Object)scope));
            Collections.reverse(nodes);
            for (Node node : nodes) {
                scope.addChildToFront(node);
            }
        }
    }
}

