/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import org.jspecify.nullness.Nullable;

class OptionalChainRewriter {
    final AbstractCompiler compiler;
    final AstFactory astFactory;
    final TmpVarNameCreator tmpVarNameCreator;
    final @Nullable Scope scope;
    final Node chainParent;
    final Node wholeChain;
    final Node insertionPoint;
    final ArrayDeque<Node> deletesToDelete;

    static Builder builder(AbstractCompiler compiler) {
        return new Builder(compiler);
    }

    private OptionalChainRewriter(Builder builder, Node wholeChain) {
        Preconditions.checkArgument((boolean)NodeUtil.isEndOfFullOptChain(wholeChain), (Object)wholeChain);
        this.compiler = builder.compiler;
        this.astFactory = builder.astFactory;
        this.tmpVarNameCreator = (TmpVarNameCreator)Preconditions.checkNotNull((Object)builder.tmpVarNameCreator);
        this.scope = builder.scope;
        this.wholeChain = wholeChain;
        this.chainParent = (Node)Preconditions.checkNotNull((Object)wholeChain.getParent(), (Object)wholeChain);
        Node enclosingStatement = NodeUtil.getEnclosingStatement(wholeChain);
        this.insertionPoint = enclosingStatement.getPrevious() != null && enclosingStatement.getPrevious().isLabelName() ? enclosingStatement.getParent() : enclosingStatement;
        this.deletesToDelete = new ArrayDeque();
    }

    void rewrite() {
        Preconditions.checkState((boolean)NodeUtil.isOptChainNode(this.wholeChain), (String)"already rewritten: %s", (Object)this.wholeChain);
        ArrayDeque<Node> startNodeStack = new ArrayDeque<Node>();
        Node subchainEnd = this.wholeChain;
        while (NodeUtil.isOptChainNode(subchainEnd)) {
            Node subchainStart = NodeUtil.getStartOfOptChainSegment(subchainEnd);
            startNodeStack.push(subchainStart);
            subchainEnd = subchainStart.getFirstChild();
        }
        Preconditions.checkState((!startNodeStack.isEmpty() ? 1 : 0) != 0);
        Node optChainReplacement = this.rewriteInitialSegment((Node)startNodeStack.pop(), this.wholeChain);
        while (!startNodeStack.isEmpty()) {
            this.rewriteInitialSegment((Node)startNodeStack.pop(), this.wholeChain);
        }
        if (this.chainParent.isCall() && optChainReplacement.isFirstChildOf(this.chainParent) && NodeUtil.isNormalGet(this.wholeChain)) {
            Node thisValue = this.wholeChain.getFirstChild();
            Node tmpThisNode = this.getSubExprNameNode(thisValue);
            optChainReplacement.detach();
            this.chainParent.addChildToFront(tmpThisNode);
            Node dotCallNode = this.astFactory.createGetPropWithUnknownType(optChainReplacement, "call").srcrefTreeIfMissing(optChainReplacement);
            this.chainParent.addChildToFront(dotCallNode);
        }
        this.compiler.reportChangeToEnclosingScope(this.chainParent);
        if (this.chainParent.isDelProp()) {
            while (!this.deletesToDelete.isEmpty()) {
                Node delete = this.deletesToDelete.removeFirst();
                Preconditions.checkState((boolean)delete.getFirstChild().isHook(), (Object)delete);
                Node hook = delete.getFirstChild();
                hook.detach();
                delete.replaceWith(hook);
                this.compiler.reportChangeToEnclosingScope(hook);
            }
        }
        Node enclosingScript = NodeUtil.getEnclosingScript(this.insertionPoint);
        NodeUtil.addFeatureToScript(enclosingScript, FeatureSet.Feature.LET_DECLARATIONS, this.compiler);
    }

    private Node rewriteInitialSegment(Node fullChainStart, Node fullChainEnd) {
        Node receiverNode = fullChainStart.getFirstChild();
        Node initialChainEnd = NodeUtil.getEndOfOptChainSegment(fullChainStart);
        boolean isBeingDeleted = fullChainEnd.getParent().isDelProp();
        if (isBeingDeleted) {
            this.deletesToDelete.addLast(fullChainEnd.getParent());
        }
        Preconditions.checkArgument((!NodeUtil.isOptChainNode(receiverNode) ? 1 : 0) != 0, (Object)receiverNode);
        NodeUtil.convertToNonOptionalChainSegment(initialChainEnd);
        Node placeholder = IR.empty();
        fullChainEnd.replaceWith(placeholder);
        if (NodeUtil.isNormalGet(receiverNode) && fullChainStart.isCall()) {
            Node thisValue = receiverNode.getFirstChild();
            Node tmpThisNode = this.getSubExprNameNode(thisValue);
            Node tmpReceiverNode = this.getSubExprNameNode(receiverNode);
            receiverNode = fullChainStart.removeFirstChild();
            fullChainStart.addChildToFront(tmpThisNode);
            fullChainStart.addChildToFront(this.astFactory.createGetPropWithUnknownType(tmpReceiverNode, "call").srcrefTreeIfMissing(receiverNode));
        } else {
            Node tmpReceiverNode = this.getSubExprNameNode(receiverNode);
            receiverNode = fullChainStart.getFirstChild();
            receiverNode.replaceWith(tmpReceiverNode);
        }
        Node optChainReplacement = this.astFactory.createHook(this.astFactory.createEq(receiverNode, this.astFactory.createNull()), isBeingDeleted ? this.astFactory.createBoolean(true) : this.astFactory.createUndefinedValue(), isBeingDeleted ? this.astFactory.createDelProp(fullChainEnd) : fullChainEnd).srcrefTreeIfMissing(fullChainEnd);
        placeholder.replaceWith(optChainReplacement);
        return optChainReplacement;
    }

    Node getSubExprNameNode(Node subExpr) {
        String tempVarName = this.declareTempVarName(subExpr);
        Node placeholder = IR.empty();
        subExpr.replaceWith(placeholder);
        Node replacement = this.astFactory.createAssign(tempVarName, subExpr).srcrefTreeIfMissing(subExpr);
        placeholder.replaceWith(replacement);
        return replacement.getFirstChild().cloneNode();
    }

    String declareTempVarName(Node valueNode) {
        String tempVarName = this.tmpVarNameCreator.createTmpVarName();
        Node declarationStatement = this.astFactory.createSingleLetNameDeclaration(tempVarName).srcrefTree(valueNode);
        declarationStatement.getFirstChild().setInferredConstantVar(true);
        declarationStatement.insertBefore(this.insertionPoint);
        this.compiler.reportChangeToEnclosingScope(declarationStatement);
        if (this.scope != null) {
            this.scope.declare(tempVarName, declarationStatement.getFirstChild(), null);
        }
        return tempVarName;
    }

    static class Builder {
        final AbstractCompiler compiler;
        final AstFactory astFactory;
        TmpVarNameCreator tmpVarNameCreator;
        Scope scope;

        private Builder(AbstractCompiler compiler) {
            this.compiler = (AbstractCompiler)Preconditions.checkNotNull((Object)compiler);
            this.astFactory = compiler.createAstFactory();
        }

        @CanIgnoreReturnValue
        Builder setTmpVarNameCreator(TmpVarNameCreator tmpVarNameCreator) {
            this.tmpVarNameCreator = (TmpVarNameCreator)Preconditions.checkNotNull((Object)tmpVarNameCreator);
            return this;
        }

        @CanIgnoreReturnValue
        Builder setScope(Scope scope) {
            this.scope = (Scope)Preconditions.checkNotNull((Object)scope);
            return this;
        }

        OptionalChainRewriter build(Node wholeChain) {
            return new OptionalChainRewriter(this, wholeChain);
        }
    }

    static interface TmpVarNameCreator {
        public String createTmpVarName();
    }
}

