/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import org.jspecify.nullness.Nullable;

class MinimizedCondition {
    private final MeasuredNode positive;
    private final MeasuredNode negative;

    private MinimizedCondition(MeasuredNode p, MeasuredNode n) {
        this.positive = p;
        this.negative = n.change();
    }

    static MinimizedCondition fromConditionNode(Node n) {
        Preconditions.checkState((boolean)n.hasParent());
        switch (n.getToken()) {
            case NOT: 
            case AND: 
            case OR: 
            case HOOK: 
            case COMMA: {
                return MinimizedCondition.computeMinimizedCondition(n);
            }
        }
        return MinimizedCondition.unoptimized(n);
    }

    MeasuredNode getMinimized(MinimizationStyle style) {
        if (style == MinimizationStyle.PREFER_UNNEGATED || this.positive.node.isNot() || this.positive.length <= this.negative.length) {
            return this.positive;
        }
        return this.negative.addNot();
    }

    static MinimizedCondition unoptimized(Node n) {
        Preconditions.checkNotNull((Object)n.getParent());
        MeasuredNode pos = new MeasuredNode(n, null, 0, false);
        MeasuredNode neg = new MeasuredNode(null, null, Integer.MAX_VALUE, true);
        return new MinimizedCondition(pos, neg);
    }

    static MeasuredNode pickBest(MeasuredNode a, MeasuredNode b) {
        if (a.length == b.length) {
            return b.isChanged() ? a : b;
        }
        return a.length < b.length ? a : b;
    }

    private static MinimizedCondition computeMinimizedCondition(Node n) {
        switch (n.getToken()) {
            case NOT: {
                MinimizedCondition subtree = MinimizedCondition.computeMinimizedCondition(n.getFirstChild());
                MeasuredNode positive = MinimizedCondition.pickBest(MeasuredNode.addNode(n, subtree.positive), subtree.negative);
                MeasuredNode negative = MinimizedCondition.pickBest(subtree.negative.negate(), subtree.positive);
                return new MinimizedCondition(positive, negative);
            }
            case AND: 
            case OR: {
                Node complementNode = new Node(n.isAnd() ? Token.OR : Token.AND).srcref(n);
                MinimizedCondition leftSubtree = MinimizedCondition.computeMinimizedCondition(n.getFirstChild());
                MinimizedCondition rightSubtree = MinimizedCondition.computeMinimizedCondition(n.getLastChild());
                MeasuredNode positive = MinimizedCondition.pickBest(MeasuredNode.addNode(n, leftSubtree.positive, rightSubtree.positive), MeasuredNode.addNode(complementNode, leftSubtree.negative, rightSubtree.negative).negate());
                MeasuredNode negative = MinimizedCondition.pickBest(MeasuredNode.addNode(n, leftSubtree.positive, rightSubtree.positive).negate(), MeasuredNode.addNode(complementNode, leftSubtree.negative, rightSubtree.negative).change());
                return new MinimizedCondition(positive, negative);
            }
            case HOOK: {
                Node cond = n.getFirstChild();
                Node thenNode = cond.getNext();
                Node elseNode = thenNode.getNext();
                MinimizedCondition thenSubtree = MinimizedCondition.computeMinimizedCondition(thenNode);
                MinimizedCondition elseSubtree = MinimizedCondition.computeMinimizedCondition(elseNode);
                MeasuredNode positive = MeasuredNode.addNode(n, MeasuredNode.forNode(cond), thenSubtree.positive, elseSubtree.positive);
                MeasuredNode negative = MeasuredNode.addNode(n, MeasuredNode.forNode(cond), thenSubtree.negative, elseSubtree.negative);
                return new MinimizedCondition(positive, negative);
            }
            case COMMA: {
                Node lhs = n.getFirstChild();
                MinimizedCondition rhsSubtree = MinimizedCondition.computeMinimizedCondition(lhs.getNext());
                MeasuredNode positive = MeasuredNode.addNode(n, MeasuredNode.forNode(lhs), rhsSubtree.positive);
                MeasuredNode negative = MeasuredNode.addNode(n, MeasuredNode.forNode(lhs), rhsSubtree.negative);
                return new MinimizedCondition(positive, negative);
            }
        }
        MeasuredNode pos = MeasuredNode.forNode(n);
        MeasuredNode neg = pos.negate();
        return new MinimizedCondition(pos, neg);
    }

    static class MeasuredNode {
        private final Node node;
        private final int length;
        private final boolean changed;
        private final MeasuredNode[] children;

        MeasuredNode(@Nullable Node n, MeasuredNode @Nullable [] children, int len, boolean ch) {
            this.node = n;
            this.children = children;
            this.length = len;
            this.changed = ch;
        }

        boolean isChanged() {
            return this.changed;
        }

        boolean isNot() {
            return this.node.isNot();
        }

        MeasuredNode withoutNot() {
            Preconditions.checkState((boolean)this.isNot());
            return MeasuredNode.normalizeChildren(this.node, this.children)[0].change();
        }

        private MeasuredNode negate() {
            switch (this.node.getToken()) {
                case EQ: {
                    return this.updateToken(Token.NE);
                }
                case NE: {
                    return this.updateToken(Token.EQ);
                }
                case SHEQ: {
                    return this.updateToken(Token.SHNE);
                }
                case SHNE: {
                    return this.updateToken(Token.SHEQ);
                }
                case NOT: {
                    return this.withoutNot();
                }
            }
            return this.addNot();
        }

        static MeasuredNode[] normalizeChildren(Node node, MeasuredNode[] children) {
            if (children != null || !node.hasChildren()) {
                return children;
            }
            MeasuredNode[] measuredChildren = new MeasuredNode[node.getChildCount()];
            int child = 0;
            for (Node c = node.getFirstChild(); c != null; c = c.getNext()) {
                measuredChildren[child++] = MeasuredNode.forNode(c);
            }
            return measuredChildren;
        }

        private MeasuredNode updateToken(Token token) {
            return new MeasuredNode(new Node(token).srcref(this.node), MeasuredNode.normalizeChildren(this.node, this.children), this.length, true);
        }

        private MeasuredNode addNot() {
            return MeasuredNode.addNode(new Node(Token.NOT).srcref(this.node), this).change();
        }

        private MeasuredNode change() {
            return this.isChanged() ? this : new MeasuredNode(this.node, this.children, this.length, true);
        }

        private static int estimateCostOneLevel(Node n, MeasuredNode ... children) {
            int cost = 0;
            if (n.isNot()) {
                ++cost;
            }
            int parentPrecedence = NodeUtil.precedence(n.getToken());
            for (MeasuredNode child : children) {
                if (!child.isLowerPrecedenceThan(parentPrecedence)) continue;
                cost += 2;
            }
            return cost;
        }

        boolean isLowerPrecedenceThan(int precedence) {
            return NodeUtil.precedence(this.node.getToken()) < precedence;
        }

        private static MeasuredNode addNode(Node parent, MeasuredNode ... children) {
            int cost = 0;
            boolean changed = false;
            for (MeasuredNode child : children) {
                cost += child.length;
                changed = changed || child.changed;
            }
            return new MeasuredNode(parent, children, cost += MeasuredNode.estimateCostOneLevel(parent, children), changed);
        }

        private static MeasuredNode forNode(Node n) {
            return new MeasuredNode(n, null, 0, false);
        }

        public boolean willChange(Node original) {
            Preconditions.checkNotNull((Object)original);
            return original != this.node || this.isChanged();
        }

        public Node applyTo(Node original) {
            Preconditions.checkNotNull((Object)original);
            Preconditions.checkState((boolean)this.willChange(original));
            Node replacement = this.buildReplacement();
            if (original != replacement) {
                this.safeDetach(replacement);
                original.replaceWith(replacement);
            }
            return replacement;
        }

        private Node safeDetach(Node n) {
            return n.hasParent() ? n.detach() : n;
        }

        @VisibleForTesting
        Node buildReplacement() {
            if (this.children != null) {
                this.node.detachChildren();
                for (MeasuredNode child : this.children) {
                    Node replacementChild = this.safeDetach(child.buildReplacement());
                    this.node.addChildToBack(replacementChild);
                }
            }
            return this.node;
        }
    }

    static enum MinimizationStyle {
        PREFER_UNNEGATED,
        ALLOW_LEADING_NOT;

    }
}

