/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multiset;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.jspecify.nullness.Nullable;

class MakeDeclaredNamesUnique
extends NodeTraversal.AbstractScopedCallback {
    public static final String ARGUMENTS = "arguments";
    private final Deque<Renamer> renamerStack = new ArrayDeque<Renamer>();
    private final Renamer rootRenamer;
    private final boolean markChanges;
    private final boolean assertOnChange;

    private MakeDeclaredNamesUnique(Renamer renamer, boolean markChanges, boolean assertOnChange) {
        this.rootRenamer = renamer;
        this.markChanges = markChanges;
        this.assertOnChange = assertOnChange;
    }

    static Builder builder() {
        return new Builder();
    }

    static CompilerPass getContextualRenameInverter(AbstractCompiler compiler) {
        return new ContextualRenameInverter(compiler);
    }

    @Override
    public void enterScope(NodeTraversal t) {
        Renamer renamer;
        Node declarationRoot = t.getScopeRoot();
        if (this.renamerStack.isEmpty()) {
            Preconditions.checkState((!declarationRoot.isFunction() || !(this.rootRenamer instanceof ContextualRenamer) ? 1 : 0) != 0);
            renamer = this.rootRenamer;
        } else {
            boolean hoist = !declarationRoot.isFunction() && !NodeUtil.createsBlockScope(declarationRoot);
            renamer = this.renamerStack.peek().createForChildScope(t.getScopeRoot(), hoist);
        }
        this.renamerStack.push(renamer);
        this.findDeclaredNames(t, declarationRoot);
    }

    @Override
    public void exitScope(NodeTraversal t) {
        if (!t.inGlobalScope()) {
            this.renamerStack.pop();
        }
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case NAME: 
            case IMPORT_STAR: {
                this.visitNameOrImportStar(t, n, parent);
                break;
            }
        }
    }

    private void visitNameOrImportStar(NodeTraversal t, Node n, Node parent) {
        if (n.isName() && NodeUtil.isNonlocalModuleExportName(n)) {
            return;
        }
        String newName = this.getReplacementName(n.getString());
        if (newName == null) {
            return;
        }
        if (this.assertOnChange) {
            throw new IllegalStateException("Unexpected renaming in MakeDeclaredNamesUnique. new name: " + newName + " for " + n);
        }
        Renamer renamer = this.renamerStack.peek();
        if (renamer.stripConstIfReplaced()) {
            n.putBooleanProp(Node.IS_CONSTANT_NAME, false);
            Node jsDocInfoNode = NodeUtil.getBestJSDocInfoNode(n);
            if (jsDocInfoNode != null && jsDocInfoNode.getJSDocInfo() != null) {
                JSDocInfo.Builder builder = JSDocInfo.Builder.copyFrom(jsDocInfoNode.getJSDocInfo());
                builder.recordMutable();
                jsDocInfoNode.setJSDocInfo(builder.build());
            }
        }
        n.setString(newName);
        if (this.markChanges) {
            t.reportCodeChange();
            if (parent.isFunction() && NodeUtil.isFunctionDeclaration(parent)) {
                t.getCompiler().reportChangeToEnclosingScope(parent);
            }
        }
    }

    private @Nullable String getReplacementName(String oldName) {
        for (Renamer renamer : this.renamerStack) {
            String newName = renamer.getReplacementName(oldName);
            if (newName == null) continue;
            return newName;
        }
        return null;
    }

    private void findDeclaredNames(NodeTraversal t, Node n) {
        Preconditions.checkState((NodeUtil.createsScope(n) || n.isScript() ? 1 : 0) != 0, (Object)n);
        for (Var v : t.getScope().getVarIterable()) {
            this.renamerStack.peek().addDeclaredName(v.getName(), false);
        }
    }

    static class TargettedRenamer
    implements Renamer {
        private final Renamer delegate;
        private final Set<String> targets;

        TargettedRenamer(Renamer delegate, Set<String> targets) {
            this.delegate = delegate;
            this.targets = targets;
        }

        @Override
        public void addDeclaredName(String name, boolean hoisted) {
            if (this.targets.contains(name)) {
                this.delegate.addDeclaredName(name, hoisted);
            }
        }

        @Override
        public @Nullable String getReplacementName(String oldName) {
            return this.targets.contains(oldName) ? this.delegate.getReplacementName(oldName) : null;
        }

        @Override
        public boolean stripConstIfReplaced() {
            return this.delegate.stripConstIfReplaced();
        }

        @Override
        public Renamer createForChildScope(Node scopeRoot, boolean hoistingTargetScope) {
            return new TargettedRenamer(this.delegate.createForChildScope(scopeRoot, hoistingTargetScope), this.targets);
        }

        @Override
        public Renamer getHoistRenamer() {
            return this.delegate.getHoistRenamer();
        }
    }

    static class BoilerplateRenamer
    extends ContextualRenamer {
        private final Supplier<String> uniqueIdSupplier;
        private final String idPrefix;
        private final CodingConvention convention;

        BoilerplateRenamer(CodingConvention convention, Supplier<String> uniqueIdSupplier, String idPrefix) {
            this.convention = convention;
            this.uniqueIdSupplier = uniqueIdSupplier;
            this.idPrefix = idPrefix;
        }

        @Override
        public Renamer createForChildScope(Node scopeRoot, boolean hoisted) {
            return new InlineRenamer(this.convention, this.uniqueIdSupplier, this.idPrefix, false, hoisted, this);
        }
    }

    static class InlineRenamer
    implements Renamer {
        private final Map<String, String> declarations = new LinkedHashMap<String, String>();
        private final Supplier<String> uniqueIdSupplier;
        private final String idPrefix;
        private final boolean removeConstness;
        private final CodingConvention convention;
        private final Renamer hoistRenamer;

        InlineRenamer(CodingConvention convention, Supplier<String> uniqueIdSupplier, String idPrefix, boolean removeConstness, boolean hoistingTargetScope, Renamer parent) {
            this.convention = convention;
            this.uniqueIdSupplier = uniqueIdSupplier;
            Preconditions.checkArgument((!idPrefix.isEmpty() ? 1 : 0) != 0);
            this.idPrefix = idPrefix;
            this.removeConstness = removeConstness;
            this.hoistRenamer = hoistingTargetScope ? this : parent.getHoistRenamer();
        }

        @Override
        public void addDeclaredName(String name, boolean hoisted) {
            Preconditions.checkState((!name.equals(MakeDeclaredNamesUnique.ARGUMENTS) ? 1 : 0) != 0);
            if (hoisted && this.hoistRenamer != this) {
                this.hoistRenamer.addDeclaredName(name, hoisted);
            } else {
                this.declarations.computeIfAbsent(name, this::getUniqueName);
            }
        }

        private String getUniqueName(String name) {
            if (((String)name).isEmpty()) {
                return name;
            }
            if (((String)name).contains("$jscomp$")) {
                name = ((String)name).substring(0, ((String)name).lastIndexOf("$jscomp$"));
            }
            if (this.convention.isExported((String)name)) {
                name = "JSCompiler_" + (String)name;
            }
            return (String)name + "$jscomp$" + this.idPrefix + this.uniqueIdSupplier.get();
        }

        @Override
        public String getReplacementName(String oldName) {
            return this.declarations.get(oldName);
        }

        @Override
        public Renamer createForChildScope(Node scopeRoot, boolean hoistingTargetScope) {
            return new InlineRenamer(this.convention, this.uniqueIdSupplier, this.idPrefix, this.removeConstness, hoistingTargetScope, this);
        }

        @Override
        public boolean stripConstIfReplaced() {
            return this.removeConstness;
        }

        @Override
        public Renamer getHoistRenamer() {
            return this.hoistRenamer;
        }
    }

    static class ContextualRenamer
    implements Renamer {
        private final @Nullable Node scopeRoot;
        private final Multiset<String> nameUsage;
        private final Map<String, String> declarations = new LinkedHashMap<String, String>();
        private final boolean global;
        private final Renamer hoistRenamer;
        static final String UNIQUE_ID_SEPARATOR = "$jscomp$";

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("scopeRoot", (Object)this.scopeRoot).add("nameUsage", this.nameUsage).add("declarations", this.declarations).add("global", this.global).toString();
        }

        ContextualRenamer() {
            this.scopeRoot = null;
            this.global = true;
            this.nameUsage = HashMultiset.create();
            this.hoistRenamer = this;
        }

        private ContextualRenamer(Node scopeRoot, Multiset<String> nameUsage, boolean hoistingTargetScope, Renamer parent) {
            Preconditions.checkState((boolean)NodeUtil.createsScope(scopeRoot), (Object)scopeRoot);
            if (scopeRoot.isFunction()) {
                Preconditions.checkState((!hoistingTargetScope ? 1 : 0) != 0, (Object)scopeRoot);
            }
            this.scopeRoot = scopeRoot;
            this.global = false;
            this.nameUsage = nameUsage;
            if (hoistingTargetScope) {
                Preconditions.checkState((!NodeUtil.createsBlockScope(scopeRoot) ? 1 : 0) != 0, (Object)scopeRoot);
                this.hoistRenamer = this;
            } else {
                Preconditions.checkState((NodeUtil.createsBlockScope(scopeRoot) || scopeRoot.isFunction() ? 1 : 0) != 0, (Object)scopeRoot);
                this.hoistRenamer = parent.getHoistRenamer();
            }
        }

        @Override
        public Renamer createForChildScope(Node scopeRoot, boolean hoistingTargetScope) {
            return new ContextualRenamer(scopeRoot, this.nameUsage, hoistingTargetScope, this);
        }

        @Override
        public void addDeclaredName(String name, boolean hoisted) {
            if (hoisted && this.hoistRenamer != this) {
                this.hoistRenamer.addDeclaredName(name, true);
            } else if (!name.equals(MakeDeclaredNamesUnique.ARGUMENTS)) {
                if (this.global) {
                    this.reserveName(name);
                } else if (!this.declarations.containsKey(name)) {
                    int id = this.incrementNameCount(name);
                    String newName = null;
                    if (id != 0) {
                        newName = ContextualRenamer.getUniqueName(name, id);
                    }
                    this.declarations.put(name, newName);
                }
            }
        }

        @Override
        public String getReplacementName(String oldName) {
            return this.declarations.get(oldName);
        }

        private static String getUniqueName(String name, int id) {
            return name + UNIQUE_ID_SEPARATOR + id;
        }

        private void reserveName(String name) {
            this.nameUsage.setCount((Object)name, 0, 1);
        }

        private int incrementNameCount(String name) {
            return this.nameUsage.add((Object)name, 1);
        }

        @Override
        public boolean stripConstIfReplaced() {
            return false;
        }

        @Override
        public Renamer getHoistRenamer() {
            return this.hoistRenamer;
        }
    }

    static class ContextualRenameInverter
    implements NodeTraversal.ScopedCallback,
    CompilerPass {
        private final AbstractCompiler compiler;
        private final Deque<ScopeContext> scopeContextStack = new ArrayDeque<ScopeContext>();
        private final VariableInfoStackMap variablesStackedByName = new VariableInfoStackMap();

        private ContextualRenameInverter(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        @Override
        public void process(Node externs, Node js) {
            NodeTraversal.traverse(this.compiler, js, this);
        }

        public static String getOriginalName(String name) {
            int index = ContextualRenameInverter.indexOfSeparator(name);
            return index <= 0 ? name : name.substring(0, index);
        }

        private static int indexOfSeparator(String name) {
            return name.lastIndexOf("$jscomp$");
        }

        @Override
        public void enterScope(NodeTraversal t) {
            if (t.inGlobalScope()) {
                return;
            }
            Scope scope = t.getScope();
            ImmutableList.Builder declaredVariablesBuilder = ImmutableList.builder();
            for (Var var : scope.getVarIterable()) {
                DeclaredVariableInfo variableInfo = this.createDeclaredVariableInfo(var);
                declaredVariablesBuilder.add((Object)variableInfo);
                this.variablesStackedByName.pushVariableInfo(variableInfo);
            }
            ScopeContext parent = this.scopeContextStack.peek();
            this.scopeContextStack.push(new ScopeContext(scope, (ImmutableList<DeclaredVariableInfo>)declaredVariablesBuilder.build(), parent));
        }

        private DeclaredVariableInfo createDeclaredVariableInfo(Var var) {
            RenamingInfo renamingInfo;
            String currentName = var.getName();
            int indexOfSeparator = ContextualRenameInverter.indexOfSeparator(currentName);
            if (indexOfSeparator > 0) {
                String invertedName = currentName.substring(0, indexOfSeparator);
                renamingInfo = new RenamingInfo(currentName, invertedName);
            } else {
                renamingInfo = null;
            }
            return new DeclaredVariableInfo(var, renamingInfo);
        }

        @Override
        public void exitScope(NodeTraversal t) {
            if (t.inGlobalScope()) {
                return;
            }
            ScopeContext scopeContext = (ScopeContext)Preconditions.checkNotNull((Object)this.scopeContextStack.pop());
            for (VariableInfo referencedVariable : scopeContext.referencedVariables) {
                scopeContext.recordPotentialConflicts(referencedVariable);
            }
            for (DeclaredVariableInfo declaredVariableInfo : scopeContext.declaredVariableInfos) {
                String variableName = declaredVariableInfo.getName();
                VariableInfo oldStackTop = this.variablesStackedByName.popVariableInfo(variableName);
                Preconditions.checkState((oldStackTop == declaredVariableInfo ? 1 : 0) != 0, (String)"Declared variable \"%s\" was not the top of the name stack", (Object)variableName);
                declaredVariableInfo.tryToInvertName();
            }
            if (this.scopeContextStack.isEmpty()) {
                this.variablesStackedByName.clear();
            }
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node node, Node parent) {
            ScopeContext scopeContext = this.scopeContextStack.peek();
            if (scopeContext != null && (NodeUtil.isReferenceName(node) || node.isImportStar())) {
                String name = node.getString();
                VariableInfo variableInfo = this.variablesStackedByName.getOrCreateCurrentVariableInfo(name);
                variableInfo.addReferenceNode(node);
                scopeContext.addReferencedVariableInfo(variableInfo);
            }
        }

        private VariableInfo createUndeclaredVariableInfo(String name) {
            return new UndeclaredVariableInfo(name);
        }

        static interface VariableInfo {
            public void addReferenceNode(Node var1);

            public String getName();

            public int getScopeDepth();

            public void addPotentialConflict(VariableInfo var1);
        }

        private static class UndeclaredVariableInfo
        implements VariableInfo {
            final String name;

            private UndeclaredVariableInfo(String name) {
                this.name = name;
            }

            @Override
            public void addReferenceNode(Node nameNode) {
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public int getScopeDepth() {
                return 0;
            }

            @Override
            public void addPotentialConflict(VariableInfo variableInfo) {
            }
        }

        private class VariableInfoStackMap {
            final Map<String, Deque<VariableInfo>> mapOfStacks = new LinkedHashMap<String, Deque<VariableInfo>>();

            private VariableInfoStackMap() {
            }

            void pushVariableInfo(VariableInfo info) {
                String name = info.getName();
                Deque<VariableInfo> variableInfoStack = this.getVariableInfoStack(name);
                variableInfoStack.push(info);
            }

            private Deque<VariableInfo> getVariableInfoStack(String name) {
                return this.mapOfStacks.computeIfAbsent(name, ignoredKey -> new ArrayDeque());
            }

            VariableInfo getOrCreateCurrentVariableInfo(String name) {
                VariableInfo variableInfo;
                Deque<VariableInfo> variableInfoStack = this.getVariableInfoStack(name);
                if (variableInfoStack.isEmpty()) {
                    variableInfo = ContextualRenameInverter.this.createUndeclaredVariableInfo(name);
                    variableInfoStack.push(variableInfo);
                } else {
                    variableInfo = variableInfoStack.peek();
                }
                return variableInfo;
            }

            VariableInfo popVariableInfo(String name) {
                Deque<VariableInfo> variableInfos = this.mapOfStacks.get(name);
                Preconditions.checkNotNull(variableInfos, (String)"Nonexistent variable info requested: '%s'", (Object)name);
                VariableInfo info = variableInfos.pop();
                if (variableInfos.isEmpty()) {
                    this.mapOfStacks.remove(name);
                }
                return info;
            }

            void clear() {
                this.mapOfStacks.clear();
            }
        }

        private static class ScopeContext {
            final @Nullable ScopeContext parent;
            final Scope scope;
            final ImmutableList<DeclaredVariableInfo> declaredVariableInfos;
            final Set<VariableInfo> referencedVariables = new LinkedHashSet<VariableInfo>();

            private ScopeContext(Scope scope, ImmutableList<DeclaredVariableInfo> declaredVariableInfos, @Nullable ScopeContext parent) {
                this.scope = scope;
                this.declaredVariableInfos = declaredVariableInfos;
                this.parent = parent;
            }

            public void addReferencedVariableInfo(VariableInfo variableInfo) {
                this.referencedVariables.add(variableInfo);
            }

            public void recordPotentialConflicts(VariableInfo referencedVariable) {
                int referencedVariableDeclarationDepth;
                int thisScopeDepth = this.scope.getDepth();
                if (thisScopeDepth >= (referencedVariableDeclarationDepth = referencedVariable.getScopeDepth())) {
                    for (DeclaredVariableInfo declaredVariableInfo : this.declaredVariableInfos) {
                        referencedVariable.addPotentialConflict(declaredVariableInfo);
                        declaredVariableInfo.addPotentialConflict(referencedVariable);
                    }
                    if (this.parent != null) {
                        this.parent.recordPotentialConflicts(referencedVariable);
                    }
                }
            }
        }

        private static class DeclaredVariableInfo
        implements VariableInfo {
            final Var var;
            String name;
            private @Nullable RenamingInfo renamingInfo;

            DeclaredVariableInfo(Var var, @Nullable RenamingInfo renamingInfo) {
                this.var = var;
                this.name = var.getName();
                this.renamingInfo = renamingInfo;
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public int getScopeDepth() {
                return ((Scope)this.var.getScope()).getDepth();
            }

            @Override
            public void addPotentialConflict(VariableInfo variableInfo) {
                if (this.renamingInfo != null && variableInfo != this) {
                    this.renamingInfo.addPotentialShadowVariable(variableInfo);
                }
            }

            @Override
            public void addReferenceNode(Node nameNode) {
                if (this.renamingInfo != null) {
                    this.renamingInfo.referenceNodes.add(nameNode);
                }
            }

            private void tryToInvertName() {
                if (this.renamingInfo != null) {
                    this.name = this.renamingInfo.attemptRename();
                    this.renamingInfo = null;
                }
            }
        }

        class RenamingInfo {
            private final List<Node> referenceNodes = new ArrayList<Node>();
            private final Set<VariableInfo> potentialShadowVariables = new LinkedHashSet<VariableInfo>();
            private final String currentName;
            private final String preferredName;

            RenamingInfo(String currentName, String preferredName) {
                this.currentName = currentName;
                this.preferredName = preferredName;
            }

            void addPotentialShadowVariable(VariableInfo variableInfo) {
                this.potentialShadowVariables.add(variableInfo);
            }

            String attemptRename() {
                LinkedHashSet<String> disallowedNames = new LinkedHashSet<String>();
                disallowedNames.add(MakeDeclaredNamesUnique.ARGUMENTS);
                for (VariableInfo potentialShadowVariable : this.potentialShadowVariables) {
                    String potentialShadowName = potentialShadowVariable.getName();
                    disallowedNames.add(potentialShadowName);
                }
                Object newName = this.preferredName;
                if (disallowedNames.contains(this.preferredName)) {
                    String baseName = this.preferredName + "$jscomp$";
                    int i = 0;
                    while (disallowedNames.contains(newName = baseName + i++)) {
                    }
                }
                if (((String)newName).equals(this.currentName)) {
                    return this.currentName;
                }
                for (Node referenceNode : this.referenceNodes) {
                    referenceNode.setString((String)newName);
                    ContextualRenameInverter.this.compiler.reportChangeToEnclosingScope(referenceNode);
                    Node parent = referenceNode.getParent();
                    if (!parent.isFunction() || !NodeUtil.isFunctionDeclaration(parent)) continue;
                    ContextualRenameInverter.this.compiler.reportChangeToEnclosingScope(parent);
                }
                return newName;
            }
        }
    }

    static interface Renamer {
        public void addDeclaredName(String var1, boolean var2);

        public String getReplacementName(String var1);

        public boolean stripConstIfReplaced();

        public Renamer createForChildScope(Node var1, boolean var2);

        public Renamer getHoistRenamer();
    }

    static final class Builder {
        private Renamer renamer;
        private boolean markChanges = true;
        private boolean assertOnChange = false;

        private Builder() {
        }

        Builder withRenamer(Renamer renamer) {
            this.renamer = renamer;
            return this;
        }

        Builder withMarkChanges(boolean markChanges) {
            this.markChanges = markChanges;
            return this;
        }

        Builder withAssertOnChange(boolean assertOnChange) {
            this.assertOnChange = assertOnChange;
            return this;
        }

        MakeDeclaredNamesUnique build() {
            if (this.renamer == null) {
                this.renamer = new ContextualRenamer();
            }
            return new MakeDeclaredNamesUnique(this.renamer, this.markChanges, this.assertOnChange);
        }
    }
}

