/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

@GwtIncompatible(value="Unnecessary")
final class LocaleDataPasses {
    static final String GOOG_LOCALE_REPLACEMENT = "__JSC_LOCALE__";
    private static final Node QNAME_FOR_GOOG_LOCALE = IR.getprop(IR.name("goog"), "LOCALE");

    private LocaleDataPasses() {
    }

    private static boolean isGoogDotLocaleReference(Node n) {
        return n.matchesQualifiedName(QNAME_FOR_GOOG_LOCALE);
    }

    static class LocaleSubstitutions
    extends NodeTraversal.AbstractPostOrderCallback
    implements CompilerPass {
        private static final String DEFAULT_LOCALE = "en";
        private final Node qnameForLocale = IR.name("__JSC_LOCALE__");
        private final AbstractCompiler compiler;
        private final AstFactory astFactory;
        private final String locale;

        LocaleSubstitutions(AbstractCompiler compiler, String locale) {
            this.compiler = compiler;
            this.astFactory = compiler.createAstFactory();
            this.locale = locale == null ? DEFAULT_LOCALE : locale;
        }

        @Override
        public void process(Node externs, Node root) {
            NodeTraversal.traverse(this.compiler, root, this);
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.matchesName(this.qnameForLocale)) {
                Node replacement = this.astFactory.createString((String)Preconditions.checkNotNull((Object)this.locale)).srcref(n);
                n.replaceWith(replacement);
                this.compiler.reportChangeToEnclosingScope(replacement);
            }
        }
    }

    private static class ProtectCurrentLocale
    extends NodeTraversal.AbstractPostOrderCallback {
        private final AbstractCompiler compiler;
        private final AstFactory astFactory;

        ProtectCurrentLocale(AbstractCompiler compiler) {
            this.compiler = compiler;
            this.astFactory = compiler.createAstFactory();
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (LocaleDataPasses.isGoogDotLocaleReference(n)) {
                Node nodeToReplace = NodeUtil.isLhsOfAssign(n) ? n.getNext() : n;
                Node replacement = this.astFactory.createName(LocaleDataPasses.GOOG_LOCALE_REPLACEMENT, AstFactory.type(nodeToReplace));
                replacement.putBooleanProp(Node.IS_CONSTANT_NAME, true);
                nodeToReplace.replaceWith(replacement);
                this.compiler.reportChangeToEnclosingScope(parent);
            }
        }
    }

    static class ProtectGoogLocale
    implements CompilerPass {
        private final AbstractCompiler compiler;

        ProtectGoogLocale(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        @Override
        public void process(Node externs, Node root) {
            NodeUtil.createSynthesizedExternsSymbol(this.compiler, LocaleDataPasses.GOOG_LOCALE_REPLACEMENT);
            ProtectCurrentLocale protectLocaleCallback = new ProtectCurrentLocale(this.compiler);
            NodeTraversal.traverse(this.compiler, root, protectLocaleCallback);
        }
    }
}

