/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.LinkedHashMultimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractVar;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeIterators;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Reference;
import com.google.javascript.jscomp.ReferenceCollection;
import com.google.javascript.jscomp.ReferenceCollector;
import com.google.javascript.jscomp.ReferenceMap;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.HashMap;
import java.util.List;
import org.jspecify.nullness.Nullable;

class InlineVariables
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final Mode mode;
    private static final VarExpert NO_INLINE_SELF_OR_ALIASES_EXPERT = new VarExpert(){

        @Override
        public InlineVarAnalysis analyze() {
            return NO_INLINE_SELF_OR_ALIASES_ANALYSIS;
        }
    };
    private static final VarExpert NO_INLINE_SELF_ALIASES_OK_EXPERT = new VarExpert(){

        @Override
        public InlineVarAnalysis analyze() {
            return NO_INLINE_SELF_ALIASES_OK_ANALYSIS;
        }
    };
    private static final InlineVarAnalysis NO_INLINE_SELF_OR_ALIASES_ANALYSIS = new InlineVarAnalysis(){};
    private static final InlineVarAnalysis NO_INLINE_SELF_ALIASES_OK_ANALYSIS = new InlineVarAnalysis(){

        @Override
        public boolean isSafeToInlineAliases() {
            return true;
        }
    };

    InlineVariables(AbstractCompiler compiler, Mode mode) {
        this.compiler = compiler;
        this.mode = mode;
    }

    @Override
    public void process(Node externs, Node root) {
        ReferenceCollector callback = new ReferenceCollector(this.compiler, new InliningBehavior(), new SyntacticScopeCreator(this.compiler), this.mode.varPredicate);
        callback.process(externs, root);
    }

    private static boolean hasNoInlineAnnotation(Var var) {
        JSDocInfo jsDocInfo = var.getJSDocInfo();
        return jsDocInfo != null && jsDocInfo.isNoInline();
    }

    private static class InitiallyUnknown<T> {
        protected boolean isKnown = false;
        protected @Nullable T value = null;

        private InitiallyUnknown() {
        }

        boolean isKnown() {
            return this.isKnown;
        }

        boolean isKnownNotNull() {
            return this.isKnownNotToBe(null);
        }

        boolean isKnownToBe(T other) {
            return this.isKnown && this.value == other;
        }

        boolean isKnownNotToBe(T other) {
            return this.isKnown && this.value != other;
        }

        T setKnownValueOnce(T value) {
            Preconditions.checkState((!this.isKnown ? 1 : 0) != 0, (Object)"already known");
            this.value = value;
            this.isKnown = true;
            return value;
        }

        T getKnownValue() {
            Preconditions.checkState((boolean)this.isKnown, (Object)"not yet known");
            return this.value;
        }
    }

    private class InliningBehavior
    implements ReferenceCollector.Behavior {
        final HashMap<Var, InlineVarAnalysis> currentScopeHandledVarAnalysesMap = new HashMap();
        final LinkedHashMultimap<Var, AliasInlineRetryHandler> varToAliasRetryHandlersMap = LinkedHashMultimap.create();

        private InliningBehavior() {
        }

        @Override
        public void afterExitScope(NodeTraversal t, ReferenceMap referenceMap) {
            this.doInlinesForScope(t, referenceMap);
        }

        private void doInlinesForScope(NodeTraversal t, ReferenceMap referenceMap) {
            this.currentScopeHandledVarAnalysesMap.clear();
            boolean mayBeAParameterModifiedViaArguments = this.varsInThisScopeMayBeModifiedUsingArguments(t.getScope(), referenceMap);
            for (Var v : t.getScope().getVarIterable()) {
                ReferenceCollection referenceInfo;
                VarExpert expert = this.createVarExpert(v, referenceInfo = referenceMap.getReferences(v), mayBeAParameterModifiedViaArguments);
                InlineVarAnalysis analysis = expert.analyze();
                if (analysis.shouldWaitForAliasedVar()) {
                    AliasInlineRetryHandler retryHandler = new AliasInlineRetryHandler(v, expert);
                    Var aliasedVar = analysis.getAliasedVar();
                    InlineVarAnalysis aliasedVarAnalysis = this.currentScopeHandledVarAnalysesMap.get(aliasedVar);
                    if (aliasedVarAnalysis != null) {
                        retryHandler.handleAliasedVarCompletion(aliasedVar, aliasedVarAnalysis);
                        continue;
                    }
                    this.varToAliasRetryHandlersMap.put((Object)aliasedVar, (Object)retryHandler);
                    continue;
                }
                if (analysis.shouldInline()) {
                    analysis.performInline();
                }
                this.currentScopeHandledVarAnalysesMap.put(v, analysis);
                this.retryAliases(v, analysis);
            }
        }

        private boolean varsInThisScopeMayBeModifiedUsingArguments(Scope scope, ReferenceMap referenceMap) {
            Var arguments;
            ReferenceCollection refs;
            if (scope.isFunctionScope() && !scope.getRootNode().isArrowFunction() && (refs = referenceMap.getReferences(arguments = (Var)scope.getArgumentsVar())) != null && !refs.references.isEmpty()) {
                for (Reference ref : refs.references) {
                    if (this.isSafeUseOfArguments(ref.getNode())) continue;
                    return true;
                }
            }
            return false;
        }

        private void retryAliases(Var aliasedVar, InlineVarAnalysis aliasedVarAnalysis) {
            for (AliasInlineRetryHandler aliasInlineRetryHandler : this.varToAliasRetryHandlersMap.removeAll((Object)aliasedVar)) {
                aliasInlineRetryHandler.handleAliasedVarCompletion(aliasedVar, aliasedVarAnalysis);
            }
        }

        private VarExpert createVarExpert(Var v, ReferenceCollection referenceInfo, boolean mayBeAParameterModifiedViaArguments) {
            if (referenceInfo == null) {
                return NO_INLINE_SELF_OR_ALIASES_EXPERT;
            }
            boolean isDeclaredOrInferredConstant = v.isDeclaredOrInferredConst();
            if (!isDeclaredOrInferredConstant && InlineVariables.this.mode == Mode.CONSTANTS_ONLY) {
                return NO_INLINE_SELF_OR_ALIASES_EXPERT;
            }
            if (v.isExtern()) {
                return NO_INLINE_SELF_OR_ALIASES_EXPERT;
            }
            if (InlineVariables.this.compiler.getCodingConvention().isExported(v.getName(), v.isLocal())) {
                return NO_INLINE_SELF_OR_ALIASES_EXPERT;
            }
            if (InlineVariables.this.compiler.getCodingConvention().isPropertyRenameFunction(v.getNameNode())) {
                return NO_INLINE_SELF_ALIASES_OK_EXPERT;
            }
            VarExpertInitData initData = new VarExpertInitData();
            initData.v = v;
            initData.referenceInfo = referenceInfo;
            initData.isDeclaredOrInferredConstant = isDeclaredOrInferredConstant;
            initData.mayBeAParameterModifiedViaArguments = mayBeAParameterModifiedViaArguments;
            return new StandardVarExpert(initData);
        }

        boolean isSafeUseOfArguments(Node argumentsNode) {
            Preconditions.checkArgument((boolean)argumentsNode.matchesName("arguments"));
            return this.isTargetOfPropertyRead(argumentsNode) || this.isSecondArgumentToDotApplyMethod(argumentsNode);
        }

        boolean isTargetOfPropertyRead(Node n) {
            Node getNode = n.getParent();
            return n.isFirstChildOf(getNode) && NodeUtil.isNormalOrOptChainGet(getNode) && !NodeUtil.isLValue(getNode);
        }

        boolean isSecondArgumentToDotApplyMethod(Node n) {
            Node thisArgNode;
            Node calleeNode;
            Node callNode = n.getParent();
            if (NodeUtil.isNormalOrOptChainCall(callNode) && NodeUtil.isNormalOrOptChainGetProp(calleeNode = callNode.getFirstChild()) && calleeNode.getString().equals("apply") && (thisArgNode = calleeNode.getNext()) != null) {
                return thisArgNode.getNext() == n;
            }
            return false;
        }

        private void inline(Reference decl, Reference init, Reference ref) {
            Node value = init.getAssignedValue();
            Preconditions.checkState((value != null ? 1 : 0) != 0);
            boolean isFunctionDeclaration = NodeUtil.isFunctionDeclaration(value);
            if (isFunctionDeclaration) {
                Node funcName = value.getFirstChild();
                Preconditions.checkNotNull((Object)funcName);
                Preconditions.checkState((boolean)funcName.isName());
                funcName.setString("");
                InlineVariables.this.compiler.reportChangeToChangeScope(value);
                InlineVariables.this.compiler.reportChangeToEnclosingScope(value.getParent());
            }
            this.inlineValue(ref.getNode(), value.detach());
            if (decl != init) {
                Node expressRoot = init.getGrandparent();
                Preconditions.checkState((boolean)expressRoot.isExprResult());
                NodeUtil.removeChild(expressRoot.getParent(), expressRoot);
            }
            if (!isFunctionDeclaration) {
                this.removeDeclaration(decl);
            }
        }

        private void inlineWellDefinedVariable(Var v, Node value, List<Reference> refSet) {
            for (Reference r : refSet) {
                if (r.getNode() == v.getNameNode()) {
                    this.removeDeclaration(r);
                    continue;
                }
                if (r.isSimpleAssignmentToName()) {
                    this.inlineValue(r.getParent(), value.detach());
                    continue;
                }
                Node clonedValue = value.cloneTree();
                NodeUtil.markNewScopesChanged(clonedValue, InlineVariables.this.compiler);
                this.inlineValue(r.getNode(), clonedValue);
            }
        }

        private void removeDeclaration(Reference decl) {
            Node varNode = decl.getParent();
            Preconditions.checkState((boolean)NodeUtil.isNameDeclaration(varNode), (Object)varNode);
            Node grandparent = decl.getGrandparent();
            InlineVariables.this.compiler.reportChangeToEnclosingScope(decl.getNode());
            decl.getNode().detach();
            if (!varNode.hasChildren()) {
                NodeUtil.removeChild(grandparent, varNode);
            }
        }

        private void inlineValue(Node toRemove, Node toInsert) {
            InlineVariables.this.compiler.reportChangeToEnclosingScope(toRemove);
            if (toRemove.getColor() != null && toRemove.isColorFromTypeCast()) {
                toInsert.setColor(toRemove.getColor());
                toInsert.setColorFromTypeCast();
            }
            toRemove.replaceWith(toInsert);
            NodeUtil.markFunctionsDeleted(toRemove, InlineVariables.this.compiler);
        }

        private boolean canInline(Reference declaration, Reference initialization, Reference reference, Node initValue) {
            if (declaration != initialization && !initialization.getGrandparent().isExprResult()) {
                return false;
            }
            if (declaration.getBasicBlock() != initialization.getBasicBlock() || declaration.getBasicBlock() != reference.getBasicBlock()) {
                return false;
            }
            Preconditions.checkState((initValue != null ? 1 : 0) != 0);
            if (initValue.isGetProp() && reference.getParent().isCall() && reference.getParent().getFirstChild() == reference.getNode()) {
                return false;
            }
            if (initValue.isFunction()) {
                Node callNode = reference.getParent();
                if (reference.getParent().isCall()) {
                    CodingConvention convention = InlineVariables.this.compiler.getCodingConvention();
                    CodingConvention.SubclassRelationship relationship = convention.getClassesDefinedByCall(callNode);
                    if (relationship != null) {
                        return false;
                    }
                    if (convention.getSingletonGetterClassName(callNode) != null) {
                        return false;
                    }
                }
            }
            if (initialization.getScope() != declaration.getScope() || !initialization.getScope().contains(reference.getScope())) {
                return false;
            }
            return this.canMoveAggressively(initValue) || this.canMoveModerately(initialization, reference);
        }

        private boolean canMoveAggressively(Node value) {
            return NodeUtil.isLiteralValue(value, true) || value.isFunction();
        }

        private boolean canMoveModerately(Reference initialization, Reference reference) {
            NodeIterators.LocalVarMotion it;
            if (NodeUtil.isNameDeclaration(initialization.getParent())) {
                it = NodeIterators.LocalVarMotion.forVar(InlineVariables.this.compiler, initialization.getNode(), initialization.getParent(), initialization.getGrandparent());
            } else if (initialization.getParent().isAssign()) {
                Preconditions.checkState((boolean)initialization.getGrandparent().isExprResult());
                it = NodeIterators.LocalVarMotion.forAssign(InlineVariables.this.compiler, initialization.getNode(), initialization.getParent(), initialization.getGrandparent(), initialization.getGrandparent().getParent());
            } else {
                throw new IllegalStateException("Unexpected initialization parent\n" + initialization.getParent().toStringTree());
            }
            Node targetName = reference.getNode();
            while (it.hasNext()) {
                Node curNode = (Node)it.next();
                if (curNode != targetName) continue;
                return true;
            }
            return false;
        }

        private boolean isValidDeclaration(Reference declaration) {
            return NodeUtil.isNameDeclaration(declaration.getParent()) && !NodeUtil.isLoopStructure(declaration.getGrandparent()) || NodeUtil.isFunctionDeclaration(declaration.getParent());
        }

        private boolean isValidInitialization(Reference initialization) {
            if (initialization == null) {
                return false;
            }
            if (initialization.isDeclaration()) {
                if (!NodeUtil.isFunctionDeclaration(initialization.getParent()) && !initialization.getNode().hasChildren()) {
                    return false;
                }
            } else {
                Node parent = initialization.getParent();
                Preconditions.checkState((parent.isAssign() && parent.getFirstChild() == initialization.getNode() ? 1 : 0) != 0);
            }
            return true;
        }

        private boolean isValidReference(Reference reference) {
            return !reference.isDeclaration() && !reference.isLvalue();
        }

        private class VarExpertInitData {
            Var v;
            ReferenceCollection referenceInfo;
            boolean isDeclaredOrInferredConstant;
            boolean mayBeAParameterModifiedViaArguments;

            private VarExpertInitData() {
            }
        }

        private class VarIsAliasAnalysis
        extends InlineVarAnalysis {
            private final Var aliasedVar;

            private VarIsAliasAnalysis(Var aliasedVar) {
                this.aliasedVar = aliasedVar;
            }

            @Override
            public boolean shouldWaitForAliasedVar() {
                return true;
            }

            @Override
            public Var getAliasedVar() {
                return this.aliasedVar;
            }

            @Override
            public boolean isSafeToInlineAliases() {
                throw new UnsupportedOperationException("analysis is incomplete");
            }
        }

        private class PositiveInlineVarAnalysis
        extends InlineVarAnalysis {
            private final Runnable inliner;

            private PositiveInlineVarAnalysis(Runnable inliner) {
                this.inliner = inliner;
            }

            @Override
            public boolean shouldInline() {
                return true;
            }

            @Override
            public void performInline() {
                this.inliner.run();
            }

            @Override
            public boolean isSafeToInlineAliases() {
                return true;
            }
        }

        private class StandardVarExpert
        extends VarExpert {
            private final Var v;
            private final ReferenceCollection referenceInfo;
            private final Reference declaration;
            private final boolean isDeclaredOrInferredConstant;
            private final boolean mayBeAParameterModifiedViaArguments;
            private final InitiallyUnknown<Boolean> isNeverAssigned = new InitiallyUnknown();
            private final InitiallyUnknown<Boolean> isWellDefined = new InitiallyUnknown();
            private final InitiallyUnknown<Boolean> isAssignedOnceInLifetime = new InitiallyUnknown();
            private final InitiallyUnknown<Boolean> isWellDefinedAssignedOnce = new InitiallyUnknown();
            private final InitiallyUnknown<Reference> initializationReference = new InitiallyUnknown();
            private final InitiallyUnknown<Boolean> allReferencesAreValid = new InitiallyUnknown();

            StandardVarExpert(VarExpertInitData initData) {
                this.v = initData.v;
                this.referenceInfo = initData.referenceInfo;
                this.declaration = initData.referenceInfo.references.get(0);
                this.isDeclaredOrInferredConstant = initData.isDeclaredOrInferredConstant;
                this.mayBeAParameterModifiedViaArguments = initData.mayBeAParameterModifiedViaArguments;
            }

            private boolean isNeverAssigned() {
                if (this.isNeverAssigned.isKnown()) {
                    return this.isNeverAssigned.getKnownValue();
                }
                if (this.initializationReference.isKnownNotNull() || this.isAssignedOnceInLifetime.isKnownToBe(true)) {
                    return this.isNeverAssigned.setKnownValueOnce(false);
                }
                return this.isNeverAssigned.setKnownValueOnce(this.referenceInfo.isNeverAssigned());
            }

            private boolean isWellDefined() {
                if (this.isWellDefined.isKnown()) {
                    return this.isWellDefined.getKnownValue();
                }
                return this.isWellDefined.setKnownValueOnce(this.referenceInfo.isWellDefined());
            }

            private boolean isAssignedOnceInLifetime() {
                if (this.isAssignedOnceInLifetime.isKnown()) {
                    return this.isAssignedOnceInLifetime.getKnownValue();
                }
                return this.isAssignedOnceInLifetime.setKnownValueOnce(this.referenceInfo.isAssignedOnceInLifetime());
            }

            private boolean isWellDefinedAssignedOnce() {
                if (this.isWellDefinedAssignedOnce.isKnown()) {
                    return this.isWellDefinedAssignedOnce.getKnownValue();
                }
                return this.isWellDefinedAssignedOnce.setKnownValueOnce(!this.isWellDefined.isKnownToBe(false) && !this.isAssignedOnceInLifetime.isKnownToBe(false) && this.isWellDefined() && this.isAssignedOnceInLifetime());
            }

            private Reference getInitialization() {
                if (this.initializationReference.isKnown()) {
                    return this.initializationReference.getKnownValue();
                }
                Reference initRef = this.isDeclaredOrInferredConstant ? this.referenceInfo.getInitializingReferenceForConstants() : this.referenceInfo.getInitializingReference();
                return this.initializationReference.setKnownValueOnce(initRef);
            }

            private boolean hasValidDeclaration() {
                return InliningBehavior.this.isValidDeclaration(this.declaration);
            }

            private boolean hasValidInitialization() {
                return InliningBehavior.this.isValidInitialization(this.getInitialization());
            }

            private boolean allReferencesAreValid() {
                if (this.allReferencesAreValid.isKnown()) {
                    return this.allReferencesAreValid.getKnownValue();
                }
                boolean hasValidDeclaration = this.hasValidDeclaration();
                boolean hasValidInitialization = this.hasValidInitialization();
                boolean neverAssigned = this.isNeverAssigned();
                if (hasValidDeclaration && (hasValidInitialization || neverAssigned)) {
                    Reference initialization = this.getInitialization();
                    for (Reference ref : this.referenceInfo.references) {
                        if (ref == this.declaration || ref == initialization || InliningBehavior.this.isValidReference(ref)) continue;
                        return this.allReferencesAreValid.setKnownValueOnce(false);
                    }
                    return this.allReferencesAreValid.setKnownValueOnce(true);
                }
                return this.allReferencesAreValid.setKnownValueOnce(false);
            }

            @Override
            public InlineVarAnalysis analyze() {
                if (InlineVariables.hasNoInlineAnnotation(this.v)) {
                    return this.getNegativeInlineVarAnalysis();
                }
                Reference initialization = this.getInitialization();
                Node initValue = initialization == null ? null : initialization.getAssignedValue();
                InitialValueAnalysis initialValueAnalysis = new InitialValueAnalysis(initValue);
                if (this.isDeclaredOrInferredConstant && initialValueAnalysis.isImmutableValue() && this.isAssignedOnceInLifetime()) {
                    return this.createInlineWellDefinedVarAnalysis(initValue);
                }
                if (InlineVariables.this.mode == Mode.CONSTANTS_ONLY) {
                    return this.getNegativeInlineVarAnalysis();
                }
                if (initialValueAnalysis.isAlias()) {
                    return new VarIsAliasAnalysis(initialValueAnalysis.getAliasedVar());
                }
                return this.analyzeWithInitialValue(initialization, initValue, initialValueAnalysis);
            }

            private InlineVarAnalysis analyzeWithInitialValue(Reference initialization, Node initValue, InitialValueAnalysis initialValueAnalysis) {
                int refCount = this.referenceInfo.references.size();
                if (refCount > 1 && this.allReferencesAreValid()) {
                    Reference singleReadReference;
                    if (this.referenceInfo.isNeverAssigned()) {
                        return new PositiveInlineVarAnalysis(() -> {
                            Node srcLocation = this.declaration.getNode();
                            Node undefinedNode = NodeUtil.newUndefinedNode(srcLocation);
                            InliningBehavior.this.inlineWellDefinedVariable(this.v, undefinedNode, this.referenceInfo.references);
                        });
                    }
                    if (this.isWellDefined() && (initialValueAnalysis.isImmutableValue() || initValue.isThis() && !this.referenceInfo.isEscaped())) {
                        return this.createInlineWellDefinedVarAnalysis(initValue);
                    }
                    int firstReadRefIndex = this.declaration == initialization ? 1 : 2;
                    int numReadRefs = refCount - firstReadRefIndex;
                    if (numReadRefs == 0) {
                        return this.createInlineWellDefinedVarAnalysis(initValue);
                    }
                    if (numReadRefs == 1 && InliningBehavior.this.canInline(this.declaration, initialization, singleReadReference = this.referenceInfo.references.get(firstReadRefIndex), initValue)) {
                        return new PositiveInlineVarAnalysis(() -> InliningBehavior.this.inline(this.declaration, initialization, singleReadReference));
                    }
                }
                return this.getNegativeInlineVarAnalysis();
            }

            private InlineVarAnalysis getNegativeInlineVarAnalysis() {
                if (this.mayBeAParameterModifiedViaArguments || InlineVariables.this.mode == Mode.CONSTANTS_ONLY || this.isWellDefinedAssignedOnce.isKnownToBe(false)) {
                    return NO_INLINE_SELF_OR_ALIASES_ANALYSIS;
                }
                if (this.isWellDefinedAssignedOnce.isKnownToBe(true)) {
                    return NO_INLINE_SELF_ALIASES_OK_ANALYSIS;
                }
                return new InlineVarAnalysis(){

                    @Override
                    public boolean isSafeToInlineAliases() {
                        return StandardVarExpert.this.isWellDefinedAssignedOnce();
                    }
                };
            }

            private PositiveInlineVarAnalysis createInlineWellDefinedVarAnalysis(Node initValue) {
                return new PositiveInlineVarAnalysis(() -> InliningBehavior.this.inlineWellDefinedVariable(this.v, initValue, this.referenceInfo.references));
            }

            @Override
            public InlineVarAnalysis reanalyzeAfterAliasedVar(Var aliasedVar, InlineVarAnalysis aliasedVarAnalysis) {
                Reference initialization = this.getInitialization();
                Node initValue = initialization == null ? null : initialization.getAssignedValue();
                InitialValueAnalysis initialValueAnalysis = new InitialValueAnalysis(initValue);
                if (this.isDeclaredOrInferredConstant && initialValueAnalysis.isImmutableValue() && this.isAssignedOnceInLifetime()) {
                    return this.createInlineWellDefinedVarAnalysis(initValue);
                }
                if (initialValueAnalysis.isAlias() && aliasedVarAnalysis.isSafeToInlineAliases() && this.isWellDefinedAssignedOnce()) {
                    return this.createInlineWellDefinedVarAnalysis(initValue);
                }
                return this.analyzeWithInitialValue(initialization, initValue, initialValueAnalysis);
            }

            private class InitialValueAnalysis {
                private final Node value;
                private final InitiallyUnknown<Boolean> isImmutableValue = new InitiallyUnknown();
                private final InitiallyUnknown<Var> aliasedVar = new InitiallyUnknown();

                InitialValueAnalysis(Node value) {
                    this.value = value;
                }

                boolean isImmutableValue() {
                    if (this.isImmutableValue.isKnown()) {
                        return this.isImmutableValue.getKnownValue();
                    }
                    return this.isImmutableValue.setKnownValueOnce(this.value != null && NodeUtil.isImmutableValue(this.value));
                }

                boolean isAlias() {
                    return this.getAliasedVar() != null;
                }

                Var getAliasedVar() {
                    if (this.aliasedVar.isKnown()) {
                        return this.aliasedVar.getKnownValue();
                    }
                    if (this.value != null && this.value.isName()) {
                        String aliasedName = this.value.getString();
                        return this.aliasedVar.setKnownValueOnce(aliasedName.equals(StandardVarExpert.this.v.getName()) ? null : (Var)((Scope)StandardVarExpert.this.v.getScope()).getVar(aliasedName));
                    }
                    return this.aliasedVar.setKnownValueOnce(null);
                }
            }
        }

        private class AliasInlineRetryHandler {
            private final Var v;
            private final VarExpert expert;

            AliasInlineRetryHandler(Var v, VarExpert expert) {
                this.v = v;
                this.expert = expert;
            }

            void handleAliasedVarCompletion(Var aliasedVar, InlineVarAnalysis aliasedVarAnalyis) {
                InlineVarAnalysis newAnalysis = this.expert.reanalyzeAfterAliasedVar(aliasedVar, aliasedVarAnalyis);
                Preconditions.checkState((!newAnalysis.shouldWaitForAliasedVar() ? 1 : 0) != 0, (String)"expert for %s asked to wait a second time", (Object)this.v);
                if (newAnalysis.shouldInline()) {
                    newAnalysis.performInline();
                }
                InliningBehavior.this.currentScopeHandledVarAnalysesMap.put(this.v, newAnalysis);
                InliningBehavior.this.retryAliases(this.v, newAnalysis);
            }
        }
    }

    private static abstract class InlineVarAnalysis {
        private InlineVarAnalysis() {
        }

        public boolean shouldInline() {
            return false;
        }

        public boolean shouldWaitForAliasedVar() {
            return false;
        }

        public Var getAliasedVar() {
            throw new UnsupportedOperationException("no aliased Var");
        }

        public boolean isSafeToInlineAliases() {
            return false;
        }

        public void performInline() {
            throw new UnsupportedOperationException("cannot inline");
        }
    }

    private static abstract class VarExpert {
        private VarExpert() {
        }

        abstract InlineVarAnalysis analyze();

        InlineVarAnalysis reanalyzeAfterAliasedVar(Var aliasedVar, InlineVarAnalysis aliasedVarAnalysis) {
            throw new UnsupportedOperationException("not waiting for an aliased variable");
        }
    }

    static enum Mode {
        CONSTANTS_ONLY((Predicate<Var>)((Predicate)AbstractVar::isDeclaredOrInferredConst)),
        LOCALS_ONLY((Predicate<Var>)((Predicate)AbstractVar::isLocal)),
        ALL((Predicate<Var>)Predicates.alwaysTrue());

        private final Predicate<Var> varPredicate;

        private Mode(Predicate<Var> varPredicate) {
            this.varPredicate = varPredicate;
        }
    }
}

