/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.FunctionArgumentInjector;
import com.google.javascript.jscomp.FunctionInjector;
import com.google.javascript.jscomp.JSChunk;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.jspecify.nullness.Nullable;

class InlineFunctions
implements CompilerPass {
    private final Map<String, FunctionState> fns = new LinkedHashMap<String, FunctionState>();
    private final Map<Node, String> anonFns = new HashMap<Node, String>();
    private final AbstractCompiler compiler;
    private final FunctionInjector injector;
    private final FunctionArgumentInjector functionArgumentInjector;
    private final CompilerOptions.Reach reach;
    private final boolean assumeMinimumCapture;
    private final boolean enforceMaxSizeAfterInlining;
    private final int maxSizeAfterInlining;

    InlineFunctions(AbstractCompiler compiler, Supplier<String> safeNameIdSupplier, CompilerOptions.Reach reach, boolean assumeStrictThis, boolean assumeMinimumCapture, int maxSizeAfterInlining) {
        Preconditions.checkArgument((compiler != null ? 1 : 0) != 0);
        Preconditions.checkArgument((safeNameIdSupplier != null ? 1 : 0) != 0);
        Preconditions.checkArgument((reach != CompilerOptions.Reach.NONE ? 1 : 0) != 0);
        this.compiler = compiler;
        this.reach = reach;
        this.assumeMinimumCapture = assumeMinimumCapture;
        this.maxSizeAfterInlining = maxSizeAfterInlining;
        this.enforceMaxSizeAfterInlining = maxSizeAfterInlining != -1;
        this.functionArgumentInjector = new FunctionArgumentInjector(compiler.getAstAnalyzer());
        this.injector = new FunctionInjector.Builder(compiler).safeNameIdSupplier(safeNameIdSupplier).assumeStrictThis(assumeStrictThis).assumeMinimumCapture(assumeMinimumCapture).functionArgumentInjector(this.functionArgumentInjector).build();
    }

    FunctionState getOrCreateFunctionState(String fnName) {
        return this.fns.computeIfAbsent(fnName, k -> new FunctionState());
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState((boolean)this.compiler.getLifeCycleStage().isNormalized());
        NodeTraversal.traverse(this.compiler, root, new FindCandidateFunctions());
        if (this.fns.isEmpty()) {
            return;
        }
        NodeTraversal.traverse(this.compiler, root, new FindCandidatesReferences(this.fns, this.anonFns));
        this.trimCandidatesNotMeetingMinimumRequirements();
        if (this.fns.isEmpty()) {
            return;
        }
        ImmutableSet fnNames = ImmutableSet.copyOf(this.fns.keySet());
        this.injector.setKnownConstantFunctions((ImmutableSet<String>)fnNames);
        this.trimCandidatesUsingOnCost();
        if (this.fns.isEmpty()) {
            return;
        }
        this.resolveInlineConflicts();
        this.decomposeExpressions();
        NodeTraversal.traverse(this.compiler, root, new CallVisitor(this.fns, this.anonFns, new Inline(this.injector)));
        this.removeInlinedFunctions();
    }

    private static boolean isAlwaysInlinable(Node fn) {
        Preconditions.checkArgument((boolean)fn.isFunction());
        Node body = NodeUtil.getFunctionBody(fn);
        return !body.hasChildren() || body.hasOneChild() && body.getFirstChild().isReturn();
    }

    private boolean targetSizeAfterInlineExceedsLimit(NodeTraversal t, FunctionState functionState) {
        int targetFunSize;
        Node containingFunction = t.getEnclosingFunction();
        if (containingFunction == null) {
            return false;
        }
        Node inlinedFun = functionState.getFn().getFunctionNode();
        if (InlineFunctions.isAlwaysInlinable(inlinedFun)) {
            return false;
        }
        int inlinedFunSize = NodeUtil.countAstSizeUpToLimit(NodeUtil.getFunctionBody(inlinedFun), this.maxSizeAfterInlining);
        return inlinedFunSize + (targetFunSize = NodeUtil.countAstSizeUpToLimit(containingFunction, this.maxSizeAfterInlining)) > this.maxSizeAfterInlining;
    }

    void maybeAddFunction(Function fn, JSChunk chunk) {
        String name = fn.getName();
        FunctionState functionState = this.getOrCreateFunctionState(name);
        if (functionState.hasExistingFunctionDefinition()) {
            functionState.disallowInlining();
            return;
        }
        Node fnNode = fn.getFunctionNode();
        if (this.hasNoInlineAnnotation(fnNode)) {
            functionState.disallowInlining();
            return;
        }
        if (this.enforceMaxSizeAfterInlining && !InlineFunctions.isAlwaysInlinable(fnNode) && this.maxSizeAfterInlining <= NodeUtil.countAstSizeUpToLimit(fnNode, this.maxSizeAfterInlining)) {
            functionState.disallowInlining();
            return;
        }
        if (functionState.canInline()) {
            Node block;
            functionState.setFn(fn);
            if (FunctionInjector.isDirectCallNodeReplacementPossible(fn.getFunctionNode())) {
                functionState.inlineDirectly(true);
            }
            if (InlineFunctions.hasNonInlinableParam(NodeUtil.getFunctionParameters(fnNode))) {
                functionState.disallowInlining();
            }
            if (!this.isCandidateFunction(fn)) {
                functionState.disallowInlining();
            }
            if (functionState.canInline()) {
                Node block2;
                functionState.setChunk(chunk);
                Set<String> namesToAlias = this.functionArgumentInjector.findModifiedParameters(fnNode);
                if (!namesToAlias.isEmpty()) {
                    functionState.inlineDirectly(false);
                    functionState.setNamesToAlias(namesToAlias);
                }
                if (NodeUtil.referencesEnclosingReceiver(block2 = NodeUtil.getFunctionBody(fnNode))) {
                    functionState.setReferencesThis(true);
                }
                if (NodeUtil.has(block2, (Predicate<Node>)((Predicate)Node::isFunction), (Predicate<Node>)Predicates.alwaysTrue())) {
                    functionState.setHasInnerFunctions(true);
                    if (!this.assumeMinimumCapture && InlineFunctions.hasLocalNames(fnNode)) {
                        functionState.disallowInlining();
                    }
                }
            }
            if (fnNode.getGrandparent().isVar() && (block = functionState.getFn().getDeclaringBlock()).isBlock() && !block.getParent().isFunction() && NodeUtil.has(block, (Predicate<Node>)((Predicate)n -> n.isLet() || n.isConst()), (Predicate<Node>)Predicates.alwaysTrue())) {
                functionState.disallowInlining();
            }
            if (fnNode.isGeneratorFunction()) {
                functionState.disallowInlining();
            }
            if (fnNode.isAsyncFunction()) {
                functionState.disallowInlining();
            }
        }
    }

    private boolean hasNoInlineAnnotation(Node fnNode) {
        JSDocInfo jsDocInfo = NodeUtil.getBestJSDocInfo(fnNode);
        return jsDocInfo != null && jsDocInfo.isNoInline();
    }

    private static boolean hasLocalNames(Node fnNode) {
        Node block = NodeUtil.getFunctionBody(fnNode);
        return NodeUtil.getFunctionParameters(fnNode).hasChildren() || NodeUtil.has(block, new NodeUtil.MatchDeclaration(), new NodeUtil.MatchShallowStatement());
    }

    private boolean isCandidateFunction(Function fn) {
        String fnName = fn.getName();
        if (this.compiler.getCodingConvention().isExported(fnName)) {
            return false;
        }
        if (this.compiler.getCodingConvention().isPropertyRenameFunction(fn.getNameNode())) {
            return false;
        }
        Node fnNode = fn.getFunctionNode();
        return this.injector.doesFunctionMeetMinimumRequirements(fnName, fnNode);
    }

    static boolean isCandidateUsage(Node name) {
        Node grandparent;
        Node parent = name.getParent();
        Preconditions.checkState((boolean)name.isName());
        if (NodeUtil.isNameDeclaration(parent) || parent.isFunction()) {
            return true;
        }
        if (NodeUtil.isNormalOrOptChainCall(parent) && parent.getFirstChild() == name) {
            return true;
        }
        return (parent.isGetElem() && name == parent.getFirstChild() && parent.getSecondChild().isStringLit() && parent.getSecondChild().getString().equals("call") || parent.isGetProp() && parent.getString().equals("call")) && (grandparent = name.getAncestor(2)).isCall() && grandparent.getFirstChild() == parent;
    }

    private void trimCandidatesNotMeetingMinimumRequirements() {
        Iterator<Map.Entry<String, FunctionState>> i = this.fns.entrySet().iterator();
        while (i.hasNext()) {
            FunctionState functionState = i.next().getValue();
            if (functionState.hasExistingFunctionDefinition() && functionState.canInline()) continue;
            i.remove();
        }
    }

    private void trimCandidatesUsingOnCost() {
        Iterator<Map.Entry<String, FunctionState>> i = this.fns.entrySet().iterator();
        while (i.hasNext()) {
            FunctionState functionState = i.next().getValue();
            if (functionState.hasReferences()) {
                boolean lowersCost = this.minimizeCost(functionState);
                if (lowersCost) continue;
                i.remove();
                continue;
            }
            if (functionState.canRemove()) continue;
            i.remove();
        }
    }

    private boolean minimizeCost(FunctionState functionState) {
        if (!this.inliningLowersCost(functionState)) {
            if (functionState.hasBlockInliningReferences()) {
                functionState.setRemove(false);
                functionState.removeBlockInliningReferences();
                if (!functionState.hasReferences() || !this.inliningLowersCost(functionState)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean inliningLowersCost(FunctionState functionState) {
        return this.injector.inliningLowersCost(functionState.getChunk(), functionState.getFn().getFunctionNode(), (Collection<? extends FunctionInjector.Reference>)functionState.getReferences(), (Set<String>)functionState.getNamesToAlias(), functionState.canRemove(), functionState.getReferencesThis());
    }

    private void resolveInlineConflicts() {
        for (FunctionState functionState : this.fns.values()) {
            this.resolveInlineConflictsForFunction(functionState);
        }
    }

    private static boolean hasNonInlinableParam(Node node) {
        Preconditions.checkNotNull((Object)node);
        Predicate pred = input -> input.isDefaultValue() || input.isDestructuringPattern();
        return NodeUtil.has(node, (Predicate<Node>)pred, (Predicate<Node>)Predicates.alwaysTrue());
    }

    private void resolveInlineConflictsForFunction(FunctionState functionState) {
        if (!functionState.hasReferences() || !functionState.canInline()) {
            return;
        }
        Node fnNode = functionState.getFn().getFunctionNode();
        Set<String> names = this.findCalledFunctions(fnNode);
        if (!names.isEmpty()) {
            for (String name : names) {
                FunctionState fsCalled = this.fns.get(name);
                if (fsCalled == null || !fsCalled.canRemove()) continue;
                fsCalled.setRemove(false);
                if (this.minimizeCost(fsCalled)) continue;
                fsCalled.disallowInlining();
            }
            functionState.setSafeFnNode(functionState.getFn().getFunctionNode().cloneTree());
        }
    }

    private Set<String> findCalledFunctions(Node node) {
        HashSet<String> changed = new HashSet<String>();
        InlineFunctions.findCalledFunctions(NodeUtil.getFunctionBody(node), changed);
        return changed;
    }

    private static void findCalledFunctions(Node node, Set<String> changed) {
        Preconditions.checkArgument((changed != null ? 1 : 0) != 0);
        if (node.isName() && InlineFunctions.isCandidateUsage(node)) {
            changed.add(node.getString());
        }
        for (Node c = node.getFirstChild(); c != null; c = c.getNext()) {
            InlineFunctions.findCalledFunctions(c, changed);
        }
    }

    private void decomposeExpressions() {
        for (FunctionState functionState : this.fns.values()) {
            if (!functionState.canInline()) continue;
            for (Reference ref : functionState.getReferences()) {
                if (!ref.requiresDecomposition) continue;
                this.injector.maybePrepareCall(ref);
            }
        }
    }

    void removeInlinedFunctions() {
        for (Map.Entry<String, FunctionState> entry : this.fns.entrySet()) {
            String name = entry.getKey();
            FunctionState functionState = entry.getValue();
            if (!functionState.canRemove()) continue;
            Function fn = functionState.getFn();
            Preconditions.checkState((boolean)functionState.canInline());
            Preconditions.checkState((fn != null ? 1 : 0) != 0);
            this.verifyAllReferencesInlined(name, functionState);
            fn.remove();
            NodeUtil.markFunctionsDeleted(fn.getFunctionNode(), this.compiler);
        }
    }

    void verifyAllReferencesInlined(String name, FunctionState functionState) {
        for (Reference ref : functionState.getReferences()) {
            if (ref.inlined) continue;
            Node parent = ref.callNode.getParent();
            throw new IllegalStateException("Call site missed (" + name + ").\n call: " + ref.callNode.toStringTree() + "\n parent:  " + (parent == null ? "null" : parent.toStringTree()));
        }
    }

    static class Reference
    extends FunctionInjector.Reference {
        boolean requiresDecomposition = false;
        boolean inlined = false;

        Reference(Node callNode, Scope scope, JSChunk chunk, FunctionInjector.InliningMode mode) {
            super(callNode, scope, chunk, mode);
        }

        void setRequiresDecomposition(boolean newVal) {
            this.requiresDecomposition = newVal;
        }
    }

    private static class FunctionExpression
    implements Function {
        private final Node fn;
        private final String fakeName;
        private final Node fakeNameNode;

        public FunctionExpression(Node fn, int index) {
            this.fn = fn;
            this.fakeName = String.valueOf(index);
            this.fakeNameNode = IR.name(this.fakeName);
        }

        @Override
        public String getName() {
            return this.fakeName;
        }

        @Override
        public Node getNameNode() {
            return this.fakeNameNode;
        }

        @Override
        public Node getFunctionNode() {
            return this.fn;
        }

        @Override
        public void remove() {
        }

        @Override
        public Node getDeclaringBlock() {
            return null;
        }
    }

    private class FunctionVar
    implements Function {
        private final Node var;

        public FunctionVar(Node var) {
            this.var = var;
        }

        @Override
        public String getName() {
            return this.var.getFirstChild().getString();
        }

        @Override
        public Node getNameNode() {
            return this.var.getFirstChild();
        }

        @Override
        public Node getFunctionNode() {
            return this.var.getFirstFirstChild();
        }

        @Override
        public void remove() {
            InlineFunctions.this.compiler.reportChangeToEnclosingScope(this.var);
            NodeUtil.removeChild(this.var.getParent(), this.var);
            NodeUtil.markFunctionsDeleted(this.var, InlineFunctions.this.compiler);
        }

        @Override
        public Node getDeclaringBlock() {
            return this.var.getParent();
        }
    }

    private class NamedFunction
    implements Function {
        private final Node fn;

        public NamedFunction(Node fn) {
            this.fn = fn;
        }

        @Override
        public String getName() {
            return this.fn.getFirstChild().getString();
        }

        @Override
        public Node getNameNode() {
            return this.fn.getFirstChild();
        }

        @Override
        public Node getFunctionNode() {
            return this.fn;
        }

        @Override
        public void remove() {
            InlineFunctions.this.compiler.reportChangeToEnclosingScope(this.fn);
            NodeUtil.removeChild(this.fn.getParent(), this.fn);
            NodeUtil.markFunctionsDeleted(this.fn, InlineFunctions.this.compiler);
        }

        @Override
        public Node getDeclaringBlock() {
            return this.fn.getParent();
        }
    }

    private static interface Function {
        public String getName();

        public Node getNameNode();

        public Node getFunctionNode();

        public void remove();

        public Node getDeclaringBlock();
    }

    private static class FunctionState {
        private @Nullable Function fn = null;
        private @Nullable Node safeFnNode = null;
        private boolean inline = true;
        private boolean remove = true;
        private boolean inlineDirectly = false;
        private boolean referencesThis = false;
        private boolean hasInnerFunctions = false;
        private @Nullable Map<Node, Reference> references = null;
        private @Nullable JSChunk chunk = null;
        private @Nullable Set<String> namesToAlias = null;

        private FunctionState() {
        }

        boolean hasExistingFunctionDefinition() {
            return this.fn != null;
        }

        public void setReferencesThis(boolean referencesThis) {
            this.referencesThis = referencesThis;
        }

        public boolean getReferencesThis() {
            return this.referencesThis;
        }

        public void setHasInnerFunctions(boolean hasInnerFunctions) {
            this.hasInnerFunctions = hasInnerFunctions;
        }

        public boolean hasInnerFunctions() {
            return this.hasInnerFunctions;
        }

        void removeBlockInliningReferences() {
            Iterator<Map.Entry<Node, Reference>> i = this.getReferencesInternal().entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<Node, Reference> entry = i.next();
                if (entry.getValue().mode != FunctionInjector.InliningMode.BLOCK) continue;
                i.remove();
            }
        }

        public boolean hasBlockInliningReferences() {
            for (Reference r : this.getReferencesInternal().values()) {
                if (r.mode != FunctionInjector.InliningMode.BLOCK) continue;
                return true;
            }
            return false;
        }

        public Function getFn() {
            return this.fn;
        }

        public void setFn(Function fn) {
            Preconditions.checkState((this.fn == null ? 1 : 0) != 0);
            this.fn = fn;
        }

        public Node getSafeFnNode() {
            return this.safeFnNode != null ? this.safeFnNode : this.fn.getFunctionNode();
        }

        public void setSafeFnNode(Node safeFnNode) {
            this.safeFnNode = safeFnNode;
        }

        public boolean canInline() {
            return this.inline;
        }

        public void disallowInlining() {
            this.inline = false;
            this.references = null;
            this.remove = false;
        }

        public boolean canRemove() {
            return this.remove;
        }

        public void setRemove(boolean remove) {
            this.remove = remove;
        }

        public boolean canInlineDirectly() {
            return this.inlineDirectly;
        }

        public void inlineDirectly(boolean directReplacement) {
            this.inlineDirectly = directReplacement;
        }

        public boolean hasReferences() {
            return this.references != null && !this.references.isEmpty();
        }

        private Map<Node, Reference> getReferencesInternal() {
            if (this.references == null) {
                return ImmutableMap.of();
            }
            return this.references;
        }

        public void addReference(Reference ref) {
            if (this.references == null) {
                this.references = new LinkedHashMap<Node, Reference>();
            }
            this.references.put(ref.callNode, ref);
        }

        public Collection<Reference> getReferences() {
            return this.getReferencesInternal().values();
        }

        public Reference getReference(Node n) {
            return this.getReferencesInternal().get(n);
        }

        public ImmutableSet<String> getNamesToAlias() {
            if (this.namesToAlias == null) {
                return ImmutableSet.of();
            }
            return ImmutableSet.copyOf(this.namesToAlias);
        }

        public void setNamesToAlias(Set<String> names) {
            this.namesToAlias = names;
        }

        public void setChunk(JSChunk chunk) {
            this.chunk = chunk;
        }

        public JSChunk getChunk() {
            return this.chunk;
        }
    }

    private static class Inline
    implements CallVisitorCallback {
        private final FunctionInjector injector;

        Inline(FunctionInjector injector) {
            this.injector = injector;
        }

        @Override
        public void visitCallSite(NodeTraversal t, Node callNode, FunctionState functionState) {
            Reference ref;
            Preconditions.checkState((boolean)functionState.hasExistingFunctionDefinition());
            if (functionState.canInline() && (ref = functionState.getReference(callNode)) != null) {
                this.inlineFunction(t, ref, functionState);
                ref.inlined = true;
            }
        }

        private void inlineFunction(NodeTraversal t, Reference ref, FunctionState functionState) {
            Node fnNode;
            Function fn = functionState.getFn();
            String fnName = fn.getName();
            Node newExpr = this.injector.inline(ref, fnName, fnNode = functionState.getSafeFnNode());
            if (!newExpr.equals(ref.callNode)) {
                t.getCompiler().reportChangeToEnclosingScope(newExpr);
            }
        }
    }

    private class FindCandidatesReferences
    extends CallVisitor
    implements CallVisitorCallback {
        FindCandidatesReferences(Map<String, FunctionState> fns, Map<Node, String> anonFns) {
            super(fns, anonFns, null);
            this.callback = this;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            super.visit(t, n, parent);
            if (n.isName()) {
                this.checkNameUsage(n, parent);
            }
        }

        @Override
        public void visitCallSite(NodeTraversal t, Node callNode, FunctionState functionState) {
            this.maybeAddReference(t, functionState, callNode, t.getChunk());
        }

        void maybeAddReference(NodeTraversal t, FunctionState functionState, Node callNode, JSChunk chunk) {
            if (!functionState.canInline()) {
                return;
            }
            FunctionInjector.InliningMode mode = functionState.canInlineDirectly() ? FunctionInjector.InliningMode.DIRECT : FunctionInjector.InliningMode.BLOCK;
            boolean referenceAdded = this.maybeAddReferenceUsingMode(t, functionState, callNode, chunk, mode);
            if (!referenceAdded && mode == FunctionInjector.InliningMode.DIRECT) {
                mode = FunctionInjector.InliningMode.BLOCK;
                referenceAdded = this.maybeAddReferenceUsingMode(t, functionState, callNode, chunk, mode);
            }
            if (!referenceAdded) {
                functionState.setRemove(false);
            }
        }

        private boolean maybeAddReferenceUsingMode(NodeTraversal t, FunctionState functionState, Node callNode, JSChunk chunk, FunctionInjector.InliningMode mode) {
            if (InlineFunctions.this.enforceMaxSizeAfterInlining && InlineFunctions.this.targetSizeAfterInlineExceedsLimit(t, functionState)) {
                return false;
            }
            Reference candidate = new Reference(callNode, t.getScope(), chunk, mode);
            FunctionInjector.CanInlineResult result = InlineFunctions.this.injector.canInlineReferenceToFunction(candidate, functionState.getFn().getFunctionNode(), functionState.getNamesToAlias(), functionState.getReferencesThis(), functionState.hasInnerFunctions());
            if (result != FunctionInjector.CanInlineResult.NO) {
                candidate.setRequiresDecomposition(result == FunctionInjector.CanInlineResult.AFTER_PREPARATION);
                functionState.addReference(candidate);
                return true;
            }
            return false;
        }

        private void checkNameUsage(Node n, Node parent) {
            Preconditions.checkState((boolean)n.isName(), (Object)n);
            if (InlineFunctions.isCandidateUsage(n)) {
                return;
            }
            String name = n.getString();
            FunctionState functionState = InlineFunctions.this.fns.get(name);
            if (functionState == null) {
                return;
            }
            if (parent.isAssign() && parent.getFirstChild() == n) {
                functionState.disallowInlining();
            } else {
                functionState.setRemove(false);
            }
        }
    }

    private static class CallVisitor
    extends NodeTraversal.AbstractPostOrderCallback {
        protected CallVisitorCallback callback;
        private final Map<String, FunctionState> functionMap;
        private final Map<Node, String> anonFunctionMap;

        CallVisitor(Map<String, FunctionState> fns, Map<Node, String> anonFns, @Nullable CallVisitorCallback callback) {
            this.functionMap = fns;
            this.anonFunctionMap = anonFns;
            this.callback = callback;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case OPTCHAIN_CALL: 
                case CALL: {
                    FunctionState functionState;
                    Node child = n.getFirstChild();
                    String name = null;
                    if (child.isName()) {
                        name = child.getString();
                    } else if (child.isFunction()) {
                        name = this.anonFunctionMap.get(child);
                    } else if (NodeUtil.isFunctionObjectCall(n)) {
                        Preconditions.checkState((boolean)NodeUtil.isNormalOrOptChainGet(child));
                        Node fnIdentifyingNode = child.getFirstChild();
                        if (fnIdentifyingNode.isName()) {
                            name = fnIdentifyingNode.getString();
                        } else if (fnIdentifyingNode.isFunction()) {
                            name = this.anonFunctionMap.get(fnIdentifyingNode);
                        }
                    }
                    if (name == null || (functionState = this.functionMap.get(name)) == null) break;
                    this.callback.visitCallSite(t, n, functionState);
                    break;
                }
            }
        }
    }

    private static interface CallVisitorCallback {
        public void visitCallSite(NodeTraversal var1, Node var2, FunctionState var3);
    }

    private class FindCandidateFunctions
    extends NodeTraversal.AbstractPostOrderCallback {
        private int callsSeen = 0;

        private FindCandidateFunctions() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (InlineFunctions.this.reach.includesGlobals() || !t.inGlobalHoistScope()) {
                this.findNamedFunctions(t, n, parent);
                this.findFunctionExpressions(t, n);
            }
        }

        public void findNamedFunctions(NodeTraversal t, Node n, Node parent) {
            if (!NodeUtil.isStatement(n)) {
                return;
            }
            switch (n.getToken()) {
                case VAR: 
                case LET: 
                case CONST: {
                    Preconditions.checkState((boolean)n.hasOneChild(), (Object)n);
                    Node nameNode = n.getFirstChild();
                    if (!nameNode.isName() || !nameNode.hasChildren() || !nameNode.getFirstChild().isFunction()) break;
                    InlineFunctions.this.maybeAddFunction(new FunctionVar(n), t.getChunk());
                    break;
                }
                case FUNCTION: {
                    Preconditions.checkState((NodeUtil.isStatementBlock(parent) || parent.isLabel() ? 1 : 0) != 0);
                    if (!NodeUtil.isFunctionDeclaration(n)) break;
                    NamedFunction fn = new NamedFunction(n);
                    InlineFunctions.this.maybeAddFunction(fn, t.getChunk());
                    break;
                }
            }
        }

        public void findFunctionExpressions(NodeTraversal t, Node n) {
            switch (n.getToken()) {
                case OPTCHAIN_CALL: 
                case CALL: {
                    Node fnIdentifyingNode;
                    Node fnNode = null;
                    if (n.getFirstChild().isFunction()) {
                        fnNode = n.getFirstChild();
                    } else if (NodeUtil.isFunctionObjectCall(n) && (fnIdentifyingNode = n.getFirstFirstChild()).isFunction()) {
                        fnNode = fnIdentifyingNode;
                    }
                    if (fnNode == null) break;
                    FunctionExpression fn = new FunctionExpression(fnNode, this.callsSeen++);
                    InlineFunctions.this.maybeAddFunction(fn, t.getChunk());
                    InlineFunctions.this.anonFns.put(fnNode, fn.getName());
                    break;
                }
            }
        }
    }
}

