/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Table;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AutoValue_GlobalNamespace_ObjLitStringKeyAnalysis;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.ModuleImportResolver;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.base.format.SimpleFormat;
import com.google.javascript.jscomp.diagnostic.LogFile;
import com.google.javascript.jscomp.modules.ModuleMap;
import com.google.javascript.jscomp.modules.ModuleMetadataMap;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.QualifiedName;
import com.google.javascript.rhino.StaticRef;
import com.google.javascript.rhino.StaticScope;
import com.google.javascript.rhino.StaticSlot;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.StaticSymbolTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jspecify.nullness.Nullable;

class GlobalNamespace
implements StaticScope,
StaticSymbolTable<Name, Ref> {
    private final AbstractCompiler compiler;
    private final boolean enableImplicitlyAliasedValues;
    private final Node root;
    private final Node externsRoot;
    private final Node globalRoot = IR.root(new Node[0]);
    private final LinkedHashMap<Node, Boolean> spreadSiblingCache = new LinkedHashMap();
    private SourceKind sourceKind;
    private boolean generated = false;
    private final @Nullable LogFile decisionsLog;
    private static final QualifiedName GOOG_PROVIDE = QualifiedName.of("goog.provide");
    private final List<Name> globalNames = new ArrayList<Name>();
    private final Map<String, Name> nameMap = new LinkedHashMap<String, Name>();
    private final Table<ModuleMetadataMap.ModuleMetadata, String, Name> nameMapByModule = HashBasedTable.create();
    private Predicate<Node> shouldTraverseScript = n -> true;

    GlobalNamespace(LogFile decisionsLog, AbstractCompiler compiler, Node root) {
        this(decisionsLog, compiler, null, root);
    }

    GlobalNamespace(AbstractCompiler compiler, Node root) {
        this(null, compiler, null, root);
    }

    GlobalNamespace(AbstractCompiler compiler, Node externsRoot, Node root) {
        this(null, compiler, externsRoot, root);
    }

    GlobalNamespace(@Nullable LogFile decisionsLog, AbstractCompiler compiler, @Nullable Node externsRoot, Node root) {
        this.decisionsLog = decisionsLog;
        this.compiler = compiler;
        this.externsRoot = externsRoot;
        this.root = root;
        this.enableImplicitlyAliasedValues = !compiler.getOptions().getAssumeStaticInheritanceIsNotUsed();
    }

    void setShouldTraverseScriptPredicate(Predicate<Node> shouldTraverseScript) {
        this.shouldTraverseScript = shouldTraverseScript;
    }

    boolean hasExternsRoot() {
        return this.externsRoot != null;
    }

    @Override
    public Node getRootNode() {
        return this.root.getParent();
    }

    private @Nullable Node getRootNode(String name, Scope s) {
        Var v = (Var)s.getVar(name = GlobalNamespace.getTopVarName(name));
        if (v == null) {
            Name providedName = this.nameMap.get(name);
            return providedName != null && providedName.getBooleanProperty(NameProp.IS_PROVIDED) ? this.globalRoot : null;
        }
        return v.isLocal() ? v.getScopeRoot() : this.globalRoot;
    }

    @Override
    public StaticScope getParentScope() {
        return null;
    }

    @Override
    public Name getSlot(String name) {
        return this.getOwnSlot(name);
    }

    @Override
    public Name getOwnSlot(String name) {
        this.ensureGenerated();
        return this.nameMap.get(name);
    }

    @Override
    public Iterable<Ref> getReferences(Name slot) {
        this.ensureGenerated();
        return Collections.unmodifiableCollection(slot.getRefs());
    }

    @Override
    public StaticScope getScope(Name slot) {
        return this;
    }

    @Override
    public Collection<Name> getAllSymbols() {
        this.ensureGenerated();
        return Collections.unmodifiableCollection(this.getNameIndex().values());
    }

    private void ensureGenerated() {
        if (!this.generated) {
            this.process();
        }
    }

    List<Name> getNameForest() {
        this.ensureGenerated();
        return this.globalNames;
    }

    Map<String, Name> getNameIndex() {
        this.ensureGenerated();
        return this.nameMap;
    }

    void scanNewNodes(Set<AstChange> newNodes) {
        BuildGlobalNamespace builder = new BuildGlobalNamespace();
        for (AstChange info : newNodes) {
            if (!info.node.isQualifiedName() && !NodeUtil.mayBeObjectLitKey(info.node)) continue;
            this.scanFromNode(builder, info.scope, info.node);
        }
    }

    private void scanFromNode(BuildGlobalNamespace builder, Scope scope, Node n) {
        Node parent = n.getParent();
        if ((n.isName() || n.isGetProp()) && parent.isGetProp()) {
            this.scanFromNode(builder, scope, n.getParent());
        } else if (n.getPrevious() != null && n.getPrevious().isObjectPattern()) {
            Node pattern = n.getPrevious();
            for (Node key = pattern.getFirstChild(); key != null; key = key.getNext()) {
                if (!key.isStringKey()) continue;
                this.scanFromNode(builder, scope, key);
            }
        }
        builder.collect(scope, n);
    }

    private void process() {
        NodeTraversal.Builder traversal = NodeTraversal.builder().setCompiler(this.compiler).setCallback(new BuildGlobalNamespace());
        if (this.hasExternsRoot()) {
            traversal.traverseRoots(this.externsRoot, this.root);
        } else {
            traversal.traverse(this.root);
        }
        this.generated = true;
    }

    private static String getTopVarName(String name) {
        int firstDotIndex = name.indexOf(46);
        return firstDotIndex == -1 ? name : name.substring(0, firstDotIndex);
    }

    @Nullable Name getNameFromModule(ModuleMetadataMap.ModuleMetadata moduleMetadata, String name) {
        Preconditions.checkNotNull((Object)moduleMetadata);
        Preconditions.checkNotNull((Object)name);
        this.ensureGenerated();
        return (Name)this.nameMapByModule.get((Object)moduleMetadata, (Object)name);
    }

    private boolean declarationHasFollowingObjectSpreadSibling(Node declaration) {
        Preconditions.checkState((boolean)declaration.getParent().isObjectLit(), (Object)declaration);
        @Nullable Boolean cached = this.spreadSiblingCache.get(declaration);
        if (cached != null) {
            return cached;
        }
        boolean toCache = false;
        for (Node sibling = declaration.getParent().getLastChild(); sibling != null; sibling = sibling.getPrevious()) {
            if (sibling.isSpread()) {
                toCache = true;
            }
            this.spreadSiblingCache.put(sibling, toCache);
        }
        return this.spreadSiblingCache.get(declaration);
    }

    @VisibleForTesting
    Name createNameForTesting(String name) {
        return new Name(name, null, SourceKind.CODE);
    }

    private Node getOutermostObjectLit(Node objLitKey) {
        Node objLitGrandparent;
        Node outermostObjectLit = objLitKey.getParent();
        Preconditions.checkState((boolean)outermostObjectLit.isObjectLit(), (Object)outermostObjectLit);
        while ((objLitGrandparent = outermostObjectLit.getGrandparent()) != null && objLitGrandparent.isObjectLit()) {
            outermostObjectLit = objLitGrandparent;
        }
        return outermostObjectLit;
    }

    private static boolean isQnameDeclarationWithoutAssignment(@Nullable Node node) {
        return node != null && node.isGetProp() && node.getParent().isExprResult();
    }

    @AutoValue
    static abstract class ObjLitStringKeyAnalysis {
        ObjLitStringKeyAnalysis() {
        }

        public abstract @Nullable String getNameString();

        public abstract @Nullable NameProp getNameType();

        static ObjLitStringKeyAnalysis forObjectDefineProperty(String nameString) {
            return new AutoValue_GlobalNamespace_ObjLitStringKeyAnalysis((String)Preconditions.checkNotNull((Object)nameString), NameProp.GET_SET);
        }

        static ObjLitStringKeyAnalysis forObjLitAssignment(String nameString, NameProp nameType) {
            return new AutoValue_GlobalNamespace_ObjLitStringKeyAnalysis((String)Preconditions.checkNotNull((Object)nameString), nameType);
        }

        static ObjLitStringKeyAnalysis forNonReference() {
            return new AutoValue_GlobalNamespace_ObjLitStringKeyAnalysis(null, NameProp.OTHER_OBJECT);
        }
    }

    static enum NameProp {
        IS_DECLARED(0),
        IS_MODULE_PROP(1),
        IS_PROVIDED(2),
        IS_USED_HAS_OWN_PROPERTY(3),
        IS_EXTERN(4),
        CONSTRUCTOR_TYPE(5),
        INTERFACE_TYPE(6),
        ENUM_TYPE(7),
        NOT_A_TYPE(8),
        CLASS(9),
        OBJECTLIT(10),
        FUNCTION(11),
        GET_SET(12),
        OTHER_OBJECT(13);

        private static final int DECLARED_TYPE_KIND_MASK;
        private static final int NAME_KIND_MASK;
        private final int bit;

        private NameProp(int index) {
            this.bit = 1 << index;
        }

        static {
            DECLARED_TYPE_KIND_MASK = NameProp.CONSTRUCTOR_TYPE.bit | NameProp.INTERFACE_TYPE.bit | NameProp.ENUM_TYPE.bit | NameProp.NOT_A_TYPE.bit;
            NAME_KIND_MASK = NameProp.CLASS.bit | NameProp.OBJECTLIT.bit | NameProp.FUNCTION.bit | NameProp.GET_SET.bit | NameProp.OTHER_OBJECT.bit;
        }
    }

    static final class Ref
    implements StaticRef {
        private Node node;
        private final Type type;
        final Scope scope;

        private Ref(@Nullable Scope scope, @Nullable Node node, Type type) {
            this.node = node;
            this.type = type;
            this.scope = scope;
        }

        @Override
        public Node getNode() {
            return this.node;
        }

        @Override
        public @Nullable StaticSourceFile getSourceFile() {
            return this.node != null ? this.node.getStaticSourceFile() : null;
        }

        @Override
        public StaticSlot getSymbol() {
            throw new UnsupportedOperationException();
        }

        boolean isDeleteProp() {
            return this.type == Type.DELETE_PROP;
        }

        boolean isSubclassingGet() {
            return this.type == Type.SUBCLASSING_GET;
        }

        boolean isTwin() {
            switch (this.type) {
                case GET_AND_SET_FROM_GLOBAL: 
                case GET_AND_SET_FROM_LOCAL: {
                    return true;
                }
            }
            return false;
        }

        boolean isGet() {
            switch (this.type) {
                case GET_AND_SET_FROM_GLOBAL: 
                case GET_AND_SET_FROM_LOCAL: 
                case PROTOTYPE_GET: 
                case DIRECT_GET: 
                case ALIASING_GET: 
                case CALL_GET: 
                case SUBCLASSING_GET: {
                    return true;
                }
            }
            return false;
        }

        boolean isAliasingGet() {
            switch (this.type) {
                case GET_AND_SET_FROM_GLOBAL: 
                case GET_AND_SET_FROM_LOCAL: 
                case ALIASING_GET: {
                    return true;
                }
            }
            return false;
        }

        boolean isSet() {
            switch (this.type) {
                case GET_AND_SET_FROM_GLOBAL: 
                case SET_FROM_GLOBAL: 
                case GET_AND_SET_FROM_LOCAL: 
                case SET_FROM_LOCAL: {
                    return true;
                }
            }
            return false;
        }

        boolean isSetFromGlobal() {
            return this.type == Type.SET_FROM_GLOBAL || this.type == Type.GET_AND_SET_FROM_GLOBAL;
        }

        boolean isUninitializedDeclaration() {
            return this.node.isName() && NodeUtil.isNameDeclaration(this.node.getParent()) && !this.node.hasChildren();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).omitNullValues().add("type", (Object)this.type).add("node", (Object)this.node).add("scope", (Object)this.scope).toString();
        }

        static enum Type {
            SET_FROM_GLOBAL,
            SET_FROM_LOCAL,
            GET_AND_SET_FROM_GLOBAL,
            GET_AND_SET_FROM_LOCAL,
            PROTOTYPE_GET,
            ALIASING_GET,
            DIRECT_GET,
            CALL_GET,
            DELETE_PROP,
            SUBCLASSING_GET;

        }
    }

    final class Name
    implements StaticSlot {
        private final String baseName;
        private final Name parent;
        @Nullable List<Name> props;
        private @Nullable Ref declaration;
        private @Nullable Ref initialization;
        private Object refsForNode = null;
        private int globalSets = 0;
        private int localSets = 0;
        private int localSetsWithNoCollapse = 0;
        private int aliasingGets = 0;
        private int totalGets = 0;
        private int callGets = 0;
        private int deleteProps = 0;
        private int subclassingGets = 0;
        private int propertyBitSet = 0;
        private @Nullable JSDocInfo firstDeclarationJSDocInfo = null;
        private @Nullable JSDocInfo firstQnameDeclarationWithoutAssignmentJsDocInfo = null;

        private Name(String name, Name parent, SourceKind sourceKind) {
            this.baseName = name;
            this.parent = parent;
            this.setBooleanProperty(NameProp.NOT_A_TYPE);
            this.setBooleanProperty(NameProp.OTHER_OBJECT);
            if (sourceKind.equals((Object)SourceKind.EXTERN)) {
                this.setBooleanProperty(NameProp.IS_EXTERN);
            }
        }

        Name addProperty(String name, SourceKind sourceKind) {
            if (this.props == null) {
                this.props = new ArrayList<Name>();
            }
            Name node = new Name(name, this, sourceKind);
            this.props.add(node);
            return node;
        }

        String getBaseName() {
            return this.baseName;
        }

        boolean inExterns() {
            return this.getBooleanProperty(NameProp.IS_EXTERN);
        }

        int subclassingGetCount() {
            return this.subclassingGets;
        }

        @Override
        public String getName() {
            return this.getFullName();
        }

        String getFullName() {
            return this.parent == null ? this.baseName : this.parent.getFullName() + "." + this.baseName;
        }

        boolean usesHasOwnProperty() {
            return this.getBooleanProperty(NameProp.IS_USED_HAS_OWN_PROPERTY);
        }

        @Override
        public @Nullable Ref getDeclaration() {
            return this.declaration;
        }

        public @Nullable Ref getInitialization() {
            return this.initialization;
        }

        boolean isFunction() {
            return this.getBooleanProperty(NameProp.FUNCTION);
        }

        boolean isClass() {
            return this.getBooleanProperty(NameProp.CLASS);
        }

        boolean isObjectLiteral() {
            return this.getBooleanProperty(NameProp.OBJECTLIT);
        }

        int getAliasingGets() {
            return this.aliasingGets;
        }

        int getSubclassingGets() {
            return this.subclassingGets;
        }

        int getLocalSets() {
            return this.localSets;
        }

        int getGlobalSets() {
            return this.globalSets;
        }

        int getTotalSets() {
            return this.globalSets + this.localSets;
        }

        int getCallGets() {
            return this.callGets;
        }

        int getTotalGets() {
            return this.totalGets;
        }

        int getDeleteProps() {
            return this.deleteProps;
        }

        Name getParent() {
            return this.parent;
        }

        @Override
        public StaticScope getScope() {
            throw new UnsupportedOperationException();
        }

        private void setBooleanProperty(NameProp property) {
            this.propertyBitSet |= property.bit;
        }

        private boolean getBooleanProperty(NameProp property) {
            return (this.propertyBitSet & property.bit) != 0;
        }

        private void addRef(Scope scope, Node node, Ref.Type type) {
            this.checkNoExistingRefsForNode(node);
            Ref ref = this.createNewRef(scope, node, type);
            this.putRef(node, ref);
            this.updateStateForAddedRef(ref);
        }

        private void checkNoExistingRefsForNode(Node node) {
            if (this.refsForNode == null) {
                return;
            }
            if (this.refsForNode instanceof Ref) {
                Preconditions.checkState((((Ref)this.refsForNode).node != node ? 1 : 0) != 0, (String)"Ref already exists for node: %s", (Object)this.refsForNode);
                return;
            }
            Ref refForNode = this.castRefsForNodeMap().get(node);
            Preconditions.checkState((refForNode == null ? 1 : 0) != 0, (String)"Ref already exists for node: %s", (Object)refForNode);
        }

        private Map<Node, Ref> castRefsForNodeMap() {
            return (Map)this.refsForNode;
        }

        private Ref createNewRef(Scope scope, Node node, Ref.Type type) {
            return new Ref((Scope)Preconditions.checkNotNull((Object)scope), (Node)Preconditions.checkNotNull((Object)node), type);
        }

        private void putRef(Node node, Ref ref) {
            if (this.refsForNode == null) {
                this.refsForNode = ref;
                return;
            }
            if (this.refsForNode instanceof Ref) {
                LinkedHashMap<Node, Ref> refsForNodeMap = new LinkedHashMap<Node, Ref>();
                Ref existingRef = (Ref)this.refsForNode;
                refsForNodeMap.put(existingRef.node, existingRef);
                this.refsForNode = refsForNodeMap;
            }
            this.castRefsForNodeMap().put(node, ref);
        }

        Ref addSingleRefForTesting(Node node, Ref.Type type) {
            Ref ref = new Ref(null, node, type);
            this.putRef(node, ref);
            this.updateStateForAddedRef(ref);
            return ref;
        }

        void addAliasingGetClonedFromDeclaration(Node newRefNode) {
            Ref declRef = (Ref)Preconditions.checkNotNull((Object)this.declaration);
            this.addRef(declRef.scope, newRefNode, Ref.Type.ALIASING_GET);
        }

        private void updateStateForAddedRef(Ref ref) {
            switch (ref.type) {
                case GET_AND_SET_FROM_GLOBAL: 
                case SET_FROM_GLOBAL: {
                    if (this.declaration == null) {
                        this.declaration = ref;
                    }
                    if (this.initialization == null && !ref.isUninitializedDeclaration()) {
                        this.initialization = ref;
                    }
                    if (this.firstDeclarationJSDocInfo == null) {
                        this.firstDeclarationJSDocInfo = this.getDocInfoForDeclaration(ref);
                    }
                    ++this.globalSets;
                    if (!ref.type.equals((Object)Ref.Type.GET_AND_SET_FROM_GLOBAL)) break;
                    ++this.aliasingGets;
                    ++this.totalGets;
                    break;
                }
                case GET_AND_SET_FROM_LOCAL: 
                case SET_FROM_LOCAL: {
                    JSDocInfo info;
                    ++this.localSets;
                    JSDocInfo jSDocInfo = info = ref.getNode() == null ? null : NodeUtil.getBestJSDocInfo(ref.getNode());
                    if (info != null && info.isNoCollapse()) {
                        ++this.localSetsWithNoCollapse;
                    }
                    if (!ref.type.equals((Object)Ref.Type.GET_AND_SET_FROM_LOCAL)) break;
                    ++this.aliasingGets;
                    ++this.totalGets;
                    break;
                }
                case PROTOTYPE_GET: 
                case DIRECT_GET: {
                    Node node = ref.getNode();
                    if (this.firstQnameDeclarationWithoutAssignmentJsDocInfo == null && GlobalNamespace.isQnameDeclarationWithoutAssignment(node)) {
                        this.firstQnameDeclarationWithoutAssignmentJsDocInfo = node.getJSDocInfo();
                    }
                    ++this.totalGets;
                    break;
                }
                case ALIASING_GET: {
                    ++this.aliasingGets;
                    ++this.totalGets;
                    break;
                }
                case CALL_GET: {
                    ++this.callGets;
                    ++this.totalGets;
                    break;
                }
                case DELETE_PROP: {
                    ++this.deleteProps;
                    break;
                }
                case SUBCLASSING_GET: {
                    ++this.subclassingGets;
                    ++this.totalGets;
                }
            }
        }

        void updateRefNode(Ref ref, @Nullable Node newNode) {
            Preconditions.checkArgument((ref.node != newNode ? 1 : 0) != 0, (String)"redundant update to Ref node: %s", (Object)ref);
            Node oldNode = ref.getNode();
            Preconditions.checkState((oldNode != null ? 1 : 0) != 0, (String)"Ref's node is already null: %s", (Object)ref);
            ref.node = newNode;
            if (this.refsForNode == null) {
                this.refsForNode = ref;
            } else if (this.refsForNode instanceof Ref) {
                Preconditions.checkState((this.refsForNode == ref ? 1 : 0) != 0);
            } else {
                Map<Node, Ref> refsForNodeMap = this.castRefsForNodeMap();
                refsForNodeMap.remove(oldNode);
                if (newNode != null) {
                    Ref existingRefForNewNode = refsForNodeMap.get(newNode);
                    Preconditions.checkArgument((existingRefForNewNode == null ? 1 : 0) != 0, (String)"refs already exist: %s", (Object)existingRefForNewNode);
                    refsForNodeMap.put(newNode, ref);
                }
            }
        }

        void removeRef(Ref ref) {
            Preconditions.checkNotNull((Object)this.refsForNode, (String)"removeRef(%s): unknown ref", (Object)ref);
            if (this.refsForNode instanceof Ref) {
                Preconditions.checkState((this.refsForNode == ref ? 1 : 0) != 0, (String)"removeRef(%s): unknown ref", (Object)ref);
                this.refsForNode = null;
            } else {
                Preconditions.checkState((boolean)this.castRefsForNodeMap().containsKey(ref.getNode()), (String)"removeRef(%s): unknown ref", (Object)ref);
                Node refNode = ref.getNode();
                if (refNode != null) {
                    this.removeRefFromNodeMap(ref);
                }
            }
            this.removeRefAndUpdateState(ref);
        }

        private void removeRefAndUpdateState(Ref ref) {
            if (ref == this.declaration) {
                this.declaration = null;
                for (Ref maybeNewDecl : this.getRefs()) {
                    if (maybeNewDecl.type != Ref.Type.SET_FROM_GLOBAL) continue;
                    this.declaration = maybeNewDecl;
                    break;
                }
            }
            switch (ref.type) {
                case SET_FROM_GLOBAL: {
                    --this.globalSets;
                    break;
                }
                case GET_AND_SET_FROM_GLOBAL: {
                    --this.aliasingGets;
                    --this.totalGets;
                    --this.globalSets;
                    break;
                }
                case GET_AND_SET_FROM_LOCAL: 
                case SET_FROM_LOCAL: {
                    JSDocInfo info;
                    --this.localSets;
                    JSDocInfo jSDocInfo = info = ref.getNode() == null ? null : NodeUtil.getBestJSDocInfo(ref.getNode());
                    if (info != null && info.isNoCollapse()) {
                        --this.localSetsWithNoCollapse;
                    }
                    if (!ref.type.equals((Object)Ref.Type.GET_AND_SET_FROM_LOCAL)) break;
                    --this.aliasingGets;
                    --this.totalGets;
                    break;
                }
                case PROTOTYPE_GET: 
                case DIRECT_GET: {
                    --this.totalGets;
                    break;
                }
                case ALIASING_GET: {
                    --this.aliasingGets;
                    --this.totalGets;
                    break;
                }
                case CALL_GET: {
                    --this.callGets;
                    --this.totalGets;
                    break;
                }
                case DELETE_PROP: {
                    --this.deleteProps;
                    break;
                }
                case SUBCLASSING_GET: {
                    --this.subclassingGets;
                    --this.totalGets;
                }
            }
        }

        private void removeRefFromNodeMap(Ref ref) {
            Node refNode = (Node)Preconditions.checkNotNull((Object)ref.getNode(), (Object)ref);
            Preconditions.checkNotNull((Object)this.refsForNode, (String)"Missing ref when trying to remove it: %s", (Object)ref);
            if (this.refsForNode instanceof Ref) {
                this.refsForNode = null;
            } else {
                Ref refsForNode = this.castRefsForNodeMap().get(refNode);
                Preconditions.checkState((refsForNode == ref ? 1 : 0) != 0, (String)"Unexpected Refs for Node: %s: when removing Ref: %s", (Object)refsForNode, (Object)ref);
                this.castRefsForNodeMap().remove(refNode);
            }
        }

        Collection<Ref> getRefs() {
            if (this.refsForNode == null) {
                return ImmutableSet.of();
            }
            if (this.refsForNode instanceof Ref) {
                return ImmutableSet.of((Object)((Ref)this.refsForNode));
            }
            return this.castRefsForNodeMap().values();
        }

        @VisibleForTesting
        @Nullable Ref getRefForNode(Node node) {
            Preconditions.checkNotNull((Object)node);
            if (this.refsForNode == null) {
                return null;
            }
            if (this.refsForNode instanceof Ref) {
                Ref ref = (Ref)this.refsForNode;
                return ref.getNode() == node ? ref : null;
            }
            return this.castRefsForNodeMap().get(node);
        }

        Ref getFirstRef() {
            Preconditions.checkNotNull((Object)this.refsForNode, (Object)"no first Ref to get");
            if (this.refsForNode instanceof Ref) {
                return (Ref)this.refsForNode;
            }
            return this.castRefsForNodeMap().values().iterator().next();
        }

        boolean canEliminate() {
            if (!this.canCollapseUnannotatedChildNames() || this.totalGets > 0) {
                return false;
            }
            if (this.props != null) {
                for (Name n : this.props) {
                    if (n.canCollapse()) continue;
                    return false;
                }
            }
            return true;
        }

        boolean isSimpleStubDeclaration() {
            if (this.getRefs().size() == 1) {
                Ref ref = this.getFirstRef();
                if (ref.node.getParent().isExprResult()) {
                    return true;
                }
            }
            return false;
        }

        boolean isCollapsingExplicitlyDenied() {
            JSDocInfo docInfo = this.getJSDocInfo();
            return docInfo != null && docInfo.isNoCollapse();
        }

        Inlinability calculateInlinability() {
            if (this.inExterns() || !this.hasOneRealGlobalSet() || this.localSets != 0) {
                return Inlinability.DO_NOT_INLINE;
            }
            Inlinability collapsibility = this.canCollapseOrInline();
            if (!collapsibility.shouldInlineUsages()) {
                return Inlinability.DO_NOT_INLINE;
            }
            block6: for (Ref ref : this.getRefs()) {
                switch (ref.type) {
                    case GET_AND_SET_FROM_GLOBAL: 
                    case SET_FROM_GLOBAL: {
                        continue block6;
                    }
                    case GET_AND_SET_FROM_LOCAL: 
                    case SET_FROM_LOCAL: {
                        throw new IllegalStateException();
                    }
                    case PROTOTYPE_GET: 
                    case DIRECT_GET: 
                    case ALIASING_GET: 
                    case CALL_GET: 
                    case SUBCLASSING_GET: {
                        continue block6;
                    }
                    case DELETE_PROP: {
                        return Inlinability.DO_NOT_INLINE;
                    }
                }
                throw new AssertionError();
            }
            return collapsibility;
        }

        private boolean hasOneRealGlobalSet() {
            return this.globalSets == 1 || this.globalSets == 2 && this.declaration.isUninitializedDeclaration();
        }

        boolean canCollapse() {
            return this.canCollapseOrInline().canCollapse();
        }

        Inlinability canCollapseOrInline() {
            Node declaration;
            if (this.inExterns()) {
                this.logDecision(Inlinability.DO_NOT_INLINE, "declared in externs");
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.isGetOrSetDefinition()) {
                this.logDecision(Inlinability.DO_NOT_INLINE, "getter / setter");
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.isCollapsingExplicitlyDenied()) {
                this.logDecision(Inlinability.DO_NOT_INLINE, "@nocollapse");
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.referencesSuperOrInnerClassName()) {
                this.logDecision(Inlinability.DO_NOT_INLINE, "references super or inner class name");
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.isToStringValueOfInObjectLiteral()) {
                this.logDecision(Inlinability.DO_NOT_INLINE, "references explicit definition of toString/valueOf functions used implicitly in the JS language");
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.deleteProps > 0) {
                this.logDecision(Inlinability.DO_NOT_INLINE, "delete operator is used on this property");
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.getDeclaration() != null && (declaration = this.getDeclaration().getNode()).getParent().isObjectLit()) {
                if (GlobalNamespace.this.declarationHasFollowingObjectSpreadSibling(declaration)) {
                    this.logDecision(Inlinability.DO_NOT_INLINE, "obj lit property followed by spread");
                    return Inlinability.DO_NOT_INLINE;
                }
                Node objectLitParent = GlobalNamespace.this.getOutermostObjectLit(declaration).getParent();
                if (objectLitParent.isOr() || objectLitParent.isHook()) {
                    this.logDecision(Inlinability.DO_NOT_INLINE, "conditional definition");
                    return Inlinability.DO_NOT_INLINE;
                }
            }
            boolean isUnchangedThroughFullName = (this.globalSets > 0 || this.localSets > 0) && this.localSetsWithNoCollapse == 0 && this.deleteProps == 0;
            Inlinability parentInlinability = this.parent == null ? Inlinability.INLINE_COMPLETELY : this.parent.canCollapseOrInlineChildNames();
            switch (parentInlinability) {
                case INLINE_COMPLETELY: {
                    if (isUnchangedThroughFullName) {
                        this.logDecision(Inlinability.INLINE_COMPLETELY, "parent inlineable: unchanged through full name");
                        return Inlinability.INLINE_COMPLETELY;
                    }
                    Inlinability unsafeInlinablility = this.getUnsafeInlinabilityBasedOnDeclaredType();
                    this.logDecision(unsafeInlinablility, "parent inlineable: changed through full name");
                    return unsafeInlinablility;
                }
                case INLINE_BUT_KEEP_DECLARATION_CLASS: 
                case INLINE_BUT_KEEP_DECLARATION_ENUM: 
                case INLINE_BUT_KEEP_DECLARATION_INTERFACE: {
                    if (this.isDeclaredType()) {
                        Inlinability unsafeInlinability = this.getUnsafeInlinabilityBasedOnDeclaredType();
                        this.logDecision(unsafeInlinability, "parent unsafely inlineable & is declared type");
                        return unsafeInlinability;
                    }
                    if (isUnchangedThroughFullName) {
                        this.logDecision(parentInlinability, "parent unsafely inlineable & unchanged through full name");
                        return parentInlinability;
                    }
                    this.logDecision(Inlinability.DO_NOT_INLINE, "parent unsafely inlineable & changed through full name");
                    return Inlinability.DO_NOT_INLINE;
                }
                case DO_NOT_INLINE: {
                    Inlinability unsafeInlinability = this.getUnsafeInlinabilityBasedOnDeclaredType();
                    this.logDecision(unsafeInlinability, "parent cannot be inlined");
                    return unsafeInlinability;
                }
            }
            throw new IllegalStateException("unknown enum value " + parentInlinability);
        }

        private void logDecision(Inlinability inlinability, String reason) {
            if (GlobalNamespace.this.decisionsLog != null && GlobalNamespace.this.decisionsLog.isLogging()) {
                GlobalNamespace.this.decisionsLog.log("%s: %s: %s", new Object[]{this.getFullName(), inlinability, reason});
            }
        }

        private Inlinability getUnsafeInlinabilityBasedOnDeclaredType() {
            if (this.getBooleanProperty(NameProp.CONSTRUCTOR_TYPE)) {
                return Inlinability.INLINE_BUT_KEEP_DECLARATION_CLASS;
            }
            if (this.getBooleanProperty(NameProp.INTERFACE_TYPE)) {
                return Inlinability.INLINE_BUT_KEEP_DECLARATION_INTERFACE;
            }
            if (this.getBooleanProperty(NameProp.ENUM_TYPE)) {
                return Inlinability.INLINE_BUT_KEEP_DECLARATION_ENUM;
            }
            if (this.getBooleanProperty(NameProp.NOT_A_TYPE)) {
                return Inlinability.DO_NOT_INLINE;
            }
            throw new IllegalStateException(SimpleFormat.format("name missing declaredType value: %s", this));
        }

        boolean referencesSuperOrInnerClassName() {
            Ref ref = this.getDeclaration();
            if (ref == null) {
                return false;
            }
            Node member = ref.getNode();
            if (member == null || !member.isStaticMember() || !member.getParent().isClassMembers()) {
                return false;
            }
            if (NodeUtil.referencesSuper(NodeUtil.getFunctionBody(member.getFirstChild()))) {
                return true;
            }
            Node classNode = member.getGrandparent();
            if (NodeUtil.isClassDeclaration(classNode)) {
                return false;
            }
            Node innerNameNode = classNode.getFirstChild();
            return !innerNameNode.isEmpty() && NodeUtil.isNameReferenced(member, innerNameNode.getString());
        }

        private boolean isSetInLoop() {
            Node n;
            Ref ref = this.getDeclaration();
            if (ref != null && (n = ref.getNode()) != null) {
                return NodeUtil.isWithinLoop(n);
            }
            return false;
        }

        boolean isGetOrSetDefinition() {
            return this.getBooleanProperty(NameProp.GET_SET);
        }

        boolean canCollapseUnannotatedChildNames() {
            return this.canCollapseOrInlineChildNames().canCollapse();
        }

        boolean isToStringValueOfInObjectLiteral() {
            Name parent = this.getParent();
            String baseName = this.getBaseName();
            return this.isFunction() && parent != null && parent.isObjectLiteral() && (baseName.equals("toString") || baseName.equals("valueOf"));
        }

        Inlinability canCollapseOrInlineChildNames() {
            if (this.getBooleanProperty(NameProp.OTHER_OBJECT)) {
                this.logChildNamesDecision(Inlinability.DO_NOT_INLINE, "NameProp.OTHER_OBJECT");
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.isGetOrSetDefinition()) {
                this.logChildNamesDecision(Inlinability.DO_NOT_INLINE, "getter/setter");
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.globalSets != 1) {
                this.logChildNamesDecision(Inlinability.DO_NOT_INLINE, () -> SimpleFormat.format("set %d times globally", this.globalSets));
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.localSets != 0) {
                this.logChildNamesDecision(Inlinability.DO_NOT_INLINE, () -> SimpleFormat.format("set %d times locally", this.localSets));
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.deleteProps != 0) {
                this.logChildNamesDecision(Inlinability.DO_NOT_INLINE, () -> SimpleFormat.format("properties are deleted %d times", this.deleteProps));
                return Inlinability.DO_NOT_INLINE;
            }
            Preconditions.checkNotNull((Object)this.declaration);
            if (this.declaration.isTwin()) {
                this.logChildNamesDecision(Inlinability.DO_NOT_INLINE, "twinned declaration");
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.isCollapsingExplicitlyDenied()) {
                this.logChildNamesDecision(Inlinability.DO_NOT_INLINE, "@nocollapse");
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.isSetInLoop()) {
                this.logChildNamesDecision(Inlinability.DO_NOT_INLINE, "set in a loop");
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.usesHasOwnProperty()) {
                this.logChildNamesDecision(Inlinability.DO_NOT_INLINE, "hasOwnProperty() call exists");
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.valueImplicitlySupportsAliasing()) {
                this.logChildNamesDecision(Inlinability.DO_NOT_INLINE, "value implicitly supports aliasing");
                return Inlinability.DO_NOT_INLINE;
            }
            if (this.parent != null && this.parent.shouldKeepKeys()) {
                Inlinability unsafeInlinability = this.getUnsafeInlinabilityBasedOnDeclaredType();
                this.logChildNamesDecision(unsafeInlinability, "parent.shouldKeepKeys()");
                return unsafeInlinability;
            }
            if (this.aliasingGets > 0) {
                Inlinability unsafeInlinability = this.getUnsafeInlinabilityBasedOnDeclaredType();
                this.logChildNamesDecision(unsafeInlinability, () -> SimpleFormat.format("%d aliasing gets exist", this.aliasingGets));
                return unsafeInlinability;
            }
            if (this.parent == null) {
                this.logChildNamesDecision(Inlinability.INLINE_COMPLETELY, "no reason not to inline");
                return Inlinability.INLINE_COMPLETELY;
            }
            Inlinability parentInlinability = this.parent.canCollapseOrInlineChildNames();
            if (parentInlinability == Inlinability.DO_NOT_INLINE) {
                Inlinability unsafeInlinability = this.getUnsafeInlinabilityBasedOnDeclaredType();
                this.logChildNamesDecision(unsafeInlinability, "parent is not inlineable");
                return unsafeInlinability;
            }
            this.logChildNamesDecision(parentInlinability, "inherited from parent");
            return parentInlinability;
        }

        private void logChildNamesDecision(Inlinability inlinability, String reason) {
            if (GlobalNamespace.this.decisionsLog != null && GlobalNamespace.this.decisionsLog.isLogging()) {
                GlobalNamespace.this.decisionsLog.log("%s: children: %s: %s", new Object[]{this.getFullName(), inlinability, reason});
            }
        }

        private void logChildNamesDecision(Inlinability inlinability, Supplier<String> reasonSupplier) {
            if (GlobalNamespace.this.decisionsLog != null && GlobalNamespace.this.decisionsLog.isLogging()) {
                GlobalNamespace.this.decisionsLog.log(() -> SimpleFormat.format("%s: children: %s: %s", new Object[]{this.getFullName(), inlinability, reasonSupplier.get()}));
            }
        }

        private boolean valueImplicitlySupportsAliasing() {
            if (!GlobalNamespace.this.enableImplicitlyAliasedValues) {
                return false;
            }
            if (this.getBooleanProperty(NameProp.CLASS)) {
                return true;
            }
            if (this.getBooleanProperty(NameProp.FUNCTION)) {
                @Nullable JSDocInfo jsdoc = this.getJSDocInfo();
                return jsdoc != null && jsdoc.isConstructorOrInterface();
            }
            return false;
        }

        boolean shouldKeepKeys() {
            return this.isObjectLiteral() && (this.aliasingGets > 0 || this.isCollapsingExplicitlyDenied());
        }

        boolean needsToBeStubbed() {
            return this.globalSets == 0 && this.localSets > 0 && this.localSetsWithNoCollapse == 0 && !this.isCollapsingExplicitlyDenied();
        }

        private void setDeclaredTypeKind(NameProp declaredType) {
            Preconditions.checkArgument(((declaredType.bit & NameProp.DECLARED_TYPE_KIND_MASK) != 0 ? 1 : 0) != 0, (String)"Unexpected NameProp for declaredType %s", (Object)((Object)declaredType));
            this.propertyBitSet = this.propertyBitSet & ~NameProp.DECLARED_TYPE_KIND_MASK | declaredType.bit;
            if (declaredType != NameProp.NOT_A_TYPE) {
                Name ancestor = this.parent;
                while (ancestor != null) {
                    ancestor.setBooleanProperty(NameProp.IS_DECLARED);
                    ancestor = ancestor.parent;
                }
            }
        }

        private void setNameType(NameProp type) {
            Preconditions.checkArgument(((type.bit & NameProp.NAME_KIND_MASK) != 0 ? 1 : 0) != 0, (String)"Unexpected NameProp for nameType %s", (Object)((Object)type));
            this.propertyBitSet = this.propertyBitSet & ~NameProp.NAME_KIND_MASK | type.bit;
        }

        boolean isDeclaredType() {
            Preconditions.checkState(((this.propertyBitSet & NameProp.DECLARED_TYPE_KIND_MASK) != 0 ? 1 : 0) != 0, (Object)this.propertyBitSet);
            return !this.getBooleanProperty(NameProp.NOT_A_TYPE);
        }

        boolean isConstructor() {
            Node declNode = this.declaration.node;
            Node rvalueNode = NodeUtil.getRValueOfLValue(declNode);
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(declNode);
            return rvalueNode != null && rvalueNode.isFunction() && jsdoc != null && jsdoc.isConstructor();
        }

        boolean isNamespaceObjectLit() {
            return this.getBooleanProperty(NameProp.IS_DECLARED) && this.isObjectLiteral();
        }

        boolean isSimpleName() {
            return this.parent == null;
        }

        String getTypeDebugString() {
            if (this.isClass()) {
                return "CLASS";
            }
            if (this.isFunction()) {
                return "FUNCTION";
            }
            if (this.isObjectLiteral()) {
                return "OBJECTLIT";
            }
            if (this.isGetOrSetDefinition()) {
                return "GET_SET";
            }
            if (this.getBooleanProperty(NameProp.OTHER_OBJECT)) {
                return "OTHER";
            }
            throw new AssertionError((Object)("Missing NameProp for name kind in " + this.propertyBitSet));
        }

        public String toString() {
            return this.getFullName() + " (" + this.getTypeDebugString() + "): " + Joiner.on((String)", ").join((Object)("globalSets=" + this.globalSets), (Object)("localSets=" + this.localSets), new Object[]{"totalGets=" + this.totalGets, "aliasingGets=" + this.aliasingGets, "callGets=" + this.callGets, "subclassingGets=" + this.subclassingGets});
        }

        @Override
        public @Nullable JSDocInfo getJSDocInfo() {
            return this.firstDeclarationJSDocInfo != null ? this.firstDeclarationJSDocInfo : this.firstQnameDeclarationWithoutAssignmentJsDocInfo;
        }

        private @Nullable JSDocInfo getDocInfoForDeclaration(Ref ref) {
            if (ref.node != null) {
                Node refParent = ref.node.getParent();
                if (refParent == null) {
                    return null;
                }
                switch (refParent.getToken()) {
                    case ASSIGN: 
                    case FUNCTION: 
                    case CLASS: {
                        return refParent.getJSDocInfo();
                    }
                    case VAR: 
                    case LET: 
                    case CONST: {
                        return ref.node == refParent.getFirstChild() ? refParent.getJSDocInfo() : ref.node.getJSDocInfo();
                    }
                    case OBJECTLIT: 
                    case CLASS_MEMBERS: {
                        return ref.node.getJSDocInfo();
                    }
                }
            }
            return null;
        }

        boolean isModuleExport() {
            return this.getBooleanProperty(NameProp.IS_MODULE_PROP);
        }
    }

    static enum Inlinability {
        INLINE_COMPLETELY(true, true, true),
        INLINE_BUT_KEEP_DECLARATION_ENUM(true, false, true),
        INLINE_BUT_KEEP_DECLARATION_INTERFACE(true, false, true),
        INLINE_BUT_KEEP_DECLARATION_CLASS(true, false, true),
        DO_NOT_INLINE(false, false, false);

        private final boolean shouldInlineUsages;
        private final boolean shouldRemoveDeclaration;
        private final boolean canCollapse;

        private Inlinability(boolean shouldInlineUsages, boolean shouldRemoveDeclaration, boolean canCollapse) {
            this.shouldInlineUsages = shouldInlineUsages;
            this.shouldRemoveDeclaration = shouldRemoveDeclaration;
            this.canCollapse = canCollapse;
        }

        boolean shouldInlineUsages() {
            return this.shouldInlineUsages;
        }

        boolean shouldRemoveDeclaration() {
            return this.shouldRemoveDeclaration;
        }

        boolean canCollapse() {
            return this.canCollapse;
        }
    }

    private class BuildGlobalNamespace
    extends NodeTraversal.AbstractPreOrderCallback {
        private @Nullable Node curModuleRoot = null;
        private  @Nullable ModuleMetadataMap.ModuleMetadata curMetadata = null;

        private BuildGlobalNamespace() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            if (n.isScript() && !GlobalNamespace.this.shouldTraverseScript.test(n)) {
                return false;
            }
            if (GlobalNamespace.this.hasExternsRoot() && n.isScript()) {
                GlobalNamespace.this.sourceKind = SourceKind.fromScriptNode(n);
            } else if (n == GlobalNamespace.this.root) {
                GlobalNamespace.this.sourceKind = SourceKind.CODE;
            }
            if (n.isModuleBody() || NodeUtil.isBundledGoogModuleScopeRoot(n)) {
                this.setupModuleMetadata(n);
            } else if (n.isScript() || NodeUtil.isBundledGoogModuleCall(n)) {
                this.curModuleRoot = null;
                this.curMetadata = null;
            }
            this.collect(t.getScope(), n);
            return true;
        }

        private void setupModuleMetadata(Node moduleRoot) {
            ModuleMap moduleMap = GlobalNamespace.this.compiler.getModuleMap();
            if (moduleMap == null) {
                return;
            }
            this.curModuleRoot = moduleRoot;
            this.curMetadata = (ModuleMetadataMap.ModuleMetadata)Preconditions.checkNotNull((Object)ModuleImportResolver.getModuleFromScopeRoot(moduleMap, GlobalNamespace.this.compiler, moduleRoot).metadata());
            if (this.curMetadata.isGoogModule()) {
                this.getOrCreateName("exports", this.curMetadata);
            }
        }

        private void collect(Scope scope, Node n) {
            ModuleMetadataMap.ModuleMetadata nameMetadata;
            String name;
            Node parent = n.getParent();
            boolean isSet = false;
            NameProp type = NameProp.OTHER_OBJECT;
            switch (n.getToken()) {
                case GETTER_DEF: 
                case SETTER_DEF: 
                case MEMBER_FUNCTION_DEF: {
                    if (parent.isClassMembers() && !n.isStaticMember()) {
                        return;
                    }
                    name = NodeUtil.getBestLValueName(n);
                    isSet = true;
                    type = n.isMemberFunctionDef() ? NameProp.FUNCTION : NameProp.GET_SET;
                    break;
                }
                case STRING_KEY: {
                    name = null;
                    if (parent.isObjectLit()) {
                        ObjLitStringKeyAnalysis analysis = this.createObjLitStringKeyAnalysis(n);
                        name = analysis.getNameString();
                        type = analysis.getNameType();
                        isSet = true;
                        break;
                    }
                    if (!parent.isObjectPattern()) break;
                    name = this.getNameForObjectPatternKey(n);
                    type = this.getValueType(n.getFirstChild());
                    break;
                }
                case GETPROP: 
                case NAME: {
                    switch (parent.getToken()) {
                        case VAR: 
                        case LET: 
                        case CONST: {
                            isSet = true;
                            Node rvalue = n.getFirstChild();
                            type = rvalue == null ? NameProp.OTHER_OBJECT : this.getValueType(rvalue);
                            break;
                        }
                        case ASSIGN: {
                            if (parent.getFirstChild() != n) break;
                            isSet = true;
                            type = this.getValueType(n.getNext());
                            break;
                        }
                        case GETPROP: {
                            return;
                        }
                        case FUNCTION: {
                            Node grandparent = parent.getParent();
                            if (grandparent == null || NodeUtil.isFunctionExpression(parent)) {
                                return;
                            }
                            isSet = true;
                            type = NameProp.FUNCTION;
                            break;
                        }
                        case CATCH: 
                        case INC: 
                        case DEC: {
                            isSet = true;
                            type = NameProp.OTHER_OBJECT;
                            break;
                        }
                        case CLASS: {
                            if (parent.getFirstChild() != n) break;
                            isSet = true;
                            type = NameProp.CLASS;
                            break;
                        }
                        case STRING_KEY: 
                        case ARRAY_PATTERN: 
                        case DEFAULT_VALUE: 
                        case COMPUTED_PROP: 
                        case ITER_REST: 
                        case OBJECT_REST: {
                            if (!n.isName() || !NodeUtil.isLhsByDestructuring(n)) break;
                            isSet = true;
                            type = NameProp.OTHER_OBJECT;
                            break;
                        }
                        case ITER_SPREAD: 
                        case OBJECT_SPREAD: {
                            break;
                        }
                        case CALL: {
                            if (!n.isFirstChildOf(parent) || !this.isObjectHasOwnPropertyCall(parent)) break;
                            String qname = n.getFirstChild().getQualifiedName();
                            Name globalName = this.getOrCreateName(qname, this.curMetadata);
                            globalName.setBooleanProperty(NameProp.IS_USED_HAS_OWN_PROPERTY);
                            break;
                        }
                        default: {
                            if (!NodeUtil.isAssignmentOp(parent) || parent.getFirstChild() != n) break;
                            isSet = true;
                            type = NameProp.OTHER_OBJECT;
                        }
                    }
                    if (!n.isQualifiedName()) {
                        return;
                    }
                    name = n.getQualifiedName();
                    break;
                }
                case CALL: {
                    if (parent.isExprResult() && GOOG_PROVIDE.matches(n.getFirstChild()) && n.getSecondChild().isStringLit()) {
                        this.createNamesFromProvide(n.getSecondChild().getString());
                        return;
                    }
                    return;
                }
                default: {
                    return;
                }
            }
            if (name == null) {
                return;
            }
            Node root = GlobalNamespace.this.getRootNode(name, scope);
            if (!this.isTopLevelScopeRoot(root)) {
                return;
            }
            ModuleMetadataMap.ModuleMetadata moduleMetadata = nameMetadata = root == GlobalNamespace.this.globalRoot ? null : this.curMetadata;
            if (isSet) {
                Scope hoistScope = (Scope)scope.getClosestHoistScope();
                if (hoistScope.isGlobal() || root != GlobalNamespace.this.globalRoot && hoistScope.getRootNode() == this.curModuleRoot) {
                    this.handleSetFromGlobal(scope, n, name, type, nameMetadata);
                } else {
                    this.handleSetFromLocal(scope, n, name, nameMetadata);
                }
            } else {
                this.handleGet(scope, n, name, nameMetadata);
            }
        }

        private ObjLitStringKeyAnalysis createObjLitStringKeyAnalysis(Node stringKeyNode) {
            Node receiverNode;
            Object nameString = NodeUtil.getBestLValueName(stringKeyNode);
            if (nameString != null) {
                return ObjLitStringKeyAnalysis.forObjLitAssignment((String)nameString, this.getValueType(stringKeyNode.getOnlyChild()));
            }
            Node objLitNode = stringKeyNode.getParent();
            Preconditions.checkArgument((boolean)objLitNode.isObjectLit(), (Object)objLitNode);
            Node objLitParentNode = objLitNode.getParent();
            if (NodeUtil.isObjectDefinePropertiesDefinition(objLitParentNode) && (receiverNode = objLitParentNode.getSecondChild()).isQualifiedName()) {
                Preconditions.checkState((objLitNode == receiverNode.getNext() ? 1 : 0) != 0, (Object)objLitParentNode);
                nameString = receiverNode.getQualifiedName() + "." + stringKeyNode.getString();
                return ObjLitStringKeyAnalysis.forObjectDefineProperty((String)nameString);
            }
            return ObjLitStringKeyAnalysis.forNonReference();
        }

        private void createNamesFromProvide(String namespace) {
            int dot = 0;
            while (dot >= 0) {
                String subNamespace = (dot = namespace.indexOf(46, dot + 1)) < 0 ? namespace : namespace.substring(0, dot);
                Preconditions.checkState((!subNamespace.isEmpty() ? 1 : 0) != 0);
                Name name = this.getOrCreateName(subNamespace, null);
                name.setBooleanProperty(NameProp.IS_PROVIDED);
            }
            Name newName = this.getOrCreateName(namespace, null);
            newName.setBooleanProperty(NameProp.IS_PROVIDED);
        }

        private boolean isTopLevelScopeRoot(Node root) {
            if (root == null) {
                return false;
            }
            if (root == GlobalNamespace.this.globalRoot) {
                return true;
            }
            if (root == this.curModuleRoot) {
                return true;
            }
            return this.curModuleRoot != null && this.curModuleRoot.isBlock() && root == this.curModuleRoot.getParent();
        }

        @Nullable String getNameForObjectPatternKey(Node stringKey) {
            Node parent = stringKey.getParent();
            Preconditions.checkState((boolean)parent.isObjectPattern());
            Node patternParent = parent.getParent();
            if (patternParent.isAssign() || patternParent.isDestructuringLhs()) {
                Node rhs = patternParent.getSecondChild();
                if (rhs == null || !rhs.isQualifiedName()) {
                    return null;
                }
                return rhs.getQualifiedName() + "." + stringKey.getString();
            }
            return null;
        }

        NameProp getValueType(Node n) {
            switch (n.getToken()) {
                case CLASS: {
                    return NameProp.CLASS;
                }
                case OBJECTLIT: {
                    return NameProp.OBJECTLIT;
                }
                case FUNCTION: {
                    return NameProp.FUNCTION;
                }
                case OR: {
                    return this.getValueType(n.getLastChild());
                }
                case HOOK: {
                    Node second = n.getSecondChild();
                    NameProp t = this.getValueType(second);
                    if (t != NameProp.OTHER_OBJECT) {
                        return t;
                    }
                    Node third = second.getNext();
                    return this.getValueType(third);
                }
            }
            return NameProp.OTHER_OBJECT;
        }

        void handleSetFromGlobal(Scope scope, Node n, String name, NameProp type, ModuleMetadataMap.ModuleMetadata metadata) {
            if (this.maybeHandlePrototypePrefix(scope, n, name, metadata)) {
                return;
            }
            Name nameObj = this.getOrCreateName(name, metadata);
            if (!nameObj.isGetOrSetDefinition()) {
                nameObj.setNameType(type);
            }
            if (n.getBooleanProp(Node.MODULE_EXPORT)) {
                nameObj.setBooleanProperty(NameProp.IS_MODULE_PROP);
            }
            if (this.isNestedAssign(n.getParent())) {
                Ref.Type refType = Ref.Type.GET_AND_SET_FROM_GLOBAL;
                this.addOrConfirmRef(nameObj, n, refType, scope);
            } else {
                this.addOrConfirmRef(nameObj, n, Ref.Type.SET_FROM_GLOBAL, scope);
                nameObj.setDeclaredTypeKind(this.getDeclaredTypeKind(n));
            }
        }

        private NameProp getDeclaredTypeKind(Node n) {
            JSDocInfo info;
            Node valueNode = NodeUtil.getRValueOfLValue(n);
            NameProp kind = valueNode == null ? NameProp.NOT_A_TYPE : (valueNode.isClass() ? NameProp.CONSTRUCTOR_TYPE : ((info = NodeUtil.getBestJSDocInfo(n)) == null ? NameProp.NOT_A_TYPE : (info.isConstructor() && valueNode.isFunction() ? NameProp.CONSTRUCTOR_TYPE : (info.isInterface() && valueNode.isFunction() ? NameProp.INTERFACE_TYPE : (info.hasEnumParameterType() && valueNode.isObjectLit() ? NameProp.ENUM_TYPE : NameProp.NOT_A_TYPE)))));
            return kind;
        }

        void handleSetFromLocal(Scope scope, Node n, String name, ModuleMetadataMap.ModuleMetadata metadata) {
            if (this.maybeHandlePrototypePrefix(scope, n, name, metadata)) {
                return;
            }
            Name nameObj = this.getOrCreateName(name, metadata);
            if (n.getBooleanProp(Node.MODULE_EXPORT)) {
                nameObj.setBooleanProperty(NameProp.IS_MODULE_PROP);
            }
            if (this.isNestedAssign(n.getParent())) {
                this.addOrConfirmRef(nameObj, n, Ref.Type.GET_AND_SET_FROM_LOCAL, scope);
            } else {
                this.addOrConfirmRef(nameObj, n, Ref.Type.SET_FROM_LOCAL, scope);
            }
        }

        void handleGet(Scope scope, Node n, String name, ModuleMetadataMap.ModuleMetadata metadata) {
            if (this.maybeHandlePrototypePrefix(scope, n, name, metadata)) {
                return;
            }
            Ref.Type type = this.determineRefTypeForGet(n, n, name);
            this.addOrConfirmRef(this.getOrCreateName(name, metadata), n, type, scope);
        }

        private Ref.Type determineRefTypeForGet(Node n, Node referenceNode, String name) {
            Ref.Type type;
            Node parent = n.getParent();
            block0 : switch (parent.getToken()) {
                case EXPR_RESULT: 
                case IF: 
                case WHILE: 
                case FOR: 
                case INSTANCEOF: 
                case TYPEOF: 
                case VOID: 
                case NOT: 
                case BITNOT: 
                case POS: 
                case NEG: 
                case SHEQ: 
                case EQ: 
                case SHNE: 
                case NE: 
                case LT: 
                case LE: 
                case GT: 
                case GE: 
                case ADD: 
                case SUB: 
                case MUL: 
                case DIV: 
                case MOD: 
                case EXPONENT: 
                case BITAND: 
                case BITOR: 
                case BITXOR: 
                case LSH: 
                case RSH: 
                case URSH: {
                    type = Ref.Type.DIRECT_GET;
                    break;
                }
                case CALL: 
                case OPTCHAIN_CALL: {
                    if (n == parent.getFirstChild()) {
                        type = Ref.Type.CALL_GET;
                        break;
                    }
                    if (this.isClassDefiningCall(parent)) {
                        type = Ref.Type.DIRECT_GET;
                        break;
                    }
                    type = Ref.Type.ALIASING_GET;
                    break;
                }
                case NEW: {
                    type = n == parent.getFirstChild() ? Ref.Type.DIRECT_GET : Ref.Type.ALIASING_GET;
                    break;
                }
                case OR: 
                case CAST: 
                case AND: 
                case COALESCE: {
                    type = this.determineRefTypeForGet(parent, referenceNode, name);
                    break;
                }
                case NAME: {
                    if (n != referenceNode && name.equals(parent.getString())) {
                        type = Ref.Type.DIRECT_GET;
                        break;
                    }
                    type = Ref.Type.ALIASING_GET;
                    break;
                }
                case HOOK: 
                case COMMA: {
                    if (n != parent.getFirstChild()) {
                        type = this.determineRefTypeForGet(parent, referenceNode, name);
                        break;
                    }
                    type = Ref.Type.DIRECT_GET;
                    break;
                }
                case DELPROP: {
                    type = Ref.Type.DELETE_PROP;
                    break;
                }
                case CLASS: {
                    type = Ref.Type.SUBCLASSING_GET;
                    break;
                }
                case ASSIGN: 
                case DESTRUCTURING_LHS: {
                    Node lhs = n.getPrevious();
                    if (lhs == null) {
                        type = Ref.Type.ALIASING_GET;
                        break;
                    }
                    while (lhs.isCast()) {
                        lhs = lhs.getOnlyChild();
                    }
                    if (n != referenceNode && lhs.matchesQualifiedName(name)) {
                        return Ref.Type.DIRECT_GET;
                    }
                    switch (lhs.getToken()) {
                        case GETPROP: 
                        case ARRAY_PATTERN: 
                        case NAME: 
                        case GETELEM: 
                        case OBJECT_PATTERN: {
                            type = Ref.Type.ALIASING_GET;
                            break block0;
                        }
                    }
                    throw new IllegalStateException("Unexpected previous sibling of " + n.getToken() + ": " + n.getPrevious());
                }
                default: {
                    type = Ref.Type.ALIASING_GET;
                }
            }
            return type;
        }

        private void addOrConfirmRef(Name nameObj, Node node, Ref.Type refType, Scope scope) {
            Ref existingRef = nameObj.getRefForNode(node);
            if (existingRef == null) {
                nameObj.addRef(scope, node, refType);
            } else {
                Ref.Type existingRefType = existingRef.type;
                Preconditions.checkState((existingRefType == refType ? 1 : 0) != 0, (String)"existing ref type: %s expected: %s", (Object)((Object)existingRefType), (Object)((Object)refType));
            }
        }

        private boolean isClassDefiningCall(Node callNode) {
            CodingConvention convention = GlobalNamespace.this.compiler.getCodingConvention();
            CodingConvention.SubclassRelationship classes = convention.getClassesDefinedByCall(callNode);
            if (classes != null) {
                return true;
            }
            String className = convention.getSingletonGetterClassName(callNode);
            return className != null;
        }

        private boolean isObjectHasOwnPropertyCall(Node callNode) {
            Preconditions.checkArgument((boolean)callNode.isCall(), (Object)callNode);
            if (!callNode.hasTwoChildren()) {
                return false;
            }
            Node callee = callNode.getFirstChild();
            if (!callee.isGetProp()) {
                return false;
            }
            Node receiver = callee.getFirstChild();
            return "hasOwnProperty".equals(callee.getString()) && receiver.isQualifiedName();
        }

        boolean maybeHandlePrototypePrefix(Scope scope, Node n, String name, ModuleMetadataMap.ModuleMetadata metadata) {
            int i;
            String prefix;
            int numLevelsToRemove;
            if (name.endsWith(".prototype")) {
                numLevelsToRemove = 1;
                prefix = name.substring(0, name.length() - 10);
            } else {
                i = name.indexOf(".prototype.");
                if (i == -1) {
                    return false;
                }
                prefix = name.substring(0, i);
                numLevelsToRemove = 2;
                i = name.indexOf(46, i + 11);
                while (i >= 0) {
                    ++numLevelsToRemove;
                    i = name.indexOf(46, i + 1);
                }
            }
            if (NodeUtil.mayBeObjectLitKey(n)) {
                return true;
            }
            for (i = 0; i < numLevelsToRemove; ++i) {
                n = n.getFirstChild();
            }
            this.addOrConfirmRef(this.getOrCreateName(prefix, metadata), n, Ref.Type.PROTOTYPE_GET, scope);
            return true;
        }

        boolean isNestedAssign(Node parent) {
            return parent.isAssign() && !parent.getParent().isExprResult();
        }

        Name getOrCreateName(String name,  @Nullable ModuleMetadataMap.ModuleMetadata metadata) {
            Name node;
            Name name2 = node = metadata == null ? GlobalNamespace.this.nameMap.get(name) : (Name)GlobalNamespace.this.nameMapByModule.get((Object)metadata, (Object)name);
            if (node == null) {
                int i = name.lastIndexOf(46);
                if (i >= 0) {
                    String parentName = name.substring(0, i);
                    Name parent = this.getOrCreateName(parentName, metadata);
                    node = parent.addProperty(name.substring(i + 1), GlobalNamespace.this.sourceKind);
                    if (metadata == null) {
                        GlobalNamespace.this.nameMap.put(name, node);
                    } else {
                        GlobalNamespace.this.nameMapByModule.put((Object)metadata, (Object)name, (Object)node);
                    }
                } else {
                    node = new Name(name, null, GlobalNamespace.this.sourceKind);
                    if (metadata == null) {
                        GlobalNamespace.this.globalNames.add(node);
                        GlobalNamespace.this.nameMap.put(name, node);
                    } else {
                        GlobalNamespace.this.nameMapByModule.put((Object)metadata, (Object)name, (Object)node);
                    }
                }
            }
            return node;
        }
    }

    static class AstChange {
        final Scope scope;
        final Node node;

        AstChange(Scope scope, Node node) {
            this.scope = scope;
            this.node = node;
        }

        public boolean equals(Object obj) {
            if (obj instanceof AstChange) {
                AstChange other = (AstChange)obj;
                return Objects.equals(this.scope, other.scope) && Objects.equals(this.node, other.node);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.scope, this.node);
        }
    }

    static enum SourceKind {
        EXTERN,
        TYPE_SUMMARY,
        CODE;


        static SourceKind fromScriptNode(Node n) {
            if (!n.isFromExterns()) {
                return CODE;
            }
            if (NodeUtil.isFromTypeSummary(n)) {
                return TYPE_SUMMARY;
            }
            return EXTERN;
        }
    }
}

