/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.Collection;
import java.util.LinkedHashSet;

final class GatherExternProperties
implements NodeTraversal.Callback,
CompilerPass {
    private final AbstractCompiler compiler;
    private final LinkedHashSet<String> externProperties = new LinkedHashSet();
    private final Mode mode;

    GatherExternProperties(AbstractCompiler compiler, Mode mode) {
        this.compiler = compiler;
        this.mode = mode;
        if (compiler.getExternProperties() != null) {
            this.externProperties.addAll((Collection<String>)compiler.getExternProperties());
        }
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, externs, this);
        this.compiler.setExternProperties((ImmutableSet<String>)ImmutableSet.copyOf(this.externProperties));
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        return !n.isScript() || !NodeUtil.isFromTypeSummary(n);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        JSDocInfo jsDocInfo;
        if (this.mode.optimize) {
            switch (n.getToken()) {
                case GETPROP: {
                    this.externProperties.add(n.getString());
                    break;
                }
                case STRING_KEY: {
                    if (!parent.isObjectLit()) break;
                    this.externProperties.add(n.getString());
                    break;
                }
                case MEMBER_FUNCTION_DEF: {
                    this.externProperties.add(n.getString());
                    break;
                }
            }
        }
        if ((jsDocInfo = n.getJSDocInfo()) != null && this.mode.check) {
            this.gatherPropertiesFromJSDocInfo(jsDocInfo);
        }
    }

    private void gatherPropertiesFromJSDocInfo(JSDocInfo jsDocInfo) {
        for (Node jsTypeExpressionNode : jsDocInfo.getTypeNodes()) {
            this.gatherPropertiesFromJsTypeExpressionNode(jsTypeExpressionNode);
        }
    }

    private void gatherPropertiesFromJsTypeExpressionNode(Node jsTypeExpressionNode) {
        switch (jsTypeExpressionNode.getToken()) {
            case LB: {
                this.gatherPropertiesFromJsDocRecordType(jsTypeExpressionNode);
                break;
            }
            default: {
                for (Node child = jsTypeExpressionNode.getFirstChild(); child != null; child = child.getNext()) {
                    this.gatherPropertiesFromJsTypeExpressionNode(child);
                }
            }
        }
    }

    private void gatherPropertiesFromJsDocRecordType(Node jsDocRecordNode) {
        Preconditions.checkState((jsDocRecordNode.getToken() == Token.LB ? 1 : 0) != 0, (Object)jsDocRecordNode);
        for (Node fieldNode = jsDocRecordNode.getFirstChild(); fieldNode != null; fieldNode = fieldNode.getNext()) {
            Node fieldTypeNode;
            Node fieldNameNode;
            if (fieldNode.getToken() == Token.COLON) {
                fieldNameNode = fieldNode.getFirstChild();
                fieldTypeNode = fieldNameNode.getNext();
            } else {
                fieldNameNode = fieldNode;
                fieldTypeNode = null;
            }
            Preconditions.checkState((boolean)fieldNameNode.isStringKey(), (Object)fieldNameNode);
            String fieldName = fieldNameNode.getString();
            if (fieldName.startsWith("'") || fieldName.startsWith("\"")) {
                fieldName = fieldName.substring(1, fieldName.length() - 1);
            }
            this.externProperties.add(fieldName);
            if (fieldTypeNode == null) continue;
            this.gatherPropertiesFromJsTypeExpressionNode(fieldTypeNode);
        }
    }

    static enum Mode {
        CHECK(true, false),
        OPTIMIZE(false, true),
        CHECK_AND_OPTIMIZE(true, true);

        private final boolean check;
        private final boolean optimize;

        private Mode(boolean check, boolean optimize) {
            this.check = check;
            this.optimize = optimize;
        }
    }
}

