/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstAnalyzer;
import com.google.javascript.jscomp.ExpressionDecomposer;
import com.google.javascript.jscomp.FunctionArgumentInjector;
import com.google.javascript.jscomp.FunctionToBlockMutator;
import com.google.javascript.jscomp.InlineCostEstimator;
import com.google.javascript.jscomp.JSChunk;
import com.google.javascript.jscomp.JSChunkGraph;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.JSType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.jspecify.nullness.Nullable;

class FunctionInjector {
    private static final Node NO_FUNCTIONS = new Node(Token.FUNCTION);
    private static final Node MULTIPLE_FUNCTIONS = new Node(Token.FUNCTION);
    private final AbstractCompiler compiler;
    private final boolean allowDecomposition;
    private ImmutableSet<String> knownConstantFunctions = ImmutableSet.of();
    private final boolean assumeStrictThis;
    private final boolean assumeMinimumCapture;
    private final Supplier<String> safeNameIdSupplier;
    private final Supplier<String> throwawayNameSupplier = new Supplier<String>(){
        private int nextId = 0;

        @Override
        public String get() {
            return String.valueOf(this.nextId++);
        }
    };
    private final FunctionArgumentInjector functionArgumentInjector;
    private final LinkedHashMap<Node, Boolean> referencesEvalCache = new LinkedHashMap();
    private final LinkedHashMap<Node, Node> innerFunctionCache = new LinkedHashMap();
    private static final int NAME_COST_ESTIMATE = InlineCostEstimator.ESTIMATED_IDENTIFIER_COST;
    private static final int COMMA_COST = 1;
    private static final int PAREN_COST = 2;

    private FunctionInjector(Builder builder) {
        this.compiler = (AbstractCompiler)Preconditions.checkNotNull((Object)builder.compiler);
        this.safeNameIdSupplier = (Supplier)Preconditions.checkNotNull(builder.safeNameIdSupplier);
        this.assumeStrictThis = builder.assumeStrictThis;
        this.assumeMinimumCapture = builder.assumeMinimumCapture;
        this.allowDecomposition = builder.allowDecomposition;
        this.functionArgumentInjector = (FunctionArgumentInjector)Preconditions.checkNotNull((Object)builder.functionArgumentInjector);
    }

    boolean doesFunctionMeetMinimumRequirements(String fnName, Node fnNode) {
        Node block = NodeUtil.getFunctionBody(fnNode);
        String fnRecursionName = fnNode.getFirstChild().getString();
        Preconditions.checkState((fnRecursionName != null ? 1 : 0) != 0);
        boolean referencesArguments = NodeUtil.isNameReferenced(block, "arguments", NodeUtil.MATCH_ANYTHING_BUT_NON_ARROW_FUNCTION);
        Predicate blocksInjection = n -> {
            if (n.isName()) {
                return n.getString().equals("eval") || !fnName.isEmpty() && n.getString().equals(fnName) || !fnRecursionName.isEmpty() && n.getString().equals(fnRecursionName);
            }
            return n.isSuper();
        };
        return !referencesArguments && !NodeUtil.has(block, (Predicate<Node>)blocksInjection, (Predicate<Node>)Predicates.alwaysTrue());
    }

    CanInlineResult canInlineReferenceToFunction(Reference ref, Node fnNode, ImmutableSet<String> needAliases, boolean referencesThis, boolean containsFunctions) {
        Node callNode = ref.callNode;
        if (!this.isSupportedCallType(callNode)) {
            return CanInlineResult.NO;
        }
        if (FunctionInjector.hasSpreadCallArgument(callNode)) {
            return CanInlineResult.NO;
        }
        if (containsFunctions) {
            if (!this.assumeMinimumCapture && !ref.scope.isGlobal()) {
                return CanInlineResult.NO;
            }
            if (NodeUtil.isWithinLoop(callNode)) {
                return CanInlineResult.NO;
            }
        }
        if (referencesThis && !NodeUtil.isFunctionObjectCall(callNode)) {
            return CanInlineResult.NO;
        }
        if (ref.mode == InliningMode.DIRECT) {
            return this.canInlineReferenceDirectly(ref, fnNode, (Set<String>)needAliases);
        }
        return this.canInlineReferenceAsStatementBlock(ref, fnNode, needAliases);
    }

    private boolean isSupportedCallType(Node callNode) {
        Node thisValue;
        return callNode.getFirstChild().isName() || !(NodeUtil.isFunctionObjectCall(callNode) ? !this.assumeStrictThis && ((thisValue = callNode.getSecondChild()) == null || !thisValue.isThis()) : NodeUtil.isFunctionObjectApply(callNode));
    }

    private static boolean hasSpreadCallArgument(Node callNode) {
        Preconditions.checkArgument((boolean)NodeUtil.isNormalOrOptChainCall(callNode), (Object)callNode);
        for (Node arg = callNode.getSecondChild(); arg != null; arg = arg.getNext()) {
            if (!arg.isSpread()) continue;
            return true;
        }
        return false;
    }

    Node inline(Reference ref, String fnName, Node fnNode) {
        Preconditions.checkState((boolean)this.compiler.getLifeCycleStage().isNormalized());
        return this.internalInline(ref, fnName, fnNode);
    }

    Node unsafeInline(Reference ref, String fnName, Node fnNode) {
        return this.internalInline(ref, fnName, fnNode);
    }

    private Node internalInline(Reference ref, String fnName, Node fnNode) {
        Node result = ref.mode == InliningMode.DIRECT ? this.inlineReturnValue(ref, fnNode) : this.inlineFunction(ref, fnNode, fnName);
        this.compiler.reportChangeToEnclosingScope(result);
        return result;
    }

    private Node inlineReturnValue(Reference ref, Node fnNode) {
        Node newExpression;
        Node callNode = ref.callNode;
        Node block = fnNode.getLastChild();
        ImmutableMap<String, Node> argMap = this.functionArgumentInjector.getFunctionCallParameterMap(fnNode, callNode, this.safeNameIdSupplier);
        if (!block.hasChildren()) {
            Node srcLocation = block;
            newExpression = NodeUtil.newUndefinedNode(srcLocation);
        } else {
            Node returnNode = block.getFirstChild();
            Preconditions.checkArgument((boolean)returnNode.isReturn(), (Object)returnNode);
            Node safeReturnNode = returnNode.cloneTree();
            Node inlineResult = this.functionArgumentInjector.inject(null, safeReturnNode, null, (Map<String, Node>)argMap);
            Preconditions.checkArgument((safeReturnNode == inlineResult ? 1 : 0) != 0);
            newExpression = safeReturnNode.removeFirstChild();
            NodeUtil.markNewScopesChanged(newExpression, this.compiler);
        }
        JSType typeBeforeCast = callNode.getJSTypeBeforeCast();
        if (typeBeforeCast != null) {
            newExpression.setJSTypeBeforeCast(typeBeforeCast);
            newExpression.setJSType(callNode.getJSType());
        }
        if (callNode.getColor() != null && callNode.isColorFromTypeCast()) {
            newExpression.setColor(callNode.getColor());
            newExpression.setColorFromTypeCast();
        }
        callNode.replaceWith(newExpression);
        NodeUtil.markFunctionsDeleted(callNode, this.compiler);
        return newExpression;
    }

    private CallSiteType classifyCallSite(Reference ref) {
        Node callNode = ref.callNode;
        Node parent = callNode.getParent();
        Node grandParent = parent.getParent();
        if (NodeUtil.isExprCall(parent)) {
            return CallSiteType.SIMPLE_CALL;
        }
        if (NodeUtil.isExprAssign(grandParent) && !NodeUtil.isNameDeclOrSimpleAssignLhs(callNode, parent) && parent.getFirstChild().isName() && !NodeUtil.isConstantName(parent.getFirstChild())) {
            return CallSiteType.SIMPLE_ASSIGNMENT;
        }
        if (parent.isName() && !NodeUtil.isConstantName(parent) && grandParent.isVar() && grandParent.hasOneChild()) {
            return CallSiteType.VAR_DECL_SIMPLE_ASSIGNMENT;
        }
        ExpressionDecomposer decomposer = this.getDecomposer(ref.scope);
        switch (decomposer.canExposeExpression(callNode)) {
            case MOVABLE: {
                return CallSiteType.EXPRESSION;
            }
            case DECOMPOSABLE: {
                return CallSiteType.DECOMPOSABLE_EXPRESSION;
            }
        }
        return CallSiteType.UNSUPPORTED;
    }

    private ExpressionDecomposer getDecomposer(Scope scope) {
        return this.compiler.createExpressionDecomposer(this.safeNameIdSupplier, this.knownConstantFunctions, scope);
    }

    void maybePrepareCall(Reference ref) {
        CallSiteType callSiteType = this.classifyCallSite(ref);
        callSiteType.prepare(this, ref);
    }

    private Node inlineFunction(Reference ref, Node fnNode, String fnName) {
        Node callNode = ref.callNode;
        Node parent = callNode.getParent();
        Node grandParent = parent.getParent();
        CallSiteType callSiteType = this.classifyCallSite(ref);
        Preconditions.checkArgument((callSiteType != CallSiteType.UNSUPPORTED ? 1 : 0) != 0);
        String resultName = null;
        boolean needsDefaultReturnResult = true;
        switch (callSiteType) {
            case SIMPLE_ASSIGNMENT: {
                resultName = parent.getFirstChild().getString();
                FunctionInjector.removeConstantVarAnnotation(ref.scope, resultName);
                break;
            }
            case VAR_DECL_SIMPLE_ASSIGNMENT: {
                resultName = parent.getString();
                FunctionInjector.removeConstantVarAnnotation(ref.scope, resultName);
                break;
            }
            case SIMPLE_CALL: {
                resultName = null;
                needsDefaultReturnResult = false;
                break;
            }
            case EXPRESSION: {
                throw new IllegalStateException("Movable expressions must be moved before inlining.");
            }
            case DECOMPOSABLE_EXPRESSION: {
                throw new IllegalStateException("Decomposable expressions must be decomposed before inlining.");
            }
            default: {
                throw new IllegalStateException("Unexpected call site type.");
            }
        }
        FunctionToBlockMutator mutator = new FunctionToBlockMutator(this.compiler, this.safeNameIdSupplier);
        boolean isCallInLoop = NodeUtil.isWithinLoop(callNode);
        Node newBlock = mutator.mutate(fnName, fnNode, callNode, resultName, needsDefaultReturnResult, isCallInLoop);
        NodeUtil.markNewScopesChanged(newBlock, this.compiler);
        switch (callSiteType) {
            case VAR_DECL_SIMPLE_ASSIGNMENT: {
                Node firstChild = parent.removeFirstChild();
                NodeUtil.markFunctionsDeleted(firstChild, this.compiler);
                Preconditions.checkState((!parent.hasChildren() ? 1 : 0) != 0);
                newBlock.insertAfter(grandParent);
                break;
            }
            case SIMPLE_ASSIGNMENT: {
                Preconditions.checkState((boolean)grandParent.isExprResult());
                grandParent.replaceWith(newBlock);
                NodeUtil.markFunctionsDeleted(grandParent, this.compiler);
                break;
            }
            case SIMPLE_CALL: {
                Preconditions.checkState((boolean)parent.isExprResult());
                parent.replaceWith(newBlock);
                NodeUtil.markFunctionsDeleted(parent, this.compiler);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected call site type.");
            }
        }
        return newBlock;
    }

    private static void removeConstantVarAnnotation(Scope scope, String name) {
        Node nameNode;
        Var var = (Var)scope.getVar(name);
        Node node = nameNode = var == null ? null : var.getNameNode();
        if (nameNode == null) {
            return;
        }
        if (nameNode.isDeclaredConstantVar()) {
            nameNode.setDeclaredConstantVar(false);
        }
    }

    static boolean isDirectCallNodeReplacementPossible(Node fnNode) {
        Node block = NodeUtil.getFunctionBody(fnNode);
        if (!block.hasChildren()) {
            return true;
        }
        return block.hasOneChild() && block.getFirstChild().isReturn() && block.getFirstFirstChild() != null;
    }

    private CanInlineResult canInlineReferenceAsStatementBlock(Reference ref, Node fnNode, ImmutableSet<String> namesToAlias) {
        CallSiteType callSiteType = this.classifyCallSite(ref);
        if (callSiteType == CallSiteType.UNSUPPORTED) {
            return CanInlineResult.NO;
        }
        if (!(this.allowDecomposition || callSiteType != CallSiteType.DECOMPOSABLE_EXPRESSION && callSiteType != CallSiteType.EXPRESSION)) {
            return CanInlineResult.NO;
        }
        if (!this.callMeetsBlockInliningRequirements(ref, fnNode, namesToAlias)) {
            return CanInlineResult.NO;
        }
        if (callSiteType == CallSiteType.DECOMPOSABLE_EXPRESSION || callSiteType == CallSiteType.EXPRESSION) {
            return CanInlineResult.AFTER_PREPARATION;
        }
        return CanInlineResult.YES;
    }

    private boolean referencesEval(Node fn) {
        Preconditions.checkState((boolean)fn.isFunction());
        @Nullable Boolean cached = this.referencesEvalCache.get(fn);
        if (cached != null) {
            return cached;
        }
        boolean result = NodeUtil.has(fn, (Predicate<Node>)((Predicate)n -> n.isName() && n.getString().equals("eval")), (Predicate<Node>)((Predicate)n -> !n.isFunction() || n.equals(fn)));
        this.referencesEvalCache.put(fn, result);
        return result;
    }

    private Node innerFunctionOf(Node containerFn) {
        Preconditions.checkState((boolean)containerFn.isFunction());
        @Nullable Node cached = this.innerFunctionCache.get(containerFn);
        if (cached != null) {
            return cached;
        }
        ArrayList innerFns = new ArrayList();
        NodeUtil.visitPreOrder(containerFn, n -> {
            if (n.equals(containerFn)) {
                return;
            }
            if (n.isFunction()) {
                innerFns.add(n);
            }
        });
        switch (innerFns.size()) {
            case 0: {
                cached = NO_FUNCTIONS;
                break;
            }
            case 1: {
                cached = (Node)innerFns.get(0);
                break;
            }
            default: {
                cached = MULTIPLE_FUNCTIONS;
            }
        }
        this.innerFunctionCache.put(containerFn, cached);
        return cached;
    }

    private boolean callMeetsBlockInliningRequirements(Reference callRef, Node calleeFn, ImmutableSet<String> namesToAlias) {
        boolean calleeContainsVars = NodeUtil.has(NodeUtil.getFunctionBody(calleeFn), new NodeUtil.MatchDeclaration(), new NodeUtil.MatchShallowStatement());
        boolean forbidTemps = false;
        if (!((Scope)callRef.scope.getClosestHoistScope()).isGlobal()) {
            Node callerFn = ((Scope)callRef.scope.getClosestHoistScope()).getRootNode().getParent();
            if (this.referencesEval(callerFn)) {
                forbidTemps = true;
            } else if (!this.assumeMinimumCapture) {
                Node innerFn = this.innerFunctionOf(callerFn);
                boolean calleeIsOnlyInnerFn = innerFn.equals(NO_FUNCTIONS) || innerFn.equals(calleeFn);
                boolean bl = forbidTemps = !calleeIsOnlyInnerFn;
            }
        }
        if (calleeContainsVars && forbidTemps) {
            return false;
        }
        if (forbidTemps) {
            boolean hasArgs;
            ImmutableMap<String, Node> args = this.functionArgumentInjector.getFunctionCallParameterMap(calleeFn, callRef.callNode, this.safeNameIdSupplier);
            boolean bl = hasArgs = !args.isEmpty();
            if (hasArgs) {
                LinkedHashSet<String> allNamesToAlias = new LinkedHashSet<String>((Collection<String>)namesToAlias);
                this.functionArgumentInjector.maybeAddTempsForCallArguments(this.compiler, calleeFn, args, allNamesToAlias, this.compiler.getCodingConvention());
                if (!allNamesToAlias.isEmpty()) {
                    return false;
                }
            }
        }
        return true;
    }

    private CanInlineResult canInlineReferenceDirectly(Reference ref, Node fnNode, Set<String> namesToAlias) {
        ImmutableMap<String, Node> args;
        boolean hasArgs;
        if (!FunctionInjector.isDirectCallNodeReplacementPossible(fnNode)) {
            return CanInlineResult.NO;
        }
        Node callNode = ref.callNode;
        Node cArg = callNode.getSecondChild();
        if (!callNode.getFirstChild().isName()) {
            if (NodeUtil.isFunctionObjectCall(callNode)) {
                if (cArg == null || !cArg.isThis()) {
                    return CanInlineResult.NO;
                }
                cArg = cArg.getNext();
            } else {
                Preconditions.checkState((!NodeUtil.isFunctionObjectApply(callNode) ? 1 : 0) != 0);
            }
        }
        boolean bl = hasArgs = !(args = this.functionArgumentInjector.getFunctionCallParameterMap(fnNode, callNode, this.throwawayNameSupplier)).isEmpty();
        if (hasArgs) {
            LinkedHashSet<String> allNamesToAlias = new LinkedHashSet<String>(namesToAlias);
            this.functionArgumentInjector.maybeAddTempsForCallArguments(this.compiler, fnNode, args, allNamesToAlias, this.compiler.getCodingConvention());
            if (!allNamesToAlias.isEmpty()) {
                return CanInlineResult.NO;
            }
        }
        return CanInlineResult.YES;
    }

    boolean inliningLowersCost(JSChunk fnChunk, Node fnNode, Collection<? extends Reference> refs, Set<String> namesToAlias, boolean isRemovable, boolean referencesThis) {
        int referenceCount = refs.size();
        if (referenceCount == 0) {
            return true;
        }
        int referencesUsingBlockInlining = 0;
        boolean checkModules = isRemovable && fnChunk != null;
        JSChunkGraph chunkGraph = this.compiler.getChunkGraph();
        for (Reference reference : refs) {
            if (reference.mode == InliningMode.BLOCK) {
                ++referencesUsingBlockInlining;
            }
            if (!checkModules || reference.chunk == null || reference.chunk == fnChunk || chunkGraph.dependsOn(reference.chunk, fnChunk)) continue;
            isRemovable = false;
            checkModules = false;
        }
        int referencesUsingDirectInlining = referenceCount - referencesUsingBlockInlining;
        if (referenceCount == 1 && isRemovable && referencesUsingDirectInlining == 1) {
            return true;
        }
        int n = FunctionInjector.estimateCallCost(fnNode, referencesThis);
        int overallCallCost = n * referenceCount;
        int costDeltaDirect = FunctionInjector.inlineCostDelta(fnNode, namesToAlias, InliningMode.DIRECT);
        int costDeltaBlock = FunctionInjector.inlineCostDelta(fnNode, namesToAlias, InliningMode.BLOCK);
        return FunctionInjector.doesLowerCost(fnNode, overallCallCost, referencesUsingDirectInlining, costDeltaDirect, referencesUsingBlockInlining, costDeltaBlock, isRemovable);
    }

    private static boolean doesLowerCost(Node fnNode, int callCost, int directInlines, int costDeltaDirect, int blockInlines, int costDeltaBlock, boolean removable) {
        int fnInstanceCount = directInlines + blockInlines - (removable ? 1 : 0);
        if (fnInstanceCount == 0) {
            return blockInlines <= 0 || costDeltaBlock <= 0;
        }
        int costDelta = directInlines * -costDeltaDirect + blockInlines * -costDeltaBlock;
        int threshold = (callCost + costDelta) / fnInstanceCount;
        return InlineCostEstimator.getCost(fnNode, threshold + 1) <= threshold;
    }

    private static int estimateCallCost(Node fnNode, boolean referencesThis) {
        Node argsNode = NodeUtil.getFunctionParameters(fnNode);
        int numArgs = argsNode.getChildCount();
        int callCost = NAME_COST_ESTIMATE + 2;
        if (numArgs > 0) {
            callCost += numArgs * NAME_COST_ESTIMATE + (numArgs - 1) * 1;
        }
        if (referencesThis) {
            callCost += 10;
        }
        return callCost;
    }

    private static int inlineCostDelta(Node fnNode, Set<String> namesToAlias, InliningMode mode) {
        int paramCount = NodeUtil.getFunctionParameters(fnNode).getChildCount();
        int commaCount = paramCount > 1 ? paramCount - 1 : 0;
        int costDeltaFunctionOverhead = 15 + commaCount + paramCount * InlineCostEstimator.ESTIMATED_IDENTIFIER_COST;
        Node block = fnNode.getLastChild();
        if (!block.hasChildren()) {
            return -costDeltaFunctionOverhead;
        }
        if (mode == InliningMode.DIRECT) {
            return -(costDeltaFunctionOverhead + 7);
        }
        int aliasCount = namesToAlias.size();
        int inlineBlockOverhead = 4;
        int perReturnOverhead = 2;
        int perReturnResultOverhead = 3;
        int perAliasOverhead = 3;
        int returnCount = NodeUtil.getNodeTypeReferenceCount(block, Token.RETURN, new NodeUtil.MatchShallowStatement());
        int resultCount = returnCount > 0 ? returnCount - 1 : 0;
        int baseOverhead = returnCount > 0 ? 4 : 0;
        int overhead = baseOverhead + returnCount * 2 + resultCount * 3 + aliasCount * 3;
        return overhead - costDeltaFunctionOverhead;
    }

    public void setKnownConstantFunctions(ImmutableSet<String> knownConstantFunctions) {
        Preconditions.checkState((boolean)this.knownConstantFunctions.isEmpty());
        this.knownConstantFunctions = knownConstantFunctions;
    }

    static enum CanInlineResult {
        YES,
        AFTER_PREPARATION,
        NO;

    }

    private static enum CallSiteType {
        UNSUPPORTED{

            @Override
            public void prepare(FunctionInjector injector, Reference ref) {
                throw new IllegalStateException("unexpected: " + ref);
            }
        }
        ,
        SIMPLE_CALL{

            @Override
            public void prepare(FunctionInjector injector, Reference ref) {
            }
        }
        ,
        SIMPLE_ASSIGNMENT{

            @Override
            public void prepare(FunctionInjector injector, Reference ref) {
            }
        }
        ,
        VAR_DECL_SIMPLE_ASSIGNMENT{

            @Override
            public void prepare(FunctionInjector injector, Reference ref) {
            }
        }
        ,
        EXPRESSION{

            @Override
            public void prepare(FunctionInjector injector, Reference ref) {
                Node callNode = ref.callNode;
                injector.getDecomposer(ref.scope).moveExpression(callNode);
                CallSiteType callSiteType = injector.classifyCallSite(ref);
                Preconditions.checkState((this != callSiteType ? 1 : 0) != 0);
                callSiteType.prepare(injector, ref);
            }
        }
        ,
        DECOMPOSABLE_EXPRESSION{

            @Override
            public void prepare(FunctionInjector injector, Reference ref) {
                Node callNode = ref.callNode;
                injector.getDecomposer(ref.scope).maybeExposeExpression(callNode);
                CallSiteType callSiteType = injector.classifyCallSite(ref);
                Preconditions.checkState((this != callSiteType ? 1 : 0) != 0);
                callSiteType.prepare(injector, ref);
            }
        };


        public abstract void prepare(FunctionInjector var1, Reference var2);
    }

    static class Reference {
        final Node callNode;
        final Scope scope;
        final JSChunk chunk;
        final InliningMode mode;

        Reference(Node callNode, Scope scope, JSChunk chunk, InliningMode mode) {
            this.callNode = callNode;
            this.scope = scope;
            this.chunk = chunk;
            this.mode = mode;
        }

        public String toString() {
            return "Reference @ " + this.callNode;
        }
    }

    static enum InliningMode {
        DIRECT,
        BLOCK;

    }

    static class Builder {
        private final AbstractCompiler compiler;
        private @Nullable Supplier<String> safeNameIdSupplier = null;
        private boolean assumeStrictThis = true;
        private boolean assumeMinimumCapture = true;
        private boolean allowDecomposition = true;
        private @Nullable FunctionArgumentInjector functionArgumentInjector = null;

        Builder(AbstractCompiler compiler) {
            this.compiler = (AbstractCompiler)Preconditions.checkNotNull((Object)compiler);
        }

        @CanIgnoreReturnValue
        Builder safeNameIdSupplier(Supplier<String> safeNameIdSupplier) {
            this.safeNameIdSupplier = (Supplier)Preconditions.checkNotNull(safeNameIdSupplier);
            return this;
        }

        @CanIgnoreReturnValue
        Builder allowDecomposition(boolean allowDecomposition) {
            this.allowDecomposition = allowDecomposition;
            return this;
        }

        @CanIgnoreReturnValue
        Builder assumeStrictThis(boolean assumeStrictThis) {
            this.assumeStrictThis = assumeStrictThis;
            return this;
        }

        @CanIgnoreReturnValue
        Builder assumeMinimumCapture(boolean assumeMinimumCapture) {
            this.assumeMinimumCapture = assumeMinimumCapture;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder functionArgumentInjector(FunctionArgumentInjector functionArgumentInjector) {
            this.functionArgumentInjector = (FunctionArgumentInjector)Preconditions.checkNotNull((Object)functionArgumentInjector);
            return this;
        }

        public FunctionInjector build() {
            if (this.safeNameIdSupplier == null) {
                this.safeNameIdSupplier = this.compiler.getUniqueNameIdSupplier();
            }
            if (this.functionArgumentInjector == null) {
                this.functionArgumentInjector = new FunctionArgumentInjector((AstAnalyzer)Preconditions.checkNotNull((Object)this.compiler.getAstAnalyzer()));
            }
            return new FunctionInjector(this);
        }
    }
}

